/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.actions;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.actions.Action;
import me.pikamug.quests.actions.ActionFactory;
import me.pikamug.quests.actions.BukkitAction;
import me.pikamug.quests.convo.actions.main.ActionMainPrompt;
import me.pikamug.quests.convo.actions.menu.ActionMenuPrompt;
import me.pikamug.quests.entity.BukkitQuestMob;
import me.pikamug.quests.entity.QuestMob;
import me.pikamug.quests.interfaces.ReloadCallback;
import me.pikamug.quests.player.Quester;
import me.pikamug.quests.quests.Quest;
import me.pikamug.quests.util.BukkitConfigUtil;
import me.pikamug.quests.util.BukkitFakeConversable;
import me.pikamug.quests.util.BukkitLang;
import org.bukkit.ChatColor;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.ConversationAbandonedEvent;
import org.bukkit.conversations.ConversationAbandonedListener;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.ConversationFactory;
import org.bukkit.conversations.ConversationPrefix;
import org.bukkit.conversations.Prompt;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BukkitActionFactory
implements ActionFactory,
ConversationAbandonedListener {
    private final BukkitQuestsPlugin plugin;
    private final ConversationFactory conversationFactory;
    private ConcurrentHashMap<UUID, Block> selectedExplosionLocations = new ConcurrentHashMap();
    private ConcurrentHashMap<UUID, Block> selectedEffectLocations = new ConcurrentHashMap();
    private ConcurrentHashMap<UUID, Block> selectedMobLocations = new ConcurrentHashMap();
    private ConcurrentHashMap<UUID, Block> selectedLightningLocations = new ConcurrentHashMap();
    private ConcurrentHashMap<UUID, Block> selectedTeleportLocations = new ConcurrentHashMap();
    private List<String> editingActionNames = new LinkedList<String>();

    public BukkitActionFactory(BukkitQuestsPlugin plugin) {
        this.plugin = plugin;
        this.conversationFactory = new ConversationFactory((Plugin)plugin).withModality(false).withLocalEcho(false).withFirstPrompt((Prompt)new ActionMenuPrompt(new ConversationContext((Plugin)plugin, (Conversable)new BukkitFakeConversable(){

            @Override
            public void sendRawMessage(@Nullable UUID uuid, @NotNull String s) {
            }
        }, new HashMap()))).withTimeout(3600).withPrefix((ConversationPrefix)new LineBreakPrefix()).addConversationAbandonedListener((ConversationAbandonedListener)this);
    }

    public ConcurrentHashMap<UUID, Block> getSelectedExplosionLocations() {
        return this.selectedExplosionLocations;
    }

    public void setSelectedExplosionLocations(ConcurrentHashMap<UUID, Block> selectedExplosionLocations) {
        this.selectedExplosionLocations = selectedExplosionLocations;
    }

    public ConcurrentHashMap<UUID, Block> getSelectedEffectLocations() {
        return this.selectedEffectLocations;
    }

    public void setSelectedEffectLocations(ConcurrentHashMap<UUID, Block> selectedEffectLocations) {
        this.selectedEffectLocations = selectedEffectLocations;
    }

    public ConcurrentHashMap<UUID, Block> getSelectedMobLocations() {
        return this.selectedMobLocations;
    }

    public void setSelectedMobLocations(ConcurrentHashMap<UUID, Block> selectedMobLocations) {
        this.selectedMobLocations = selectedMobLocations;
    }

    public ConcurrentHashMap<UUID, Block> getSelectedLightningLocations() {
        return this.selectedLightningLocations;
    }

    public void setSelectedLightningLocations(ConcurrentHashMap<UUID, Block> selectedLightningLocations) {
        this.selectedLightningLocations = selectedLightningLocations;
    }

    public ConcurrentHashMap<UUID, Block> getSelectedTeleportLocations() {
        return this.selectedTeleportLocations;
    }

    public void setSelectedTeleportLocations(ConcurrentHashMap<UUID, Block> selectedTeleportLocations) {
        this.selectedTeleportLocations = selectedTeleportLocations;
    }

    @Override
    public ConversationFactory getConversationFactory() {
        return this.conversationFactory;
    }

    @Override
    public List<String> getNamesOfActionsBeingEdited() {
        return this.editingActionNames;
    }

    @Override
    public void setNamesOfActionsBeingEdited(List<String> actionNames) {
        this.editingActionNames = actionNames;
    }

    public void conversationAbandoned(ConversationAbandonedEvent abandonedEvent) {
        if (abandonedEvent.getContext().getForWhom() instanceof Player) {
            UUID uuid = ((Player)abandonedEvent.getContext().getForWhom()).getUniqueId();
            this.selectedExplosionLocations.remove(uuid);
            this.selectedEffectLocations.remove(uuid);
            this.selectedMobLocations.remove(uuid);
            this.selectedLightningLocations.remove(uuid);
            this.selectedTeleportLocations.remove(uuid);
        }
    }

    @Override
    public Prompt returnToMenu(ConversationContext context) {
        return new ActionMainPrompt(context);
    }

    @Override
    public void loadData(ConversationContext context, Action action) {
        LinkedList<String> locs;
        BukkitAction bukkitAction = (BukkitAction)action;
        if (bukkitAction.getMessage() != null) {
            context.setSessionData((Object)"actMessage", (Object)bukkitAction.getMessage());
        }
        if (bukkitAction.isClearInv()) {
            context.setSessionData((Object)"actClearInv", (Object)true);
        } else {
            context.setSessionData((Object)"actClearInv", (Object)false);
        }
        if (bukkitAction.isFailQuest()) {
            context.setSessionData((Object)"actFailQuest", (Object)true);
        } else {
            context.setSessionData((Object)"actFailQuest", (Object)false);
        }
        if (bukkitAction.getItems() != null && !bukkitAction.getItems().isEmpty()) {
            LinkedList<ItemStack> items = new LinkedList<ItemStack>(bukkitAction.getItems());
            context.setSessionData((Object)"actItems", items);
        }
        if (bukkitAction.getExplosions() != null && !bukkitAction.getExplosions().isEmpty()) {
            locs = new LinkedList<String>();
            for (Location location : bukkitAction.getExplosions()) {
                locs.add(BukkitConfigUtil.getLocationInfo(location));
            }
            context.setSessionData((Object)"actExplosions", locs);
        }
        if (bukkitAction.getEffects() != null && !bukkitAction.getEffects().isEmpty()) {
            locs = new LinkedList();
            LinkedList effs = new LinkedList();
            for (Map.Entry<Location, Effect> entry : bukkitAction.getEffects().entrySet()) {
                locs.add(BukkitConfigUtil.getLocationInfo(entry.getKey()));
                effs.add(entry.getValue().toString());
            }
            context.setSessionData((Object)"actEffects", effs);
            context.setSessionData((Object)"actEffectLocations", locs);
        }
        if (bukkitAction.getStormWorld() != null) {
            context.setSessionData((Object)"actStormWorld", (Object)bukkitAction.getStormWorld().getName());
            context.setSessionData((Object)"actStormDuration", (Object)bukkitAction.getStormDuration());
        }
        if (bukkitAction.getThunderWorld() != null) {
            context.setSessionData((Object)"actThunderWorld", (Object)bukkitAction.getThunderWorld().getName());
            context.setSessionData((Object)"actThunderDuration", (Object)bukkitAction.getThunderDuration());
        }
        if (bukkitAction.getMobSpawns() != null && !bukkitAction.getMobSpawns().isEmpty()) {
            context.setSessionData((Object)"actMobs", bukkitAction.getMobSpawns());
        }
        if (bukkitAction.getLightningStrikes() != null && !bukkitAction.getLightningStrikes().isEmpty()) {
            locs = new LinkedList();
            for (Location location : bukkitAction.getLightningStrikes()) {
                locs.add(BukkitConfigUtil.getLocationInfo(location));
            }
            context.setSessionData((Object)"actLightningStrikes", locs);
        }
        if (bukkitAction.getPotionEffects() != null && !bukkitAction.getPotionEffects().isEmpty()) {
            LinkedList<String> types = new LinkedList<String>();
            LinkedList<Long> durations = new LinkedList<Long>();
            LinkedList<Integer> linkedList = new LinkedList<Integer>();
            for (PotionEffect pe : bukkitAction.getPotionEffects()) {
                types.add(pe.getType().getName());
                durations.add(Long.valueOf(pe.getDuration()));
                linkedList.add(pe.getAmplifier());
            }
            context.setSessionData((Object)"actPotionTypes", types);
            context.setSessionData((Object)"actPotionDurations", durations);
            context.setSessionData((Object)"actPotionMagnitudes", linkedList);
        }
        if (bukkitAction.getHunger() > -1) {
            context.setSessionData((Object)"actHunger", (Object)bukkitAction.getHunger());
        }
        if (bukkitAction.getSaturation() > -1) {
            context.setSessionData((Object)"actSaturation", (Object)bukkitAction.getSaturation());
        }
        if (bukkitAction.getHealth() > -1.0f) {
            context.setSessionData((Object)"actHealth", (Object)Float.valueOf(bukkitAction.getHealth()));
        }
        if (bukkitAction.getTeleport() != null) {
            context.setSessionData((Object)"actTeleportLocation", (Object)BukkitConfigUtil.getLocationInfo(bukkitAction.getTeleport()));
        }
        if (bukkitAction.getCommands() != null) {
            context.setSessionData((Object)"actCommands", bukkitAction.getCommands());
        }
        if (bukkitAction.getTimer() > 0) {
            context.setSessionData((Object)"actTimer", (Object)bukkitAction.getTimer());
        }
        if (bukkitAction.isCancelTimer()) {
            context.setSessionData((Object)"actCancelTimer", (Object)true);
        }
    }

    @Override
    public void clearData(ConversationContext context) {
        context.setSessionData((Object)"oldAction", null);
        context.setSessionData((Object)"actName", null);
        context.setSessionData((Object)"actMessage", null);
        context.setSessionData((Object)"actClearInv", null);
        context.setSessionData((Object)"actFailQuest", null);
        context.setSessionData((Object)"actItems", null);
        context.setSessionData((Object)"actItemAmounts", null);
        context.setSessionData((Object)"actExplosions", null);
        context.setSessionData((Object)"actEffects", null);
        context.setSessionData((Object)"actEffectLocations", null);
        context.setSessionData((Object)"actStormWorld", null);
        context.setSessionData((Object)"actStormDuration", null);
        context.setSessionData((Object)"actThunderWorld", null);
        context.setSessionData((Object)"actThunderDuration", null);
        context.setSessionData((Object)"actMobs", null);
        context.setSessionData((Object)"actLightningStrikes", null);
        context.setSessionData((Object)"actPotionTypes", null);
        context.setSessionData((Object)"actPotionDurations", null);
        context.setSessionData((Object)"actPotionMagnitudes", null);
        context.setSessionData((Object)"actHunger", null);
        context.setSessionData((Object)"actSaturation", null);
        context.setSessionData((Object)"actHealth", null);
        context.setSessionData((Object)"actTeleportLocation", null);
        context.setSessionData((Object)"actCommands", null);
        context.setSessionData((Object)"actTimer", null);
        context.setSessionData((Object)"actCancelTimer", null);
    }

    @Override
    public void deleteAction(ConversationContext context) {
        YamlConfiguration data = new YamlConfiguration();
        File actionsFile = new File(this.plugin.getDataFolder(), "storage" + File.separatorChar + "actions.yml");
        try {
            data.load(actionsFile);
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
            context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("questErrorReadingFile").replace("<file>", actionsFile.getName()));
            return;
        }
        String action = (String)context.getSessionData((Object)"delEvent");
        String key = "actions";
        ConfigurationSection sec = data.getConfigurationSection(key);
        if (sec == null) {
            key = "events";
            sec = data.getConfigurationSection(key);
        }
        if (sec != null && action != null) {
            sec.set(action, null);
        }
        try {
            data.save(actionsFile);
        }
        catch (IOException e) {
            context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("questSaveError"));
            return;
        }
        ReloadCallback<Boolean> callback = response -> {
            if (!response.booleanValue()) {
                context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("unknownError"));
            }
        };
        this.plugin.reload(callback);
        context.getForWhom().sendRawMessage(ChatColor.YELLOW + BukkitLang.get("eventEditorDeleted"));
        if (this.plugin.getConfigSettings().getConsoleLogging() > 0) {
            String identifier = context.getForWhom() instanceof Player ? "Player " + ((Player)context.getForWhom()).getUniqueId() : "CONSOLE";
            this.plugin.getLogger().info(identifier + " deleted action " + action);
        }
        for (Quester q : this.plugin.getOfflineQuesters()) {
            for (Quest quest : q.getCurrentQuests().keySet()) {
                q.checkQuest(quest);
            }
        }
        this.clearData(context);
    }

    @Override
    public void saveAction(ConversationContext context) {
        Integer i;
        LinkedList commands;
        Boolean b;
        YamlConfiguration data = new YamlConfiguration();
        File actionsFile = new File(this.plugin.getDataFolder(), "storage" + File.separatorChar + "actions.yml");
        try {
            data.load(actionsFile);
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
            context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("questErrorReadingFile").replace("<file>", actionsFile.getName()));
            return;
        }
        String key = "actions";
        if (data.getConfigurationSection(key) == null) {
            key = "events";
        }
        if (context.getSessionData((Object)"oldAction") != null && !((String)Objects.requireNonNull(context.getSessionData((Object)"oldAction"))).isEmpty()) {
            data.set(key + "." + context.getSessionData((Object)"oldAction"), null);
            Collection<Action> temp = this.plugin.getLoadedActions();
            temp.remove(this.plugin.getAction((String)context.getSessionData((Object)"oldAction")));
            this.plugin.setLoadedActions(temp);
        }
        ConfigurationSection section = data.createSection(key + "." + context.getSessionData((Object)"actName"));
        this.editingActionNames.remove((String)context.getSessionData((Object)"actName"));
        if (context.getSessionData((Object)"actMessage") != null) {
            section.set("message", context.getSessionData((Object)"actMessage"));
        }
        if (context.getSessionData((Object)"actClearInv") != null && (b = (Boolean)context.getSessionData((Object)"actClearInv")) != null) {
            section.set("clear-inventory", (Object)b);
        }
        if (context.getSessionData((Object)"actFailQuest") != null && (b = (Boolean)context.getSessionData((Object)"actFailQuest")) != null) {
            section.set("fail-quest", (Object)b);
        }
        if (context.getSessionData((Object)"actItems") != null) {
            section.set("items", context.getSessionData((Object)"actItems"));
        }
        if (context.getSessionData((Object)"actExplosions") != null) {
            section.set("explosions", context.getSessionData((Object)"actExplosions"));
        }
        if (context.getSessionData((Object)"actEffects") != null) {
            section.set("effects", context.getSessionData((Object)"actEffects"));
            section.set("effect-locations", context.getSessionData((Object)"actEffectLocations"));
        }
        if (context.getSessionData((Object)"actStormWorld") != null) {
            section.set("storm-world", context.getSessionData((Object)"actStormWorld"));
            section.set("storm-duration", context.getSessionData((Object)"actStormDuration"));
        }
        if (context.getSessionData((Object)"actThunderWorld") != null) {
            section.set("thunder-world", context.getSessionData((Object)"actThunderWorld"));
            section.set("thunder-duration", context.getSessionData((Object)"actThunderDuration"));
        }
        try {
            if (context.getSessionData((Object)"actMobs") != null) {
                int count = 0;
                for (QuestMob mob : (LinkedList)Objects.requireNonNull(context.getSessionData((Object)"actMobs"))) {
                    BukkitQuestMob questMob;
                    ConfigurationSection cs = section.getConfigurationSection("mob-spawns." + count);
                    if (cs == null) {
                        cs = section.createSection("mob-spawns." + count);
                    }
                    if ((questMob = (BukkitQuestMob)mob).getName() != null) {
                        cs.set("name", (Object)questMob.getName());
                    }
                    cs.set("spawn-location", (Object)BukkitConfigUtil.getLocationInfo(questMob.getSpawnLocation()));
                    cs.set("mob-type", (Object)questMob.getType().name());
                    cs.set("spawn-amounts", (Object)questMob.getSpawnAmounts());
                    cs.set("held-item", (Object)questMob.getInventory()[0]);
                    cs.set("held-item-drop-chance", (Object)questMob.getDropChances()[0]);
                    cs.set("boots", (Object)questMob.getInventory()[1]);
                    cs.set("boots-drop-chance", (Object)questMob.getDropChances()[1]);
                    cs.set("leggings", (Object)questMob.getInventory()[2]);
                    cs.set("leggings-drop-chance", (Object)questMob.getDropChances()[2]);
                    cs.set("chest-plate", (Object)questMob.getInventory()[3]);
                    cs.set("chest-plate-drop-chance", (Object)questMob.getDropChances()[3]);
                    cs.set("helmet", (Object)questMob.getInventory()[4]);
                    cs.set("helmet-drop-chance", (Object)questMob.getDropChances()[4]);
                    ++count;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (context.getSessionData((Object)"actLightningStrikes") != null) {
            section.set("lightning-strikes", context.getSessionData((Object)"actLightningStrikes"));
        }
        if (context.getSessionData((Object)"actCommands") != null && (commands = (LinkedList)context.getSessionData((Object)"actCommands")) != null && !commands.isEmpty()) {
            section.set("commands", (Object)commands);
        }
        if (context.getSessionData((Object)"actPotionTypes") != null) {
            section.set("potion-effect-types", context.getSessionData((Object)"actPotionTypes"));
            section.set("potion-effect-durations", context.getSessionData((Object)"actPotionDurations"));
            section.set("potion-effect-amplifiers", context.getSessionData((Object)"actPotionMagnitudes"));
        }
        if (context.getSessionData((Object)"actHunger") != null) {
            section.set("hunger", context.getSessionData((Object)"actHunger"));
        }
        if (context.getSessionData((Object)"actSaturation") != null) {
            section.set("saturation", context.getSessionData((Object)"actSaturation"));
        }
        if (context.getSessionData((Object)"actHealth") != null) {
            section.set("health", context.getSessionData((Object)"actHealth"));
        }
        if (context.getSessionData((Object)"actTeleportLocation") != null) {
            section.set("teleport-location", context.getSessionData((Object)"actTeleportLocation"));
        }
        if (context.getSessionData((Object)"actTimer") != null && (i = (Integer)context.getSessionData((Object)"actTimer")) != null && i > 0) {
            section.set("timer", context.getSessionData((Object)"actTimer"));
        }
        if (context.getSessionData((Object)"actCancelTimer") != null && (b = (Boolean)context.getSessionData((Object)"actCancelTimer")) != null) {
            section.set("cancel-timer", (Object)b);
        }
        if (context.getSessionData((Object)"actDenizen") != null) {
            section.set("denizen-script", context.getSessionData((Object)"actDenizen"));
        }
        try {
            data.save(actionsFile);
        }
        catch (IOException e) {
            context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("questSaveError"));
            return;
        }
        ReloadCallback<Boolean> callback = response -> {
            if (!response.booleanValue()) {
                context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("unknownError"));
            }
        };
        this.plugin.reload(callback);
        context.getForWhom().sendRawMessage(ChatColor.YELLOW + BukkitLang.get("eventEditorSaved"));
        if (this.plugin.getConfigSettings().getConsoleLogging() > 0) {
            String identifier = context.getForWhom() instanceof Player ? "Player " + ((Player)context.getForWhom()).getUniqueId() : "CONSOLE";
            this.plugin.getLogger().info(identifier + " saved action " + context.getSessionData((Object)"actName"));
        }
        for (Quester q : this.plugin.getOfflineQuesters()) {
            for (Quest quest : q.getCurrentQuests().keySet()) {
                q.checkQuest(quest);
            }
        }
        this.clearData(context);
    }

    public static class LineBreakPrefix
    implements ConversationPrefix {
        @NotNull
        public String getPrefix(@NotNull ConversationContext context) {
            return "\n";
        }
    }
}

