/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.commands;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import me.pikamug.quests.util.BukkitLang;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public abstract class BukkitQuestsSubCommand {
    public abstract String getName();

    public abstract String getNameI18N();

    public abstract String getDescription();

    public abstract String getPermission();

    public abstract String getSyntax();

    public abstract int getMaxArguments();

    public abstract void execute(CommandSender var1, String[] var2);

    public List<String> tabComplete(CommandSender commandSender, String[] args) {
        return Collections.emptyList();
    }

    public static boolean assertNonPlayer(CommandSender commandSender) {
        if (!(commandSender instanceof Player)) {
            commandSender.sendMessage(ChatColor.YELLOW + BukkitLang.get("consoleError"));
            return true;
        }
        return false;
    }

    public static Player getOnlinePlayer(String name) {
        if (name == null) {
            return null;
        }
        for (Player p : Bukkit.getServer().getOnlinePlayers()) {
            if (!p.getName().equalsIgnoreCase(name)) continue;
            return p;
        }
        for (Player p : Bukkit.getServer().getOnlinePlayers()) {
            if (!p.getName().toLowerCase().startsWith(name)) continue;
            return p;
        }
        for (Player p : Bukkit.getServer().getOnlinePlayers()) {
            if (!p.getName().toLowerCase().contains(name)) continue;
            return p;
        }
        return null;
    }

    public static OfflinePlayer getOfflinePlayer(String name) {
        if (name == null) {
            return null;
        }
        Player player = BukkitQuestsSubCommand.getOnlinePlayer(name);
        if (player != null) {
            return player;
        }
        for (OfflinePlayer p : Bukkit.getServer().getOfflinePlayers()) {
            if (p == null || p.getName() == null || !p.getName().equalsIgnoreCase(name)) continue;
            return p;
        }
        for (OfflinePlayer p : Bukkit.getServer().getOfflinePlayers()) {
            if (p == null || p.getName() == null || !p.getName().toLowerCase().startsWith(name)) continue;
            return p;
        }
        for (OfflinePlayer p : Bukkit.getServer().getOfflinePlayers()) {
            if (p == null || p.getName() == null || !p.getName().toLowerCase().contains(name)) continue;
            return p;
        }
        return null;
    }

    public static String concatArgArray(String[] args, int startingIndex, int endingIndex, char delimiter) {
        StringBuilder s = new StringBuilder();
        for (int i = startingIndex; i <= endingIndex; ++i) {
            s.append(args[i]).append(delimiter);
        }
        return (s = new StringBuilder(s.substring(0, s.length()))).toString().trim().isEmpty() ? null : s.toString().trim();
    }

    public static Map<String, Integer> sort(Map<String, Integer> unsortedMap) {
        LinkedList<Map.Entry<String, Integer>> list = new LinkedList<Map.Entry<String, Integer>>(unsortedMap.entrySet());
        list.sort((o1, o2) -> {
            int i = (Integer)o1.getValue();
            int i2 = (Integer)o2.getValue();
            return Integer.compare(i2, i);
        });
        LinkedHashMap<String, Integer> sortedMap = new LinkedHashMap<String, Integer>();
        for (Map.Entry entry : list) {
            sortedMap.put((String)entry.getKey(), (Integer)entry.getValue());
        }
        return sortedMap;
    }
}

