/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.commands.quest;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.player.BukkitQuester;
import me.pikamug.quests.quests.Quest;
import me.pikamug.quests.quests.components.BukkitRequirements;
import me.pikamug.quests.quests.components.Stage;
import me.pikamug.quests.util.BukkitItemUtil;
import me.pikamug.quests.util.BukkitLang;
import me.pikamug.quests.util.BukkitMiscUtil;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class BukkitQuestCommandHandler {
    private final BukkitQuestsPlugin plugin;

    public BukkitQuestCommandHandler(BukkitQuestsPlugin plugin) {
        this.plugin = plugin;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean check(CommandSender cs, String[] args) {
        if (!(cs instanceof Player)) {
            cs.sendMessage(ChatColor.YELLOW + BukkitLang.get("consoleError"));
            return true;
        }
        if (!cs.hasPermission("quests.quest")) {
            cs.sendMessage(ChatColor.RED + BukkitLang.get("noPermission"));
            return true;
        }
        if (args.length != 0) {
            this.showQuestDetails(cs, args);
            return true;
        }
        Player player = (Player)cs;
        BukkitQuester quester = this.plugin.getQuester(player.getUniqueId());
        if (quester.getCurrentQuests().isEmpty()) {
            BukkitLang.send(player, ChatColor.YELLOW + BukkitLang.get(player, "noActiveQuest"));
            return true;
        }
        int[] ticks = new int[]{1};
        Iterator iterator = ((ConcurrentHashMap.KeySetView)quester.getCurrentQuests().keySet()).iterator();
        while (iterator.hasNext()) {
            Quest q = (Quest)iterator.next();
            Stage stage = quester.getCurrentStage(q);
            q.updateCompass(quester, stage);
            if (quester.getQuestProgressOrDefault(q).getDelayStartTime() == 0L || quester.getStageTime(q) < 0L) {
                String msg = BukkitLang.get(player, "questObjectivesTitle").replace("<quest>", q.getName());
                this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                    BukkitLang.send(player, ChatColor.GOLD + msg);
                    quester.showCurrentObjectives(q, quester, false);
                    ticks[0] = ticks[0] + 1;
                }, (long)ticks[0]);
                continue;
            }
            long time = quester.getStageTime(q);
            String msg = ChatColor.YELLOW + "(" + BukkitLang.get(player, "delay") + ") " + ChatColor.RED + BukkitLang.get(player, "plnTooEarly").replace("<quest>", q.getName().replace("<time>", BukkitMiscUtil.getTime(time)));
            this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                BukkitLang.send(player, msg);
                ticks[0] = ticks[0] + 1;
            }, (long)ticks[0]);
        }
        return true;
    }

    public List<String> suggest(CommandSender cs, String[] args) {
        if (args.length != 1) {
            return Collections.emptyList();
        }
        ArrayList<String> results = new ArrayList<String>();
        for (Quest quest : this.plugin.getLoadedQuests()) {
            if (!quest.getName().toLowerCase().startsWith(args[0].toLowerCase())) continue;
            results.add(ChatColor.stripColor((String)quest.getName()));
        }
        return results;
    }

    private void showQuestDetails(CommandSender cs, String[] args) {
        if (cs.hasPermission("quests.questinfo")) {
            StringBuilder name = new StringBuilder();
            if (args.length == 1) {
                name = new StringBuilder(args[0].toLowerCase());
            } else {
                int index = 0;
                for (String string : args) {
                    if (index == args.length - 1) {
                        name.append(string.toLowerCase());
                    } else {
                        name.append(string.toLowerCase()).append(" ");
                    }
                    ++index;
                }
            }
            Quest q = this.plugin.getQuest(name.toString());
            if (q != null) {
                BukkitRequirements reqs;
                Player player = (Player)cs;
                BukkitQuester quester = this.plugin.getQuester(player.getUniqueId());
                cs.sendMessage(ChatColor.GOLD + "- " + q.getName() + " -");
                cs.sendMessage(" ");
                if (q.getNpcStart() != null) {
                    String msg = BukkitLang.get("speakTo");
                    msg = msg.replace("<npc>", q.getNpcStartName());
                    cs.sendMessage(ChatColor.YELLOW + msg);
                } else {
                    cs.sendMessage(ChatColor.YELLOW + q.getDescription());
                }
                cs.sendMessage(" ");
                if (this.plugin.getConfigSettings().canShowQuestReqs() && (reqs = (BukkitRequirements)q.getRequirements()).hasRequirement()) {
                    cs.sendMessage(ChatColor.GOLD + BukkitLang.get("requirements"));
                    if (!reqs.getPermissions().isEmpty()) {
                        for (String perm : reqs.getPermissions()) {
                            if (this.plugin.getDependencies().getVaultPermission().has(player, perm)) {
                                cs.sendMessage(ChatColor.GREEN + BukkitLang.get("permissionDisplay") + " " + perm);
                                continue;
                            }
                            cs.sendMessage(ChatColor.RED + BukkitLang.get("permissionDisplay") + " " + perm);
                        }
                    }
                    if (reqs.getHeroesPrimaryClass() != null) {
                        if (this.plugin.getDependencies().testPrimaryHeroesClass(reqs.getHeroesPrimaryClass(), player.getUniqueId())) {
                            cs.sendMessage(ChatColor.BOLD + "" + ChatColor.GREEN + reqs.getHeroesPrimaryClass() + ChatColor.RESET + "" + ChatColor.DARK_GREEN + " " + BukkitLang.get("heroesClass"));
                        } else {
                            cs.sendMessage(ChatColor.BOLD + "" + ChatColor.DARK_RED + reqs.getHeroesPrimaryClass() + ChatColor.RESET + "" + ChatColor.RED + " " + BukkitLang.get("heroesClass"));
                        }
                    }
                    if (reqs.getHeroesSecondaryClass() != null) {
                        if (this.plugin.getDependencies().testSecondaryHeroesClass(reqs.getHeroesSecondaryClass(), player.getUniqueId())) {
                            cs.sendMessage(ChatColor.BOLD + "" + ChatColor.DARK_RED + reqs.getHeroesSecondaryClass() + ChatColor.RESET + "" + ChatColor.RED + " " + BukkitLang.get("heroesClass"));
                        } else {
                            cs.sendMessage(ChatColor.BOLD + "" + ChatColor.GREEN + reqs.getHeroesSecondaryClass() + ChatColor.RESET + "" + ChatColor.DARK_GREEN + " " + BukkitLang.get("heroesClass"));
                        }
                    }
                    for (String skill : reqs.getMcmmoSkills()) {
                        int level = this.plugin.getDependencies().getMcmmoSkillLevel(this.plugin.getDependencies().getMcMMOSkill(skill), player.getName());
                        int req = reqs.getMcmmoAmounts().get(reqs.getMcmmoSkills().indexOf(skill));
                        String skillName = BukkitMiscUtil.getCapitalized(skill);
                        if (level >= req) {
                            cs.sendMessage(ChatColor.GREEN + skillName + " " + BukkitLang.get("mcMMOLevel") + " " + req);
                            continue;
                        }
                        cs.sendMessage(ChatColor.RED + skillName + " " + BukkitLang.get("mcMMOLevel") + " " + req);
                    }
                    if (reqs.getQuestPoints() != 0) {
                        if (quester.getQuestPoints() >= reqs.getQuestPoints()) {
                            cs.sendMessage(ChatColor.GRAY + "- " + ChatColor.GREEN + reqs.getQuestPoints() + " " + BukkitLang.get("questPoints"));
                        } else {
                            cs.sendMessage(ChatColor.GRAY + "- " + ChatColor.RED + reqs.getQuestPoints() + " " + BukkitLang.get("questPoints"));
                        }
                    }
                    if (reqs.getMoney() != 0) {
                        if (this.plugin.getDependencies().getVaultEconomy() != null && this.plugin.getDependencies().getVaultEconomy().getBalance(quester.getOfflinePlayer()) >= (double)reqs.getMoney()) {
                            cs.sendMessage(ChatColor.GRAY + "- " + ChatColor.GREEN + reqs.getMoney() + " " + (reqs.getMoney() > 1 ? this.plugin.getDependencies().getVaultEconomy().currencyNamePlural() : this.plugin.getDependencies().getVaultEconomy().currencyNameSingular()));
                        } else {
                            cs.sendMessage(ChatColor.GRAY + "- " + ChatColor.RED + reqs.getMoney() + " " + (reqs.getMoney() > 1 ? this.plugin.getDependencies().getVaultEconomy().currencyNamePlural() : this.plugin.getDependencies().getVaultEconomy().currencyNameSingular()));
                        }
                    }
                    for (ItemStack is : reqs.getItems()) {
                        if (this.plugin.getQuester(player.getUniqueId()).hasItem(is)) {
                            cs.sendMessage(ChatColor.GRAY + "- " + ChatColor.GREEN + BukkitItemUtil.getString(is));
                            continue;
                        }
                        cs.sendMessage(ChatColor.GRAY + "- " + ChatColor.RED + BukkitItemUtil.getString(is));
                    }
                    for (Quest quest : quester.getCompletedQuests()) {
                        if (reqs.getNeededQuestIds().contains(quest.getId())) {
                            cs.sendMessage(ChatColor.GRAY + "- " + ChatColor.GREEN + BukkitLang.get("complete") + " " + ChatColor.ITALIC + quest.getName());
                            continue;
                        }
                        cs.sendMessage(ChatColor.GRAY + "- " + ChatColor.RED + BukkitLang.get("complete") + " " + ChatColor.ITALIC + quest.getName());
                    }
                    Map<String, String> map = quester.getCompletedQuests().stream().collect(Collectors.toMap(Quest::getId, Quest::getName));
                    for (String questId : reqs.getBlockQuestIds()) {
                        String msg;
                        if (map.containsKey(questId)) {
                            msg = BukkitLang.get("haveCompleted");
                            msg = msg.replace("<quest>", map.get(questId));
                            cs.sendMessage(ChatColor.GRAY + "- " + ChatColor.RED + msg);
                            continue;
                        }
                        msg = BukkitLang.get("cannotComplete");
                        msg = msg.replace("<quest>", this.plugin.getQuestById(questId).getName());
                        cs.sendMessage(ChatColor.GRAY + "- " + ChatColor.GREEN + msg);
                    }
                }
            } else {
                cs.sendMessage(ChatColor.YELLOW + BukkitLang.get("questNotFound").replace("<input>", name.toString()));
            }
        } else {
            cs.sendMessage(ChatColor.RED + BukkitLang.get("noPermission"));
        }
    }
}

