/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.commands.questadmin.subcommands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.commands.BukkitQuestsSubCommand;
import me.pikamug.quests.player.BukkitQuester;
import me.pikamug.quests.quests.Quest;
import me.pikamug.quests.util.BukkitLang;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class BukkitQuestadminFinishCommand
extends BukkitQuestsSubCommand {
    private final BukkitQuestsPlugin plugin;

    public BukkitQuestadminFinishCommand(BukkitQuestsPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public String getName() {
        return "finish";
    }

    @Override
    public String getNameI18N() {
        return BukkitLang.get("COMMAND_QUESTADMIN_FINISH");
    }

    @Override
    public String getDescription() {
        return BukkitLang.get("COMMAND_QUESTADMIN_FINISH_HELP");
    }

    @Override
    public String getPermission() {
        return "quests.admin.finish";
    }

    @Override
    public String getSyntax() {
        return "/questadmin finish";
    }

    @Override
    public int getMaxArguments() {
        return 3;
    }

    @Override
    public void execute(CommandSender cs, String[] args) {
        if (args.length < 3) {
            return;
        }
        if (cs.hasPermission("quests.admin.*") || cs.hasPermission("quests.admin.finish")) {
            OfflinePlayer target = BukkitQuestadminFinishCommand.getOfflinePlayer(args[1]);
            if (target == null) {
                try {
                    target = Bukkit.getOfflinePlayer((UUID)UUID.fromString(args[1]));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (target == null || target.getName() == null) {
                cs.sendMessage(ChatColor.YELLOW + BukkitLang.get("playerNotFound"));
                return;
            }
            BukkitQuester quester = this.plugin.getQuester(target.getUniqueId());
            if (quester.getCurrentQuests().isEmpty() && target.getName() != null) {
                String msg = BukkitLang.get("noCurrentQuest");
                msg = msg.replace("<player>", target.getName());
                cs.sendMessage(ChatColor.YELLOW + msg);
            } else {
                String questName = BukkitQuestadminFinishCommand.concatArgArray(args, 2, args.length - 1, ' ');
                Quest quest = this.plugin.getQuest(questName);
                if (quest == null) {
                    cs.sendMessage(ChatColor.RED + BukkitLang.get("questNotFound").replace("<input>", questName != null ? questName : ""));
                    return;
                }
                String msg1 = BukkitLang.get("questForceFinish");
                msg1 = msg1.replace("<player>", target.getName());
                msg1 = msg1.replace("<quest>", quest.getName());
                cs.sendMessage(ChatColor.GOLD + msg1);
                if (target.isOnline()) {
                    Player p = (Player)target;
                    String msg2 = BukkitLang.get(p, "questForcedFinish");
                    msg2 = msg2.replace("<player>", cs.getName());
                    msg2 = msg2.replace("<quest>", quest.getName());
                    BukkitLang.send(p, ChatColor.GREEN + msg2);
                }
                quest.completeQuest(quester);
                quester.saveData();
            }
        } else {
            cs.sendMessage(ChatColor.RED + BukkitLang.get("noPermission"));
        }
    }

    @Override
    public List<String> tabComplete(CommandSender commandSender, String[] args) {
        if (args.length == 2) {
            return null;
        }
        if (args.length == 3) {
            ArrayList<String> results = new ArrayList<String>();
            Player player = Bukkit.getPlayer((String)args[1]);
            if (player != null) {
                BukkitQuester quester = this.plugin.getQuester(player.getUniqueId());
                if (quester != null) {
                    for (Quest quest : quester.getCurrentQuests().keySet()) {
                        if (!quest.getName().toLowerCase().startsWith(args[2].toLowerCase())) continue;
                        results.add(ChatColor.stripColor((String)quest.getName()));
                    }
                }
            } else {
                for (Quest quest : this.plugin.getLoadedQuests()) {
                    if (!quest.getName().toLowerCase().startsWith(args[2].toLowerCase())) continue;
                    results.add(ChatColor.stripColor((String)quest.getName()));
                }
            }
            return results;
        }
        return Collections.emptyList();
    }
}

