/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.commands.questadmin.subcommands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.commands.BukkitQuestsSubCommand;
import me.pikamug.quests.player.BukkitQuester;
import me.pikamug.quests.quests.Quest;
import me.pikamug.quests.util.BukkitLang;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class BukkitQuestadminGiveCommand
extends BukkitQuestsSubCommand {
    private final BukkitQuestsPlugin plugin;

    public BukkitQuestadminGiveCommand(BukkitQuestsPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public String getName() {
        return "give";
    }

    @Override
    public String getNameI18N() {
        return BukkitLang.get("COMMAND_QUESTADMIN_GIVE");
    }

    @Override
    public String getDescription() {
        return BukkitLang.get("COMMAND_QUESTADMIN_GIVE_HELP");
    }

    @Override
    public String getPermission() {
        return "quests.admin.give";
    }

    @Override
    public String getSyntax() {
        return "/questadmin give";
    }

    @Override
    public int getMaxArguments() {
        return 3;
    }

    @Override
    public void execute(CommandSender cs, String[] args) {
        if (args.length < 3) {
            return;
        }
        if (cs.hasPermission("quests.admin.*") || cs.hasPermission("quests.admin.give")) {
            OfflinePlayer target = BukkitQuestadminGiveCommand.getOfflinePlayer(args[1]);
            if (target == null) {
                try {
                    target = Bukkit.getOfflinePlayer((UUID)UUID.fromString(args[1]));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (target == null || target.getName() == null) {
                cs.sendMessage(ChatColor.YELLOW + BukkitLang.get("playerNotFound"));
                return;
            }
            StringBuilder name = new StringBuilder();
            if (args.length == 3) {
                name = new StringBuilder(args[2].toLowerCase());
            } else {
                for (int i = 2; i < args.length; ++i) {
                    int lastIndex = args.length - 1;
                    if (i == lastIndex) {
                        name.append(args[i].toLowerCase());
                        continue;
                    }
                    name.append(args[i].toLowerCase()).append(" ");
                }
            }
            Quest questToGive = this.plugin.getQuest(name.toString());
            if (questToGive == null) {
                cs.sendMessage(ChatColor.YELLOW + BukkitLang.get("questNotFound").replace("<input>", name.toString()));
            } else {
                BukkitQuester quester = this.plugin.getQuester(target.getUniqueId());
                for (Quest q : quester.getCurrentQuests().keySet()) {
                    if (!q.getName().equalsIgnoreCase(questToGive.getName())) continue;
                    String msg = BukkitLang.get("questsPlayerHasQuestAlready");
                    msg = msg.replace("<player>", target.getName());
                    msg = msg.replace("<quest>", questToGive.getName());
                    cs.sendMessage(ChatColor.YELLOW + msg);
                    return;
                }
                quester.hardQuit(questToGive);
                String msg1 = BukkitLang.get("questForceTake");
                msg1 = msg1.replace("<player>", target.getName());
                msg1 = msg1.replace("<quest>", questToGive.getName());
                cs.sendMessage(ChatColor.GOLD + msg1);
                if (target.isOnline()) {
                    Player p = (Player)target;
                    String msg2 = BukkitLang.get(p, "questForcedTake");
                    msg2 = msg2.replace("<player>", cs.getName());
                    msg2 = msg2.replace("<quest>", questToGive.getName());
                    BukkitLang.send(p, ChatColor.GREEN + msg2);
                }
                quester.takeQuest(questToGive, true);
            }
        } else {
            cs.sendMessage(ChatColor.RED + BukkitLang.get("noPermission"));
        }
    }

    @Override
    public List<String> tabComplete(CommandSender commandSender, String[] args) {
        if (args.length == 2) {
            return null;
        }
        if (args.length == 3) {
            ArrayList<String> results = new ArrayList<String>();
            for (Quest quest : this.plugin.getLoadedQuests()) {
                if (!quest.getName().toLowerCase().startsWith(args[2].toLowerCase())) continue;
                results.add(ChatColor.stripColor((String)quest.getName()));
            }
            return results;
        }
        return Collections.emptyList();
    }
}

