/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.commands.questadmin.subcommands;

import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.commands.BukkitQuestsSubCommand;
import me.pikamug.quests.interfaces.ReloadCallback;
import me.pikamug.quests.util.BukkitLang;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class BukkitQuestadminReloadCommand
extends BukkitQuestsSubCommand {
    private final BukkitQuestsPlugin plugin;

    public BukkitQuestadminReloadCommand(BukkitQuestsPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public String getName() {
        return "reload";
    }

    @Override
    public String getNameI18N() {
        return BukkitLang.get("COMMAND_QUESTADMIN_RELOAD");
    }

    @Override
    public String getDescription() {
        return BukkitLang.get("COMMAND_QUESTADMIN_RELOAD_HELP");
    }

    @Override
    public String getPermission() {
        return "quests.admin.reload";
    }

    @Override
    public String getSyntax() {
        return "/questadmin reload";
    }

    @Override
    public int getMaxArguments() {
        return 1;
    }

    @Override
    public void execute(CommandSender cs, String[] args) {
        if (cs.hasPermission("quests.admin.*") || cs.hasPermission("quests.admin.reload")) {
            cs.sendMessage(ChatColor.GOLD + BukkitLang.get("questsReloading"));
            ReloadCallback<Boolean> callback = response -> {
                if (response.booleanValue()) {
                    cs.sendMessage(ChatColor.GOLD + BukkitLang.get("questsReloaded"));
                    String msg = BukkitLang.get("numQuestsLoaded");
                    msg = msg.replace("<number>", String.valueOf(this.plugin.getLoadedQuests().size()));
                    cs.sendMessage(ChatColor.GOLD + msg);
                } else {
                    cs.sendMessage(ChatColor.RED + BukkitLang.get("unknownError"));
                }
            };
            this.plugin.reload(callback);
        } else {
            cs.sendMessage(ChatColor.RED + BukkitLang.get("noPermission"));
        }
    }
}

