/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.commands.questadmin.subcommands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.commands.BukkitQuestsSubCommand;
import me.pikamug.quests.player.BukkitQuester;
import me.pikamug.quests.quests.Quest;
import me.pikamug.quests.util.BukkitLang;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class BukkitQuestadminRemoveCommand
extends BukkitQuestsSubCommand {
    private final BukkitQuestsPlugin plugin;

    public BukkitQuestadminRemoveCommand(BukkitQuestsPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public String getName() {
        return "remove";
    }

    @Override
    public String getNameI18N() {
        return BukkitLang.get("COMMAND_QUESTADMIN_REMOVE");
    }

    @Override
    public String getDescription() {
        return BukkitLang.get("COMMAND_QUESTADMIN_REMOVE_HELP");
    }

    @Override
    public String getPermission() {
        return "quests.admin.remove";
    }

    @Override
    public String getSyntax() {
        return "/questadmin remove";
    }

    @Override
    public int getMaxArguments() {
        return 3;
    }

    @Override
    public void execute(CommandSender cs, String[] args) {
        if (args.length < 3) {
            return;
        }
        if (cs.hasPermission("quests.admin.*") && cs.hasPermission("quests.admin.remove")) {
            OfflinePlayer target = BukkitQuestadminRemoveCommand.getOfflinePlayer(args[1]);
            if (target == null) {
                try {
                    target = Bukkit.getOfflinePlayer((UUID)UUID.fromString(args[1]));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (target == null || target.getName() == null) {
                cs.sendMessage(ChatColor.YELLOW + BukkitLang.get("playerNotFound"));
                return;
            }
            String questName = BukkitQuestadminRemoveCommand.concatArgArray(args, 2, args.length - 1, ' ');
            Quest toRemove = this.plugin.getQuest(questName);
            if (toRemove == null) {
                cs.sendMessage(ChatColor.RED + BukkitLang.get("questNotFound").replace("<input>", questName != null ? questName : ""));
                return;
            }
            BukkitQuester quester = this.plugin.getQuester(target.getUniqueId());
            String msg = BukkitLang.get("questRemoved");
            msg = target.getName() != null ? msg.replace("<player>", target.getName()) : msg.replace("<player>", args[1]);
            msg = msg.replace("<quest>", toRemove.getName());
            cs.sendMessage(ChatColor.GOLD + msg);
            cs.sendMessage(ChatColor.DARK_PURPLE + " UUID: " + ChatColor.DARK_AQUA + quester.getUUID().toString());
            quester.hardRemove(toRemove);
            quester.saveData();
            quester.updateJournal();
        } else {
            cs.sendMessage(ChatColor.RED + BukkitLang.get("noPermission"));
        }
    }

    @Override
    public List<String> tabComplete(CommandSender commandSender, String[] args) {
        if (args.length == 2) {
            return null;
        }
        if (args.length == 3) {
            ArrayList<String> results = new ArrayList<String>();
            Player player = Bukkit.getPlayer((String)args[1]);
            if (player != null) {
                BukkitQuester quester = this.plugin.getQuester(player.getUniqueId());
                if (quester != null) {
                    for (Quest quest : quester.getCompletedQuests()) {
                        if (!quest.getName().toLowerCase().startsWith(args[2].toLowerCase())) continue;
                        results.add(ChatColor.stripColor((String)quest.getName()));
                    }
                }
            } else {
                for (Quest quest : this.plugin.getLoadedQuests()) {
                    if (!quest.getName().toLowerCase().startsWith(args[2].toLowerCase())) continue;
                    results.add(ChatColor.stripColor((String)quest.getName()));
                }
            }
            return results;
        }
        return Collections.emptyList();
    }
}

