/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.commands.questadmin.subcommands;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListSet;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.commands.BukkitQuestsSubCommand;
import me.pikamug.quests.player.BukkitQuester;
import me.pikamug.quests.storage.QuesterStorage;
import me.pikamug.quests.util.BukkitLang;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;

public class BukkitQuestadminResetCommand
extends BukkitQuestsSubCommand {
    private final BukkitQuestsPlugin plugin;

    public BukkitQuestadminResetCommand(BukkitQuestsPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public String getName() {
        return "reset";
    }

    @Override
    public String getNameI18N() {
        return BukkitLang.get("COMMAND_QUESTADMIN_RESET");
    }

    @Override
    public String getDescription() {
        return BukkitLang.get("COMMAND_QUESTADMIN_RESET_HELP");
    }

    @Override
    public String getPermission() {
        return "quests.admin.reset";
    }

    @Override
    public String getSyntax() {
        return "/questadmin reset";
    }

    @Override
    public int getMaxArguments() {
        return 2;
    }

    @Override
    public void execute(CommandSender cs, String[] args) {
        if (args.length == 1) {
            return;
        }
        if (cs.hasPermission("quests.admin.*") || cs.hasPermission("quests.admin.reset")) {
            OfflinePlayer target = BukkitQuestadminResetCommand.getOfflinePlayer(args[1]);
            if (target == null) {
                try {
                    target = Bukkit.getOfflinePlayer((UUID)UUID.fromString(args[1]));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (target == null || target.getName() == null) {
                cs.sendMessage(ChatColor.YELLOW + BukkitLang.get("playerNotFound"));
                return;
            }
            UUID id = target.getUniqueId();
            ConcurrentSkipListSet temp = (ConcurrentSkipListSet)this.plugin.getOfflineQuesters();
            temp.removeIf(quester -> quester.getUUID().equals(id));
            this.plugin.setOfflineQuesters(temp);
            BukkitQuester quester2 = this.plugin.getQuester(id);
            try {
                quester2.resetCompass();
                quester2.hardClear();
                quester2.saveData();
                quester2.updateJournal();
                QuesterStorage storage = this.plugin.getStorage();
                storage.deleteQuester(id);
                String msg = BukkitLang.get("questReset");
                msg = target.getName() != null ? msg.replace("<player>", target.getName()) : msg.replace("<player>", args[1]);
                cs.sendMessage(ChatColor.GOLD + msg);
                cs.sendMessage(ChatColor.DARK_PURPLE + " UUID: " + ChatColor.DARK_AQUA + id);
            }
            catch (Exception e) {
                this.plugin.getLogger().info("Data file does not exist for " + id);
            }
            quester2 = new BukkitQuester(this.plugin, id);
            quester2.saveData();
            ConcurrentSkipListSet temp2 = (ConcurrentSkipListSet)this.plugin.getOfflineQuesters();
            temp2.add(quester2);
            this.plugin.setOfflineQuesters(temp2);
        } else {
            cs.sendMessage(ChatColor.RED + BukkitLang.get("noPermission"));
        }
    }

    @Override
    public List<String> tabComplete(CommandSender commandSender, String[] args) {
        if (args.length == 2) {
            return null;
        }
        return Collections.emptyList();
    }
}

