/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.commands.questadmin.subcommands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.commands.BukkitQuestsSubCommand;
import me.pikamug.quests.player.BukkitQuester;
import me.pikamug.quests.quests.Quest;
import me.pikamug.quests.util.BukkitLang;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class BukkitQuestadminSetstageCommand
extends BukkitQuestsSubCommand {
    private final BukkitQuestsPlugin plugin;

    public BukkitQuestadminSetstageCommand(BukkitQuestsPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public String getName() {
        return "setstage";
    }

    @Override
    public String getNameI18N() {
        return BukkitLang.get("COMMAND_QUESTADMIN_SETSTAGE");
    }

    @Override
    public String getDescription() {
        return BukkitLang.get("COMMAND_QUESTADMIN_SETSTAGE_HELP");
    }

    @Override
    public String getPermission() {
        return "quests.admin.setstage";
    }

    @Override
    public String getSyntax() {
        return "/questadmin setstage";
    }

    @Override
    public int getMaxArguments() {
        return 4;
    }

    @Override
    public void execute(CommandSender cs, String[] args) {
        if (args.length < 4) {
            return;
        }
        if (cs.hasPermission("quests.admin.*") || cs.hasPermission("quests.admin.setstage")) {
            int stage;
            OfflinePlayer target = BukkitQuestadminSetstageCommand.getOfflinePlayer(args[1]);
            if (target == null) {
                try {
                    target = Bukkit.getOfflinePlayer((UUID)UUID.fromString(args[1]));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (target == null || target.getName() == null) {
                cs.sendMessage(ChatColor.YELLOW + BukkitLang.get("playerNotFound"));
                return;
            }
            try {
                stage = Integer.parseInt(args[args.length - 1]);
            }
            catch (NumberFormatException e) {
                cs.sendMessage(ChatColor.YELLOW + BukkitLang.get("inputNum"));
                return;
            }
            BukkitQuester quester = this.plugin.getQuester(target.getUniqueId());
            if (quester.getCurrentQuests().isEmpty() && target.getName() != null) {
                String msg = BukkitLang.get("noCurrentQuest");
                msg = msg.replace("<player>", target.getName());
                cs.sendMessage(ChatColor.YELLOW + msg);
            } else {
                String questName = BukkitQuestadminSetstageCommand.concatArgArray(args, 2, args.length - 2, ' ');
                Quest quest = this.plugin.getQuest(BukkitQuestadminSetstageCommand.concatArgArray(args, 2, args.length - 2, ' '));
                if (quest == null) {
                    cs.sendMessage(ChatColor.RED + BukkitLang.get("questNotFound").replace("<input>", questName != null ? questName : ""));
                    return;
                }
                if (!quester.getCurrentQuests().containsKey(quest)) {
                    String msg1 = BukkitLang.get("questForceTake");
                    msg1 = msg1.replace("<player>", quester.getLastKnownName());
                    msg1 = msg1.replace("<quest>", quest.getName());
                    cs.sendMessage(ChatColor.GOLD + msg1);
                    if (quester.getPlayer() != null && quester.getPlayer().isOnline()) {
                        String msg2 = BukkitLang.get("questForcedTake");
                        msg2 = msg2.replace("<player>", quester.getLastKnownName());
                        msg2 = msg2.replace("<quest>", quest.getName());
                        BukkitLang.send(quester.getPlayer(), ChatColor.GREEN + msg2);
                    }
                    quester.takeQuest(quest, true);
                    quester.saveData();
                }
                try {
                    quest.setStage(quester, stage - 1);
                }
                catch (IndexOutOfBoundsException e) {
                    String msg = BukkitLang.get("invalidRange");
                    msg = msg.replace("<least>", "1").replace("<greatest>", String.valueOf(quest.getStages().size()));
                    cs.sendMessage(ChatColor.RED + msg);
                }
                quester.saveData();
            }
        } else {
            cs.sendMessage(ChatColor.RED + BukkitLang.get("noPermission"));
        }
    }

    @Override
    public List<String> tabComplete(CommandSender commandSender, String[] args) {
        Quest quest;
        if (args.length == 2) {
            return null;
        }
        if (args.length == 3) {
            ArrayList<String> results = new ArrayList<String>();
            Player player = Bukkit.getPlayer((String)args[1]);
            if (player != null) {
                BukkitQuester quester = this.plugin.getQuester(player.getUniqueId());
                if (quester != null) {
                    for (Quest quest2 : quester.getCurrentQuests().keySet()) {
                        if (!quest2.getName().toLowerCase().startsWith(args[2].toLowerCase())) continue;
                        results.add(ChatColor.stripColor((String)quest2.getName()));
                    }
                }
            } else {
                for (Quest quest3 : this.plugin.getLoadedQuests()) {
                    if (!quest3.getName().toLowerCase().startsWith(args[2].toLowerCase())) continue;
                    results.add(ChatColor.stripColor((String)quest3.getName()));
                }
            }
            return results;
        }
        if (args.length > 3 && (quest = this.plugin.getQuest(args[2])) != null) {
            ArrayList<String> results = new ArrayList<String>();
            for (int i = 1; i <= quest.getStages().size(); ++i) {
                results.add(String.valueOf(i));
            }
            return results;
        }
        return Collections.emptyList();
    }
}

