/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.commands.questadmin.subcommands;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.commands.BukkitQuestsSubCommand;
import me.pikamug.quests.player.BukkitQuester;
import me.pikamug.quests.quests.Quest;
import me.pikamug.quests.util.BukkitLang;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;

public class BukkitQuestadminStatsCommand
extends BukkitQuestsSubCommand {
    private final BukkitQuestsPlugin plugin;

    public BukkitQuestadminStatsCommand(BukkitQuestsPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public String getName() {
        return "stats";
    }

    @Override
    public String getNameI18N() {
        return BukkitLang.get("COMMAND_QUESTADMIN_STATS");
    }

    @Override
    public String getDescription() {
        return BukkitLang.get("COMMAND_QUESTADMIN_STATS_HELP");
    }

    @Override
    public String getPermission() {
        return "quests.admin.stats";
    }

    @Override
    public String getSyntax() {
        return "/questadmin stats";
    }

    @Override
    public int getMaxArguments() {
        return 2;
    }

    @Override
    public void execute(CommandSender cs, String[] args) {
        if (args.length == 1) {
            return;
        }
        if (cs.hasPermission("quests.admin.*") && cs.hasPermission("quests.admin.stats")) {
            OfflinePlayer target = BukkitQuestadminStatsCommand.getOfflinePlayer(args[1]);
            if (target == null) {
                try {
                    target = Bukkit.getOfflinePlayer((UUID)UUID.fromString(args[1]));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (target == null || target.getName() == null) {
                cs.sendMessage(ChatColor.YELLOW + BukkitLang.get("playerNotFound"));
                return;
            }
            BukkitQuester quester = this.plugin.getQuester(target.getUniqueId());
            cs.sendMessage(ChatColor.GOLD + "- " + target.getName() + " -");
            cs.sendMessage(ChatColor.YELLOW + BukkitLang.get("questPoints") + " - " + ChatColor.DARK_PURPLE + quester.getQuestPoints());
            if (quester.getCurrentQuests().isEmpty()) {
                cs.sendMessage(ChatColor.YELLOW + BukkitLang.get("currentQuest") + " " + ChatColor.DARK_PURPLE + BukkitLang.get("none"));
            } else {
                cs.sendMessage(ChatColor.YELLOW + BukkitLang.get("currentQuest"));
                for (Map.Entry<Quest, Integer> set : quester.getCurrentQuests().entrySet()) {
                    Quest q = set.getKey();
                    String msg = ChatColor.LIGHT_PURPLE + " - " + ChatColor.DARK_PURPLE + q.getName() + ChatColor.LIGHT_PURPLE + " (" + BukkitLang.get("stageEditorStage") + " " + (set.getValue() + 1) + ")";
                    cs.sendMessage(msg);
                }
            }
            cs.sendMessage(ChatColor.YELLOW + BukkitLang.get("completedQuest"));
            if (quester.getCompletedQuests().isEmpty()) {
                cs.sendMessage(ChatColor.DARK_PURPLE + BukkitLang.get("none"));
            } else {
                StringBuilder completed = new StringBuilder(" ");
                int index = 1;
                for (Quest q : quester.getCompletedQuests()) {
                    completed.append(ChatColor.DARK_PURPLE).append(q.getName());
                    if (quester.getAmountsCompleted().containsKey(q) && quester.getAmountsCompleted().get(q) > 1) {
                        completed.append(ChatColor.LIGHT_PURPLE).append(" (x").append(quester.getAmountsCompleted().get(q)).append(")");
                    }
                    if (index < quester.getCompletedQuests().size()) {
                        completed.append(", ");
                    }
                    ++index;
                }
                cs.sendMessage(completed.toString());
            }
        } else {
            cs.sendMessage(ChatColor.RED + BukkitLang.get("noPermission"));
        }
    }

    @Override
    public List<String> tabComplete(CommandSender commandSender, String[] args) {
        if (args.length == 2) {
            return null;
        }
        return Collections.emptyList();
    }
}

