/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.commands.questadmin.subcommands;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.commands.BukkitQuestsSubCommand;
import me.pikamug.quests.player.BukkitQuester;
import me.pikamug.quests.util.BukkitLang;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class BukkitQuestadminTakepointsCommand
extends BukkitQuestsSubCommand {
    private final BukkitQuestsPlugin plugin;

    public BukkitQuestadminTakepointsCommand(BukkitQuestsPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public String getName() {
        return "takepoints";
    }

    @Override
    public String getNameI18N() {
        return BukkitLang.get("COMMAND_QUESTADMIN_TAKEPOINTS");
    }

    @Override
    public String getDescription() {
        return BukkitLang.get("COMMAND_QUESTADMIN_TAKEPOINTS_HELP");
    }

    @Override
    public String getPermission() {
        return "quests.admin.takepoints";
    }

    @Override
    public String getSyntax() {
        return "/questadmin takepoints";
    }

    @Override
    public int getMaxArguments() {
        return 3;
    }

    @Override
    public void execute(CommandSender cs, String[] args) {
        if (args.length < 3) {
            return;
        }
        if (cs.hasPermission("quests.admin.*") || cs.hasPermission("quests.admin.takepoints")) {
            int points;
            OfflinePlayer target = BukkitQuestadminTakepointsCommand.getOfflinePlayer(args[1]);
            if (target == null) {
                try {
                    target = Bukkit.getOfflinePlayer((UUID)UUID.fromString(args[1]));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (target == null || target.getName() == null) {
                cs.sendMessage(ChatColor.YELLOW + BukkitLang.get("playerNotFound"));
                return;
            }
            try {
                points = Integer.parseInt(args[2]);
            }
            catch (NumberFormatException e) {
                cs.sendMessage(ChatColor.YELLOW + BukkitLang.get("inputNum"));
                return;
            }
            BukkitQuester quester = this.plugin.getQuester(target.getUniqueId());
            int newPoints = quester.getQuestPoints() - Math.abs(points);
            if (newPoints < 0) {
                quester.setQuestPoints(0);
            } else {
                quester.setQuestPoints(quester.getQuestPoints() - Math.abs(points));
                String msg1 = BukkitLang.get("takeQuestPoints").replace("<points>", BukkitLang.get("questPoints"));
                msg1 = msg1.replace("<player>", target.getName());
                msg1 = msg1.replace("<number>", String.valueOf(points));
                cs.sendMessage(ChatColor.GOLD + msg1);
                if (target.isOnline()) {
                    Player p = (Player)target;
                    String msg2 = BukkitLang.get(p, "questPointsTaken").replace("<points>", BukkitLang.get("questPoints"));
                    msg2 = msg2.replace("<player>", cs.getName());
                    msg2 = msg2.replace("<number>", String.valueOf(points));
                    p.sendMessage(ChatColor.GREEN + msg2);
                }
                quester.saveData();
            }
        } else {
            cs.sendMessage(ChatColor.RED + BukkitLang.get("noPermission"));
        }
    }

    @Override
    public List<String> tabComplete(CommandSender commandSender, String[] args) {
        if (args.length == 2) {
            return null;
        }
        return Collections.emptyList();
    }
}

