/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.commands.quests.subcommands;

import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.commands.BukkitQuestsSubCommand;
import me.pikamug.quests.util.BukkitLang;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.conversations.Conversable;

public class BukkitQuestsActionsCommand
extends BukkitQuestsSubCommand {
    private final BukkitQuestsPlugin plugin;

    public BukkitQuestsActionsCommand(BukkitQuestsPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public String getName() {
        return "actions";
    }

    @Override
    public String getNameI18N() {
        return BukkitLang.get("COMMAND_EVENTS_EDITOR");
    }

    @Override
    public String getDescription() {
        return BukkitLang.get("COMMAND_EVENTS_EDITOR_HELP");
    }

    @Override
    public String getPermission() {
        return "quests.actions";
    }

    @Override
    public String getSyntax() {
        return "/quests actions";
    }

    @Override
    public int getMaxArguments() {
        return 1;
    }

    @Override
    public void execute(CommandSender cs, String[] args) {
        if (cs.hasPermission("quests.actions.*") || cs.hasPermission("quests.actions.editor") || cs.hasPermission("quests.mode.trial")) {
            Conversable c = (Conversable)cs;
            if (!c.isConversing()) {
                this.plugin.getActionFactory().getConversationFactory().buildConversation(c).begin();
            } else {
                cs.sendMessage(ChatColor.RED + BukkitLang.get(cs, "duplicateEditor"));
            }
        } else {
            cs.sendMessage(ChatColor.RED + BukkitLang.get(cs, "noPermission"));
        }
    }
}

