/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.commands.quests.subcommands;

import me.pikamug.quests.commands.BukkitQuestsSubCommand;
import me.pikamug.quests.util.BukkitLang;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class BukkitQuestsChoiceCommand
extends BukkitQuestsSubCommand {
    @Override
    public String getName() {
        return "choice";
    }

    @Override
    public String getNameI18N() {
        return BukkitLang.get("COMMAND_CHOICE");
    }

    @Override
    public String getDescription() {
        return BukkitLang.get("COMMAND_CHOICE_HELP");
    }

    @Override
    public String getPermission() {
        return "quests.choice";
    }

    @Override
    public String getSyntax() {
        return "/quests choice";
    }

    @Override
    public int getMaxArguments() {
        return 2;
    }

    @Override
    public void execute(CommandSender cs, String[] args) {
        if (BukkitQuestsChoiceCommand.assertNonPlayer(cs)) {
            return;
        }
        Player player = (Player)cs;
        if (!cs.hasPermission(this.getPermission())) {
            BukkitLang.send(player, ChatColor.RED + BukkitLang.get(player, "noPermission"));
            return;
        }
        if (!player.isConversing()) {
            BukkitLang.send(player, ChatColor.RED + BukkitLang.get(player, "notConversing"));
            return;
        }
        if (args.length == 1) {
            return;
        }
        String input = BukkitQuestsChoiceCommand.concatArgArray(args, 1, args.length - 1, ' ');
        if (input != null) {
            player.acceptConversationInput(input);
        }
    }
}

