/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.commands.quests.subcommands;

import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.commands.BukkitQuestsSubCommand;
import me.pikamug.quests.util.BukkitLang;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.conversations.Conversable;

public class BukkitQuestsConditionsCommand
extends BukkitQuestsSubCommand {
    private final BukkitQuestsPlugin plugin;

    public BukkitQuestsConditionsCommand(BukkitQuestsPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public String getName() {
        return "conditions";
    }

    @Override
    public String getNameI18N() {
        return BukkitLang.get("COMMAND_CONDITIONS_EDITOR");
    }

    @Override
    public String getDescription() {
        return BukkitLang.get("COMMAND_CONDITIONS_EDITOR_HELP");
    }

    @Override
    public String getPermission() {
        return "quests.conditions";
    }

    @Override
    public String getSyntax() {
        return "/quests conditions";
    }

    @Override
    public int getMaxArguments() {
        return 1;
    }

    @Override
    public void execute(CommandSender cs, String[] args) {
        if (cs.hasPermission("quests.conditions.*") || cs.hasPermission("quests.conditions.editor") || cs.hasPermission("quests.mode.trial")) {
            Conversable c = (Conversable)cs;
            if (!c.isConversing()) {
                this.plugin.getConditionFactory().getConversationFactory().buildConversation(c).begin();
            } else {
                cs.sendMessage(ChatColor.RED + BukkitLang.get(cs, "duplicateEditor"));
            }
        } else {
            cs.sendMessage(ChatColor.RED + BukkitLang.get(cs, "noPermission"));
        }
    }
}

