/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.commands.quests.subcommands;

import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.commands.BukkitQuestsSubCommand;
import me.pikamug.quests.events.command.BukkitQuestsCommandPreEditorEvent;
import me.pikamug.quests.player.BukkitQuester;
import me.pikamug.quests.util.BukkitLang;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.Conversation;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class BukkitQuestsEditorCommand
extends BukkitQuestsSubCommand {
    private final BukkitQuestsPlugin plugin;

    public BukkitQuestsEditorCommand(BukkitQuestsPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public String getName() {
        return "editor";
    }

    @Override
    public String getNameI18N() {
        return BukkitLang.get("COMMAND_EDITOR");
    }

    @Override
    public String getDescription() {
        return BukkitLang.get("COMMAND_EDITOR_HELP");
    }

    @Override
    public String getPermission() {
        return "quests.editor";
    }

    @Override
    public String getSyntax() {
        return "/quests editor";
    }

    @Override
    public int getMaxArguments() {
        return 1;
    }

    @Override
    public void execute(CommandSender cs, String[] args) {
        if (cs.hasPermission("quests.editor.*") || cs.hasPermission("quests.editor.editor") || cs.hasPermission("quests.mode.trial")) {
            Conversable c = (Conversable)cs;
            if (!c.isConversing()) {
                Conversation cn = this.plugin.getQuestFactory().getConversationFactory().buildConversation(c);
                if (cs instanceof Player) {
                    BukkitQuester quester = this.plugin.getQuester(((Player)cs).getUniqueId());
                    BukkitQuestsCommandPreEditorEvent event = new BukkitQuestsCommandPreEditorEvent(quester, cn.getContext());
                    this.plugin.getServer().getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        return;
                    }
                }
                cn.begin();
            } else {
                cs.sendMessage(ChatColor.RED + BukkitLang.get(cs, "duplicateEditor"));
            }
        } else {
            cs.sendMessage(ChatColor.RED + BukkitLang.get(cs, "noPermission"));
        }
    }
}

