/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.commands.quests.subcommands;

import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.commands.BukkitQuestsSubCommand;
import me.pikamug.quests.events.command.BukkitQuestsCommandPreJournalEvent;
import me.pikamug.quests.item.BukkitQuestJournal;
import me.pikamug.quests.libs.bookutil.BookUtil;
import me.pikamug.quests.player.BukkitQuester;
import me.pikamug.quests.util.BukkitLang;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class BukkitQuestsJournalCommand
extends BukkitQuestsSubCommand {
    private final BukkitQuestsPlugin plugin;

    public BukkitQuestsJournalCommand(BukkitQuestsPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public String getName() {
        return "journal";
    }

    @Override
    public String getNameI18N() {
        return BukkitLang.get("COMMAND_JOURNAL");
    }

    @Override
    public String getDescription() {
        return BukkitLang.get("COMMAND_JOURNAL_HELP");
    }

    @Override
    public String getPermission() {
        return "quests.journal";
    }

    @Override
    public String getSyntax() {
        return "/quests journal";
    }

    @Override
    public int getMaxArguments() {
        return 1;
    }

    @Override
    public void execute(CommandSender cs, String[] args) {
        if (BukkitQuestsJournalCommand.assertNonPlayer(cs)) {
            return;
        }
        Player player = (Player)cs;
        if (player.hasPermission(this.getPermission())) {
            BukkitQuester quester = this.plugin.getQuester(player.getUniqueId());
            BukkitQuestsCommandPreJournalEvent preEvent = new BukkitQuestsCommandPreJournalEvent(quester);
            this.plugin.getServer().getPluginManager().callEvent((Event)preEvent);
            if (preEvent.isCancelled()) {
                return;
            }
            if (!this.plugin.getConfigSettings().canGiveJournalItem()) {
                BukkitQuestJournal journal = new BukkitQuestJournal(this.plugin, quester);
                BookUtil.openPlayer(player, journal.toItemStack());
            } else {
                PlayerInventory inv = player.getInventory();
                int index = quester.getJournalIndex();
                if (index != -1) {
                    inv.setItem(index, null);
                    BukkitLang.send(player, ChatColor.YELLOW + BukkitLang.get(player, "journalPutAway").replace("<journal>", BukkitLang.get(player, "journalTitle")));
                } else if (player.getItemInHand().getType().equals((Object)Material.AIR)) {
                    BukkitQuestJournal journal = new BukkitQuestJournal(this.plugin, quester);
                    player.setItemInHand(journal.toItemStack());
                    BukkitLang.send(player, ChatColor.YELLOW + BukkitLang.get(player, "journalTaken").replace("<journal>", BukkitLang.get(player, "journalTitle")));
                } else if (inv.firstEmpty() != -1) {
                    ItemStack[] arr = inv.getContents();
                    for (int i = 0; i < arr.length; ++i) {
                        if (arr[i] != null) continue;
                        BukkitQuestJournal journal = new BukkitQuestJournal(this.plugin, quester);
                        inv.setItem(i, journal.toItemStack());
                        BukkitLang.send(player, ChatColor.YELLOW + BukkitLang.get(player, "journalTaken").replace("<journal>", BukkitLang.get(player, "journalTitle")));
                        break;
                    }
                } else {
                    BukkitLang.send(player, ChatColor.YELLOW + BukkitLang.get(player, "journalNoRoom").replace("<journal>", BukkitLang.get(player, "journalTitle")));
                }
            }
        }
    }
}

