/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.commands.quests.subcommands;

import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.commands.BukkitQuestsSubCommand;
import me.pikamug.quests.events.command.BukkitQuestsCommandPreListEvent;
import me.pikamug.quests.player.BukkitQuester;
import me.pikamug.quests.quests.Quest;
import me.pikamug.quests.util.BukkitLang;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class BukkitQuestsListCommand
extends BukkitQuestsSubCommand {
    private final BukkitQuestsPlugin plugin;

    public BukkitQuestsListCommand(BukkitQuestsPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public String getName() {
        return "list";
    }

    @Override
    public String getNameI18N() {
        return BukkitLang.get("COMMAND_LIST");
    }

    @Override
    public String getDescription() {
        return BukkitLang.get("COMMAND_LIST_HELP");
    }

    @Override
    public String getPermission() {
        return "quests.list";
    }

    @Override
    public String getSyntax() {
        return "/quests list";
    }

    @Override
    public int getMaxArguments() {
        return 1;
    }

    @Override
    public void execute(CommandSender cs, String[] args) {
        block12: {
            if (cs.hasPermission(this.getPermission())) {
                if (!(cs instanceof Player)) {
                    int num = 1;
                    cs.sendMessage(ChatColor.GOLD + BukkitLang.get("questListTitle"));
                    for (Quest q : this.plugin.getLoadedQuests()) {
                        cs.sendMessage(ChatColor.YELLOW + "" + num + ". " + q.getName());
                        ++num;
                    }
                    return;
                }
                Player player = (Player)cs;
                if (args.length == 1) {
                    BukkitQuester quester = this.plugin.getQuester(player.getUniqueId());
                    BukkitQuestsCommandPreListEvent preEvent = new BukkitQuestsCommandPreListEvent(quester, 1);
                    this.plugin.getServer().getPluginManager().callEvent((Event)preEvent);
                    if (preEvent.isCancelled()) {
                        return;
                    }
                    quester.listQuests(quester, 1);
                } else if (args.length == 2) {
                    try {
                        int page = Integer.parseInt(args[1]);
                        if (page < 1) {
                            cs.sendMessage(ChatColor.YELLOW + BukkitLang.get(player, "pageSelectionPosNum"));
                            break block12;
                        }
                        BukkitQuester quester = this.plugin.getQuester(player.getUniqueId());
                        BukkitQuestsCommandPreListEvent preEvent = new BukkitQuestsCommandPreListEvent(quester, page);
                        this.plugin.getServer().getPluginManager().callEvent((Event)preEvent);
                        if (preEvent.isCancelled()) {
                            return;
                        }
                        quester.listQuests(quester, page);
                    }
                    catch (NumberFormatException e) {
                        cs.sendMessage(ChatColor.YELLOW + BukkitLang.get(player, "pageSelectionNum"));
                    }
                }
            } else {
                cs.sendMessage(ChatColor.RED + BukkitLang.get(cs, "noPermission"));
            }
        }
    }
}

