/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.commands.quests.subcommands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.commands.BukkitQuestsSubCommand;
import me.pikamug.quests.player.BukkitQuester;
import me.pikamug.quests.quests.Quest;
import me.pikamug.quests.util.BukkitLang;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class BukkitQuestsQuitCommand
extends BukkitQuestsSubCommand {
    private final BukkitQuestsPlugin plugin;

    public BukkitQuestsQuitCommand(BukkitQuestsPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public String getName() {
        return "quit";
    }

    @Override
    public String getNameI18N() {
        return BukkitLang.get("COMMAND_QUIT");
    }

    @Override
    public String getDescription() {
        return BukkitLang.get("COMMAND_QUIT_HELP");
    }

    @Override
    public String getPermission() {
        return "quests.quit";
    }

    @Override
    public String getSyntax() {
        return "/quests quit";
    }

    @Override
    public int getMaxArguments() {
        return 2;
    }

    @Override
    public void execute(CommandSender cs, String[] args) {
        if (args.length == 1) {
            return;
        }
        if (BukkitQuestsQuitCommand.assertNonPlayer(cs)) {
            return;
        }
        Player player = (Player)cs;
        if (player.hasPermission(this.getPermission())) {
            BukkitQuester quester = this.plugin.getQuester(player.getUniqueId());
            if (!quester.getCurrentQuests().isEmpty()) {
                String questName = BukkitQuestsQuitCommand.concatArgArray(args, 1, args.length - 1, ' ');
                Quest quest = this.plugin.getQuest(BukkitQuestsQuitCommand.concatArgArray(args, 1, args.length - 1, ' '));
                if (quest != null) {
                    if (quest.getOptions().canAllowQuitting()) {
                        String msg = ChatColor.YELLOW + BukkitLang.get(player, "questQuit").replace("<quest>", quest.getName());
                        quester.abandonQuest(quest, msg);
                    } else {
                        BukkitLang.send(player, ChatColor.YELLOW + BukkitLang.get(player, "questQuitDisabled"));
                    }
                } else {
                    BukkitLang.send(player, ChatColor.RED + BukkitLang.get(player, "questNotFound").replace("<input>", questName != null ? questName : ""));
                }
            } else {
                BukkitLang.send(player, ChatColor.YELLOW + BukkitLang.get(player, "noActiveQuest"));
            }
        } else {
            BukkitLang.send(player, ChatColor.RED + BukkitLang.get(player, "noPermission"));
        }
    }

    @Override
    public List<String> tabComplete(CommandSender commandSender, String[] args) {
        if (args.length == 2) {
            ArrayList<String> results = new ArrayList<String>();
            if (commandSender instanceof Player) {
                BukkitQuester quester = this.plugin.getQuester(((Player)commandSender).getUniqueId());
                if (quester != null) {
                    for (Quest quest : quester.getCurrentQuests().keySet()) {
                        if (!quest.getName().toLowerCase().startsWith(args[1].toLowerCase())) continue;
                        results.add(ChatColor.stripColor((String)quest.getName()));
                    }
                }
            } else {
                for (Quest quest : this.plugin.getLoadedQuests()) {
                    if (!quest.getName().toLowerCase().startsWith(args[1].toLowerCase())) continue;
                    results.add(ChatColor.stripColor((String)quest.getName()));
                }
            }
            return results;
        }
        return Collections.emptyList();
    }
}

