/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.commands.quests.subcommands;

import java.util.Map;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.commands.BukkitQuestsSubCommand;
import me.pikamug.quests.player.BukkitQuester;
import me.pikamug.quests.quests.Quest;
import me.pikamug.quests.util.BukkitLang;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class BukkitQuestsStatsCommand
extends BukkitQuestsSubCommand {
    private final BukkitQuestsPlugin plugin;

    public BukkitQuestsStatsCommand(BukkitQuestsPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public String getName() {
        return "stats";
    }

    @Override
    public String getNameI18N() {
        return BukkitLang.get("COMMAND_STATS");
    }

    @Override
    public String getDescription() {
        return BukkitLang.get("COMMAND_STATS_HELP");
    }

    @Override
    public String getPermission() {
        return "quests.stats";
    }

    @Override
    public String getSyntax() {
        return "/quests stats";
    }

    @Override
    public int getMaxArguments() {
        return 1;
    }

    @Override
    public void execute(CommandSender cs, String[] args) {
        if (BukkitQuestsStatsCommand.assertNonPlayer(cs)) {
            return;
        }
        Player player = (Player)cs;
        if (cs.hasPermission(this.getPermission())) {
            BukkitQuester quester = this.plugin.getQuester(player.getUniqueId());
            cs.sendMessage(ChatColor.GOLD + "- " + player.getName() + " -");
            cs.sendMessage(ChatColor.YELLOW + BukkitLang.get(player, "questPoints") + " - " + ChatColor.DARK_PURPLE + quester.getQuestPoints());
            if (quester.getCurrentQuests().isEmpty()) {
                cs.sendMessage(ChatColor.YELLOW + BukkitLang.get(player, "currentQuest") + " " + ChatColor.DARK_PURPLE + BukkitLang.get("none"));
            } else {
                cs.sendMessage(ChatColor.YELLOW + BukkitLang.get(player, "currentQuest"));
                for (Map.Entry<Quest, Integer> set : quester.getCurrentQuests().entrySet()) {
                    Quest q = set.getKey();
                    String msg = ChatColor.LIGHT_PURPLE + " - " + ChatColor.DARK_PURPLE + q.getName() + ChatColor.LIGHT_PURPLE + " (" + BukkitLang.get(player, "stageEditorStage") + " " + (set.getValue() + 1) + ")";
                    cs.sendMessage(msg);
                }
            }
            cs.sendMessage(ChatColor.YELLOW + BukkitLang.get(player, "completedQuest"));
            if (quester.getCompletedQuests().isEmpty()) {
                cs.sendMessage(ChatColor.DARK_PURPLE + BukkitLang.get("none"));
            } else {
                StringBuilder completed = new StringBuilder(" ");
                int index = 1;
                for (Quest q : quester.getCompletedQuests()) {
                    completed.append(ChatColor.DARK_PURPLE).append(q.getName());
                    if (quester.getAmountsCompleted().containsKey(q) && quester.getAmountsCompleted().get(q) > 1) {
                        completed.append(ChatColor.LIGHT_PURPLE).append(" (x").append(quester.getAmountsCompleted().get(q)).append(")");
                    }
                    if (index < quester.getCompletedQuests().size()) {
                        completed.append(", ");
                    }
                    ++index;
                }
                cs.sendMessage(completed.toString());
            }
        }
    }
}

