/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.commands.quests.subcommands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.commands.BukkitQuestsSubCommand;
import me.pikamug.quests.player.BukkitQuester;
import me.pikamug.quests.quests.Quest;
import me.pikamug.quests.util.BukkitLang;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class BukkitQuestsTakeCommand
extends BukkitQuestsSubCommand {
    private final BukkitQuestsPlugin plugin;

    public BukkitQuestsTakeCommand(BukkitQuestsPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public String getName() {
        return "take";
    }

    @Override
    public String getNameI18N() {
        return BukkitLang.get("COMMAND_TAKE");
    }

    @Override
    public String getDescription() {
        return BukkitLang.get("COMMAND_TAKE_HELP");
    }

    @Override
    public String getPermission() {
        return "quests.take";
    }

    @Override
    public String getSyntax() {
        return "/quests take";
    }

    @Override
    public int getMaxArguments() {
        return 2;
    }

    @Override
    public void execute(CommandSender cs, String[] args) {
        if (args.length == 1) {
            return;
        }
        if (BukkitQuestsTakeCommand.assertNonPlayer(cs)) {
            return;
        }
        Player player = (Player)cs;
        if (this.plugin.getConfigSettings().canAllowCommands()) {
            if (player.hasPermission(this.getPermission())) {
                String questToFindName = BukkitQuestsTakeCommand.concatArgArray(args, 1, args.length - 1, ' ');
                Quest questToFind = this.plugin.getQuest(questToFindName);
                if (questToFind != null) {
                    BukkitQuester quester = this.plugin.getQuester(player.getUniqueId());
                    for (Quest q : quester.getCurrentQuests().keySet()) {
                        if (!q.getId().equals(questToFind.getId())) continue;
                        BukkitLang.send(player, ChatColor.RED + BukkitLang.get(player, "questAlreadyOn"));
                        return;
                    }
                    quester.offerQuest(questToFind, true);
                } else {
                    BukkitLang.send(player, ChatColor.YELLOW + BukkitLang.get(player, "questNotFound").replace("<input>", questToFindName != null ? questToFindName : ""));
                }
            } else {
                BukkitLang.send(player, ChatColor.RED + BukkitLang.get(player, "noPermission"));
            }
        } else {
            BukkitLang.send(player, ChatColor.YELLOW + BukkitLang.get(player, "questTakeDisabled"));
        }
    }

    @Override
    public List<String> tabComplete(CommandSender commandSender, String[] args) {
        if (args.length == 2) {
            ArrayList<String> results = new ArrayList<String>();
            for (Quest quest : this.plugin.getLoadedQuests()) {
                if (!quest.getName().toLowerCase().startsWith(args[1].toLowerCase())) continue;
                results.add(ChatColor.stripColor((String)quest.getName()));
            }
            return results;
        }
        return Collections.emptyList();
    }
}

