/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.commands.quests.subcommands;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.commands.BukkitQuestsSubCommand;
import me.pikamug.quests.player.Quester;
import me.pikamug.quests.util.BukkitLang;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class BukkitQuestsTopCommand
extends BukkitQuestsSubCommand {
    private final BukkitQuestsPlugin plugin;

    public BukkitQuestsTopCommand(BukkitQuestsPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public String getName() {
        return "top";
    }

    @Override
    public String getNameI18N() {
        return BukkitLang.get("COMMAND_TOP");
    }

    @Override
    public String getDescription() {
        return BukkitLang.get("COMMAND_TOP_HELP");
    }

    @Override
    public String getPermission() {
        return "quests.top";
    }

    @Override
    public String getSyntax() {
        return "/quests top";
    }

    @Override
    public int getMaxArguments() {
        return 1;
    }

    @Override
    public void execute(CommandSender cs, String[] args) {
        if (cs.hasPermission(this.getPermission())) {
            int topNumber;
            if (args.length == 1) {
                topNumber = 5;
            } else {
                try {
                    topNumber = Integer.parseInt(args[1]);
                }
                catch (NumberFormatException e) {
                    cs.sendMessage(ChatColor.YELLOW + BukkitLang.get(cs, "inputNum"));
                    return;
                }
            }
            if (topNumber < 1 || topNumber > this.plugin.getConfigSettings().getTopLimit()) {
                cs.sendMessage(ChatColor.YELLOW + BukkitLang.get(cs, "invalidRange").replace("<least>", "1").replace("<greatest>", String.valueOf(this.plugin.getConfigSettings().getTopLimit())));
                return;
            }
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                Map<String, Integer> questPoints = this.plugin.getOfflineQuesters().stream().collect(Collectors.toMap(Quester::getLastKnownName, Quester::getQuestPoints));
                LinkedHashMap sortedMap = (LinkedHashMap)BukkitQuestsTopCommand.sort(questPoints);
                int numPrinted = 0;
                String msg = BukkitLang.get(cs, "topQuestersTitle");
                msg = msg.replace("<number>", String.valueOf(topNumber));
                cs.sendMessage(ChatColor.GOLD + msg);
                for (Map.Entry entry : sortedMap.entrySet()) {
                    cs.sendMessage(ChatColor.YELLOW + String.valueOf(++numPrinted) + ". " + (String)entry.getKey() + " - " + ChatColor.DARK_PURPLE + entry.getValue() + ChatColor.YELLOW + " " + BukkitLang.get(cs, "questPoints"));
                    if (numPrinted != topNumber) continue;
                    break;
                }
            });
        }
    }
}

