/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.conditions;

import java.util.LinkedList;
import java.util.UUID;
import me.clip.placeholderapi.PlaceholderAPI;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.conditions.Condition;
import me.pikamug.quests.player.Quester;
import me.pikamug.quests.quests.Quest;
import me.pikamug.quests.util.BukkitItemUtil;
import me.pikamug.quests.util.BukkitMiscUtil;
import org.bukkit.block.Biome;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class BukkitCondition
implements Condition {
    private final BukkitQuestsPlugin plugin;
    private String name = "";
    private boolean failQuest = false;
    private LinkedList<String> entitiesWhileRiding = new LinkedList();
    private LinkedList<UUID> npcsWhileRiding = new LinkedList();
    private LinkedList<String> permissions = new LinkedList();
    private LinkedList<ItemStack> itemsWhileHoldingMainHand = new LinkedList();
    private LinkedList<ItemStack> itemsWhileWearing = new LinkedList();
    private LinkedList<String> worldsWhileStayingWithin = new LinkedList();
    private int tickStartWhileStayingWithin = -1;
    private int tickEndWhileStayingWithin = -1;
    private LinkedList<String> biomesWhileStayingWithin = new LinkedList();
    private LinkedList<String> regionsWhileStayingWithin = new LinkedList();
    private LinkedList<String> placeholdersCheckIdentifier = new LinkedList();
    private LinkedList<String> placeholdersCheckValue = new LinkedList();

    public BukkitCondition(BukkitQuestsPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public int compareTo(Condition condition) {
        return this.name.compareTo(condition.getName());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isFailQuest() {
        return this.failQuest;
    }

    @Override
    public void setFailQuest(boolean failQuest) {
        this.failQuest = failQuest;
    }

    @Override
    public LinkedList<String> getEntitiesWhileRiding() {
        return this.entitiesWhileRiding;
    }

    @Override
    public void setEntitiesWhileRiding(LinkedList<String> entitiesWhileRiding) {
        this.entitiesWhileRiding = entitiesWhileRiding;
    }

    @Override
    public LinkedList<UUID> getNpcsWhileRiding() {
        return this.npcsWhileRiding;
    }

    @Override
    public void setNpcsWhileRiding(LinkedList<UUID> npcsWhileRiding) {
        this.npcsWhileRiding = npcsWhileRiding;
    }

    @Override
    public LinkedList<String> getPermissions() {
        return this.permissions;
    }

    @Override
    public void setPermissions(LinkedList<String> permissions) {
        this.permissions = permissions;
    }

    public LinkedList<ItemStack> getItemsWhileHoldingMainHand() {
        return this.itemsWhileHoldingMainHand;
    }

    public void setItemsWhileHoldingMainHand(LinkedList<ItemStack> itemsWhileHoldingMainHand) {
        this.itemsWhileHoldingMainHand = itemsWhileHoldingMainHand;
    }

    public LinkedList<ItemStack> getItemsWhileWearing() {
        return this.itemsWhileWearing;
    }

    public void setItemsWhileWearing(LinkedList<ItemStack> itemsWhileWearing) {
        this.itemsWhileWearing = itemsWhileWearing;
    }

    @Override
    public LinkedList<String> getWorldsWhileStayingWithin() {
        return this.worldsWhileStayingWithin;
    }

    @Override
    public void setWorldsWhileStayingWithin(LinkedList<String> worldsWhileStayingWithin) {
        this.worldsWhileStayingWithin = worldsWhileStayingWithin;
    }

    @Override
    public int getTickStartWhileStayingWithin() {
        return this.tickStartWhileStayingWithin;
    }

    @Override
    public void setTickStartWhileStayingWithin(int tickStartWhileStayingWithin) {
        this.tickStartWhileStayingWithin = tickStartWhileStayingWithin;
    }

    @Override
    public int getTickEndWhileStayingWithin() {
        return this.tickEndWhileStayingWithin;
    }

    @Override
    public void setTickEndWhileStayingWithin(int tickEndWhileStayingWithin) {
        this.tickEndWhileStayingWithin = tickEndWhileStayingWithin;
    }

    @Override
    public LinkedList<String> getBiomesWhileStayingWithin() {
        return this.biomesWhileStayingWithin;
    }

    @Override
    public void setBiomesWhileStayingWithin(LinkedList<String> biomesWhileStayingWithin) {
        this.biomesWhileStayingWithin = biomesWhileStayingWithin;
    }

    @Override
    public LinkedList<String> getRegionsWhileStayingWithin() {
        return this.regionsWhileStayingWithin;
    }

    @Override
    public void setRegionsWhileStayingWithin(LinkedList<String> biomesWhileStayingWithin) {
        this.regionsWhileStayingWithin = biomesWhileStayingWithin;
    }

    @Override
    public LinkedList<String> getPlaceholdersCheckIdentifier() {
        return this.placeholdersCheckIdentifier;
    }

    @Override
    public void setPlaceholdersCheckIdentifier(LinkedList<String> placeholdersCheckIdentifier) {
        this.placeholdersCheckIdentifier = placeholdersCheckIdentifier;
    }

    @Override
    public LinkedList<String> getPlaceholdersCheckValue() {
        return this.placeholdersCheckValue;
    }

    @Override
    public void setPlaceholdersCheckValue(LinkedList<String> placeholdersCheckValue) {
        this.placeholdersCheckValue = placeholdersCheckValue;
    }

    @Override
    public boolean check(Quester quester, Quest quest) {
        boolean failed;
        block22: {
            Player player;
            block30: {
                block29: {
                    block28: {
                        block27: {
                            block26: {
                                block25: {
                                    block24: {
                                        block23: {
                                            player = quester.getPlayer();
                                            failed = false;
                                            if (this.entitiesWhileRiding.isEmpty()) break block23;
                                            boolean atLeastOne = false;
                                            for (String e : this.entitiesWhileRiding) {
                                                if (player.getVehicle() == null) {
                                                    return false;
                                                }
                                                if (!player.getVehicle().getType().equals((Object)BukkitMiscUtil.getProperMobType(e))) continue;
                                                atLeastOne = true;
                                                break;
                                            }
                                            if (atLeastOne) break block22;
                                            failed = true;
                                            break block22;
                                        }
                                        if (this.npcsWhileRiding.isEmpty()) break block24;
                                        boolean atLeastOne = false;
                                        for (UUID n : this.npcsWhileRiding) {
                                            if (!this.plugin.getDependencies().hasAnyEntityNpcDependencies()) {
                                                this.plugin.getLogger().warning("An Entity NPC plugin must be installed for condition ride NPC UUID " + n);
                                                return false;
                                            }
                                            if (player.getVehicle() == null) {
                                                return false;
                                            }
                                            if (!player.getVehicle().equals(this.plugin.getDependencies().getNpcEntity(n))) continue;
                                            atLeastOne = true;
                                            break;
                                        }
                                        if (atLeastOne) break block22;
                                        failed = true;
                                        break block22;
                                    }
                                    if (this.permissions.isEmpty()) break block25;
                                    for (String p : this.permissions) {
                                        if (!this.plugin.getDependencies().isPluginAvailable("Vault")) {
                                            this.plugin.getLogger().warning("Vault must be installed for condition permission checks: " + p);
                                            return false;
                                        }
                                        if (this.plugin.getDependencies().getVaultPermission().has(player, p)) continue;
                                        failed = true;
                                        if (this.plugin.getConfigSettings().getConsoleLogging() <= 3) break block22;
                                        this.plugin.getLogger().info("DEBUG: Condition permission mismatch for " + player.getName() + ": " + p);
                                        break block22;
                                    }
                                    break block22;
                                }
                                if (this.itemsWhileHoldingMainHand.isEmpty()) break block26;
                                boolean atLeastOne = false;
                                for (ItemStack is : this.itemsWhileHoldingMainHand) {
                                    if (BukkitItemUtil.compareItems(player.getItemInHand(), is, true, true) != 0) continue;
                                    atLeastOne = true;
                                    break;
                                }
                                if (atLeastOne) break block22;
                                failed = true;
                                break block22;
                            }
                            if (this.itemsWhileWearing.isEmpty()) break block27;
                            int matches = 0;
                            block4: for (ItemStack is : this.itemsWhileWearing) {
                                for (ItemStack armor : player.getInventory().getArmorContents()) {
                                    if (BukkitItemUtil.compareItems(armor, is, true, true) != 0) continue;
                                    ++matches;
                                    continue block4;
                                }
                            }
                            if (matches == this.itemsWhileWearing.size()) break block22;
                            failed = true;
                            break block22;
                        }
                        if (this.worldsWhileStayingWithin.isEmpty()) break block28;
                        boolean atLeastOne = false;
                        for (String w : this.worldsWhileStayingWithin) {
                            if (!player.getWorld().getName().equalsIgnoreCase(w)) continue;
                            atLeastOne = true;
                            break;
                        }
                        if (atLeastOne) break block22;
                        failed = true;
                        break block22;
                    }
                    if (this.tickStartWhileStayingWithin <= -1 || this.tickEndWhileStayingWithin <= -1) break block29;
                    long t = player.getWorld().getTime();
                    if (t >= (long)this.tickStartWhileStayingWithin && t <= (long)this.tickEndWhileStayingWithin) break block22;
                    failed = true;
                    break block22;
                }
                if (this.biomesWhileStayingWithin.isEmpty()) break block30;
                boolean atLeastOne = false;
                for (String b : this.biomesWhileStayingWithin) {
                    Biome properBiome = BukkitMiscUtil.getProperBiome(b);
                    if (properBiome == null) {
                        this.plugin.getLogger().warning("Invalid entry for condition biome checks: " + b);
                        continue;
                    }
                    String playerBiome = player.getWorld().getBiome(player.getLocation().getBlockX(), player.getLocation().getBlockZ()).name();
                    if (playerBiome.equalsIgnoreCase(properBiome.name())) {
                        atLeastOne = true;
                        break;
                    }
                    if (this.plugin.getConfigSettings().getConsoleLogging() <= 3) continue;
                    this.plugin.getLogger().info("DEBUG: Failed biome match " + playerBiome + " to " + properBiome.name());
                }
                if (atLeastOne) break block22;
                failed = true;
                break block22;
            }
            if (!this.regionsWhileStayingWithin.isEmpty()) {
                for (String r : this.regionsWhileStayingWithin) {
                    if (quester.isInRegion(r)) continue;
                    failed = true;
                    if (this.plugin.getConfigSettings().getConsoleLogging() <= 3) break;
                    this.plugin.getLogger().info("DEBUG: Condition region mismatch for " + player.getName() + ": " + r);
                    break;
                }
            } else if (!this.placeholdersCheckIdentifier.isEmpty()) {
                int index = 0;
                for (String i : this.placeholdersCheckIdentifier) {
                    if (!this.plugin.getDependencies().isPluginAvailable("PlaceholderAPI")) {
                        this.plugin.getLogger().warning("PAPI must be installed for placeholder checks: " + i);
                        return false;
                    }
                    if (this.placeholdersCheckValue.size() <= index) {
                        this.plugin.getLogger().warning("Condition placeholder values outweigh identifiers: " + i);
                        return false;
                    }
                    if (!this.placeholdersCheckValue.get(index).equals(PlaceholderAPI.setPlaceholders((Player)player, (String)i))) {
                        failed = true;
                        if (this.plugin.getConfigSettings().getConsoleLogging() <= 3) break;
                        this.plugin.getLogger().info("DEBUG: Condition placeholder mismatch for " + player.getName() + ": " + i);
                        break;
                    }
                    ++index;
                }
            }
        }
        return !failed;
    }
}

