/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.conditions;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.conditions.BukkitCondition;
import me.pikamug.quests.conditions.Condition;
import me.pikamug.quests.conditions.ConditionFactory;
import me.pikamug.quests.convo.conditions.main.ConditionMainPrompt;
import me.pikamug.quests.convo.conditions.menu.ConditionMenuPrompt;
import me.pikamug.quests.interfaces.ReloadCallback;
import me.pikamug.quests.player.Quester;
import me.pikamug.quests.quests.Quest;
import me.pikamug.quests.util.BukkitFakeConversable;
import me.pikamug.quests.util.BukkitLang;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.ConversationAbandonedEvent;
import org.bukkit.conversations.ConversationAbandonedListener;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.ConversationFactory;
import org.bukkit.conversations.ConversationPrefix;
import org.bukkit.conversations.Prompt;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BukkitConditionFactory
implements ConditionFactory,
ConversationAbandonedListener {
    private final BukkitQuestsPlugin plugin;
    private final ConversationFactory conversationFactory;
    private List<String> editingConditionNames = new LinkedList<String>();

    public BukkitConditionFactory(BukkitQuestsPlugin plugin) {
        this.plugin = plugin;
        this.conversationFactory = new ConversationFactory((Plugin)plugin).withModality(false).withLocalEcho(false).withFirstPrompt((Prompt)new ConditionMenuPrompt(new ConversationContext((Plugin)plugin, (Conversable)new BukkitFakeConversable(){

            @Override
            public void sendRawMessage(@Nullable UUID uuid, @NotNull String s) {
            }
        }, new HashMap()))).withTimeout(3600).withPrefix((ConversationPrefix)new LineBreakPrefix()).addConversationAbandonedListener((ConversationAbandonedListener)this);
    }

    @Override
    public ConversationFactory getConversationFactory() {
        return this.conversationFactory;
    }

    @Override
    public List<String> getNamesOfConditionsBeingEdited() {
        return this.editingConditionNames;
    }

    @Override
    public void setNamesOfConditionsBeingEdited(List<String> conditionNames) {
        this.editingConditionNames = conditionNames;
    }

    public void conversationAbandoned(@NotNull ConversationAbandonedEvent abandonedEvent) {
    }

    @Override
    public Prompt returnToMenu(ConversationContext context) {
        return new ConditionMainPrompt(context);
    }

    @Override
    public void loadData(ConversationContext context, Condition condition) {
        LinkedList<ItemStack> items;
        BukkitCondition bukkitCondition = (BukkitCondition)condition;
        if (bukkitCondition.isFailQuest()) {
            context.setSessionData((Object)"conFailQuest", (Object)true);
        } else {
            context.setSessionData((Object)"conFailQuest", (Object)false);
        }
        if (bukkitCondition.getEntitiesWhileRiding() != null && !bukkitCondition.getEntitiesWhileRiding().isEmpty()) {
            LinkedList<String> entities = new LinkedList<String>(bukkitCondition.getEntitiesWhileRiding());
            context.setSessionData((Object)"conRidingEntity", entities);
        }
        if (bukkitCondition.getNpcsWhileRiding() != null && !bukkitCondition.getNpcsWhileRiding().isEmpty()) {
            LinkedList<UUID> npcs = new LinkedList<UUID>(bukkitCondition.getNpcsWhileRiding());
            context.setSessionData((Object)"conRidingNpc", npcs);
        }
        if (bukkitCondition.getPermissions() != null && !bukkitCondition.getPermissions().isEmpty()) {
            LinkedList<String> permissions = new LinkedList<String>(bukkitCondition.getPermissions());
            context.setSessionData((Object)"conPermission", permissions);
        }
        if (bukkitCondition.getItemsWhileHoldingMainHand() != null && !bukkitCondition.getItemsWhileHoldingMainHand().isEmpty()) {
            items = new LinkedList<ItemStack>(bukkitCondition.getItemsWhileHoldingMainHand());
            context.setSessionData((Object)"conHoldingMainHand", items);
        }
        if (bukkitCondition.getItemsWhileWearing() != null && !bukkitCondition.getItemsWhileWearing().isEmpty()) {
            items = new LinkedList<ItemStack>(bukkitCondition.getItemsWhileWearing());
            context.setSessionData((Object)"conWearing", items);
        }
        if (bukkitCondition.getWorldsWhileStayingWithin() != null && !bukkitCondition.getWorldsWhileStayingWithin().isEmpty()) {
            LinkedList<String> worlds = new LinkedList<String>(bukkitCondition.getBiomesWhileStayingWithin());
            context.setSessionData((Object)"conWithinWorld", worlds);
        }
        if (bukkitCondition.getTickStartWhileStayingWithin() > -1) {
            int tick = bukkitCondition.getTickStartWhileStayingWithin();
            context.setSessionData((Object)"conWithinTicksStart", (Object)tick);
        }
        if (bukkitCondition.getTickEndWhileStayingWithin() > -1) {
            int tick = bukkitCondition.getTickEndWhileStayingWithin();
            context.setSessionData((Object)"conWithinTicksEnd", (Object)tick);
        }
        if (bukkitCondition.getBiomesWhileStayingWithin() != null && !bukkitCondition.getBiomesWhileStayingWithin().isEmpty()) {
            LinkedList<String> biomes = new LinkedList<String>(bukkitCondition.getBiomesWhileStayingWithin());
            context.setSessionData((Object)"conWithinBiome", biomes);
        }
        if (bukkitCondition.getRegionsWhileStayingWithin() != null && !bukkitCondition.getRegionsWhileStayingWithin().isEmpty()) {
            LinkedList<String> regions = new LinkedList<String>(bukkitCondition.getRegionsWhileStayingWithin());
            context.setSessionData((Object)"conWithinRegion", regions);
        }
        if (bukkitCondition.getPlaceholdersCheckIdentifier() != null && !bukkitCondition.getPlaceholdersCheckIdentifier().isEmpty()) {
            LinkedList<String> identifiers = new LinkedList<String>(bukkitCondition.getPlaceholdersCheckIdentifier());
            context.setSessionData((Object)"conPlaceholderId", identifiers);
        }
        if (bukkitCondition.getPlaceholdersCheckValue() != null && !bukkitCondition.getPlaceholdersCheckValue().isEmpty()) {
            LinkedList<String> values = new LinkedList<String>(bukkitCondition.getPlaceholdersCheckValue());
            context.setSessionData((Object)"conPlaceholderVal", values);
        }
    }

    @Override
    public void clearData(ConversationContext context) {
        context.setSessionData((Object)"oldCondition", null);
        context.setSessionData((Object)"conName", null);
        context.setSessionData((Object)"conFailQuest", null);
        context.setSessionData((Object)"conRidingEntity", null);
        context.setSessionData((Object)"conRidingNpc", null);
        context.setSessionData((Object)"conPermission", null);
        context.setSessionData((Object)"conHoldingMainHand", null);
        context.setSessionData((Object)"conWearing", null);
        context.setSessionData((Object)"conWithinWorld", null);
        context.setSessionData((Object)"conWithinTicksStart", null);
        context.setSessionData((Object)"conWithinTicksEnd", null);
        context.setSessionData((Object)"conWithinBiome", null);
        context.setSessionData((Object)"conWithinRegion", null);
        context.setSessionData((Object)"conPlaceholderId", null);
        context.setSessionData((Object)"conPlaceholderVal", null);
    }

    @Override
    public void deleteCondition(ConversationContext context) {
        YamlConfiguration data = new YamlConfiguration();
        File conditionsFile = new File(this.plugin.getDataFolder(), "storage" + File.separatorChar + "conditions.yml");
        try {
            data.load(conditionsFile);
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
            context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("questErrorReadingFile").replace("<file>", conditionsFile.getName()));
            return;
        }
        String condition = (String)context.getSessionData((Object)"delCondition");
        ConfigurationSection sec = data.getConfigurationSection("conditions");
        if (sec != null && condition != null) {
            sec.set(condition, null);
        }
        try {
            data.save(conditionsFile);
        }
        catch (IOException e) {
            context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("questSaveError"));
            return;
        }
        ReloadCallback<Boolean> callback = response -> {
            if (!response.booleanValue()) {
                context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("unknownError"));
            }
        };
        this.plugin.reload(callback);
        context.getForWhom().sendRawMessage(ChatColor.YELLOW + BukkitLang.get("conditionEditorDeleted"));
        if (this.plugin.getConfigSettings().getConsoleLogging() > 0) {
            String identifier = context.getForWhom() instanceof Player ? "Player " + ((Player)context.getForWhom()).getUniqueId() : "CONSOLE";
            this.plugin.getLogger().info(identifier + " deleted condition " + condition);
        }
        for (Quester q : this.plugin.getOfflineQuesters()) {
            for (Quest quest : q.getCurrentQuests().keySet()) {
                q.checkQuest(quest);
            }
        }
        this.clearData(context);
    }

    @Override
    public void saveCondition(ConversationContext context) {
        Boolean b;
        YamlConfiguration data = new YamlConfiguration();
        File conditionsFile = new File(this.plugin.getDataFolder(), "storage" + File.separatorChar + "conditions.yml");
        try {
            data.load(conditionsFile);
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
            context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("questErrorReadingFile").replace("<file>", conditionsFile.getName()));
            return;
        }
        if (context.getSessionData((Object)"oldCondition") != null && !((String)Objects.requireNonNull(context.getSessionData((Object)"oldCondition"))).isEmpty()) {
            data.set("conditions." + context.getSessionData((Object)"oldCondition"), null);
            Collection<Condition> temp = this.plugin.getLoadedConditions();
            temp.remove(this.plugin.getCondition((String)context.getSessionData((Object)"oldCondition")));
            this.plugin.setLoadedConditions(temp);
        }
        ConfigurationSection section = data.createSection("conditions." + context.getSessionData((Object)"conName"));
        this.editingConditionNames.remove((String)context.getSessionData((Object)"conName"));
        if (context.getSessionData((Object)"conFailQuest") != null && (b = (Boolean)context.getSessionData((Object)"conFailQuest")) != null) {
            section.set("fail-quest", (Object)b);
        }
        if (context.getSessionData((Object)"conRidingEntity") != null) {
            section.set("ride-entity", context.getSessionData((Object)"conRidingEntity"));
        }
        if (context.getSessionData((Object)"conRidingNpc") != null) {
            section.set("ride-npc-uuid", context.getSessionData((Object)"conRidingNpc"));
        }
        if (context.getSessionData((Object)"conPermission") != null) {
            section.set("permission", context.getSessionData((Object)"conPermission"));
        }
        if (context.getSessionData((Object)"conHoldingMainHand") != null) {
            section.set("hold-main-hand", context.getSessionData((Object)"conHoldingMainHand"));
        }
        if (context.getSessionData((Object)"conWearing") != null) {
            section.set("wear", context.getSessionData((Object)"conWearing"));
        }
        if (context.getSessionData((Object)"conWithinWorld") != null) {
            section.set("stay-within-world", context.getSessionData((Object)"conWithinWorld"));
        }
        if (context.getSessionData((Object)"conWithinTicksStart") != null) {
            section.set("stay-within-ticks.start", context.getSessionData((Object)"conWithinTicksStart"));
        }
        if (context.getSessionData((Object)"conWithinTicksEnd") != null) {
            section.set("stay-within-ticks.end", context.getSessionData((Object)"conWithinTicksEnd"));
        }
        if (context.getSessionData((Object)"conWithinBiome") != null) {
            section.set("stay-within-biome", context.getSessionData((Object)"conWithinBiome"));
        }
        if (context.getSessionData((Object)"conWithinRegion") != null) {
            section.set("stay-within-region", context.getSessionData((Object)"conWithinRegion"));
        }
        if (context.getSessionData((Object)"conPlaceholderId") != null) {
            section.set("check-placeholder-id", context.getSessionData((Object)"conPlaceholderId"));
        }
        if (context.getSessionData((Object)"conPlaceholderVal") != null) {
            section.set("check-placeholder-value", context.getSessionData((Object)"conPlaceholderVal"));
        }
        try {
            data.save(conditionsFile);
        }
        catch (IOException e) {
            context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("questSaveError"));
            return;
        }
        ReloadCallback<Boolean> callback = response -> {
            if (!response.booleanValue()) {
                context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("unknownError"));
            }
        };
        this.plugin.reload(callback);
        context.getForWhom().sendRawMessage(ChatColor.YELLOW + BukkitLang.get("conditionEditorSaved"));
        if (this.plugin.getConfigSettings().getConsoleLogging() > 0) {
            String identifier = context.getForWhom() instanceof Player ? "Player " + ((Player)context.getForWhom()).getUniqueId() : "CONSOLE";
            this.plugin.getLogger().info(identifier + " saved condition " + context.getSessionData((Object)"conName"));
        }
        for (Quester q : this.plugin.getOfflineQuesters()) {
            for (Quest quest : q.getCurrentQuests().keySet()) {
                q.checkQuest(quest);
            }
        }
        this.clearData(context);
    }

    public static class LineBreakPrefix
    implements ConversationPrefix {
        @NotNull
        public String getPrefix(@NotNull ConversationContext context) {
            return "\n";
        }
    }
}

