/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.config;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.config.ConfigSettings;
import org.bukkit.configuration.file.FileConfiguration;

public class BukkitConfigSettings
implements ConfigSettings {
    private final BukkitQuestsPlugin plugin;
    private int acceptTimeout = 20;
    private boolean allowCommands = true;
    private boolean allowCommandsForNpcQuests = false;
    private boolean allowPranks = true;
    private boolean clickablePrompts = true;
    private int conditionInterval = 7;
    private boolean confirmAbandon = true;
    private boolean confirmAccept = true;
    private int consoleLogging = 1;
    private boolean disableCommandFeedback = true;
    private boolean genFilesOnJoin = true;
    private boolean giveJournalItem = false;
    private boolean ignoreLockedQuests = false;
    private int killDelay = 0;
    private String language = "en-US";
    private boolean languageOverrideClient;
    private int maxQuests = 0;
    private boolean npcEffects = true;
    private String effect = "note";
    private String redoEffect = "angry_villager";
    private boolean preventExploit;
    private boolean showCompletedObjs = true;
    private boolean showQuestReqs = true;
    private boolean showQuestTitles = true;
    private int strictPlayerMovement = 0;
    private boolean trialSave = true;
    private int topLimit = 150;
    private boolean translateNames = false;
    private boolean translateSubCommands = false;
    private boolean updateCheck = true;

    public BukkitConfigSettings(BukkitQuestsPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public int getAcceptTimeout() {
        return this.acceptTimeout;
    }

    @Override
    public void setAcceptTimeout(int acceptTimeout) {
        this.acceptTimeout = acceptTimeout;
    }

    @Override
    public boolean canAllowCommands() {
        return this.allowCommands;
    }

    @Override
    public void setAllowCommands(boolean allowCommands) {
        this.allowCommands = allowCommands;
    }

    @Override
    public boolean canAllowCommandsForNpcQuests() {
        return this.allowCommandsForNpcQuests;
    }

    @Override
    public void setAllowCommandsForNpcQuests(boolean allowCommandsForNpcQuests) {
        this.allowCommandsForNpcQuests = allowCommandsForNpcQuests;
    }

    @Override
    public boolean canAllowPranks() {
        return this.allowPranks;
    }

    @Override
    public void setAllowPranks(boolean allowPranks) {
        this.allowPranks = allowPranks;
    }

    @Override
    public boolean canClickablePrompts() {
        return this.clickablePrompts;
    }

    @Override
    public void setClickablePrompts(boolean clickablePrompts) {
        this.clickablePrompts = clickablePrompts;
    }

    @Override
    public int getConditionInterval() {
        return this.conditionInterval;
    }

    @Override
    public void setConditionInterval(int conditionInterval) {
        this.conditionInterval = conditionInterval;
    }

    @Override
    public boolean canConfirmAbandon() {
        return this.confirmAbandon;
    }

    @Override
    public void setConfirmAbandon(boolean confirmAbandon) {
        this.confirmAbandon = confirmAbandon;
    }

    @Override
    public boolean canConfirmAccept() {
        return this.confirmAccept;
    }

    @Override
    public void setConfirmAccept(boolean confirmAccept) {
        this.confirmAccept = confirmAccept;
    }

    @Override
    public int getConsoleLogging() {
        return this.consoleLogging;
    }

    @Override
    public void setConsoleLogging(int consoleLogging) {
        this.consoleLogging = consoleLogging;
    }

    @Override
    public boolean canDisableCommandFeedback() {
        return this.disableCommandFeedback;
    }

    @Override
    public void setDisableCommandFeedback(boolean disableCommandFeedback) {
        this.disableCommandFeedback = disableCommandFeedback;
    }

    @Override
    public boolean canGenFilesOnJoin() {
        return this.genFilesOnJoin;
    }

    @Override
    public void setGenFilesOnJoin(boolean genFilesOnJoin) {
        this.genFilesOnJoin = genFilesOnJoin;
    }

    @Override
    public boolean canGiveJournalItem() {
        return this.giveJournalItem;
    }

    @Override
    public void setGiveJournalItem(boolean giveJournalItem) {
        this.giveJournalItem = giveJournalItem;
    }

    @Override
    public boolean canIgnoreLockedQuests() {
        return this.ignoreLockedQuests;
    }

    @Override
    public void setIgnoreLockedQuests(boolean ignoreLockedQuests) {
        this.ignoreLockedQuests = ignoreLockedQuests;
    }

    @Override
    public int getKillDelay() {
        return this.killDelay;
    }

    @Override
    public void setKillDelay(int killDelay) {
        this.killDelay = killDelay;
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    @Override
    public void setLanguage(String language) {
        this.language = language;
    }

    @Override
    public boolean canLanguageOverrideClient() {
        return this.languageOverrideClient;
    }

    @Override
    public void setLanguageOverrideClient(boolean languageOverrideClient) {
        this.languageOverrideClient = languageOverrideClient;
    }

    @Override
    public int getMaxQuests() {
        return this.maxQuests;
    }

    @Override
    public void setMaxQuests(int maxQuests) {
        this.maxQuests = maxQuests;
    }

    @Override
    public boolean canNpcEffects() {
        return this.npcEffects;
    }

    @Override
    public void setNpcEffects(boolean npcEffects) {
        this.npcEffects = npcEffects;
    }

    @Override
    public String getEffect() {
        return this.effect;
    }

    @Override
    public void setEffect(String effect) {
        this.effect = effect;
    }

    @Override
    public String getRedoEffect() {
        return this.redoEffect;
    }

    @Override
    public void setRedoEffect(String redoEffect) {
        this.redoEffect = redoEffect;
    }

    @Override
    public boolean canPreventExploit() {
        return this.preventExploit;
    }

    @Override
    public void setPreventExploit(boolean preventExploit) {
        this.preventExploit = preventExploit;
    }

    @Override
    public boolean canShowCompletedObjs() {
        return this.showCompletedObjs;
    }

    @Override
    public void setShowCompletedObjs(boolean showCompletedObjs) {
        this.showCompletedObjs = showCompletedObjs;
    }

    @Override
    public boolean canShowQuestReqs() {
        return this.showQuestReqs;
    }

    @Override
    public void setShowQuestReqs(boolean showQuestReqs) {
        this.showQuestReqs = showQuestReqs;
    }

    @Override
    public boolean canShowQuestTitles() {
        return this.showQuestTitles;
    }

    @Override
    public void setShowQuestTitles(boolean showQuestTitles) {
        this.showQuestTitles = showQuestTitles;
    }

    @Override
    public int getStrictPlayerMovement() {
        return this.strictPlayerMovement;
    }

    @Override
    public void setStrictPlayerMovement(int strictPlayerMovement) {
        this.strictPlayerMovement = strictPlayerMovement;
    }

    @Override
    public boolean canTrialSave() {
        return this.trialSave;
    }

    @Override
    public void setTrialSave(boolean trialSave) {
        this.trialSave = trialSave;
    }

    @Override
    public int getTopLimit() {
        return this.topLimit;
    }

    @Override
    public void setTopLimit(int topLimit) {
        this.topLimit = topLimit;
    }

    @Override
    public boolean canTranslateNames() {
        return this.translateNames;
    }

    @Override
    public void setTranslateNames(boolean translateItems) {
        this.translateNames = translateItems;
    }

    @Override
    public boolean canTranslateSubCommands() {
        return this.translateSubCommands;
    }

    @Override
    public void setTranslateSubCommands(boolean translateSubCommands) {
        this.translateSubCommands = translateSubCommands;
    }

    @Override
    public boolean canUpdateCheck() {
        return this.updateCheck;
    }

    @Override
    public void setUpdateCheck(boolean updateCheck) {
        this.updateCheck = updateCheck;
    }

    @Override
    public void init() {
        FileConfiguration config = this.plugin.getConfig();
        this.acceptTimeout = config.getInt("accept-timeout", 20);
        this.allowCommands = config.getBoolean("allow-command-questing", true);
        this.allowCommandsForNpcQuests = config.getBoolean("allow-command-quests-with-npcs", false);
        this.allowPranks = config.getBoolean("allow-pranks", true);
        this.clickablePrompts = config.getBoolean("clickable-prompts", true);
        this.conditionInterval = config.getInt("condition-interval", 8);
        this.confirmAbandon = config.getBoolean("confirm-abandon", true);
        this.confirmAccept = config.getBoolean("confirm-accept", true);
        if (this.conditionInterval < 3 || this.conditionInterval > 180) {
            this.plugin.getLogger().warning("Condition interval out of range, reverting to default of 8 seconds");
            this.conditionInterval = 8;
        }
        this.consoleLogging = config.getInt("console-logging", 1);
        this.disableCommandFeedback = config.getBoolean("disable-command-feedback", true);
        this.genFilesOnJoin = config.getBoolean("generate-files-on-join", true);
        this.giveJournalItem = config.getBoolean("give-journal-item", false);
        this.ignoreLockedQuests = config.getBoolean("ignore-locked-quests", false);
        this.killDelay = config.getInt("kill-delay", 600);
        this.language = Objects.requireNonNull(config.getString("language")).equalsIgnoreCase("en") ? "en-US" : config.getString("language", "en-US");
        this.languageOverrideClient = config.getBoolean("language-override-client", false);
        this.maxQuests = config.getInt("max-quests", this.maxQuests);
        this.npcEffects = config.getBoolean("npc-effects.enabled", true);
        this.effect = config.getString("npc-effects.new-quest", "note");
        this.redoEffect = config.getString("npc-effects.redo-quest", "angry_villager");
        this.preventExploit = config.getBoolean("prevent-exploit", true);
        this.showCompletedObjs = config.getBoolean("show-completed-objectives", true);
        this.showQuestReqs = config.getBoolean("show-requirements", true);
        this.showQuestTitles = config.getBoolean("show-titles", true);
        this.strictPlayerMovement = config.getInt("strict-player-movement", 0);
        this.trialSave = config.getBoolean("trial-save", false);
        this.topLimit = config.getInt("top-limit", 150);
        this.translateNames = config.getBoolean("translate-names", true);
        this.translateSubCommands = config.getBoolean("translate-subcommands", false);
        this.updateCheck = config.getBoolean("update-check", true);
        try {
            config.save(new File(this.plugin.getDataFolder(), "config.yml"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

