/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.convo;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.pikamug.quests.Quests;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.NumericPrompt;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.NotNull;

public abstract class QuestsNumericPrompt
extends NumericPrompt {
    private static final HandlerList HANDLERS = new HandlerList();
    private static final Pattern NUMBER_PATTERN = Pattern.compile("^(\\d+) - ");

    public String getName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public HandlerList getHandlers() {
        return HANDLERS;
    }

    public static HandlerList getHandlerList() {
        return HANDLERS;
    }

    @NotNull
    public String getPromptText(@NotNull ConversationContext cc) {
        return QuestsNumericPrompt.sendClickableSelection(this.getBasicPromptText(cc), cc);
    }

    public abstract String getBasicPromptText(ConversationContext var1);

    public static String sendClickableSelection(String input, ConversationContext context) {
        if (context.getPlugin() == null) {
            return "ERROR";
        }
        if (!(context.getForWhom() instanceof Player) || !((Quests)context.getPlugin()).getConfigSettings().canClickablePrompts()) {
            return input;
        }
        String[] basicText = input.split("\n");
        TextComponent component = new TextComponent("");
        boolean first = true;
        for (String line : basicText) {
            Matcher matcher = NUMBER_PATTERN.matcher(ChatColor.stripColor((String)line));
            TextComponent lineComponent = new TextComponent(TextComponent.fromLegacyText((String)line));
            if (matcher.find()) {
                lineComponent.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/quests choice " + matcher.group(1)));
            }
            if (first) {
                first = false;
            } else {
                component.addExtra("\n");
            }
            component.addExtra((BaseComponent)lineComponent);
        }
        ((Player)context.getForWhom()).spigot().sendMessage((BaseComponent)component);
        return "";
    }
}

