/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.convo.actions.main;

import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.actions.Action;
import me.pikamug.quests.convo.QuestsNumericPrompt;
import me.pikamug.quests.convo.actions.ActionsEditorNumericPrompt;
import me.pikamug.quests.convo.actions.ActionsEditorStringPrompt;
import me.pikamug.quests.convo.actions.tasks.ActionEffectPrompt;
import me.pikamug.quests.convo.actions.tasks.ActionPlayerPrompt;
import me.pikamug.quests.convo.actions.tasks.ActionTimerPrompt;
import me.pikamug.quests.convo.actions.tasks.ActionWeatherPrompt;
import me.pikamug.quests.convo.generic.ItemStackPrompt;
import me.pikamug.quests.entity.BukkitQuestMob;
import me.pikamug.quests.entity.QuestMob;
import me.pikamug.quests.events.editor.actions.ActionsEditorPostOpenNumericPromptEvent;
import me.pikamug.quests.events.editor.actions.ActionsEditorPostOpenStringPromptEvent;
import me.pikamug.quests.quests.Quest;
import me.pikamug.quests.quests.components.Stage;
import me.pikamug.quests.util.BukkitConfigUtil;
import me.pikamug.quests.util.BukkitItemUtil;
import me.pikamug.quests.util.BukkitLang;
import me.pikamug.quests.util.BukkitMiscUtil;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.Prompt;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ActionMainPrompt
extends ActionsEditorNumericPrompt {
    private final BukkitQuestsPlugin plugin;
    private final int size = 10;

    public ActionMainPrompt(ConversationContext context) {
        super(context);
        this.plugin = (BukkitQuestsPlugin)context.getPlugin();
    }

    @Override
    public int getSize() {
        return 10;
    }

    @Override
    public String getTitle(ConversationContext context) {
        return BukkitLang.get("event") + ": " + context.getSessionData((Object)"actName");
    }

    @Override
    public ChatColor getNumberColor(ConversationContext context, int number) {
        switch (number) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                return ChatColor.BLUE;
            }
            case 7: {
                if (this.plugin.getDependencies().getDenizenApi() == null) {
                    return ChatColor.GRAY;
                }
                return ChatColor.BLUE;
            }
            case 9: {
                return ChatColor.GREEN;
            }
            case 10: {
                return ChatColor.RED;
            }
        }
        return null;
    }

    @Override
    public String getSelectionText(ConversationContext context, int number) {
        switch (number) {
            case 1: {
                return ChatColor.YELLOW + BukkitLang.get("eventEditorSetName");
            }
            case 2: {
                return ChatColor.GOLD + BukkitLang.get("eventEditorPlayer");
            }
            case 3: {
                return ChatColor.GOLD + BukkitLang.get("eventEditorTimer");
            }
            case 4: {
                return ChatColor.GOLD + BukkitLang.get("eventEditorEffect");
            }
            case 5: {
                return ChatColor.GOLD + BukkitLang.get("eventEditorWeather");
            }
            case 6: {
                return ChatColor.YELLOW + BukkitLang.get("eventEditorSetMobSpawns");
            }
            case 7: {
                if (this.plugin.getDependencies().getDenizenApi() == null) {
                    return ChatColor.GRAY + BukkitLang.get("stageEditorDenizenScript");
                }
                return ChatColor.YELLOW + BukkitLang.get("stageEditorDenizenScript");
            }
            case 8: {
                return ChatColor.YELLOW + BukkitLang.get("eventEditorFailQuest");
            }
            case 9: {
                return ChatColor.GREEN + BukkitLang.get("save");
            }
            case 10: {
                return ChatColor.RED + BukkitLang.get("exit");
            }
        }
        return null;
    }

    @Override
    public String getAdditionalText(ConversationContext context, int number) {
        switch (number) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                return "";
            }
            case 6: {
                if (context.getSessionData((Object)"actMobs") == null) {
                    return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                LinkedList mobs = (LinkedList)context.getSessionData((Object)"actMobs");
                StringBuilder text = new StringBuilder();
                if (mobs != null) {
                    for (QuestMob mob : mobs) {
                        BukkitQuestMob qm = (BukkitQuestMob)mob;
                        text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.AQUA).append(qm.getType().name()).append(qm.getName() != null ? " (" + qm.getName() + ")" : "").append(ChatColor.GRAY).append(" x ").append(ChatColor.DARK_AQUA).append(qm.getSpawnAmounts()).append("\n").append(ChatColor.GRAY).append("        \u2515 ").append(ChatColor.GREEN).append(BukkitConfigUtil.getLocationInfo(qm.getSpawnLocation()));
                    }
                }
                return text.toString();
            }
            case 7: {
                if (this.plugin.getDependencies().getDenizenApi() == null) {
                    return ChatColor.GRAY + "(" + BukkitLang.get("notInstalled") + ")";
                }
                if (context.getSessionData((Object)"actDenizen") == null) {
                    return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                return ChatColor.GRAY + "(" + ChatColor.AQUA + context.getSessionData((Object)"actDenizen") + ChatColor.GRAY + ")";
            }
            case 8: {
                if (context.getSessionData((Object)"actFailQuest") == null) {
                    return ChatColor.GRAY + "(" + ChatColor.RED + BukkitLang.get("false") + ChatColor.GRAY + ")";
                }
                Boolean failOpt = (Boolean)context.getSessionData((Object)"actFailQuest");
                return ChatColor.GRAY + "(" + (Boolean.TRUE.equals(failOpt) ? ChatColor.GREEN + BukkitLang.get("true") : ChatColor.RED + BukkitLang.get("false")) + ChatColor.GRAY + ")";
            }
        }
        return null;
    }

    @Override
    @NotNull
    public String getBasicPromptText(@NotNull ConversationContext context) {
        ActionsEditorPostOpenNumericPromptEvent event = new ActionsEditorPostOpenNumericPromptEvent(context, this);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        StringBuilder text = new StringBuilder(ChatColor.GOLD + "- " + this.getTitle(context).replaceFirst(": ", ": " + ChatColor.AQUA) + ChatColor.GOLD + " -");
        for (int i = 1; i <= 10; ++i) {
            text.append("\n").append(this.getNumberColor(context, i)).append(ChatColor.BOLD).append(i).append(ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i)).append(" ").append(this.getAdditionalText(context, i));
        }
        return text.toString();
    }

    public Prompt acceptValidatedInput(@NotNull ConversationContext context, Number input) {
        switch (input.intValue()) {
            case 1: {
                return new ActionNamePrompt(context);
            }
            case 2: {
                return new ActionPlayerPrompt(context);
            }
            case 3: {
                return new ActionTimerPrompt(context);
            }
            case 4: {
                return new ActionEffectPrompt(context);
            }
            case 5: {
                return new ActionWeatherPrompt(context);
            }
            case 6: {
                return new ActionMobListPrompt(context);
            }
            case 7: {
                if (this.plugin.getDependencies().getDenizenApi() != null) {
                    if (!this.plugin.hasLimitedAccess(context.getForWhom())) {
                        return new ActionDenizenPrompt(context);
                    }
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("modeDeny").replace("<mode>", BukkitLang.get("trialMode")));
                    return new ActionMainPrompt(context);
                }
                return new ActionMainPrompt(context);
            }
            case 8: {
                Boolean b = (Boolean)context.getSessionData((Object)"actFailQuest");
                if (Boolean.TRUE.equals(b)) {
                    context.setSessionData((Object)"actFailQuest", (Object)false);
                } else {
                    context.setSessionData((Object)"actFailQuest", (Object)true);
                }
                return new ActionMainPrompt(context);
            }
            case 9: {
                if (context.getSessionData((Object)"oldAction") != null) {
                    return new ActionSavePrompt(context, (String)context.getSessionData((Object)"oldAction"));
                }
                return new ActionSavePrompt(context, null);
            }
            case 10: {
                return new ActionExitPrompt(context);
            }
        }
        return new ActionMainPrompt(context);
    }

    public class ActionNamePrompt
    extends ActionsEditorStringPrompt {
        public ActionNamePrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("eventEditorEnterEventName");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            ActionsEditorPostOpenStringPromptEvent event = new ActionsEditorPostOpenStringPromptEvent(context, this);
            ActionMainPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                for (Action a : ActionMainPrompt.this.plugin.getLoadedActions()) {
                    if (!a.getName().equalsIgnoreCase(input)) continue;
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("eventEditorExists"));
                    return new ActionNamePrompt(context);
                }
                List<String> actionNames = ActionMainPrompt.this.plugin.getActionFactory().getNamesOfActionsBeingEdited();
                if (actionNames.contains(input)) {
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("questEditorBeingEdited"));
                    return new ActionNamePrompt(context);
                }
                if (input.contains(",")) {
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("questEditorInvalidQuestName"));
                    return new ActionNamePrompt(context);
                }
                actionNames.remove((String)context.getSessionData((Object)"actName"));
                context.setSessionData((Object)"actName", (Object)input);
                actionNames.add(input);
                ActionMainPrompt.this.plugin.getActionFactory().setNamesOfActionsBeingEdited(actionNames);
            }
            return new ActionMainPrompt(context);
        }
    }

    public class ActionMobListPrompt
    extends ActionsEditorNumericPrompt {
        private final int size = 3;

        public ActionMobListPrompt(ConversationContext context) {
            super(context);
            this.size = 3;
        }

        @Override
        public int getSize() {
            return 3;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("eventEditorMobSpawnsTitle");
        }

        @Override
        public ChatColor getNumberColor(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.BLUE;
                }
                case 2: {
                    return ChatColor.RED;
                }
                case 3: {
                    return ChatColor.GREEN;
                }
            }
            return null;
        }

        @Override
        public String getSelectionText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.YELLOW + BukkitLang.get("eventEditorAddMobTypes");
                }
                case 2: {
                    return ChatColor.RED + BukkitLang.get("clear");
                }
                case 3: {
                    return ChatColor.GREEN + BukkitLang.get("done");
                }
            }
            return null;
        }

        @Override
        public String getAdditionalText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    if (context.getSessionData((Object)"actMobs") != null) {
                        LinkedList mobs = (LinkedList)context.getSessionData((Object)"actMobs");
                        StringBuilder text = new StringBuilder();
                        if (mobs != null) {
                            for (QuestMob mob : mobs) {
                                BukkitQuestMob qm = (BukkitQuestMob)mob;
                                text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.AQUA).append(qm.getType().name()).append(qm.getName() != null ? " (" + qm.getName() + ")" : "").append(" x ").append(qm.getSpawnAmounts()).append("\n").append(ChatColor.GRAY).append("        \u2515 ").append(ChatColor.GREEN).append(BukkitConfigUtil.getLocationInfo(qm.getSpawnLocation()));
                            }
                        }
                        return text.toString();
                    }
                }
                case 2: 
                case 3: {
                    return "";
                }
            }
            return null;
        }

        @Override
        @NotNull
        public String getBasicPromptText(@NotNull ConversationContext context) {
            ActionsEditorPostOpenNumericPromptEvent event = new ActionsEditorPostOpenNumericPromptEvent(context, this);
            ActionMainPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(ChatColor.GOLD + this.getTitle(context));
            for (int i = 1; i <= 3; ++i) {
                text.append("\n").append(this.getNumberColor(context, i)).append(ChatColor.BOLD).append(i).append(ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i)).append(" ").append(this.getAdditionalText(context, i));
            }
            return text.toString();
        }

        public Prompt acceptValidatedInput(@NotNull ConversationContext context, Number input) {
            switch (input.intValue()) {
                case 1: {
                    return new ActionMobPrompt(context, null);
                }
                case 2: {
                    context.getForWhom().sendRawMessage(ChatColor.YELLOW + BukkitLang.get("eventEditorMobSpawnsCleared"));
                    context.setSessionData((Object)"actMobs", null);
                    return new ActionMobListPrompt(context);
                }
                case 3: {
                    return new ActionMainPrompt(context);
                }
            }
            return new ActionMobListPrompt(context);
        }
    }

    public class ActionDenizenPrompt
    extends ActionsEditorStringPrompt {
        public ActionDenizenPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("stageEditorDenizenScript");
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("stageEditorScriptPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            ActionsEditorPostOpenStringPromptEvent event = new ActionsEditorPostOpenStringPromptEvent(context, this);
            ActionMainPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(ChatColor.DARK_AQUA + "- " + this.getTitle(context) + " -");
            if (ActionMainPrompt.this.plugin.getDependencies().getDenizenApi() != null && ActionMainPrompt.this.plugin.getDependencies().getDenizenApi().getScriptNames() != null) {
                for (String s : ActionMainPrompt.this.plugin.getDependencies().getDenizenApi().getScriptNames()) {
                    text.append("\n").append(ChatColor.AQUA).append("- ").append(s);
                }
            }
            return text + "\n" + ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel")) && !input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                if (ActionMainPrompt.this.plugin.getDependencies().getDenizenApi().containsScript(input)) {
                    context.setSessionData((Object)"actDenizen", (Object)input.toUpperCase());
                    return new ActionMainPrompt(context);
                }
                context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("stageEditorInvalidScript"));
                return new ActionDenizenPrompt(context);
            }
            if (input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                context.setSessionData((Object)"actDenizen", null);
                context.getForWhom().sendRawMessage(ChatColor.YELLOW + BukkitLang.get("stageEditorDenizenCleared"));
                return new ActionMainPrompt(context);
            }
            return new ActionMainPrompt(context);
        }
    }

    public class ActionSavePrompt
    extends ActionsEditorStringPrompt {
        String modName;
        LinkedList<String> modified;
        private final int size = 2;

        public ActionSavePrompt(ConversationContext context, String modifiedName) {
            super(context);
            this.modName = null;
            this.modified = new LinkedList();
            this.size = 2;
            if (modifiedName != null) {
                this.modName = modifiedName;
                block0: for (Quest q : ActionMainPrompt.this.plugin.getLoadedQuests()) {
                    for (Stage s : q.getStages()) {
                        if (s.getFinishAction() == null || s.getFinishAction().getName() == null || !s.getFinishAction().getName().equalsIgnoreCase(modifiedName)) continue;
                        this.modified.add(q.getName());
                        continue block0;
                    }
                }
            }
        }

        public int getSize() {
            return 2;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        public ChatColor getNumberColor(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.GREEN;
                }
                case 2: {
                    return ChatColor.RED;
                }
            }
            return null;
        }

        public String getSelectionText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.GREEN + BukkitLang.get("yesWord");
                }
                case 2: {
                    return ChatColor.RED + BukkitLang.get("noWord");
                }
            }
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("questEditorSave");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            ActionsEditorPostOpenStringPromptEvent event = new ActionsEditorPostOpenStringPromptEvent(context, this);
            ActionMainPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(ChatColor.YELLOW + this.getQueryText(context));
            if (!this.modified.isEmpty()) {
                text.append("\n").append(ChatColor.RED).append(" ").append(BukkitLang.get("eventEditorModifiedNote"));
                for (String s : this.modified) {
                    text.append("\n").append(ChatColor.GRAY).append("    - ").append(ChatColor.DARK_RED).append(s);
                }
                text.append("\n").append(ChatColor.RED).append(" ").append(BukkitLang.get("eventEditorForcedToQuit"));
            }
            for (int i = 1; i <= 2; ++i) {
                text.append("\n").append(this.getNumberColor(context, i)).append(ChatColor.BOLD).append(i).append(ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i));
            }
            return QuestsNumericPrompt.sendClickableSelection(text.toString(), context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (input.equalsIgnoreCase("1") || input.equalsIgnoreCase(BukkitLang.get("yesWord"))) {
                if (ActionMainPrompt.this.plugin.hasLimitedAccess(context.getForWhom()) && !ActionMainPrompt.this.plugin.getConfigSettings().canTrialSave()) {
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("modeDeny").replace("<mode>", BukkitLang.get("trialMode")));
                    return new ActionMainPrompt(context);
                }
                ActionMainPrompt.this.plugin.getActionFactory().saveAction(context);
                return Prompt.END_OF_CONVERSATION;
            }
            if (input.equalsIgnoreCase("2") || input.equalsIgnoreCase(BukkitLang.get("noWord"))) {
                return new ActionMainPrompt(context);
            }
            return new ActionSavePrompt(context, this.modName);
        }
    }

    public class ActionExitPrompt
    extends ActionsEditorStringPrompt {
        private final int size = 2;

        public ActionExitPrompt(ConversationContext context) {
            super(context);
            this.size = 2;
        }

        public int getSize() {
            return 2;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        public ChatColor getNumberColor(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.GREEN;
                }
                case 2: {
                    return ChatColor.RED;
                }
            }
            return null;
        }

        public String getSelectionText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.GREEN + BukkitLang.get("yesWord");
                }
                case 2: {
                    return ChatColor.RED + BukkitLang.get("noWord");
                }
            }
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("confirmDelete");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            ActionsEditorPostOpenStringPromptEvent event = new ActionsEditorPostOpenStringPromptEvent(context, this);
            ActionMainPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(ChatColor.YELLOW + this.getQueryText(context));
            for (int i = 1; i <= 2; ++i) {
                text.append("\n").append(this.getNumberColor(context, i)).append(ChatColor.BOLD).append(i).append(ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i));
            }
            return QuestsNumericPrompt.sendClickableSelection(text.toString(), context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (input.equalsIgnoreCase("1") || input.equalsIgnoreCase(BukkitLang.get("yesWord"))) {
                context.getForWhom().sendRawMessage(ChatColor.BOLD + "" + ChatColor.YELLOW + BukkitLang.get("exited"));
                ActionMainPrompt.this.plugin.getActionFactory().clearData(context);
                return Prompt.END_OF_CONVERSATION;
            }
            if (input.equalsIgnoreCase("2") || input.equalsIgnoreCase(BukkitLang.get("noWord"))) {
                return new ActionMainPrompt(context);
            }
            return new ActionExitPrompt(context);
        }
    }

    public class ActionMobDropPrompt
    extends ActionsEditorStringPrompt {
        private final BukkitQuestMob questMob;
        private final Integer invIndex;

        public ActionMobDropPrompt(ConversationContext context, int invIndex, BukkitQuestMob questMob) {
            super(context);
            this.questMob = questMob;
            this.invIndex = invIndex;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("eventEditorSetDropChance").replace("<least>", "0.0").replaceFirst("<greatest>", "1.0");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            ActionsEditorPostOpenStringPromptEvent event = new ActionsEditorPostOpenStringPromptEvent(context, this);
            ActionMainPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            float chance;
            if (input == null) {
                return null;
            }
            if (input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                return new ActionMobPrompt(context, this.questMob);
            }
            try {
                chance = Float.parseFloat(input);
            }
            catch (NumberFormatException e) {
                context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("invalidRange").replace("<least>", "0.0").replace("<greatest>", "1.0"));
                return new ActionMobDropPrompt(context, this.invIndex, this.questMob);
            }
            if (chance > 1.0f || chance < 0.0f) {
                context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("invalidRange").replace("<least>", "0.0").replace("<greatest>", "1.0"));
                return new ActionMobDropPrompt(context, this.invIndex, this.questMob);
            }
            Float[] temp = this.questMob.getDropChances();
            temp[this.invIndex.intValue()] = Float.valueOf(chance);
            this.questMob.setDropChances(temp);
            return new ActionMobEquipmentPrompt(context, this.questMob);
        }
    }

    public class ActionMobLocationPrompt
    extends ActionsEditorStringPrompt {
        private final BukkitQuestMob questMob;

        public ActionMobLocationPrompt(ConversationContext context, BukkitQuestMob questMob) {
            super(context);
            this.questMob = questMob;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("eventEditorSetMobLocationPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            ActionsEditorPostOpenStringPromptEvent event = new ActionsEditorPostOpenStringPromptEvent(context, this);
            ActionMainPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            Player player = (Player)context.getForWhom();
            if (input.equalsIgnoreCase(BukkitLang.get("cmdAdd"))) {
                ConcurrentHashMap<UUID, Block> selectedMobLocations = ActionMainPrompt.this.plugin.getActionFactory().getSelectedMobLocations();
                Block block = selectedMobLocations.get(player.getUniqueId());
                if (block == null) {
                    player.sendMessage(ChatColor.RED + BukkitLang.get("eventEditorSelectBlockFirst"));
                    return new ActionMobLocationPrompt(context, this.questMob);
                }
                Location loc = block.getLocation();
                this.questMob.setSpawnLocation(loc);
                selectedMobLocations.remove(player.getUniqueId());
                ActionMainPrompt.this.plugin.getActionFactory().setSelectedMobLocations(selectedMobLocations);
                return new ActionMobPrompt(context, this.questMob);
            }
            if (input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                ConcurrentHashMap<UUID, Block> selectedMobLocations = ActionMainPrompt.this.plugin.getActionFactory().getSelectedMobLocations();
                selectedMobLocations.remove(player.getUniqueId());
                ActionMainPrompt.this.plugin.getActionFactory().setSelectedMobLocations(selectedMobLocations);
                return new ActionMobPrompt(context, this.questMob);
            }
            return new ActionMobLocationPrompt(context, this.questMob);
        }
    }

    public class ActionMobAmountPrompt
    extends ActionsEditorStringPrompt {
        private final BukkitQuestMob questMob;

        public ActionMobAmountPrompt(ConversationContext context, BukkitQuestMob questMob) {
            super(context);
            this.questMob = questMob;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("eventEditorSetMobAmountsPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            ActionsEditorPostOpenStringPromptEvent event = new ActionsEditorPostOpenStringPromptEvent(context, this);
            ActionMainPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                try {
                    int i = Integer.parseInt(input);
                    if (i < 1) {
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("invalidMinimum").replace("<number>", "1"));
                        return new ActionMobAmountPrompt(context, this.questMob);
                    }
                    this.questMob.setSpawnAmounts(i);
                    return new ActionMobPrompt(context, this.questMob);
                }
                catch (NumberFormatException e) {
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("reqNotANumber").replace("<input>", input));
                    return new ActionMobAmountPrompt(context, this.questMob);
                }
            }
            return new ActionMobPrompt(context, this.questMob);
        }
    }

    public class ActionMobTypePrompt
    extends ActionsEditorStringPrompt {
        private final BukkitQuestMob questMob;

        public ActionMobTypePrompt(ConversationContext context, BukkitQuestMob questMob) {
            super(context);
            this.questMob = questMob;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("eventEditorMobsTitle");
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("eventEditorSetMobTypesPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            ActionsEditorPostOpenStringPromptEvent event = new ActionsEditorPostOpenStringPromptEvent(context, this);
            ActionMainPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder mobs = new StringBuilder(ChatColor.LIGHT_PURPLE + this.getTitle(context) + "\n");
            LinkedList<EntityType> mobArr = new LinkedList<EntityType>(Arrays.asList(EntityType.values()));
            LinkedList<EntityType> toRemove = new LinkedList<EntityType>();
            for (EntityType type : mobArr) {
                if (type.isAlive() && !type.name().equals("PLAYER")) continue;
                toRemove.add(type);
            }
            mobArr.removeAll(toRemove);
            mobArr.sort(Comparator.comparing(Enum::name));
            for (int i = 0; i < mobArr.size(); ++i) {
                mobs.append(ChatColor.AQUA).append(BukkitMiscUtil.snakeCaseToUpperCamelCase(((EntityType)mobArr.get(i)).name()));
                if (i >= mobArr.size() - 1) continue;
                mobs.append(ChatColor.GRAY).append(", ");
            }
            mobs.append("\n").append(ChatColor.YELLOW).append(this.getQueryText(context));
            return mobs.toString();
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                if (BukkitMiscUtil.getProperMobType(input) != null) {
                    this.questMob.setType(BukkitMiscUtil.getProperMobType(input));
                } else {
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("stageEditorInvalidMob").replace("<input>", input));
                    return new ActionMobTypePrompt(context, this.questMob);
                }
            }
            return new ActionMobPrompt(context, this.questMob);
        }
    }

    public class ActionMobNamePrompt
    extends ActionsEditorStringPrompt {
        private final BukkitQuestMob questMob;

        public ActionMobNamePrompt(ConversationContext context, BukkitQuestMob questMob) {
            super(context);
            this.questMob = questMob;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("eventEditorSetMobNamePrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            ActionsEditorPostOpenStringPromptEvent event = new ActionsEditorPostOpenStringPromptEvent(context, this);
            ActionMainPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                return new ActionMobPrompt(context, this.questMob);
            }
            if (input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                this.questMob.setName(null);
                return new ActionMobPrompt(context, this.questMob);
            }
            input = ChatColor.translateAlternateColorCodes((char)'&', (String)input);
            this.questMob.setName(input);
            return new ActionMobPrompt(context, this.questMob);
        }
    }

    public class ActionMobEquipmentPrompt
    extends ActionsEditorNumericPrompt {
        private BukkitQuestMob questMob;
        private Integer itemIndex;
        private final int size = 12;

        public ActionMobEquipmentPrompt(ConversationContext context, BukkitQuestMob questMob) {
            super(context);
            this.itemIndex = -1;
            this.size = 12;
            this.questMob = questMob;
        }

        @Override
        public int getSize() {
            return 12;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("eventEditorAddEquipmentTitle");
        }

        @Override
        public ChatColor getNumberColor(ConversationContext context, int number) {
            switch (number) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    return ChatColor.BLUE;
                }
                case 11: {
                    return ChatColor.RED;
                }
                case 12: {
                    return ChatColor.GREEN;
                }
            }
            return null;
        }

        @Override
        public String getSelectionText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.YELLOW + BukkitLang.get("eventEditorSetMobItemInHand");
                }
                case 2: {
                    return ChatColor.YELLOW + BukkitLang.get("eventEditorSetMobItemInHandDrop");
                }
                case 3: {
                    return ChatColor.YELLOW + BukkitLang.get("eventEditorSetMobBoots");
                }
                case 4: {
                    return ChatColor.YELLOW + BukkitLang.get("eventEditorSetMobBootsDrop");
                }
                case 5: {
                    return ChatColor.YELLOW + BukkitLang.get("eventEditorSetMobLeggings");
                }
                case 6: {
                    return ChatColor.YELLOW + BukkitLang.get("eventEditorSetMobLeggingsDrop");
                }
                case 7: {
                    return ChatColor.YELLOW + BukkitLang.get("eventEditorSetMobChestPlate");
                }
                case 8: {
                    return ChatColor.YELLOW + BukkitLang.get("eventEditorSetMobChestPlateDrop");
                }
                case 9: {
                    return ChatColor.YELLOW + BukkitLang.get("eventEditorSetMobHelmet");
                }
                case 10: {
                    return ChatColor.YELLOW + BukkitLang.get("eventEditorSetMobHelmetDrop");
                }
                case 11: {
                    return ChatColor.RED + BukkitLang.get("cancel");
                }
                case 12: {
                    return ChatColor.GREEN + BukkitLang.get("done");
                }
            }
            return null;
        }

        @Override
        public String getAdditionalText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.GRAY + "(" + (this.questMob.getInventory()[0] == null ? ChatColor.GRAY + BukkitLang.get("noneSet") : ChatColor.AQUA + BukkitItemUtil.getDisplayString(this.questMob.getInventory()[0])) + ChatColor.GRAY + ")";
                }
                case 2: {
                    return ChatColor.GRAY + "(" + (this.questMob.getDropChances()[0] == null ? ChatColor.GRAY + BukkitLang.get("noneSet") : ChatColor.AQUA + "" + this.questMob.getDropChances()[0]) + ChatColor.GRAY + ")";
                }
                case 3: {
                    return ChatColor.GRAY + "(" + (this.questMob.getInventory()[1] == null ? ChatColor.GRAY + BukkitLang.get("noneSet") : ChatColor.AQUA + BukkitItemUtil.getDisplayString(this.questMob.getInventory()[1])) + ChatColor.GRAY + ")";
                }
                case 4: {
                    return ChatColor.GRAY + "(" + (this.questMob.getDropChances()[1] == null ? ChatColor.GRAY + BukkitLang.get("noneSet") : ChatColor.AQUA + "" + this.questMob.getDropChances()[1]) + ChatColor.GRAY + ")";
                }
                case 5: {
                    return ChatColor.GRAY + "(" + (this.questMob.getInventory()[2] == null ? ChatColor.GRAY + BukkitLang.get("noneSet") : ChatColor.AQUA + BukkitItemUtil.getDisplayString(this.questMob.getInventory()[2])) + ChatColor.GRAY + ")";
                }
                case 6: {
                    return ChatColor.GRAY + "(" + (this.questMob.getDropChances()[2] == null ? ChatColor.GRAY + BukkitLang.get("noneSet") : ChatColor.AQUA + "" + this.questMob.getDropChances()[2]) + ChatColor.GRAY + ")";
                }
                case 7: {
                    return ChatColor.GRAY + "(" + (this.questMob.getInventory()[3] == null ? ChatColor.GRAY + BukkitLang.get("noneSet") : ChatColor.AQUA + BukkitItemUtil.getDisplayString(this.questMob.getInventory()[3])) + ChatColor.GRAY + ")";
                }
                case 8: {
                    return ChatColor.GRAY + "(" + (this.questMob.getDropChances()[3] == null ? ChatColor.GRAY + BukkitLang.get("noneSet") : ChatColor.AQUA + "" + this.questMob.getDropChances()[3]) + ChatColor.GRAY + ")";
                }
                case 9: {
                    return ChatColor.GRAY + "(" + (this.questMob.getInventory()[4] == null ? ChatColor.GRAY + BukkitLang.get("noneSet") : ChatColor.AQUA + BukkitItemUtil.getDisplayString(this.questMob.getInventory()[4])) + ChatColor.GRAY + ")";
                }
                case 10: {
                    return ChatColor.GRAY + "(" + (this.questMob.getDropChances()[4] == null ? ChatColor.GRAY + BukkitLang.get("noneSet") : ChatColor.AQUA + "" + this.questMob.getDropChances()[4]) + ChatColor.GRAY + ")";
                }
                case 11: 
                case 12: {
                    return "";
                }
            }
            return null;
        }

        @Override
        @NotNull
        public String getBasicPromptText(@NotNull ConversationContext context) {
            if (this.questMob == null) {
                this.questMob = new BukkitQuestMob();
            }
            if (context.getSessionData((Object)"tempStack") != null) {
                if (this.itemIndex >= 0) {
                    this.questMob.getInventory()[this.itemIndex.intValue()] = (ItemStack)context.getSessionData((Object)"tempStack");
                    try {
                        if (this.questMob.getDropChances()[this.itemIndex] == null) {
                            Float[] chances = this.questMob.getDropChances();
                            chances[this.itemIndex.intValue()] = Float.valueOf(1.0f);
                            this.questMob.setDropChances(chances);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this.itemIndex = -1;
                }
                ItemStackPrompt.clearSessionData(context);
            }
            ActionsEditorPostOpenNumericPromptEvent event = new ActionsEditorPostOpenNumericPromptEvent(context, this);
            ActionMainPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(ChatColor.GOLD + this.getTitle(context));
            for (int i = 1; i <= 12; ++i) {
                text.append("\n").append(this.getNumberColor(context, i)).append(ChatColor.BOLD).append(i).append(ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i)).append(ChatColor.GRAY).append(" ").append(this.getAdditionalText(context, i));
            }
            return text.toString();
        }

        public Prompt acceptValidatedInput(@NotNull ConversationContext context, Number input) {
            switch (input.intValue()) {
                case 1: {
                    this.itemIndex = 0;
                    return new ItemStackPrompt(context, (Prompt)this);
                }
                case 2: {
                    return new ActionMobDropPrompt(context, 0, this.questMob);
                }
                case 3: {
                    this.itemIndex = 1;
                    return new ItemStackPrompt(context, (Prompt)this);
                }
                case 4: {
                    return new ActionMobDropPrompt(context, 1, this.questMob);
                }
                case 5: {
                    this.itemIndex = 2;
                    return new ItemStackPrompt(context, (Prompt)this);
                }
                case 6: {
                    return new ActionMobDropPrompt(context, 2, this.questMob);
                }
                case 7: {
                    this.itemIndex = 3;
                    return new ItemStackPrompt(context, (Prompt)this);
                }
                case 8: {
                    return new ActionMobDropPrompt(context, 3, this.questMob);
                }
                case 9: {
                    this.itemIndex = 4;
                    return new ItemStackPrompt(context, (Prompt)this);
                }
                case 10: {
                    return new ActionMobDropPrompt(context, 4, this.questMob);
                }
                case 11: {
                    return new ActionMobListPrompt(context);
                }
            }
            return new ActionMobPrompt(context, this.questMob);
        }
    }

    public class ActionMobPrompt
    extends ActionsEditorNumericPrompt {
        private BukkitQuestMob questMob;
        private final int size = 7;

        public ActionMobPrompt(ConversationContext context, BukkitQuestMob questMob) {
            super(context);
            this.size = 7;
            this.questMob = questMob;
        }

        @Override
        public int getSize() {
            return 7;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("eventEditorAddMobTypesTitle");
        }

        @Override
        public ChatColor getNumberColor(ConversationContext context, int number) {
            switch (number) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    return ChatColor.BLUE;
                }
                case 6: {
                    return ChatColor.RED;
                }
                case 7: {
                    return ChatColor.GREEN;
                }
            }
            return null;
        }

        @Override
        public String getSelectionText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.YELLOW + BukkitLang.get("eventEditorSetMobName");
                }
                case 2: {
                    return ChatColor.YELLOW + BukkitLang.get("eventEditorSetMobType");
                }
                case 3: {
                    return ChatColor.YELLOW + BukkitLang.get("eventEditorSetMobSpawnAmount");
                }
                case 4: {
                    return ChatColor.YELLOW + BukkitLang.get("eventEditorAddSpawnLocation");
                }
                case 5: {
                    return ChatColor.YELLOW + BukkitLang.get("eventEditorSetEquipment");
                }
                case 6: {
                    return ChatColor.RED + BukkitLang.get("cancel");
                }
                case 7: {
                    return ChatColor.GREEN + BukkitLang.get("done");
                }
            }
            return null;
        }

        @Override
        public String getAdditionalText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.GRAY + "(" + (this.questMob.getName() == null ? BukkitLang.get("noneSet") : ChatColor.AQUA + this.questMob.getName()) + ChatColor.GRAY + ")";
                }
                case 2: {
                    return ChatColor.GRAY + "(" + (this.questMob.getType() == null ? BukkitLang.get("noneSet") : ChatColor.AQUA + this.questMob.getType().name()) + ChatColor.GRAY + ")";
                }
                case 3: {
                    return ChatColor.GRAY + "(" + (this.questMob.getSpawnAmounts() == null ? ChatColor.GRAY + BukkitLang.get("noneSet") : ChatColor.AQUA + "" + this.questMob.getSpawnAmounts()) + ChatColor.GRAY + ")";
                }
                case 4: {
                    return ChatColor.GRAY + "(" + (this.questMob.getSpawnLocation() == null ? ChatColor.GRAY + BukkitLang.get("noneSet") : ChatColor.AQUA + BukkitConfigUtil.getLocationInfo(this.questMob.getSpawnLocation())) + ChatColor.GRAY + ")";
                }
                case 5: {
                    return ChatColor.GRAY + "(" + (this.questMob.getInventory()[0] == null ? ChatColor.GRAY + BukkitLang.get("noneSet") : ChatColor.AQUA + BukkitItemUtil.getDisplayString(this.questMob.getInventory()[0])) + ChatColor.GRAY + ")";
                }
                case 6: 
                case 7: {
                    return "";
                }
            }
            return null;
        }

        @Override
        @NotNull
        public String getBasicPromptText(@NotNull ConversationContext context) {
            if (this.questMob == null) {
                this.questMob = new BukkitQuestMob();
            }
            ActionsEditorPostOpenNumericPromptEvent event = new ActionsEditorPostOpenNumericPromptEvent(context, this);
            ActionMainPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(ChatColor.GOLD + this.getTitle(context));
            for (int i = 1; i <= 7; ++i) {
                text.append("\n").append(this.getNumberColor(context, i)).append(ChatColor.BOLD).append(i).append(ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i)).append(ChatColor.GRAY).append(" ").append(this.getAdditionalText(context, i));
            }
            return text.toString();
        }

        public Prompt acceptValidatedInput(@NotNull ConversationContext context, Number input) {
            switch (input.intValue()) {
                case 1: {
                    return new ActionMobNamePrompt(context, this.questMob);
                }
                case 2: {
                    return new ActionMobTypePrompt(context, this.questMob);
                }
                case 3: {
                    return new ActionMobAmountPrompt(context, this.questMob);
                }
                case 4: {
                    if (context.getForWhom() instanceof Player) {
                        ConcurrentHashMap<UUID, Block> selectedMobLocations = ActionMainPrompt.this.plugin.getActionFactory().getSelectedMobLocations();
                        selectedMobLocations.put(((Player)context.getForWhom()).getUniqueId(), ((World)Bukkit.getWorlds().get(0)).getBlockAt(0, 0, 0));
                        ActionMainPrompt.this.plugin.getActionFactory().setSelectedMobLocations(selectedMobLocations);
                        return new ActionMobLocationPrompt(context, this.questMob);
                    }
                    context.getForWhom().sendRawMessage(ChatColor.YELLOW + BukkitLang.get("consoleError"));
                    return new ActionMainPrompt(context);
                }
                case 5: {
                    return new ActionMobEquipmentPrompt(context, this.questMob);
                }
                case 6: {
                    return new ActionMobListPrompt(context);
                }
                case 7: {
                    LinkedList list;
                    if (this.questMob.getType() == null) {
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("eventEditorMustSetMobTypesFirst"));
                        return new ActionMobPrompt(context, this.questMob);
                    }
                    if (this.questMob.getSpawnLocation() == null) {
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("eventEditorMustSetMobLocationFirst"));
                        return new ActionMobPrompt(context, this.questMob);
                    }
                    if (this.questMob.getSpawnAmounts() == null) {
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("eventEditorMustSetMobAmountsFirst"));
                        return new ActionMobPrompt(context, this.questMob);
                    }
                    LinkedList linkedList = list = context.getSessionData((Object)"actMobs") == null ? new LinkedList() : (LinkedList)context.getSessionData((Object)"actMobs");
                    if (list != null) {
                        list.add(this.questMob);
                        context.setSessionData((Object)"actMobs", (Object)list);
                    }
                    return new ActionMobListPrompt(context);
                }
            }
            return new ActionMobPrompt(context, this.questMob);
        }
    }
}

