/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.convo.actions.menu;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.actions.Action;
import me.pikamug.quests.convo.QuestsNumericPrompt;
import me.pikamug.quests.convo.actions.ActionsEditorNumericPrompt;
import me.pikamug.quests.convo.actions.ActionsEditorStringPrompt;
import me.pikamug.quests.convo.actions.main.ActionMainPrompt;
import me.pikamug.quests.events.editor.actions.ActionsEditorPostOpenNumericPromptEvent;
import me.pikamug.quests.events.editor.actions.ActionsEditorPostOpenStringPromptEvent;
import me.pikamug.quests.quests.Quest;
import me.pikamug.quests.quests.components.Stage;
import me.pikamug.quests.util.BukkitLang;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.Prompt;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

public class ActionMenuPrompt
extends ActionsEditorNumericPrompt {
    private final BukkitQuestsPlugin plugin;
    private final int size = 4;

    public ActionMenuPrompt(ConversationContext context) {
        super(context);
        this.plugin = (BukkitQuestsPlugin)context.getPlugin();
    }

    @Override
    public int getSize() {
        return 4;
    }

    @Override
    public String getTitle(ConversationContext context) {
        String title = BukkitLang.get("eventEditorTitle");
        return title + (this.plugin.hasLimitedAccess(context.getForWhom()) ? ChatColor.RED + " (" + BukkitLang.get("trialMode") + ")" : "");
    }

    @Override
    public ChatColor getNumberColor(ConversationContext context, int number) {
        switch (number) {
            case 1: 
            case 2: 
            case 3: {
                return ChatColor.BLUE;
            }
            case 4: {
                return ChatColor.RED;
            }
        }
        return null;
    }

    @Override
    public String getSelectionText(ConversationContext context, int number) {
        switch (number) {
            case 1: {
                return ChatColor.YELLOW + BukkitLang.get("eventEditorCreate");
            }
            case 2: {
                return ChatColor.YELLOW + BukkitLang.get("eventEditorEdit");
            }
            case 3: {
                return ChatColor.YELLOW + BukkitLang.get("eventEditorDelete");
            }
            case 4: {
                return ChatColor.RED + BukkitLang.get("exit");
            }
        }
        return null;
    }

    @Override
    public String getAdditionalText(ConversationContext context, int number) {
        return null;
    }

    @Override
    @NotNull
    public String getBasicPromptText(@NotNull ConversationContext context) {
        ActionsEditorPostOpenNumericPromptEvent event = new ActionsEditorPostOpenNumericPromptEvent(context, this);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        StringBuilder text = new StringBuilder(ChatColor.GOLD + this.getTitle(context));
        for (int i = 1; i <= 4; ++i) {
            text.append("\n").append(this.getNumberColor(context, i)).append(ChatColor.BOLD).append(i).append(ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i));
        }
        return text.toString();
    }

    protected Prompt acceptValidatedInput(ConversationContext context, Number input) {
        CommandSender cs = (CommandSender)context.getForWhom();
        switch (input.intValue()) {
            case 1: {
                if (cs.hasPermission("quests.editor.actions.create") || cs.hasPermission("quests.editor.events.create")) {
                    context.setSessionData((Object)"oldAction", (Object)"");
                    return new ActionSelectCreatePrompt(context);
                }
                cs.sendMessage(ChatColor.RED + BukkitLang.get("noPermission"));
                return new ActionMenuPrompt(context);
            }
            case 2: {
                if (cs.hasPermission("quests.editor.actions.edit") || cs.hasPermission("quests.editor.events.edit")) {
                    if (this.plugin.getLoadedActions().isEmpty()) {
                        context.getForWhom().sendRawMessage(ChatColor.YELLOW + BukkitLang.get("eventEditorNoneToEdit"));
                        return new ActionMenuPrompt(context);
                    }
                    return new ActionSelectEditPrompt(context);
                }
                cs.sendMessage(ChatColor.RED + BukkitLang.get("noPermission"));
                return new ActionMenuPrompt(context);
            }
            case 3: {
                if (cs.hasPermission("quests.editor.actions.delete") || cs.hasPermission("quests.editor.events.delete")) {
                    if (this.plugin.getLoadedActions().isEmpty()) {
                        context.getForWhom().sendRawMessage(ChatColor.YELLOW + BukkitLang.get("eventEditorNoneToDelete"));
                        return new ActionMenuPrompt(context);
                    }
                    return new ActionSelectDeletePrompt(context);
                }
                cs.sendMessage(ChatColor.RED + BukkitLang.get("noPermission"));
                return new ActionMenuPrompt(context);
            }
            case 4: {
                context.getForWhom().sendRawMessage(ChatColor.YELLOW + BukkitLang.get("exited"));
                return Prompt.END_OF_CONVERSATION;
            }
        }
        return new ActionMenuPrompt(context);
    }

    public class ActionSelectCreatePrompt
    extends ActionsEditorStringPrompt {
        public ActionSelectCreatePrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("eventCreateTitle");
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("eventEditorEnterEventName");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            ActionsEditorPostOpenStringPromptEvent event = new ActionsEditorPostOpenStringPromptEvent(context, this);
            ActionMenuPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.GOLD + this.getTitle(context) + "\n" + ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("itemCreateInvalidInput"));
                return new ActionSelectCreatePrompt(context);
            }
            if (!(input = input.trim()).equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                for (Action action : ActionMenuPrompt.this.plugin.getLoadedActions()) {
                    if (!action.getName().equalsIgnoreCase(input)) continue;
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("eventEditorExists"));
                    return new ActionSelectCreatePrompt(context);
                }
                List<String> actionNames = ActionMenuPrompt.this.plugin.getActionFactory().getNamesOfActionsBeingEdited();
                if (actionNames.contains(input)) {
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("questEditorBeingEdited"));
                    return new ActionSelectCreatePrompt(context);
                }
                if (input.contains(".") || input.contains(",")) {
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("questEditorInvalidQuestName"));
                    return new ActionSelectCreatePrompt(context);
                }
                if (input.isEmpty()) {
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("itemCreateInvalidInput"));
                    return new ActionSelectCreatePrompt(context);
                }
                context.setSessionData((Object)"actName", (Object)input);
                actionNames.add(input);
                ActionMenuPrompt.this.plugin.getActionFactory().setNamesOfActionsBeingEdited(actionNames);
                return new ActionMainPrompt(context);
            }
            return new ActionMenuPrompt(context);
        }
    }

    public class ActionSelectEditPrompt
    extends ActionsEditorStringPrompt {
        public ActionSelectEditPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("eventEditTitle");
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("eventEditorEnterEventName");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            ActionsEditorPostOpenStringPromptEvent event = new ActionsEditorPostOpenStringPromptEvent(context, this);
            ActionMenuPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            List<String> names = ActionMenuPrompt.this.plugin.getLoadedActions().stream().map(Action::getName).collect(Collectors.toList());
            return this.sendClickableMenu(this.getTitle(context), names, this.getQueryText(context), context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                Action action = ActionMenuPrompt.this.plugin.getAction(input);
                if (action != null) {
                    context.setSessionData((Object)"oldAction", (Object)action.getName());
                    context.setSessionData((Object)"actName", (Object)action.getName());
                    ActionMenuPrompt.this.plugin.getActionFactory().loadData(context, action);
                    return new ActionMainPrompt(context);
                }
                context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("eventEditorNotFound").replace("<input>", input));
                return new ActionSelectEditPrompt(context);
            }
            return new ActionMenuPrompt(context);
        }
    }

    public class ActionSelectDeletePrompt
    extends ActionsEditorStringPrompt {
        public ActionSelectDeletePrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("eventDeleteTitle");
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("eventEditorEnterEventName");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            ActionsEditorPostOpenStringPromptEvent event = new ActionsEditorPostOpenStringPromptEvent(context, this);
            ActionMenuPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            List<String> names = ActionMenuPrompt.this.plugin.getLoadedActions().stream().map(Action::getName).collect(Collectors.toList());
            return this.sendClickableMenu(this.getTitle(context), names, this.getQueryText(context), context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                LinkedList<String> used = new LinkedList<String>();
                Action action = ActionMenuPrompt.this.plugin.getAction(input);
                if (action != null) {
                    block0: for (Quest quest : ActionMenuPrompt.this.plugin.getLoadedQuests()) {
                        for (Stage stage : quest.getStages()) {
                            if (stage.getFinishAction() == null || !stage.getFinishAction().getName().equalsIgnoreCase(action.getName())) continue;
                            used.add(quest.getName());
                            continue block0;
                        }
                    }
                    if (used.isEmpty()) {
                        context.setSessionData((Object)"delEvent", (Object)action.getName());
                        return new ActionConfirmDeletePrompt(context);
                    }
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("eventEditorEventInUse") + " \"" + ChatColor.DARK_PURPLE + action.getName() + ChatColor.RED + "\":");
                    for (String s : used) {
                        context.getForWhom().sendRawMessage(ChatColor.RED + "- " + ChatColor.DARK_RED + s);
                    }
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("eventEditorMustModifyQuests"));
                    return new ActionSelectDeletePrompt(context);
                }
                context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("eventEditorNotFound").replace("<input>", input));
                return new ActionSelectDeletePrompt(context);
            }
            return new ActionMenuPrompt(context);
        }
    }

    public class ActionConfirmDeletePrompt
    extends ActionsEditorStringPrompt {
        private final int size = 2;

        public ActionConfirmDeletePrompt(ConversationContext context) {
            super(context);
            this.size = 2;
        }

        public int getSize() {
            return 2;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        public ChatColor getNumberColor(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.GREEN;
                }
                case 2: {
                    return ChatColor.RED;
                }
            }
            return null;
        }

        public String getSelectionText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.GREEN + BukkitLang.get("yesWord");
                }
                case 2: {
                    return ChatColor.RED + BukkitLang.get("noWord");
                }
            }
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("confirmDelete");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            ActionsEditorPostOpenStringPromptEvent event = new ActionsEditorPostOpenStringPromptEvent(context, this);
            ActionMenuPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(ChatColor.RED + this.getQueryText(context) + " (" + ChatColor.YELLOW + context.getSessionData((Object)"delEvent") + ChatColor.RED + ")\n");
            for (int i = 1; i <= 2; ++i) {
                text.append("\n").append(this.getNumberColor(context, i)).append(ChatColor.BOLD).append(i).append(ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i));
            }
            return QuestsNumericPrompt.sendClickableSelection(text.toString(), context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (input.equalsIgnoreCase("1") || input.equalsIgnoreCase(BukkitLang.get("yesWord"))) {
                ActionMenuPrompt.this.plugin.getActionFactory().deleteAction(context);
                return Prompt.END_OF_CONVERSATION;
            }
            if (input.equalsIgnoreCase("2") || input.equalsIgnoreCase(BukkitLang.get("noWord"))) {
                return new ActionMenuPrompt(context);
            }
            return new ActionConfirmDeletePrompt(context);
        }
    }
}

