/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.convo.actions.tasks;

import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.convo.actions.ActionsEditorNumericPrompt;
import me.pikamug.quests.convo.actions.ActionsEditorStringPrompt;
import me.pikamug.quests.convo.actions.main.ActionMainPrompt;
import me.pikamug.quests.events.editor.actions.ActionsEditorPostOpenNumericPromptEvent;
import me.pikamug.quests.events.editor.actions.ActionsEditorPostOpenStringPromptEvent;
import me.pikamug.quests.util.BukkitConfigUtil;
import me.pikamug.quests.util.BukkitLang;
import me.pikamug.quests.util.BukkitMiscUtil;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.Prompt;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

public class ActionEffectPrompt
extends ActionsEditorNumericPrompt {
    private final BukkitQuestsPlugin plugin;
    private final int size = 3;

    public ActionEffectPrompt(ConversationContext context) {
        super(context);
        this.plugin = (BukkitQuestsPlugin)context.getPlugin();
    }

    @Override
    public int getSize() {
        return 3;
    }

    @Override
    public String getTitle(ConversationContext context) {
        return BukkitLang.get("eventEditorEffect");
    }

    @Override
    public ChatColor getNumberColor(ConversationContext context, int number) {
        switch (number) {
            case 1: 
            case 2: {
                return ChatColor.BLUE;
            }
            case 3: {
                return ChatColor.GREEN;
            }
        }
        return null;
    }

    @Override
    public String getSelectionText(ConversationContext context, int number) {
        switch (number) {
            case 1: {
                return ChatColor.YELLOW + BukkitLang.get("eventEditorSetEffects");
            }
            case 2: {
                return ChatColor.YELLOW + BukkitLang.get("eventEditorSetExplosions");
            }
            case 3: {
                return ChatColor.GREEN + BukkitLang.get("done");
            }
        }
        return null;
    }

    @Override
    public String getAdditionalText(ConversationContext context, int number) {
        switch (number) {
            case 1: {
                if (context.getSessionData((Object)"actEffects") == null) {
                    return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                StringBuilder text = new StringBuilder();
                LinkedList effects = (LinkedList)context.getSessionData((Object)"actEffects");
                LinkedList locations = (LinkedList)context.getSessionData((Object)"actEffectLocations");
                if (effects != null && locations != null) {
                    for (String effect : effects) {
                        text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.AQUA).append(effect).append(ChatColor.GRAY).append(" at ").append(ChatColor.DARK_AQUA).append((String)locations.get(effects.indexOf(effect)));
                    }
                }
                return text.toString();
            }
            case 2: {
                if (context.getSessionData((Object)"actExplosions") == null) {
                    return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                StringBuilder text = new StringBuilder();
                LinkedList locations = (LinkedList)context.getSessionData((Object)"actExplosions");
                if (locations != null) {
                    for (String loc : locations) {
                        text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.AQUA).append(loc);
                    }
                }
                return text.toString();
            }
            case 3: {
                return "";
            }
        }
        return null;
    }

    @Override
    @NotNull
    public String getBasicPromptText(@NotNull ConversationContext context) {
        ActionsEditorPostOpenNumericPromptEvent event = new ActionsEditorPostOpenNumericPromptEvent(context, this);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        StringBuilder text = new StringBuilder(ChatColor.GOLD + "- " + this.getTitle(context) + " -");
        for (int i = 1; i <= 3; ++i) {
            text.append("\n").append(this.getNumberColor(context, i)).append(ChatColor.BOLD).append(i).append(ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i)).append(" ").append(this.getAdditionalText(context, i));
        }
        return text.toString();
    }

    protected Prompt acceptValidatedInput(@NotNull ConversationContext context, Number input) {
        switch (input.intValue()) {
            case 1: {
                return new ActionEffectSoundListPrompt(context);
            }
            case 2: {
                if (context.getForWhom() instanceof Player) {
                    ConcurrentHashMap<UUID, Block> selectedExplosionLocations = this.plugin.getActionFactory().getSelectedExplosionLocations();
                    selectedExplosionLocations.put(((Player)context.getForWhom()).getUniqueId(), ((World)Bukkit.getWorlds().get(0)).getBlockAt(0, 0, 0));
                    this.plugin.getActionFactory().setSelectedExplosionLocations(selectedExplosionLocations);
                    return new ActionEffectExplosionPrompt(context);
                }
                context.getForWhom().sendRawMessage(ChatColor.YELLOW + BukkitLang.get("consoleError"));
                return new ActionEffectPrompt(context);
            }
            case 3: {
                return new ActionMainPrompt(context);
            }
        }
        return new ActionEffectPrompt(context);
    }

    public class ActionEffectSoundListPrompt
    extends ActionsEditorNumericPrompt {
        private final int size = 4;

        public ActionEffectSoundListPrompt(ConversationContext context) {
            super(context);
            this.size = 4;
        }

        @Override
        public int getSize() {
            return 4;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("eventEditorEffectsTitle");
        }

        @Override
        public ChatColor getNumberColor(ConversationContext context, int number) {
            switch (number) {
                case 1: 
                case 2: {
                    return ChatColor.BLUE;
                }
                case 3: {
                    return ChatColor.RED;
                }
                case 4: {
                    return ChatColor.GREEN;
                }
            }
            return null;
        }

        @Override
        public String getSelectionText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.YELLOW + BukkitLang.get("eventEditorAddEffect");
                }
                case 2: {
                    return ChatColor.YELLOW + BukkitLang.get("eventEditorAddEffectLocation");
                }
                case 3: {
                    return ChatColor.RED + BukkitLang.get("clear");
                }
                case 4: {
                    return ChatColor.GREEN + BukkitLang.get("done");
                }
            }
            return null;
        }

        @Override
        public String getAdditionalText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    if (context.getSessionData((Object)"actEffects") == null) {
                        return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    StringBuilder text = new StringBuilder();
                    for (String s : (List)Objects.requireNonNull(context.getSessionData((Object)"actEffects"))) {
                        text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.AQUA).append(s);
                    }
                    return text.toString();
                }
                case 2: {
                    if (context.getSessionData((Object)"actEffectLocations") == null) {
                        return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    StringBuilder text = new StringBuilder();
                    for (String s : (List)Objects.requireNonNull(context.getSessionData((Object)"actEffectLocations"))) {
                        text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.AQUA).append(s);
                    }
                    return text.toString();
                }
                case 3: 
                case 4: {
                    return "";
                }
            }
            return null;
        }

        @Override
        @NotNull
        public String getBasicPromptText(@NotNull ConversationContext context) {
            ActionsEditorPostOpenNumericPromptEvent event = new ActionsEditorPostOpenNumericPromptEvent(context, this);
            ActionEffectPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(ChatColor.GOLD + this.getTitle(context));
            for (int i = 1; i <= 4; ++i) {
                text.append("\n").append(this.getNumberColor(context, i)).append(ChatColor.BOLD).append(i).append(ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i)).append(" ").append(this.getAdditionalText(context, i));
            }
            return text.toString();
        }

        protected Prompt acceptValidatedInput(@NotNull ConversationContext context, Number input) {
            switch (input.intValue()) {
                case 1: {
                    return new ActionEffectSoundPrompt(context);
                }
                case 2: {
                    if (context.getSessionData((Object)"actEffects") == null) {
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("eventEditorMustAddEffects"));
                        return new ActionEffectSoundListPrompt(context);
                    }
                    if (context.getForWhom() instanceof Player) {
                        ConcurrentHashMap<UUID, Block> selectedEffectLocations = ActionEffectPrompt.this.plugin.getActionFactory().getSelectedEffectLocations();
                        selectedEffectLocations.put(((Player)context.getForWhom()).getUniqueId(), ((World)Bukkit.getWorlds().get(0)).getBlockAt(0, 0, 0));
                        ActionEffectPrompt.this.plugin.getActionFactory().setSelectedEffectLocations(selectedEffectLocations);
                        return new ActionEffectSoundLocationPrompt(context);
                    }
                    context.getForWhom().sendRawMessage(ChatColor.YELLOW + BukkitLang.get("consoleError"));
                    return new ActionEffectSoundListPrompt(context);
                }
                case 3: {
                    context.getForWhom().sendRawMessage(ChatColor.YELLOW + BukkitLang.get("eventEditorEffectsCleared"));
                    context.setSessionData((Object)"actEffects", null);
                    context.setSessionData((Object)"actEffectLocations", null);
                    return new ActionEffectSoundListPrompt(context);
                }
                case 4: {
                    List effects = (List)context.getSessionData((Object)"actEffects");
                    List locations = (List)context.getSessionData((Object)"actEffectLocations");
                    int one = effects != null ? effects.size() : 0;
                    int two = locations != null ? locations.size() : 0;
                    if (one == two) {
                        return new ActionMainPrompt(context);
                    }
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("listsNotSameSize"));
                    return new ActionEffectSoundListPrompt(context);
                }
            }
            return new ActionEffectSoundListPrompt(context);
        }
    }

    public class ActionEffectExplosionPrompt
    extends ActionsEditorStringPrompt {
        public ActionEffectExplosionPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("eventEditorExplosionPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            ActionsEditorPostOpenStringPromptEvent event = new ActionsEditorPostOpenStringPromptEvent(context, this);
            ActionEffectPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            Player player = (Player)context.getForWhom();
            if (input.equalsIgnoreCase(BukkitLang.get("cmdAdd"))) {
                LinkedList locations;
                ConcurrentHashMap<UUID, Block> selectedExplosionLocations = ActionEffectPrompt.this.plugin.getActionFactory().getSelectedExplosionLocations();
                Block block = selectedExplosionLocations.get(player.getUniqueId());
                if (block != null) {
                    Location loc = block.getLocation();
                    locations = context.getSessionData((Object)"actExplosions") != null ? (LinkedList)context.getSessionData((Object)"actExplosions") : new LinkedList();
                    if (locations != null) {
                        locations.add(BukkitConfigUtil.getLocationInfo(loc));
                    }
                } else {
                    player.sendMessage(ChatColor.RED + BukkitLang.get("eventEditorSelectBlockFirst"));
                    return new ActionEffectExplosionPrompt(context);
                }
                context.setSessionData((Object)"actExplosions", (Object)locations);
                selectedExplosionLocations.remove(player.getUniqueId());
                ActionEffectPrompt.this.plugin.getActionFactory().setSelectedExplosionLocations(selectedExplosionLocations);
                return new ActionMainPrompt(context);
            }
            if (input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                context.setSessionData((Object)"actExplosions", null);
                ConcurrentHashMap<UUID, Block> selectedExplosionLocations = ActionEffectPrompt.this.plugin.getActionFactory().getSelectedExplosionLocations();
                selectedExplosionLocations.remove(player.getUniqueId());
                ActionEffectPrompt.this.plugin.getActionFactory().setSelectedExplosionLocations(selectedExplosionLocations);
                return new ActionMainPrompt(context);
            }
            if (input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                ConcurrentHashMap<UUID, Block> selectedExplosionLocations = ActionEffectPrompt.this.plugin.getActionFactory().getSelectedExplosionLocations();
                selectedExplosionLocations.remove(player.getUniqueId());
                ActionEffectPrompt.this.plugin.getActionFactory().setSelectedExplosionLocations(selectedExplosionLocations);
                return new ActionMainPrompt(context);
            }
            return new ActionEffectExplosionPrompt(context);
        }
    }

    public class ActionEffectSoundLocationPrompt
    extends ActionsEditorStringPrompt {
        public ActionEffectSoundLocationPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("eventEditorEffectLocationPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            ActionsEditorPostOpenStringPromptEvent event = new ActionsEditorPostOpenStringPromptEvent(context, this);
            ActionEffectPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            Player player = (Player)context.getForWhom();
            if (input.equalsIgnoreCase(BukkitLang.get("cmdAdd"))) {
                LinkedList locations;
                ConcurrentHashMap<UUID, Block> selectedEffectLocations = ActionEffectPrompt.this.plugin.getActionFactory().getSelectedEffectLocations();
                Block block = (Block)selectedEffectLocations.get(player.getUniqueId());
                if (block != null) {
                    Location loc = block.getLocation();
                    locations = context.getSessionData((Object)"actEffectLocations") != null ? (LinkedList)context.getSessionData((Object)"actEffectLocations") : new LinkedList();
                    if (locations != null) {
                        locations.add(BukkitConfigUtil.getLocationInfo(loc));
                    }
                } else {
                    player.sendMessage(ChatColor.RED + BukkitLang.get("eventEditorSelectBlockFirst"));
                    return new ActionEffectSoundLocationPrompt(context);
                }
                context.setSessionData((Object)"actEffectLocations", (Object)locations);
                selectedEffectLocations.remove(player.getUniqueId());
                return new ActionEffectSoundListPrompt(context);
            }
            if (input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                ConcurrentHashMap<UUID, Block> selectedEffectLocations = ActionEffectPrompt.this.plugin.getActionFactory().getSelectedEffectLocations();
                selectedEffectLocations.remove(player.getUniqueId());
                ActionEffectPrompt.this.plugin.getActionFactory().setSelectedEffectLocations(selectedEffectLocations);
                return new ActionEffectSoundListPrompt(context);
            }
            return new ActionEffectSoundLocationPrompt(context);
        }
    }

    public class ActionEffectSoundPrompt
    extends ActionsEditorStringPrompt {
        public ActionEffectSoundPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("eventEditorEffectsTitle");
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("effEnterName");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            ActionsEditorPostOpenStringPromptEvent event = new ActionsEditorPostOpenStringPromptEvent(context, this);
            ActionEffectPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder effects = new StringBuilder(ChatColor.LIGHT_PURPLE + this.getTitle(context) + "\n");
            LinkedList<Effect> effArr = new LinkedList<Effect>(Arrays.asList(Effect.values()));
            effArr.sort(Comparator.comparing(Enum::name));
            for (int i = 0; i < effArr.size(); ++i) {
                effects.append(ChatColor.AQUA).append(BukkitMiscUtil.snakeCaseToUpperCamelCase(((Effect)effArr.get(i)).name()));
                if (i >= effArr.size() - 1) continue;
                effects.append(ChatColor.GRAY).append(", ");
            }
            effects.append("\n").append(ChatColor.YELLOW).append(this.getQueryText(context));
            return effects.toString();
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                if (BukkitMiscUtil.getProperEffect(input) != null) {
                    LinkedList effects = context.getSessionData((Object)"actEffects") != null ? (LinkedList)context.getSessionData((Object)"actEffects") : new LinkedList();
                    if (effects != null && BukkitMiscUtil.getProperEffect(input) != null) {
                        effects.add(Objects.requireNonNull(BukkitMiscUtil.getProperEffect(input)).name());
                    }
                    context.setSessionData((Object)"actEffects", (Object)effects);
                    if (context.getForWhom() instanceof Player) {
                        ConcurrentHashMap<UUID, Block> selectedEffectLocations = ActionEffectPrompt.this.plugin.getActionFactory().getSelectedEffectLocations();
                        selectedEffectLocations.remove(((Player)context.getForWhom()).getUniqueId());
                        ActionEffectPrompt.this.plugin.getActionFactory().setSelectedEffectLocations(selectedEffectLocations);
                    }
                    return new ActionEffectSoundListPrompt(context);
                }
                context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("eventEditorInvalidEffect").replace("<input>", input));
                return new ActionEffectSoundPrompt(context);
            }
            if (context.getForWhom() instanceof Player) {
                ConcurrentHashMap<UUID, Block> selectedEffectLocations = ActionEffectPrompt.this.plugin.getActionFactory().getSelectedEffectLocations();
                selectedEffectLocations.remove(((Player)context.getForWhom()).getUniqueId());
                ActionEffectPrompt.this.plugin.getActionFactory().setSelectedEffectLocations(selectedEffectLocations);
            }
            return new ActionEffectSoundListPrompt(context);
        }
    }
}

