/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.convo.actions.tasks;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.convo.actions.ActionsEditorNumericPrompt;
import me.pikamug.quests.convo.actions.ActionsEditorStringPrompt;
import me.pikamug.quests.convo.actions.main.ActionMainPrompt;
import me.pikamug.quests.convo.generic.ItemStackPrompt;
import me.pikamug.quests.events.editor.actions.ActionsEditorPostOpenNumericPromptEvent;
import me.pikamug.quests.events.editor.actions.ActionsEditorPostOpenStringPromptEvent;
import me.pikamug.quests.util.BukkitConfigUtil;
import me.pikamug.quests.util.BukkitItemUtil;
import me.pikamug.quests.util.BukkitLang;
import me.pikamug.quests.util.BukkitMiscUtil;
import me.pikamug.quests.util.RomanNumeral;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.Prompt;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;

public class ActionPlayerPrompt
extends ActionsEditorNumericPrompt {
    private final BukkitQuestsPlugin plugin;
    private final int size = 10;

    public ActionPlayerPrompt(ConversationContext context) {
        super(context);
        this.plugin = (BukkitQuestsPlugin)context.getPlugin();
    }

    @Override
    public int getSize() {
        return 10;
    }

    @Override
    public String getTitle(ConversationContext context) {
        return BukkitLang.get("eventEditorPlayer");
    }

    @Override
    public ChatColor getNumberColor(ConversationContext context, int number) {
        switch (number) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return ChatColor.BLUE;
            }
            case 10: {
                return ChatColor.GREEN;
            }
        }
        return null;
    }

    @Override
    public String getSelectionText(ConversationContext context, int number) {
        switch (number) {
            case 1: {
                return ChatColor.YELLOW + BukkitLang.get("eventEditorSetMessage");
            }
            case 2: {
                return ChatColor.YELLOW + BukkitLang.get("eventEditorSetItems");
            }
            case 3: {
                return ChatColor.YELLOW + BukkitLang.get("eventEditorSetPotionEffects");
            }
            case 4: {
                return ChatColor.YELLOW + BukkitLang.get("eventEditorSetHunger");
            }
            case 5: {
                return ChatColor.YELLOW + BukkitLang.get("eventEditorSetSaturation");
            }
            case 6: {
                return ChatColor.YELLOW + BukkitLang.get("eventEditorSetHealth");
            }
            case 7: {
                return ChatColor.YELLOW + BukkitLang.get("eventEditorSetTeleport");
            }
            case 8: {
                return ChatColor.YELLOW + BukkitLang.get("eventEditorSetCommands");
            }
            case 9: {
                return ChatColor.YELLOW + BukkitLang.get("eventEditorClearInv");
            }
            case 10: {
                return ChatColor.GREEN + BukkitLang.get("done");
            }
        }
        return null;
    }

    @Override
    public String getAdditionalText(ConversationContext context, int number) {
        switch (number) {
            case 1: {
                if (context.getSessionData((Object)"actMessage") == null) {
                    return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                return ChatColor.GRAY + "(" + ChatColor.AQUA + context.getSessionData((Object)"actMessage") + ChatColor.GRAY + ")";
            }
            case 2: {
                if (context.getSessionData((Object)"actItems") == null) {
                    return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                StringBuilder text = new StringBuilder();
                LinkedList items = (LinkedList)context.getSessionData((Object)"actItems");
                if (items != null) {
                    for (ItemStack is : items) {
                        if (is == null) continue;
                        text.append("\n").append(ChatColor.GRAY).append("     - ").append(BukkitItemUtil.getString(is));
                    }
                    return text.toString();
                }
            }
            case 3: {
                if (context.getSessionData((Object)"actPotionTypes") == null) {
                    return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                StringBuilder text = new StringBuilder();
                LinkedList types = (LinkedList)context.getSessionData((Object)"actPotionTypes");
                LinkedList durations = (LinkedList)context.getSessionData((Object)"actPotionDurations");
                LinkedList mags = (LinkedList)context.getSessionData((Object)"actPotionMagnitudes");
                int index = -1;
                if (types != null && durations != null && mags != null) {
                    for (String type : types) {
                        text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.AQUA).append(type).append(ChatColor.DARK_PURPLE).append(" ").append(RomanNumeral.getNumeral((Integer)mags.get(++index))).append(ChatColor.GRAY).append(" -> ").append(ChatColor.DARK_AQUA).append(BukkitMiscUtil.getTime((Long)durations.get(index) * 50L));
                    }
                }
                return text.toString();
            }
            case 4: {
                if (context.getSessionData((Object)"actHunger") == null) {
                    return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                return ChatColor.GRAY + "(" + ChatColor.AQUA + context.getSessionData((Object)"actHunger") + ChatColor.GRAY + ")";
            }
            case 5: {
                if (context.getSessionData((Object)"actSaturation") == null) {
                    return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                return ChatColor.GRAY + "(" + ChatColor.AQUA + context.getSessionData((Object)"actSaturation") + ChatColor.GRAY + ")";
            }
            case 6: {
                if (context.getSessionData((Object)"actHealth") == null) {
                    return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                return ChatColor.GRAY + "(" + ChatColor.AQUA + context.getSessionData((Object)"actHealth") + ChatColor.GRAY + ")";
            }
            case 7: {
                if (context.getSessionData((Object)"actTeleportLocation") == null) {
                    return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                return ChatColor.GRAY + "(" + ChatColor.AQUA + context.getSessionData((Object)"actTeleportLocation") + ChatColor.GRAY + ")";
            }
            case 8: {
                if (context.getSessionData((Object)"actCommands") == null) {
                    return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                StringBuilder text = new StringBuilder();
                for (String s : (LinkedList)Objects.requireNonNull(context.getSessionData((Object)"actCommands"))) {
                    text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.AQUA).append(s);
                }
                return text.toString();
            }
            case 9: {
                if (context.getSessionData((Object)"actClearInv") == null) {
                    return ChatColor.GRAY + "(" + ChatColor.RED + BukkitLang.get("false") + ChatColor.GRAY + ")";
                }
                Boolean clearOpt = (Boolean)context.getSessionData((Object)"actClearInv");
                return ChatColor.GRAY + "(" + (Boolean.TRUE.equals(clearOpt) ? ChatColor.GREEN + BukkitLang.get("true") : ChatColor.RED + BukkitLang.get("false")) + ChatColor.GRAY + ")";
            }
            case 10: {
                return "";
            }
        }
        return null;
    }

    @Override
    @NotNull
    public String getBasicPromptText(ConversationContext context) {
        if (context.getSessionData((Object)"actClearInv") == null) {
            context.setSessionData((Object)"actClearInv", (Object)false);
        }
        ActionsEditorPostOpenNumericPromptEvent event = new ActionsEditorPostOpenNumericPromptEvent(context, this);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        StringBuilder text = new StringBuilder(ChatColor.GOLD + "- " + this.getTitle(context) + " -");
        for (int i = 1; i <= 10; ++i) {
            text.append("\n").append(this.getNumberColor(context, i)).append(ChatColor.BOLD).append(i).append(ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i)).append(" ").append(this.getAdditionalText(context, i));
        }
        return text.toString();
    }

    protected Prompt acceptValidatedInput(@NotNull ConversationContext context, Number input) {
        switch (input.intValue()) {
            case 1: {
                return new ActionPlayerMessagePrompt(context);
            }
            case 2: {
                return new ActionPlayerItemListPrompt(context);
            }
            case 3: {
                return new ActionPlayerPotionListPrompt(context);
            }
            case 4: {
                return new ActionPlayerHungerPrompt(context);
            }
            case 5: {
                return new ActionPlayerSaturationPrompt(context);
            }
            case 6: {
                return new ActionPlayerHealthPrompt(context);
            }
            case 7: {
                if (context.getForWhom() instanceof Player) {
                    ConcurrentHashMap<UUID, Block> selectedTeleportLocations = this.plugin.getActionFactory().getSelectedTeleportLocations();
                    selectedTeleportLocations.put(((Player)context.getForWhom()).getUniqueId(), ((World)Bukkit.getWorlds().get(0)).getBlockAt(0, 0, 0));
                    this.plugin.getActionFactory().setSelectedTeleportLocations(selectedTeleportLocations);
                    return new ActionPlayerTeleportPrompt(context);
                }
                context.getForWhom().sendRawMessage(ChatColor.YELLOW + BukkitLang.get("consoleError"));
                return new ActionPlayerPrompt(context);
            }
            case 8: {
                if (!this.plugin.hasLimitedAccess(context.getForWhom())) {
                    return new ActionPlayerCommandsPrompt(context);
                }
                context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("noPermission"));
                return new ActionPlayerPrompt(context);
            }
            case 9: {
                Boolean b = (Boolean)context.getSessionData((Object)"actClearInv");
                if (Boolean.TRUE.equals(b)) {
                    context.setSessionData((Object)"actClearInv", (Object)false);
                } else {
                    context.setSessionData((Object)"actClearInv", (Object)true);
                }
                return new ActionPlayerPrompt(context);
            }
            case 10: {
                return new ActionMainPrompt(context);
            }
        }
        return new ActionPlayerPrompt(context);
    }

    public class ActionPlayerMessagePrompt
    extends ActionsEditorStringPrompt {
        public ActionPlayerMessagePrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("eventEditorSetMessagePrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            ActionsEditorPostOpenStringPromptEvent event = new ActionsEditorPostOpenStringPromptEvent(context, this);
            ActionPlayerPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel")) && !input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                context.setSessionData((Object)"actMessage", (Object)input);
            } else if (input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                context.setSessionData((Object)"actMessage", null);
            }
            return new ActionMainPrompt(context);
        }
    }

    public class ActionPlayerItemListPrompt
    extends ActionsEditorNumericPrompt {
        private final int size = 3;

        public ActionPlayerItemListPrompt(ConversationContext context) {
            super(context);
            this.size = 3;
        }

        @Override
        public int getSize() {
            return 3;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("eventEditorGiveItemsTitle");
        }

        @Override
        public ChatColor getNumberColor(ConversationContext context, int number) {
            switch (number) {
                case 1: 
                case 2: {
                    return ChatColor.BLUE;
                }
                case 3: {
                    return ChatColor.GREEN;
                }
            }
            return null;
        }

        @Override
        public String getSelectionText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.YELLOW + BukkitLang.get("stageEditorDeliveryAddItem");
                }
                case 2: {
                    return ChatColor.RED + BukkitLang.get("clear");
                }
                case 3: {
                    return ChatColor.GREEN + BukkitLang.get("done");
                }
            }
            return null;
        }

        @Override
        public String getAdditionalText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    if (context.getSessionData((Object)"actItems") == null) {
                        return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    StringBuilder text = new StringBuilder();
                    for (ItemStack is : (List)Objects.requireNonNull(context.getSessionData((Object)"actItems"))) {
                        text.append("\n").append(ChatColor.GRAY).append("     - ").append(BukkitItemUtil.getDisplayString(is));
                    }
                    return text.toString();
                }
                case 2: 
                case 3: {
                    return "";
                }
            }
            return null;
        }

        @Override
        @NotNull
        public String getBasicPromptText(ConversationContext context) {
            if (context.getSessionData((Object)"tempStack") != null) {
                if (context.getSessionData((Object)"actItems") != null) {
                    List items = (List)context.getSessionData((Object)"actItems");
                    if (items != null) {
                        items.add((ItemStack)context.getSessionData((Object)"tempStack"));
                        context.setSessionData((Object)"actItems", (Object)items);
                    }
                } else {
                    LinkedList<ItemStack> itemRewards = new LinkedList<ItemStack>();
                    itemRewards.add((ItemStack)context.getSessionData((Object)"tempStack"));
                    context.setSessionData((Object)"actItems", itemRewards);
                }
                ItemStackPrompt.clearSessionData(context);
            }
            ActionsEditorPostOpenNumericPromptEvent event = new ActionsEditorPostOpenNumericPromptEvent(context, this);
            ActionPlayerPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(ChatColor.GOLD + this.getTitle(context));
            for (int i = 1; i <= 3; ++i) {
                text.append("\n").append(this.getNumberColor(context, i)).append(ChatColor.BOLD).append(i).append(ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i)).append(" ").append(this.getAdditionalText(context, i));
            }
            return text.toString();
        }

        protected Prompt acceptValidatedInput(@NotNull ConversationContext context, Number input) {
            switch (input.intValue()) {
                case 1: {
                    return new ItemStackPrompt(context, (Prompt)this);
                }
                case 2: {
                    context.getForWhom().sendRawMessage(ChatColor.YELLOW + BukkitLang.get("eventEditorItemsCleared"));
                    context.setSessionData((Object)"actItems", null);
                    return new ActionPlayerItemListPrompt(context);
                }
                case 3: {
                    return new ActionMainPrompt(context);
                }
            }
            return new ActionPlayerItemListPrompt(context);
        }
    }

    public class ActionPlayerPotionListPrompt
    extends ActionsEditorNumericPrompt {
        private final int size = 5;

        public ActionPlayerPotionListPrompt(ConversationContext context) {
            super(context);
            this.size = 5;
        }

        @Override
        public int getSize() {
            return 5;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("eventEditorPotionEffectsTitle");
        }

        @Override
        public ChatColor getNumberColor(ConversationContext context, int number) {
            switch (number) {
                case 1: 
                case 2: 
                case 3: {
                    return ChatColor.BLUE;
                }
                case 4: {
                    return ChatColor.RED;
                }
                case 5: {
                    return ChatColor.GREEN;
                }
            }
            return null;
        }

        @Override
        public String getSelectionText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.YELLOW + BukkitLang.get("eventEditorSetPotionEffectTypes");
                }
                case 2: {
                    return ChatColor.YELLOW + BukkitLang.get("eventEditorSetPotionDurations");
                }
                case 3: {
                    return ChatColor.YELLOW + BukkitLang.get("eventEditorSetPotionMagnitudes");
                }
                case 4: {
                    return ChatColor.RED + BukkitLang.get("clear");
                }
                case 5: {
                    return ChatColor.GREEN + BukkitLang.get("done");
                }
            }
            return null;
        }

        @Override
        public String getAdditionalText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    if (context.getSessionData((Object)"actPotionTypes") == null) {
                        return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    StringBuilder text = new StringBuilder();
                    for (String s : (LinkedList)Objects.requireNonNull(context.getSessionData((Object)"actPotionTypes"))) {
                        text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.AQUA).append(s);
                    }
                    return text.toString();
                }
                case 2: {
                    if (context.getSessionData((Object)"actPotionDurations") == null) {
                        return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    StringBuilder text = new StringBuilder();
                    for (Long l : (LinkedList)Objects.requireNonNull(context.getSessionData((Object)"actPotionDurations"))) {
                        text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.DARK_AQUA).append(BukkitMiscUtil.getTime(l * 50L));
                    }
                    return text.toString();
                }
                case 3: {
                    if (context.getSessionData((Object)"actPotionMagnitudes") == null) {
                        return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    StringBuilder text = new StringBuilder();
                    Iterator iterator = ((LinkedList)Objects.requireNonNull(context.getSessionData((Object)"actPotionMagnitudes"))).iterator();
                    while (iterator.hasNext()) {
                        int i = (Integer)iterator.next();
                        text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.DARK_PURPLE).append(i);
                    }
                    return text.toString();
                }
                case 4: 
                case 5: {
                    return "";
                }
            }
            return null;
        }

        @Override
        @NotNull
        public String getBasicPromptText(@NotNull ConversationContext context) {
            ActionsEditorPostOpenNumericPromptEvent event = new ActionsEditorPostOpenNumericPromptEvent(context, this);
            ActionPlayerPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(ChatColor.GOLD + this.getTitle(context));
            for (int i = 1; i <= 5; ++i) {
                text.append("\n").append(this.getNumberColor(context, i)).append(ChatColor.BOLD).append(i).append(ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i)).append(" ").append(this.getAdditionalText(context, i));
            }
            return text.toString();
        }

        protected Prompt acceptValidatedInput(@NotNull ConversationContext context, Number input) {
            switch (input.intValue()) {
                case 1: {
                    return new ActionPlayerPotionTypesPrompt(context);
                }
                case 2: {
                    if (context.getSessionData((Object)"actPotionTypes") == null) {
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("eventEditorMustSetPotionTypesFirst"));
                        return new ActionPlayerPotionListPrompt(context);
                    }
                    return new ActionPlayerPotionDurationsPrompt(context);
                }
                case 3: {
                    if (context.getSessionData((Object)"actPotionTypes") == null) {
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("eventEditorMustSetPotionTypesAndDurationsFirst"));
                        return new ActionPlayerPotionListPrompt(context);
                    }
                    if (context.getSessionData((Object)"actPotionDurations") == null) {
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("eventEditorMustSetPotionDurationsFirst"));
                        return new ActionPlayerPotionListPrompt(context);
                    }
                    return new ActionPlayerPotionMagnitudesPrompt(context);
                }
                case 4: {
                    context.getForWhom().sendRawMessage(ChatColor.YELLOW + BukkitLang.get("eventEditorPotionsCleared"));
                    context.setSessionData((Object)"actPotionTypes", null);
                    context.setSessionData((Object)"actPotionDurations", null);
                    context.setSessionData((Object)"actPotionMagnitudes", null);
                    return new ActionPlayerPotionListPrompt(context);
                }
                case 5: {
                    List types = (List)context.getSessionData((Object)"actPotionTypes");
                    List durations = (List)context.getSessionData((Object)"actPotionDurations");
                    List strength = (List)context.getSessionData((Object)"actPotionMagnitudes");
                    int one = types != null ? types.size() : 0;
                    int two = durations != null ? durations.size() : 0;
                    int three = strength != null ? strength.size() : 0;
                    if (one == two && two == three) {
                        return new ActionMainPrompt(context);
                    }
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("eventEditorListSizeMismatch"));
                    return new ActionPlayerPotionListPrompt(context);
                }
            }
            return new ActionPlayerPotionListPrompt(context);
        }
    }

    public class ActionPlayerHungerPrompt
    extends ActionsEditorStringPrompt {
        public ActionPlayerHungerPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("eventEditorSetHungerPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            ActionsEditorPostOpenStringPromptEvent event = new ActionsEditorPostOpenStringPromptEvent(context, this);
            ActionPlayerPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                try {
                    int i = Integer.parseInt(input);
                    if (i < 0) {
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("invalidMinimum").replace("<number>", "0"));
                        return new ActionPlayerHungerPrompt(context);
                    }
                    context.setSessionData((Object)"actHunger", (Object)i);
                }
                catch (NumberFormatException e) {
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("reqNotANumber").replace("<input>", input));
                    return new ActionPlayerHungerPrompt(context);
                }
            } else {
                context.setSessionData((Object)"actHunger", null);
            }
            return new ActionMainPrompt(context);
        }
    }

    public class ActionPlayerSaturationPrompt
    extends ActionsEditorStringPrompt {
        public ActionPlayerSaturationPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("eventEditorSetSaturationPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            ActionsEditorPostOpenStringPromptEvent event = new ActionsEditorPostOpenStringPromptEvent(context, this);
            ActionPlayerPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                try {
                    int i = Integer.parseInt(input);
                    if (i < 0) {
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("invalidMinimum").replace("<number>", "0"));
                        return new ActionPlayerSaturationPrompt(context);
                    }
                    context.setSessionData((Object)"actSaturation", (Object)i);
                }
                catch (NumberFormatException e) {
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("reqNotANumber").replace("<input>", input));
                    return new ActionPlayerSaturationPrompt(context);
                }
            } else {
                context.setSessionData((Object)"actSaturation", null);
            }
            return new ActionMainPrompt(context);
        }
    }

    public class ActionPlayerHealthPrompt
    extends ActionsEditorStringPrompt {
        public ActionPlayerHealthPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("eventEditorSetHealthPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            ActionsEditorPostOpenStringPromptEvent event = new ActionsEditorPostOpenStringPromptEvent(context, this);
            ActionPlayerPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                try {
                    int i = Integer.parseInt(input);
                    if (i < 0) {
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("invalidMinimum").replace("<number>", "0"));
                        return new ActionPlayerHealthPrompt(context);
                    }
                    context.setSessionData((Object)"actHealth", (Object)i);
                }
                catch (NumberFormatException e) {
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("reqNotANumber").replace("<input>", input));
                    return new ActionPlayerHealthPrompt(context);
                }
            } else {
                context.setSessionData((Object)"actHealth", null);
            }
            return new ActionMainPrompt(context);
        }
    }

    public class ActionPlayerTeleportPrompt
    extends ActionsEditorStringPrompt {
        public ActionPlayerTeleportPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("eventEditorSetTeleportPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            ActionsEditorPostOpenStringPromptEvent event = new ActionsEditorPostOpenStringPromptEvent(context, this);
            ActionPlayerPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            Player player = (Player)context.getForWhom();
            if (input.equalsIgnoreCase(BukkitLang.get("cmdDone"))) {
                ConcurrentHashMap<UUID, Block> selectedTeleportLocations = ActionPlayerPrompt.this.plugin.getActionFactory().getSelectedTeleportLocations();
                Block block = selectedTeleportLocations.get(player.getUniqueId());
                if (block == null) {
                    player.sendMessage(ChatColor.RED + BukkitLang.get("eventEditorSelectBlockFirst"));
                    return new ActionPlayerTeleportPrompt(context);
                }
                Location loc = block.getLocation();
                context.setSessionData((Object)"actTeleportLocation", (Object)BukkitConfigUtil.getLocationInfo(loc));
                selectedTeleportLocations.remove(player.getUniqueId());
                ActionPlayerPrompt.this.plugin.getActionFactory().setSelectedTeleportLocations(selectedTeleportLocations);
                return new ActionMainPrompt(context);
            }
            if (input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                context.setSessionData((Object)"actTeleportLocation", null);
                ConcurrentHashMap<UUID, Block> selectedTeleportLocations = ActionPlayerPrompt.this.plugin.getActionFactory().getSelectedTeleportLocations();
                selectedTeleportLocations.remove(player.getUniqueId());
                ActionPlayerPrompt.this.plugin.getActionFactory().setSelectedTeleportLocations(selectedTeleportLocations);
                return new ActionMainPrompt(context);
            }
            if (input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                ConcurrentHashMap<UUID, Block> selectedTeleportLocations = ActionPlayerPrompt.this.plugin.getActionFactory().getSelectedTeleportLocations();
                selectedTeleportLocations.remove(player.getUniqueId());
                ActionPlayerPrompt.this.plugin.getActionFactory().setSelectedTeleportLocations(selectedTeleportLocations);
                return new ActionMainPrompt(context);
            }
            return new ActionPlayerTeleportPrompt(context);
        }
    }

    public class ActionPlayerCommandsPrompt
    extends ActionsEditorStringPrompt {
        public ActionPlayerCommandsPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("eventEditorSetCommandsPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            ActionsEditorPostOpenStringPromptEvent event = new ActionsEditorPostOpenStringPromptEvent(context, this);
            ActionPlayerPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel")) && !input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                String[] commands = input.split(BukkitLang.get("charSemi"));
                LinkedList<String> cmdList = new LinkedList<String>(Arrays.asList(commands));
                context.setSessionData((Object)"actCommands", cmdList);
            } else if (input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                context.setSessionData((Object)"actCommands", null);
            }
            return new ActionMainPrompt(context);
        }
    }

    public class ActionPlayerPotionMagnitudesPrompt
    extends ActionsEditorStringPrompt {
        public ActionPlayerPotionMagnitudesPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("eventEditorSetPotionMagnitudesPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            ActionsEditorPostOpenStringPromptEvent event = new ActionsEditorPostOpenStringPromptEvent(context, this);
            ActionPlayerPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                LinkedList<Integer> magAmounts = new LinkedList<Integer>();
                for (String s : input.split(" ")) {
                    try {
                        int i = Integer.parseInt(s);
                        if (i < 1) {
                            context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("invalidMinimum").replace("<number>", "1"));
                            return new ActionPlayerPotionMagnitudesPrompt(context);
                        }
                        magAmounts.add(i);
                    }
                    catch (NumberFormatException e) {
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("reqNotANumber").replace("<input>", s));
                        return new ActionPlayerPotionMagnitudesPrompt(context);
                    }
                }
                context.setSessionData((Object)"actPotionMagnitudes", magAmounts);
            }
            return new ActionPlayerPotionListPrompt(context);
        }
    }

    public class ActionPlayerPotionDurationsPrompt
    extends ActionsEditorStringPrompt {
        public ActionPlayerPotionDurationsPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("eventEditorSetPotionDurationsPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            ActionsEditorPostOpenStringPromptEvent event = new ActionsEditorPostOpenStringPromptEvent(context, this);
            ActionPlayerPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                LinkedList<Long> effDurations = new LinkedList<Long>();
                for (String s : input.split(" ")) {
                    try {
                        int i = Integer.parseInt(s);
                        long l = (long)i * 1000L;
                        if (l < 1000L) {
                            context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("invalidMinimum").replace("<number>", "1"));
                            return new ActionPlayerPotionDurationsPrompt(context);
                        }
                        effDurations.add(l / 50L);
                    }
                    catch (NumberFormatException e) {
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("reqNotANumber").replace("<input>", s));
                        return new ActionPlayerPotionDurationsPrompt(context);
                    }
                }
                context.setSessionData((Object)"actPotionDurations", effDurations);
            }
            return new ActionPlayerPotionListPrompt(context);
        }
    }

    public class ActionPlayerPotionTypesPrompt
    extends ActionsEditorStringPrompt {
        public ActionPlayerPotionTypesPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("eventEditorPotionTypesTitle");
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("eventEditorSetPotionEffectsPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            ActionsEditorPostOpenStringPromptEvent event = new ActionsEditorPostOpenStringPromptEvent(context, this);
            ActionPlayerPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder potions = new StringBuilder(ChatColor.LIGHT_PURPLE + this.getTitle(context) + "\n");
            LinkedList<PotionEffectType> effArr = new LinkedList<PotionEffectType>(Arrays.asList(PotionEffectType.values()));
            effArr.sort(Comparator.comparing(PotionEffectType::getName));
            for (int i = 0; i < effArr.size(); ++i) {
                String name = ((PotionEffectType)effArr.get(i)).getName().replaceFirst("minecraft:", "").toUpperCase();
                potions.append(ChatColor.AQUA).append(name);
                if (i >= effArr.size() - 1) continue;
                potions.append(ChatColor.GRAY).append(", ");
            }
            potions.append("\n").append(ChatColor.YELLOW).append(this.getQueryText(context));
            return potions.toString();
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                LinkedList<String> effTypes = new LinkedList<String>();
                for (String s : input.split(" ")) {
                    if (PotionEffectType.getByName((String)s.toUpperCase()) == null) {
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("eventEditorInvalidPotionType").replace("<input>", s));
                        return new ActionPlayerPotionTypesPrompt(context);
                    }
                    effTypes.add(Objects.requireNonNull(PotionEffectType.getByName((String)s.toUpperCase())).getName());
                    context.setSessionData((Object)"actPotionTypes", effTypes);
                }
            }
            return new ActionPlayerPotionListPrompt(context);
        }
    }
}

