/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.convo.actions.tasks;

import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.convo.actions.ActionsEditorNumericPrompt;
import me.pikamug.quests.convo.actions.ActionsEditorStringPrompt;
import me.pikamug.quests.convo.actions.main.ActionMainPrompt;
import me.pikamug.quests.events.editor.actions.ActionsEditorPostOpenNumericPromptEvent;
import me.pikamug.quests.events.editor.actions.ActionsEditorPostOpenStringPromptEvent;
import me.pikamug.quests.util.BukkitLang;
import me.pikamug.quests.util.BukkitMiscUtil;
import org.bukkit.ChatColor;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.Prompt;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

public class ActionTimerPrompt
extends ActionsEditorNumericPrompt {
    private final BukkitQuestsPlugin plugin;
    private final int size = 3;

    public ActionTimerPrompt(ConversationContext context) {
        super(context);
        this.plugin = (BukkitQuestsPlugin)context.getPlugin();
    }

    @Override
    public int getSize() {
        return 3;
    }

    @Override
    public String getTitle(ConversationContext context) {
        return BukkitLang.get("eventEditorTimer");
    }

    @Override
    public ChatColor getNumberColor(ConversationContext context, int number) {
        switch (number) {
            case 1: 
            case 2: {
                return ChatColor.BLUE;
            }
            case 3: {
                return ChatColor.GREEN;
            }
        }
        return null;
    }

    @Override
    public String getSelectionText(ConversationContext context, int number) {
        switch (number) {
            case 1: {
                return ChatColor.YELLOW + BukkitLang.get("eventEditorSetTimer");
            }
            case 2: {
                return ChatColor.YELLOW + BukkitLang.get("eventEditorCancelTimer");
            }
            case 3: {
                return ChatColor.GREEN + BukkitLang.get("done");
            }
        }
        return null;
    }

    @Override
    public String getAdditionalText(ConversationContext context, int number) {
        switch (number) {
            case 1: {
                if (context.getSessionData((Object)"actTimer") == null) {
                    return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                Integer timer = (Integer)context.getSessionData((Object)"actTimer");
                if (timer != null) {
                    return ChatColor.GRAY + "(" + ChatColor.AQUA + BukkitMiscUtil.getTime((long)timer.intValue() * 1000L) + ChatColor.GRAY + ")";
                }
            }
            case 2: {
                if (context.getSessionData((Object)"actCancelTimer") == null) {
                    return ChatColor.GRAY + "(" + ChatColor.RED + BukkitLang.get("false") + ChatColor.GRAY + ")";
                }
                Boolean timerOpt = (Boolean)context.getSessionData((Object)"actCancelTimer");
                return ChatColor.GRAY + "(" + (Boolean.TRUE.equals(timerOpt) ? ChatColor.GREEN + BukkitLang.get("true") : ChatColor.RED + BukkitLang.get("false")) + ChatColor.GRAY + ")";
            }
            case 3: {
                return "";
            }
        }
        return null;
    }

    @Override
    @NotNull
    public String getBasicPromptText(ConversationContext context) {
        if (context.getSessionData((Object)"actCancelTimer") == null) {
            context.setSessionData((Object)"actCancelTimer", (Object)false);
        }
        ActionsEditorPostOpenNumericPromptEvent event = new ActionsEditorPostOpenNumericPromptEvent(context, this);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        StringBuilder text = new StringBuilder(ChatColor.GOLD + "- " + this.getTitle(context) + " -");
        for (int i = 1; i <= 3; ++i) {
            text.append("\n").append(this.getNumberColor(context, i)).append(ChatColor.BOLD).append(i).append(ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i)).append(" ").append(this.getAdditionalText(context, i));
        }
        return text.toString();
    }

    protected Prompt acceptValidatedInput(@NotNull ConversationContext context, Number input) {
        switch (input.intValue()) {
            case 1: {
                return new ActionTimerFailPrompt(context);
            }
            case 2: {
                Boolean b = (Boolean)context.getSessionData((Object)"actCancelTimer");
                if (Boolean.TRUE.equals(b)) {
                    context.setSessionData((Object)"actCancelTimer", (Object)false);
                } else {
                    context.setSessionData((Object)"actCancelTimer", (Object)true);
                }
                return new ActionTimerPrompt(context);
            }
            case 3: {
                return new ActionMainPrompt(context);
            }
        }
        return new ActionTimerPrompt(context);
    }

    public class ActionTimerFailPrompt
    extends ActionsEditorStringPrompt {
        public ActionTimerFailPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("eventEditorEnterTimerSeconds");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            ActionsEditorPostOpenStringPromptEvent event = new ActionsEditorPostOpenStringPromptEvent(context, this);
            ActionTimerPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            try {
                int i = Integer.parseInt(input);
                if (i < 1) {
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("questEditorPositiveAmount"));
                } else {
                    context.setSessionData((Object)"actTimer", (Object)i);
                }
            }
            catch (NumberFormatException e) {
                context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("reqNotANumber").replace("<input>", input));
                return new ActionTimerFailPrompt(context);
            }
            return new ActionTimerPrompt(context);
        }
    }
}

