/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.convo.actions.tasks;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.convo.actions.ActionsEditorNumericPrompt;
import me.pikamug.quests.convo.actions.ActionsEditorStringPrompt;
import me.pikamug.quests.convo.actions.main.ActionMainPrompt;
import me.pikamug.quests.events.editor.actions.ActionsEditorPostOpenNumericPromptEvent;
import me.pikamug.quests.events.editor.actions.ActionsEditorPostOpenStringPromptEvent;
import me.pikamug.quests.util.BukkitConfigUtil;
import me.pikamug.quests.util.BukkitLang;
import me.pikamug.quests.util.BukkitMiscUtil;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.Prompt;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

public class ActionWeatherPrompt
extends ActionsEditorNumericPrompt {
    private final BukkitQuestsPlugin plugin;
    private final int size = 4;

    public ActionWeatherPrompt(ConversationContext context) {
        super(context);
        this.plugin = (BukkitQuestsPlugin)context.getPlugin();
    }

    @Override
    public int getSize() {
        return 4;
    }

    @Override
    public String getTitle(ConversationContext context) {
        return BukkitLang.get("eventEditorWeather");
    }

    @Override
    public ChatColor getNumberColor(ConversationContext context, int number) {
        switch (number) {
            case 1: 
            case 2: 
            case 3: {
                return ChatColor.BLUE;
            }
            case 4: {
                return ChatColor.GREEN;
            }
        }
        return null;
    }

    @Override
    public String getSelectionText(ConversationContext context, int number) {
        switch (number) {
            case 1: {
                return ChatColor.YELLOW + BukkitLang.get("eventEditorSetStorm");
            }
            case 2: {
                return ChatColor.YELLOW + BukkitLang.get("eventEditorSetThunder");
            }
            case 3: {
                return ChatColor.YELLOW + BukkitLang.get("eventEditorSetLightning");
            }
            case 4: {
                return ChatColor.GREEN + BukkitLang.get("done");
            }
        }
        return null;
    }

    @Override
    public String getAdditionalText(ConversationContext context, int number) {
        switch (number) {
            case 1: {
                if (context.getSessionData((Object)"actStormWorld") == null) {
                    return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                Integer duration = (Integer)context.getSessionData((Object)"actStormDuration");
                if (duration != null) {
                    return ChatColor.GRAY + "(" + ChatColor.AQUA + context.getSessionData((Object)"actStormWorld") + ChatColor.GRAY + " -> " + ChatColor.DARK_AQUA + BukkitMiscUtil.getTime((long)duration.intValue() * 1000L) + ChatColor.GRAY + ")";
                }
            }
            case 2: {
                if (context.getSessionData((Object)"actThunderWorld") == null) {
                    return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                Integer duration = (Integer)context.getSessionData((Object)"actThunderDuration");
                if (duration != null) {
                    return ChatColor.GRAY + "(" + ChatColor.AQUA + context.getSessionData((Object)"actThunderWorld") + ChatColor.GRAY + " -> " + ChatColor.DARK_AQUA + BukkitMiscUtil.getTime((long)duration.intValue() * 1000L) + ChatColor.GRAY + ")";
                }
            }
            case 3: {
                if (context.getSessionData((Object)"actLightningStrikes") == null) {
                    return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                StringBuilder text = new StringBuilder();
                LinkedList locations = (LinkedList)context.getSessionData((Object)"actLightningStrikes");
                if (locations != null) {
                    for (String loc : locations) {
                        text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.AQUA).append(loc);
                    }
                }
                return text.toString();
            }
            case 4: {
                return "";
            }
        }
        return null;
    }

    @Override
    @NotNull
    public String getBasicPromptText(@NotNull ConversationContext context) {
        ActionsEditorPostOpenNumericPromptEvent event = new ActionsEditorPostOpenNumericPromptEvent(context, this);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        StringBuilder text = new StringBuilder(ChatColor.GOLD + "- " + this.getTitle(context) + " -");
        for (int i = 1; i <= 4; ++i) {
            text.append("\n").append(this.getNumberColor(context, i)).append(ChatColor.BOLD).append(i).append(ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i)).append(" ").append(this.getAdditionalText(context, i));
        }
        return text.toString();
    }

    protected Prompt acceptValidatedInput(@NotNull ConversationContext context, Number input) {
        switch (input.intValue()) {
            case 1: {
                return new ActionStormPrompt(context);
            }
            case 2: {
                return new ActionThunderPrompt(context);
            }
            case 3: {
                if (context.getForWhom() instanceof Player) {
                    ConcurrentHashMap<UUID, Block> selectedLightningLocations = this.plugin.getActionFactory().getSelectedLightningLocations();
                    selectedLightningLocations.put(((Player)context.getForWhom()).getUniqueId(), ((World)Bukkit.getWorlds().get(0)).getBlockAt(0, 0, 0));
                    this.plugin.getActionFactory().setSelectedLightningLocations(selectedLightningLocations);
                    return new ActionLightningPrompt(context);
                }
                context.getForWhom().sendRawMessage(ChatColor.YELLOW + BukkitLang.get("consoleError"));
                return new ActionWeatherPrompt(context);
            }
            case 4: {
                return new ActionMainPrompt(context);
            }
        }
        return new ActionWeatherPrompt(context);
    }

    public class ActionStormPrompt
    extends ActionsEditorNumericPrompt {
        private final int size = 4;

        public ActionStormPrompt(ConversationContext context) {
            super(context);
            this.size = 4;
        }

        @Override
        public int getSize() {
            return 4;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("eventEditorStormTitle");
        }

        @Override
        public ChatColor getNumberColor(ConversationContext context, int number) {
            switch (number) {
                case 1: 
                case 2: {
                    return ChatColor.BLUE;
                }
                case 3: {
                    return ChatColor.RED;
                }
                case 4: {
                    return ChatColor.GREEN;
                }
            }
            return null;
        }

        @Override
        public String getSelectionText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.YELLOW + BukkitLang.get("eventEditorSetWorld");
                }
                case 2: {
                    return ChatColor.YELLOW + BukkitLang.get("eventEditorSetDuration");
                }
                case 3: {
                    return ChatColor.YELLOW + BukkitLang.get("clear");
                }
                case 4: {
                    return ChatColor.GREEN + BukkitLang.get("done");
                }
            }
            return null;
        }

        @Override
        public String getAdditionalText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    if (context.getSessionData((Object)"actStormWorld") == null) {
                        return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    return ChatColor.GRAY + "(" + ChatColor.AQUA + context.getSessionData((Object)"actStormWorld") + ChatColor.GRAY + ")";
                }
                case 2: {
                    if (context.getSessionData((Object)"actStormDuration") == null) {
                        return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    Integer duration = (Integer)context.getSessionData((Object)"actStormDuration");
                    if (duration != null) {
                        return ChatColor.GRAY + "(" + ChatColor.AQUA + BukkitMiscUtil.getTime((long)duration.intValue() * 1000L) + ChatColor.GRAY + ")";
                    }
                }
                case 3: 
                case 4: {
                    return "";
                }
            }
            return null;
        }

        @Override
        @NotNull
        public String getBasicPromptText(@NotNull ConversationContext context) {
            ActionsEditorPostOpenNumericPromptEvent event = new ActionsEditorPostOpenNumericPromptEvent(context, this);
            ActionWeatherPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(ChatColor.GOLD + this.getTitle(context));
            for (int i = 1; i <= 4; ++i) {
                text.append("\n").append(this.getNumberColor(context, i)).append(ChatColor.BOLD).append(i).append(ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i)).append(" ").append(this.getAdditionalText(context, i));
            }
            return text.toString();
        }

        protected Prompt acceptValidatedInput(@NotNull ConversationContext context, Number input) {
            switch (input.intValue()) {
                case 1: {
                    return new ActionStormWorldPrompt(context);
                }
                case 2: {
                    if (context.getSessionData((Object)"actStormWorld") == null) {
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("eventEditorSetWorldFirst"));
                        return new ActionStormPrompt(context);
                    }
                    return new ActionStormDurationPrompt(context);
                }
                case 3: {
                    if (context.getSessionData((Object)"actStormWorld") != null && context.getSessionData((Object)"actStormDuration") == null) {
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("eventEditorMustSetStormDuration"));
                        return new ActionStormPrompt(context);
                    }
                    return new ActionMainPrompt(context);
                }
                case 4: {
                    return new ActionMainPrompt(context);
                }
            }
            return new ActionStormPrompt(context);
        }
    }

    public class ActionThunderPrompt
    extends ActionsEditorNumericPrompt {
        private final int size = 4;

        public ActionThunderPrompt(ConversationContext context) {
            super(context);
            this.size = 4;
        }

        @Override
        public int getSize() {
            return 4;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("eventEditorThunderTitle");
        }

        @Override
        public ChatColor getNumberColor(ConversationContext context, int number) {
            switch (number) {
                case 1: 
                case 2: {
                    return ChatColor.BLUE;
                }
                case 3: {
                    return ChatColor.RED;
                }
                case 4: {
                    return ChatColor.GREEN;
                }
            }
            return null;
        }

        @Override
        public String getSelectionText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.YELLOW + BukkitLang.get("eventEditorSetWorld");
                }
                case 2: {
                    return ChatColor.YELLOW + BukkitLang.get("eventEditorSetDuration");
                }
                case 3: {
                    return ChatColor.YELLOW + BukkitLang.get("clear");
                }
                case 4: {
                    return ChatColor.GREEN + BukkitLang.get("done");
                }
            }
            return null;
        }

        @Override
        public String getAdditionalText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    if (context.getSessionData((Object)"actThunderWorld") == null) {
                        return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    return ChatColor.GRAY + "(" + ChatColor.AQUA + context.getSessionData((Object)"actThunderWorld") + ChatColor.GRAY + ")";
                }
                case 2: {
                    if (context.getSessionData((Object)"actThunderDuration") == null) {
                        return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    Integer duration = (Integer)context.getSessionData((Object)"actThunderDuration");
                    if (duration != null) {
                        return ChatColor.GRAY + "(" + ChatColor.AQUA + BukkitMiscUtil.getTime((long)duration.intValue() * 1000L) + ChatColor.GRAY + ")";
                    }
                }
                case 3: 
                case 4: {
                    return "";
                }
            }
            return null;
        }

        @Override
        @NotNull
        public String getBasicPromptText(@NotNull ConversationContext context) {
            ActionsEditorPostOpenNumericPromptEvent event = new ActionsEditorPostOpenNumericPromptEvent(context, this);
            ActionWeatherPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(ChatColor.GOLD + this.getTitle(context));
            for (int i = 1; i <= 4; ++i) {
                text.append("\n").append(this.getNumberColor(context, i)).append(ChatColor.BOLD).append(i).append(ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i)).append(" ").append(this.getAdditionalText(context, i));
            }
            return text.toString();
        }

        protected Prompt acceptValidatedInput(@NotNull ConversationContext context, Number input) {
            switch (input.intValue()) {
                case 1: {
                    return new ActionThunderWorldPrompt(context);
                }
                case 2: {
                    if (context.getSessionData((Object)"actThunderWorld") == null) {
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("eventEditorSetWorldFirst"));
                        return new ActionThunderPrompt(context);
                    }
                    return new ActionThunderDurationPrompt(context);
                }
                case 3: {
                    context.getForWhom().sendRawMessage(ChatColor.YELLOW + BukkitLang.get("eventEditorThunderCleared"));
                    context.setSessionData((Object)"actThunderWorld", null);
                    context.setSessionData((Object)"actThunderDuration", null);
                    return new ActionThunderPrompt(context);
                }
                case 4: {
                    if (context.getSessionData((Object)"actThunderWorld") != null && context.getSessionData((Object)"actThunderDuration") == null) {
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("eventEditorMustSetThunderDuration"));
                        return new ActionThunderPrompt(context);
                    }
                    return new ActionMainPrompt(context);
                }
            }
            return new ActionThunderPrompt(context);
        }
    }

    public class ActionLightningPrompt
    extends ActionsEditorStringPrompt {
        public ActionLightningPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("eventEditorLightningPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            ActionsEditorPostOpenStringPromptEvent event = new ActionsEditorPostOpenStringPromptEvent(context, this);
            ActionWeatherPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            Player player = (Player)context.getForWhom();
            if (input.equalsIgnoreCase(BukkitLang.get("cmdAdd"))) {
                LinkedList locations;
                ConcurrentHashMap<UUID, Block> selectedLightningLocations = ActionWeatherPrompt.this.plugin.getActionFactory().getSelectedLightningLocations();
                Block block = selectedLightningLocations.get(player.getUniqueId());
                if (block != null) {
                    Location loc = block.getLocation();
                    locations = context.getSessionData((Object)"actLightningStrikes") != null ? (LinkedList)context.getSessionData((Object)"actLightningStrikes") : new LinkedList();
                    if (locations != null) {
                        locations.add(BukkitConfigUtil.getLocationInfo(loc));
                    }
                } else {
                    player.sendMessage(ChatColor.RED + BukkitLang.get("eventEditorSelectBlockFirst"));
                    return new ActionLightningPrompt(context);
                }
                context.setSessionData((Object)"actLightningStrikes", (Object)locations);
                selectedLightningLocations.remove(player.getUniqueId());
                ActionWeatherPrompt.this.plugin.getActionFactory().setSelectedLightningLocations(selectedLightningLocations);
                return new ActionMainPrompt(context);
            }
            if (input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                context.setSessionData((Object)"actLightningStrikes", null);
                ConcurrentHashMap<UUID, Block> selectedLightningLocations = ActionWeatherPrompt.this.plugin.getActionFactory().getSelectedLightningLocations();
                selectedLightningLocations.remove(player.getUniqueId());
                ActionWeatherPrompt.this.plugin.getActionFactory().setSelectedLightningLocations(selectedLightningLocations);
                return new ActionMainPrompt(context);
            }
            if (input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                ConcurrentHashMap<UUID, Block> selectedLightningLocations = ActionWeatherPrompt.this.plugin.getActionFactory().getSelectedLightningLocations();
                selectedLightningLocations.remove(player.getUniqueId());
                ActionWeatherPrompt.this.plugin.getActionFactory().setSelectedLightningLocations(selectedLightningLocations);
                return new ActionMainPrompt(context);
            }
            return new ActionLightningPrompt(context);
        }
    }

    public class ActionThunderDurationPrompt
    extends ActionsEditorStringPrompt {
        public ActionThunderDurationPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("eventEditorEnterDuration");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            ActionsEditorPostOpenStringPromptEvent event = new ActionsEditorPostOpenStringPromptEvent(context, this);
            ActionWeatherPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            try {
                int i = Integer.parseInt(input);
                if (i < 1) {
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("invalidMinimum").replace("<number>", "1"));
                    return new ActionThunderDurationPrompt(context);
                }
                context.setSessionData((Object)"actThunderDuration", (Object)i);
            }
            catch (NumberFormatException e) {
                context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("reqNotANumber").replace("<input>", input));
            }
            return new ActionThunderPrompt(context);
        }
    }

    public class ActionThunderWorldPrompt
    extends ActionsEditorStringPrompt {
        public ActionThunderWorldPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("eventEditorWorldsTitle");
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("eventEditorEnterThunderWorld");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            ActionsEditorPostOpenStringPromptEvent event = new ActionsEditorPostOpenStringPromptEvent(context, this);
            ActionWeatherPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder worlds = new StringBuilder(ChatColor.LIGHT_PURPLE + this.getTitle(context) + "\n");
            List worldArr = ActionWeatherPrompt.this.plugin.getServer().getWorlds();
            for (int i = 0; i < worldArr.size(); ++i) {
                worlds.append(ChatColor.AQUA).append(((World)worldArr.get(i)).getName());
                if (i >= worldArr.size() - 1) continue;
                worlds.append(ChatColor.GRAY).append(", ");
            }
            worlds.append("\n").append(ChatColor.YELLOW).append(this.getQueryText(context));
            return worlds.toString();
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                if (ActionWeatherPrompt.this.plugin.getServer().getWorld(input) != null) {
                    context.setSessionData((Object)"actThunderWorld", (Object)Objects.requireNonNull(ActionWeatherPrompt.this.plugin.getServer().getWorld(input)).getName());
                } else {
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("eventEditorInvalidWorld").replace("<input>", input));
                    return new ActionThunderWorldPrompt(context);
                }
            }
            return new ActionThunderPrompt(context);
        }
    }

    public class ActionStormDurationPrompt
    extends ActionsEditorStringPrompt {
        public ActionStormDurationPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("eventEditorEnterDuration");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            ActionsEditorPostOpenStringPromptEvent event = new ActionsEditorPostOpenStringPromptEvent(context, this);
            ActionWeatherPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            try {
                int i = Integer.parseInt(input);
                if (i < 1) {
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("invalidMinimum").replace("<number>", "1"));
                    return new ActionStormDurationPrompt(context);
                }
                context.setSessionData((Object)"actStormDuration", (Object)i);
            }
            catch (NumberFormatException e) {
                context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("reqNotANumber").replace("<input>", input));
            }
            return new ActionStormPrompt(context);
        }
    }

    public class ActionStormWorldPrompt
    extends ActionsEditorStringPrompt {
        public ActionStormWorldPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("eventEditorWorldsTitle");
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("eventEditorEnterStormWorld");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            ActionsEditorPostOpenStringPromptEvent event = new ActionsEditorPostOpenStringPromptEvent(context, this);
            ActionWeatherPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder worlds = new StringBuilder(ChatColor.LIGHT_PURPLE + this.getTitle(context) + "\n");
            List worldArr = ActionWeatherPrompt.this.plugin.getServer().getWorlds();
            for (int i = 0; i < worldArr.size(); ++i) {
                worlds.append(ChatColor.AQUA).append(((World)worldArr.get(i)).getName());
                if (i >= worldArr.size() - 1) continue;
                worlds.append(ChatColor.GRAY).append(", ");
            }
            worlds.append("\n").append(ChatColor.YELLOW).append(this.getQueryText(context));
            return worlds.toString();
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                if (ActionWeatherPrompt.this.plugin.getServer().getWorld(input) != null) {
                    context.setSessionData((Object)"actStormWorld", (Object)Objects.requireNonNull(ActionWeatherPrompt.this.plugin.getServer().getWorld(input)).getName());
                } else {
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("eventEditorInvalidWorld").replace("<input>", input));
                    return new ActionStormWorldPrompt(context);
                }
            }
            return new ActionStormPrompt(context);
        }
    }
}

