/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.convo.conditions.main;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.conditions.Condition;
import me.pikamug.quests.convo.QuestsNumericPrompt;
import me.pikamug.quests.convo.conditions.ConditionsEditorNumericPrompt;
import me.pikamug.quests.convo.conditions.ConditionsEditorStringPrompt;
import me.pikamug.quests.convo.conditions.tasks.ConditionEntityPrompt;
import me.pikamug.quests.convo.conditions.tasks.ConditionPlayerPrompt;
import me.pikamug.quests.convo.conditions.tasks.ConditionWorldPrompt;
import me.pikamug.quests.events.editor.conditions.ConditionsEditorPostOpenNumericPromptEvent;
import me.pikamug.quests.events.editor.conditions.ConditionsEditorPostOpenStringPromptEvent;
import me.pikamug.quests.quests.Quest;
import me.pikamug.quests.quests.components.Stage;
import me.pikamug.quests.util.BukkitLang;
import org.bukkit.ChatColor;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.Prompt;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

public class ConditionMainPrompt
extends ConditionsEditorNumericPrompt {
    private final BukkitQuestsPlugin plugin;
    private final int size = 8;

    public ConditionMainPrompt(ConversationContext context) {
        super(context);
        this.plugin = (BukkitQuestsPlugin)context.getPlugin();
    }

    @Override
    public int getSize() {
        return 8;
    }

    @Override
    public String getTitle(ConversationContext context) {
        return BukkitLang.get("condition") + ": " + context.getSessionData((Object)"conName");
    }

    @Override
    public ChatColor getNumberColor(ConversationContext context, int number) {
        switch (number) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return ChatColor.BLUE;
            }
            case 7: {
                return ChatColor.GREEN;
            }
            case 8: {
                return ChatColor.RED;
            }
        }
        return null;
    }

    @Override
    public String getSelectionText(ConversationContext context, int number) {
        switch (number) {
            case 1: {
                return ChatColor.YELLOW + BukkitLang.get("conditionEditorSetName");
            }
            case 2: {
                return ChatColor.GOLD + BukkitLang.get("conditionEditorEntity");
            }
            case 3: {
                return ChatColor.GOLD + BukkitLang.get("eventEditorPlayer");
            }
            case 4: {
                return ChatColor.GOLD + BukkitLang.get("conditionEditorWorld");
            }
            case 5: {
                return ChatColor.YELLOW + BukkitLang.get("conditionEditorCheckPlaceholder");
            }
            case 6: {
                return ChatColor.YELLOW + BukkitLang.get("eventEditorFailQuest");
            }
            case 7: {
                return ChatColor.GREEN + BukkitLang.get("save");
            }
            case 8: {
                return ChatColor.RED + BukkitLang.get("exit");
            }
        }
        return null;
    }

    @Override
    public String getAdditionalText(ConversationContext context, int number) {
        switch (number) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                return "";
            }
            case 6: {
                if (context.getSessionData((Object)"conFailQuest") == null) {
                    return ChatColor.GRAY + "(" + ChatColor.RED + BukkitLang.get("false") + ChatColor.GRAY + ")";
                }
                Boolean failOpt = (Boolean)context.getSessionData((Object)"conFailQuest");
                return ChatColor.GRAY + "(" + (Boolean.TRUE.equals(failOpt) ? ChatColor.GREEN + BukkitLang.get("true") : ChatColor.RED + BukkitLang.get("false")) + ChatColor.GRAY + ")";
            }
        }
        return null;
    }

    @Override
    @NotNull
    public String getBasicPromptText(@NotNull ConversationContext context) {
        ConditionsEditorPostOpenNumericPromptEvent event = new ConditionsEditorPostOpenNumericPromptEvent(context, this);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        StringBuilder text = new StringBuilder(ChatColor.GOLD + "- " + this.getTitle(context).replaceFirst(": ", ": " + ChatColor.AQUA) + ChatColor.GOLD + " -");
        for (int i = 1; i <= 8; ++i) {
            text.append("\n").append(this.getNumberColor(context, i)).append(ChatColor.BOLD).append(i).append(ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i)).append(" ").append(this.getAdditionalText(context, i));
        }
        return text.toString();
    }

    public Prompt acceptValidatedInput(@NotNull ConversationContext context, Number input) {
        switch (input.intValue()) {
            case 1: {
                return new ConditionNamePrompt(context);
            }
            case 2: {
                return new ConditionEntityPrompt(context);
            }
            case 3: {
                return new ConditionPlayerPrompt(context);
            }
            case 4: {
                return new ConditionWorldPrompt(context);
            }
            case 5: {
                return new ConditionPlaceholderListPrompt(context);
            }
            case 6: {
                Boolean b = (Boolean)context.getSessionData((Object)"conFailQuest");
                if (Boolean.TRUE.equals(b)) {
                    context.setSessionData((Object)"conFailQuest", (Object)false);
                } else {
                    context.setSessionData((Object)"conFailQuest", (Object)true);
                }
                return new ConditionMainPrompt(context);
            }
            case 7: {
                if (context.getSessionData((Object)"oldCondition") != null) {
                    return new ConditionSavePrompt(context, (String)context.getSessionData((Object)"oldCondition"));
                }
                return new ConditionSavePrompt(context, null);
            }
            case 8: {
                return new ConditionExitPrompt(context);
            }
        }
        return new ConditionMainPrompt(context);
    }

    public class ConditionNamePrompt
    extends ConditionsEditorStringPrompt {
        public ConditionNamePrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("conditionEditorEnterName");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            ConditionsEditorPostOpenStringPromptEvent event = new ConditionsEditorPostOpenStringPromptEvent(context, this);
            ConditionMainPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                for (Condition c : ConditionMainPrompt.this.plugin.getLoadedConditions()) {
                    if (!c.getName().equalsIgnoreCase(input)) continue;
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("conditionEditorExists"));
                    return new ConditionNamePrompt(context);
                }
                List<String> conditionNames = ConditionMainPrompt.this.plugin.getConditionFactory().getNamesOfConditionsBeingEdited();
                if (conditionNames.contains(input)) {
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("questEditorBeingEdited"));
                    return new ConditionNamePrompt(context);
                }
                if (input.contains(",")) {
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("questEditorInvalidQuestName"));
                    return new ConditionNamePrompt(context);
                }
                conditionNames.remove((String)context.getSessionData((Object)"conName"));
                context.setSessionData((Object)"conName", (Object)input);
                conditionNames.add(input);
                ConditionMainPrompt.this.plugin.getConditionFactory().setNamesOfConditionsBeingEdited(conditionNames);
            }
            return new ConditionMainPrompt(context);
        }
    }

    public class ConditionPlaceholderListPrompt
    extends ConditionsEditorNumericPrompt {
        private final int size = 4;

        public ConditionPlaceholderListPrompt(ConversationContext context) {
            super(context);
            this.size = 4;
        }

        @Override
        public int getSize() {
            return 4;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("conditionEditorPlaceholderTitle");
        }

        @Override
        public ChatColor getNumberColor(ConversationContext context, int number) {
            switch (number) {
                case 1: 
                case 2: {
                    return ChatColor.BLUE;
                }
                case 3: {
                    return ChatColor.RED;
                }
                case 4: {
                    return ChatColor.GREEN;
                }
            }
            return null;
        }

        @Override
        public String getSelectionText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.YELLOW + BukkitLang.get("conditionEditorSetPlaceholderId");
                }
                case 2: {
                    return ChatColor.YELLOW + BukkitLang.get("conditionEditorSetPlaceholderVal");
                }
                case 3: {
                    return ChatColor.RED + BukkitLang.get("clear");
                }
                case 4: {
                    return ChatColor.GREEN + BukkitLang.get("done");
                }
            }
            return null;
        }

        @Override
        public String getAdditionalText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    if (ConditionMainPrompt.this.plugin.getDependencies().getPlaceholderApi() != null) {
                        if (context.getSessionData((Object)"conPlaceholderId") == null) {
                            return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                        }
                        List id = (List)context.getSessionData((Object)"conPlaceholderId");
                        StringBuilder text = new StringBuilder();
                        if (id != null) {
                            for (String i : id) {
                                text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.AQUA).append(i);
                            }
                        }
                        return text.toString();
                    }
                    return ChatColor.GRAY + "(" + BukkitLang.get("notInstalled") + ")";
                }
                case 2: {
                    if (ConditionMainPrompt.this.plugin.getDependencies().getPlaceholderApi() != null) {
                        if (context.getSessionData((Object)"conPlaceholderVal") == null) {
                            return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                        }
                        List val = (List)context.getSessionData((Object)"conPlaceholderVal");
                        StringBuilder text = new StringBuilder();
                        if (val != null) {
                            for (String i : val) {
                                text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.AQUA).append(i);
                            }
                        }
                        return text.toString();
                    }
                    return ChatColor.GRAY + "(" + BukkitLang.get("notInstalled") + ")";
                }
                case 3: 
                case 4: {
                    return "";
                }
            }
            return null;
        }

        @Override
        @NotNull
        public String getBasicPromptText(@NotNull ConversationContext context) {
            ConditionsEditorPostOpenNumericPromptEvent event = new ConditionsEditorPostOpenNumericPromptEvent(context, this);
            ConditionMainPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(ChatColor.AQUA + this.getTitle(context));
            for (int i = 1; i <= 4; ++i) {
                text.append("\n").append(this.getNumberColor(context, i)).append(ChatColor.BOLD).append(i).append(ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i)).append(" ").append(this.getAdditionalText(context, i));
            }
            return text.toString();
        }

        protected Prompt acceptValidatedInput(@NotNull ConversationContext context, Number input) {
            switch (input.intValue()) {
                case 1: {
                    return new ConditionPlaceholderIdentifierPrompt(context);
                }
                case 2: {
                    return new ConditionPlaceholderValuePrompt(context);
                }
                case 3: {
                    context.getForWhom().sendRawMessage(ChatColor.YELLOW + BukkitLang.get("conditionEditorPlaceholderCleared"));
                    context.setSessionData((Object)"conPlaceholderId", null);
                    context.setSessionData((Object)"conPlaceholderVal", null);
                    return new ConditionPlaceholderListPrompt(context);
                }
                case 4: {
                    int one = context.getSessionData((Object)"conPlaceholderId") != null ? ((List)Objects.requireNonNull(context.getSessionData((Object)"conPlaceholderId"))).size() : 0;
                    int two = context.getSessionData((Object)"conPlaceholderVal") != null ? ((List)Objects.requireNonNull(context.getSessionData((Object)"conPlaceholderVal"))).size() : 0;
                    if (one == two) {
                        return new ConditionMainPrompt(context);
                    }
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("listsNotSameSize"));
                    return new ConditionPlaceholderListPrompt(context);
                }
            }
            return new ConditionPlaceholderListPrompt(context);
        }
    }

    public class ConditionSavePrompt
    extends ConditionsEditorStringPrompt {
        String modName;
        LinkedList<String> modified;
        private final int size = 2;

        public ConditionSavePrompt(ConversationContext context, String modifiedName) {
            super(context);
            this.modName = null;
            this.modified = new LinkedList();
            this.size = 2;
            if (modifiedName != null) {
                this.modName = modifiedName;
                block0: for (Quest q : ConditionMainPrompt.this.plugin.getLoadedQuests()) {
                    for (Stage s : q.getStages()) {
                        if (s.getCondition() == null || s.getCondition().getName() == null || !s.getCondition().getName().equalsIgnoreCase(modifiedName)) continue;
                        this.modified.add(q.getName());
                        continue block0;
                    }
                }
            }
        }

        public int getSize() {
            return 2;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        public ChatColor getNumberColor(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.GREEN;
                }
                case 2: {
                    return ChatColor.RED;
                }
            }
            return null;
        }

        public String getSelectionText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.GREEN + BukkitLang.get("yesWord");
                }
                case 2: {
                    return ChatColor.RED + BukkitLang.get("noWord");
                }
            }
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("questEditorSave");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            ConditionsEditorPostOpenStringPromptEvent event = new ConditionsEditorPostOpenStringPromptEvent(context, this);
            ConditionMainPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(ChatColor.YELLOW + this.getQueryText(context));
            if (!this.modified.isEmpty()) {
                text.append("\n").append(ChatColor.RED).append(" ").append(BukkitLang.get("conditionEditorModifiedNote"));
                for (String s : this.modified) {
                    text.append("\n").append(ChatColor.GRAY).append("    - ").append(ChatColor.DARK_RED).append(s);
                }
                text.append("\n").append(ChatColor.RED).append(" ").append(BukkitLang.get("conditionEditorForcedToQuit"));
            }
            for (int i = 1; i <= 2; ++i) {
                text.append("\n").append(this.getNumberColor(context, i)).append(ChatColor.BOLD).append(i).append(ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i));
            }
            return QuestsNumericPrompt.sendClickableSelection(text.toString(), context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (input.equalsIgnoreCase("1") || input.equalsIgnoreCase(BukkitLang.get("yesWord"))) {
                if (ConditionMainPrompt.this.plugin.hasLimitedAccess(context.getForWhom()) && !ConditionMainPrompt.this.plugin.getConfigSettings().canTrialSave()) {
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("modeDeny").replace("<mode>", BukkitLang.get("trialMode")));
                    return new ConditionMainPrompt(context);
                }
                ConditionMainPrompt.this.plugin.getConditionFactory().saveCondition(context);
                return Prompt.END_OF_CONVERSATION;
            }
            if (input.equalsIgnoreCase("2") || input.equalsIgnoreCase(BukkitLang.get("noWord"))) {
                return new ConditionMainPrompt(context);
            }
            return new ConditionSavePrompt(context, this.modName);
        }
    }

    public class ConditionExitPrompt
    extends ConditionsEditorStringPrompt {
        private final int size = 2;

        public ConditionExitPrompt(ConversationContext context) {
            super(context);
            this.size = 2;
        }

        public int getSize() {
            return 2;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        public ChatColor getNumberColor(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.GREEN;
                }
                case 2: {
                    return ChatColor.RED;
                }
            }
            return null;
        }

        public String getSelectionText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.GREEN + BukkitLang.get("yesWord");
                }
                case 2: {
                    return ChatColor.RED + BukkitLang.get("noWord");
                }
            }
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("confirmDelete");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            ConditionsEditorPostOpenStringPromptEvent event = new ConditionsEditorPostOpenStringPromptEvent(context, this);
            ConditionMainPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(ChatColor.YELLOW + this.getQueryText(context));
            for (int i = 1; i <= 2; ++i) {
                text.append("\n").append(this.getNumberColor(context, i)).append(ChatColor.BOLD).append(i).append(ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i));
            }
            return QuestsNumericPrompt.sendClickableSelection(text.toString(), context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (input.equalsIgnoreCase("1") || input.equalsIgnoreCase(BukkitLang.get("yesWord"))) {
                context.getForWhom().sendRawMessage(ChatColor.BOLD + "" + ChatColor.YELLOW + BukkitLang.get("exited"));
                ConditionMainPrompt.this.plugin.getConditionFactory().clearData(context);
                return Prompt.END_OF_CONVERSATION;
            }
            if (input.equalsIgnoreCase("2") || input.equalsIgnoreCase(BukkitLang.get("noWord"))) {
                return new ConditionMainPrompt(context);
            }
            return new ConditionExitPrompt(context);
        }
    }

    public class ConditionPlaceholderValuePrompt
    extends ConditionsEditorStringPrompt {
        public ConditionPlaceholderValuePrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("conditionEditorEnterPlaceholderVal");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            ConditionsEditorPostOpenStringPromptEvent event = new ConditionsEditorPostOpenStringPromptEvent(context, this);
            ConditionMainPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                String[] args = input.split(" ");
                LinkedList<String> values = new LinkedList<String>(Arrays.asList(args));
                context.setSessionData((Object)"conPlaceholderVal", values);
            }
            return new ConditionPlaceholderListPrompt(context);
        }
    }

    public class ConditionPlaceholderIdentifierPrompt
    extends ConditionsEditorStringPrompt {
        public ConditionPlaceholderIdentifierPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("conditionEditorEnterPlaceholderId");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            ConditionsEditorPostOpenStringPromptEvent event = new ConditionsEditorPostOpenStringPromptEvent(context, this);
            ConditionMainPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                String[] args = input.split(" ");
                LinkedList<String> identifiers = new LinkedList<String>();
                for (String arg : args) {
                    if (!arg.trim().startsWith("%")) {
                        arg = "%" + arg.trim();
                    }
                    if (!arg.endsWith("%")) {
                        arg = arg + "%";
                    }
                    identifiers.add(arg);
                }
                context.setSessionData((Object)"conPlaceholderId", identifiers);
            }
            return new ConditionPlaceholderListPrompt(context);
        }
    }
}

