/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.convo.conditions.menu;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.conditions.Condition;
import me.pikamug.quests.convo.QuestsNumericPrompt;
import me.pikamug.quests.convo.conditions.ConditionsEditorNumericPrompt;
import me.pikamug.quests.convo.conditions.ConditionsEditorStringPrompt;
import me.pikamug.quests.convo.conditions.main.ConditionMainPrompt;
import me.pikamug.quests.events.editor.conditions.ConditionsEditorPostOpenNumericPromptEvent;
import me.pikamug.quests.events.editor.conditions.ConditionsEditorPostOpenStringPromptEvent;
import me.pikamug.quests.quests.Quest;
import me.pikamug.quests.quests.components.Stage;
import me.pikamug.quests.util.BukkitLang;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.Prompt;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

public class ConditionMenuPrompt
extends ConditionsEditorNumericPrompt {
    private final BukkitQuestsPlugin plugin;
    private final int size = 4;

    public ConditionMenuPrompt(ConversationContext context) {
        super(context);
        this.plugin = (BukkitQuestsPlugin)context.getPlugin();
    }

    @Override
    public int getSize() {
        return 4;
    }

    @Override
    public String getTitle(ConversationContext context) {
        String title = BukkitLang.get("conditionEditorTitle");
        return title + (this.plugin.hasLimitedAccess(context.getForWhom()) ? ChatColor.RED + " (" + BukkitLang.get("trialMode") + ")" : "");
    }

    @Override
    public ChatColor getNumberColor(ConversationContext context, int number) {
        switch (number) {
            case 1: 
            case 2: 
            case 3: {
                return ChatColor.BLUE;
            }
            case 4: {
                return ChatColor.RED;
            }
        }
        return null;
    }

    @Override
    public String getSelectionText(ConversationContext context, int number) {
        switch (number) {
            case 1: {
                return ChatColor.YELLOW + BukkitLang.get("conditionEditorCreate");
            }
            case 2: {
                return ChatColor.YELLOW + BukkitLang.get("conditionEditorEdit");
            }
            case 3: {
                return ChatColor.YELLOW + BukkitLang.get("conditionEditorDelete");
            }
            case 4: {
                return ChatColor.RED + BukkitLang.get("exit");
            }
        }
        return null;
    }

    @Override
    public String getAdditionalText(ConversationContext context, int number) {
        return null;
    }

    @Override
    @NotNull
    public String getBasicPromptText(@NotNull ConversationContext context) {
        ConditionsEditorPostOpenNumericPromptEvent event = new ConditionsEditorPostOpenNumericPromptEvent(context, this);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        StringBuilder text = new StringBuilder(ChatColor.GOLD + this.getTitle(context));
        for (int i = 1; i <= 4; ++i) {
            text.append("\n").append(this.getNumberColor(context, i)).append(ChatColor.BOLD).append(i).append(ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i));
        }
        return text.toString();
    }

    protected Prompt acceptValidatedInput(ConversationContext context, Number input) {
        CommandSender cs = (CommandSender)context.getForWhom();
        switch (input.intValue()) {
            case 1: {
                if (cs.hasPermission("quests.conditions.create")) {
                    context.setSessionData((Object)"oldCondition", (Object)"");
                    return new ConditionSelectCreatePrompt(context);
                }
                cs.sendMessage(ChatColor.RED + BukkitLang.get("noPermission"));
                return new ConditionMenuPrompt(context);
            }
            case 2: {
                if (cs.hasPermission("quests.conditions.edit")) {
                    if (this.plugin.getLoadedConditions().isEmpty()) {
                        context.getForWhom().sendRawMessage(ChatColor.YELLOW + BukkitLang.get("conditionEditorNoneToEdit"));
                        return new ConditionMenuPrompt(context);
                    }
                    return new ConditionSelectEditPrompt(context);
                }
                cs.sendMessage(ChatColor.RED + BukkitLang.get("noPermission"));
                return new ConditionMenuPrompt(context);
            }
            case 3: {
                if (cs.hasPermission("quests.conditions.delete")) {
                    if (this.plugin.getLoadedConditions().isEmpty()) {
                        context.getForWhom().sendRawMessage(ChatColor.YELLOW + BukkitLang.get("conditionEditorNoneToDelete"));
                        return new ConditionMenuPrompt(context);
                    }
                    return new ConditionSelectDeletePrompt(context);
                }
                cs.sendMessage(ChatColor.RED + BukkitLang.get("noPermission"));
                return new ConditionMenuPrompt(context);
            }
            case 4: {
                context.getForWhom().sendRawMessage(ChatColor.YELLOW + BukkitLang.get("exited"));
                return Prompt.END_OF_CONVERSATION;
            }
        }
        return new ConditionMenuPrompt(context);
    }

    public class ConditionSelectCreatePrompt
    extends ConditionsEditorStringPrompt {
        public ConditionSelectCreatePrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("conditionCreateTitle");
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("conditionEditorEnterName");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            ConditionsEditorPostOpenStringPromptEvent event = new ConditionsEditorPostOpenStringPromptEvent(context, this);
            ConditionMenuPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.GOLD + this.getTitle(context) + "\n" + ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("itemCreateInvalidInput"));
                return new ConditionSelectCreatePrompt(context);
            }
            if (!(input = input.trim()).equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                for (Condition c : ConditionMenuPrompt.this.plugin.getLoadedConditions()) {
                    if (!c.getName().equalsIgnoreCase(input)) continue;
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("conditionEditorExists"));
                    return new ConditionSelectCreatePrompt(context);
                }
                List<String> actionNames = ConditionMenuPrompt.this.plugin.getConditionFactory().getNamesOfConditionsBeingEdited();
                if (actionNames.contains(input)) {
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("questEditorBeingEdited"));
                    return new ConditionSelectCreatePrompt(context);
                }
                if (input.contains(".") || input.contains(",")) {
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("questEditorInvalidQuestName"));
                    return new ConditionSelectCreatePrompt(context);
                }
                if (input.isEmpty()) {
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("itemCreateInvalidInput"));
                    return new ConditionSelectCreatePrompt(context);
                }
                context.setSessionData((Object)"conName", (Object)input);
                actionNames.add(input);
                ConditionMenuPrompt.this.plugin.getConditionFactory().setNamesOfConditionsBeingEdited(actionNames);
                return new ConditionMainPrompt(context);
            }
            return new ConditionMenuPrompt(context);
        }
    }

    public class ConditionSelectEditPrompt
    extends ConditionsEditorStringPrompt {
        public ConditionSelectEditPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("conditionEditTitle");
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("conditionEditorEnterName");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            ConditionsEditorPostOpenStringPromptEvent event = new ConditionsEditorPostOpenStringPromptEvent(context, this);
            ConditionMenuPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            List<String> names = ConditionMenuPrompt.this.plugin.getLoadedConditions().stream().map(Condition::getName).collect(Collectors.toList());
            return this.sendClickableMenu(this.getTitle(context), names, this.getQueryText(context), context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                Condition c = ConditionMenuPrompt.this.plugin.getCondition(input);
                if (c != null) {
                    context.setSessionData((Object)"oldCondition", (Object)c.getName());
                    context.setSessionData((Object)"conName", (Object)c.getName());
                    ConditionMenuPrompt.this.plugin.getConditionFactory().loadData(context, c);
                    return new ConditionMainPrompt(context);
                }
                context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("conditionEditorNotFound").replace("<input>", input));
                return new ConditionSelectEditPrompt(context);
            }
            return new ConditionMenuPrompt(context);
        }
    }

    public class ConditionSelectDeletePrompt
    extends ConditionsEditorStringPrompt {
        public ConditionSelectDeletePrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("conditionDeleteTitle");
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("conditionEditorEnterName");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            ConditionsEditorPostOpenStringPromptEvent event = new ConditionsEditorPostOpenStringPromptEvent(context, this);
            ConditionMenuPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            List<String> names = ConditionMenuPrompt.this.plugin.getLoadedConditions().stream().map(Condition::getName).collect(Collectors.toList());
            return this.sendClickableMenu(this.getTitle(context), names, this.getQueryText(context), context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                LinkedList<String> used = new LinkedList<String>();
                Condition c = ConditionMenuPrompt.this.plugin.getCondition(input);
                if (c != null) {
                    block0: for (Quest quest : ConditionMenuPrompt.this.plugin.getLoadedQuests()) {
                        for (Stage stage : quest.getStages()) {
                            if (stage.getCondition() == null || !stage.getCondition().getName().equalsIgnoreCase(c.getName())) continue;
                            used.add(quest.getName());
                            continue block0;
                        }
                    }
                    if (used.isEmpty()) {
                        context.setSessionData((Object)"delCondition", (Object)c.getName());
                        return new ConditionConfirmDeletePrompt(context);
                    }
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("conditionEditorInUse") + " \"" + ChatColor.DARK_PURPLE + c.getName() + ChatColor.RED + "\":");
                    for (String s : used) {
                        context.getForWhom().sendRawMessage(ChatColor.RED + "- " + ChatColor.DARK_RED + s);
                    }
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("eventEditorMustModifyQuests"));
                    return new ConditionSelectDeletePrompt(context);
                }
                context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("conditionEditorNotFound").replace("<input>", input));
                return new ConditionSelectDeletePrompt(context);
            }
            return new ConditionMenuPrompt(context);
        }
    }

    public class ConditionConfirmDeletePrompt
    extends ConditionsEditorStringPrompt {
        private final int size = 2;

        public ConditionConfirmDeletePrompt(ConversationContext context) {
            super(context);
            this.size = 2;
        }

        public int getSize() {
            return 2;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        public ChatColor getNumberColor(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.GREEN;
                }
                case 2: {
                    return ChatColor.RED;
                }
            }
            return null;
        }

        public String getSelectionText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.GREEN + BukkitLang.get("yesWord");
                }
                case 2: {
                    return ChatColor.RED + BukkitLang.get("noWord");
                }
            }
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("confirmDelete");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            ConditionsEditorPostOpenStringPromptEvent event = new ConditionsEditorPostOpenStringPromptEvent(context, this);
            ConditionMenuPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(ChatColor.RED + this.getQueryText(context) + " (" + ChatColor.YELLOW + context.getSessionData((Object)"delCondition") + ChatColor.RED + ")\n");
            for (int i = 1; i <= 2; ++i) {
                text.append("\n").append(this.getNumberColor(context, i)).append(ChatColor.BOLD).append(i).append(ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i));
            }
            return QuestsNumericPrompt.sendClickableSelection(text.toString(), context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (input.equalsIgnoreCase("1") || input.equalsIgnoreCase(BukkitLang.get("yesWord"))) {
                ConditionMenuPrompt.this.plugin.getConditionFactory().deleteCondition(context);
                return Prompt.END_OF_CONVERSATION;
            }
            if (input.equalsIgnoreCase("2") || input.equalsIgnoreCase(BukkitLang.get("noWord"))) {
                return new ConditionMenuPrompt(context);
            }
            return new ConditionConfirmDeletePrompt(context);
        }
    }
}

