/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.convo.conditions.tasks;

import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListSet;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.convo.conditions.ConditionsEditorNumericPrompt;
import me.pikamug.quests.convo.conditions.ConditionsEditorStringPrompt;
import me.pikamug.quests.convo.conditions.main.ConditionMainPrompt;
import me.pikamug.quests.events.editor.conditions.ConditionsEditorPostOpenNumericPromptEvent;
import me.pikamug.quests.events.editor.conditions.ConditionsEditorPostOpenStringPromptEvent;
import me.pikamug.quests.util.BukkitLang;
import me.pikamug.quests.util.BukkitMiscUtil;
import org.bukkit.ChatColor;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.Prompt;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

public class ConditionEntityPrompt
extends ConditionsEditorNumericPrompt {
    private final BukkitQuestsPlugin plugin;
    private final int size = 3;

    public ConditionEntityPrompt(ConversationContext context) {
        super(context);
        this.plugin = (BukkitQuestsPlugin)context.getPlugin();
    }

    @Override
    public int getSize() {
        return 3;
    }

    @Override
    public String getTitle(ConversationContext context) {
        return BukkitLang.get("conditionEditorEntity");
    }

    @Override
    public ChatColor getNumberColor(ConversationContext context, int number) {
        switch (number) {
            case 1: 
            case 2: {
                return ChatColor.BLUE;
            }
            case 3: {
                return ChatColor.GREEN;
            }
        }
        return null;
    }

    @Override
    public String getSelectionText(ConversationContext context, int number) {
        switch (number) {
            case 1: {
                return ChatColor.YELLOW + BukkitLang.get("conditionEditorRideEntity");
            }
            case 2: {
                return ChatColor.YELLOW + BukkitLang.get("conditionEditorRideNPC");
            }
            case 3: {
                return ChatColor.GREEN + BukkitLang.get("done");
            }
        }
        return null;
    }

    @Override
    public String getAdditionalText(ConversationContext context, int number) {
        switch (number) {
            case 1: {
                if (context.getSessionData((Object)"conRidingEntity") == null) {
                    return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                StringBuilder text = new StringBuilder();
                List whileRidingEntity = (List)context.getSessionData((Object)"conRidingEntity");
                if (whileRidingEntity != null) {
                    for (String s : whileRidingEntity) {
                        text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.BLUE).append(BukkitMiscUtil.getProperMobType(s));
                    }
                }
                return text.toString();
            }
            case 2: {
                if (this.plugin.getDependencies().hasAnyNpcDependencies()) {
                    if (context.getSessionData((Object)"conRidingNpc") == null) {
                        return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    StringBuilder text = new StringBuilder();
                    List whileRidingNpc = (List)context.getSessionData((Object)"conRidingNpc");
                    if (whileRidingNpc != null) {
                        for (UUID u : whileRidingNpc) {
                            text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.BLUE).append(this.plugin.getDependencies().getNpcName(u));
                        }
                    }
                    return text.toString();
                }
                return ChatColor.GRAY + "(" + BukkitLang.get("notInstalled") + ")";
            }
            case 3: {
                return "";
            }
        }
        return null;
    }

    @Override
    @NotNull
    public String getBasicPromptText(@NotNull ConversationContext context) {
        ConditionsEditorPostOpenNumericPromptEvent event = new ConditionsEditorPostOpenNumericPromptEvent(context, this);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        StringBuilder text = new StringBuilder(ChatColor.AQUA + "- " + this.getTitle(context) + " -");
        for (int i = 1; i <= 3; ++i) {
            text.append("\n").append(this.getNumberColor(context, i)).append(ChatColor.BOLD).append(i).append(ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i)).append(" ").append(this.getAdditionalText(context, i));
        }
        return text.toString();
    }

    protected Prompt acceptValidatedInput(@NotNull ConversationContext context, Number input) {
        switch (input.intValue()) {
            case 1: {
                return new ConditionEntitiesPrompt(context);
            }
            case 2: {
                return new ConditionNpcsPrompt(context);
            }
            case 3: {
                try {
                    return new ConditionMainPrompt(context);
                }
                catch (Exception e) {
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("itemCreateCriticalError"));
                    return Prompt.END_OF_CONVERSATION;
                }
            }
        }
        return new ConditionEntityPrompt(context);
    }

    public class ConditionEntitiesPrompt
    extends ConditionsEditorStringPrompt {
        public ConditionEntitiesPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("conditionEditorEntitiesTitle");
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("conditionEditorEntitiesPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            ConditionsEditorPostOpenStringPromptEvent event = new ConditionsEditorPostOpenStringPromptEvent(context, this);
            ConditionEntityPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder mobs = new StringBuilder(ChatColor.LIGHT_PURPLE + this.getTitle(context) + "\n");
            LinkedList<EntityType> mobArr = new LinkedList<EntityType>(Arrays.asList(EntityType.values()));
            LinkedList<EntityType> toRemove = new LinkedList<EntityType>();
            for (EntityType type : mobArr) {
                if (type.getEntityClass() != null && Vehicle.class.isAssignableFrom(type.getEntityClass())) continue;
                toRemove.add(type);
            }
            mobArr.removeAll(toRemove);
            mobArr.sort(Comparator.comparing(Enum::name));
            for (int i = 0; i < mobArr.size(); ++i) {
                mobs.append(ChatColor.AQUA).append(BukkitMiscUtil.snakeCaseToUpperCamelCase(((EntityType)mobArr.get(i)).name()));
                if (i >= mobArr.size() - 1) continue;
                mobs.append(ChatColor.GRAY).append(", ");
            }
            mobs.append("\n").append(ChatColor.YELLOW).append(this.getQueryText(context));
            return mobs.toString();
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                LinkedList<String> mobTypes = new LinkedList<String>();
                for (String s : input.split(" ")) {
                    if (BukkitMiscUtil.getProperMobType(s) != null) {
                        EntityType type = BukkitMiscUtil.getProperMobType(s);
                        if (type == null || type.getEntityClass() == null || !Vehicle.class.isAssignableFrom(type.getEntityClass())) {
                            context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("stageEditorInvalidMob").replace("<input>", s));
                            return new ConditionEntitiesPrompt(context);
                        }
                    } else {
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("stageEditorInvalidMob").replace("<input>", s));
                        return new ConditionEntitiesPrompt(context);
                    }
                    mobTypes.add(s);
                    context.setSessionData((Object)"conRidingEntity", mobTypes);
                }
            }
            return new ConditionEntityPrompt(context);
        }
    }

    public class ConditionNpcsPrompt
    extends ConditionsEditorStringPrompt {
        public ConditionNpcsPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("conditionEditorNpcsTitle");
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("enterNpcUniqueIds");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            ConditionsEditorPostOpenStringPromptEvent event = new ConditionsEditorPostOpenStringPromptEvent(context, this);
            ConditionEntityPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            if (context.getForWhom() instanceof Player) {
                ConcurrentSkipListSet<UUID> selectingNpcs = ConditionEntityPrompt.this.plugin.getQuestFactory().getSelectingNpcs();
                selectingNpcs.add(((Player)context.getForWhom()).getUniqueId());
                ConditionEntityPrompt.this.plugin.getQuestFactory().setSelectingNpcs(selectingNpcs);
                return ChatColor.YELLOW + BukkitLang.get("questEditorClickNPCStart");
            }
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                LinkedList npcs = context.getSessionData((Object)"conRidingNpc") != null ? (LinkedList)context.getSessionData((Object)"conRidingNpc") : new LinkedList();
                for (String s : input.split(" ")) {
                    try {
                        UUID uuid = UUID.fromString(s);
                        if (npcs == null || !ConditionEntityPrompt.this.plugin.getDependencies().isNpc(uuid)) {
                            context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("stageEditorInvalidNPC").replace("<input>", s));
                            return new ConditionNpcsPrompt(context);
                        }
                        npcs.add(uuid.toString());
                    }
                    catch (IllegalArgumentException e) {
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("stageEditorNotListOfUniqueIds").replace("<data>", input));
                        return new ConditionNpcsPrompt(context);
                    }
                }
                context.setSessionData((Object)"conRidingNpc", (Object)npcs);
            }
            if (context.getForWhom() instanceof Player) {
                ConcurrentSkipListSet<UUID> selectingNpcs = ConditionEntityPrompt.this.plugin.getQuestFactory().getSelectingNpcs();
                selectingNpcs.remove(((Player)context.getForWhom()).getUniqueId());
                ConditionEntityPrompt.this.plugin.getQuestFactory().setSelectingNpcs(selectingNpcs);
            }
            return new ConditionEntityPrompt(context);
        }
    }
}

