/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.convo.conditions.tasks;

import java.util.LinkedList;
import java.util.List;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.convo.conditions.ConditionsEditorNumericPrompt;
import me.pikamug.quests.convo.conditions.ConditionsEditorStringPrompt;
import me.pikamug.quests.convo.conditions.main.ConditionMainPrompt;
import me.pikamug.quests.convo.generic.ItemStackPrompt;
import me.pikamug.quests.events.editor.conditions.ConditionsEditorPostOpenNumericPromptEvent;
import me.pikamug.quests.events.editor.conditions.ConditionsEditorPostOpenStringPromptEvent;
import me.pikamug.quests.util.BukkitItemUtil;
import me.pikamug.quests.util.BukkitLang;
import org.bukkit.ChatColor;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.Prompt;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ConditionPlayerPrompt
extends ConditionsEditorNumericPrompt {
    private final BukkitQuestsPlugin plugin;
    private final int size = 4;

    public ConditionPlayerPrompt(ConversationContext context) {
        super(context);
        this.plugin = (BukkitQuestsPlugin)context.getPlugin();
    }

    @Override
    public int getSize() {
        return 4;
    }

    @Override
    public String getTitle(ConversationContext context) {
        return BukkitLang.get("eventEditorPlayer");
    }

    @Override
    public ChatColor getNumberColor(ConversationContext context, int number) {
        switch (number) {
            case 1: 
            case 2: 
            case 3: {
                return ChatColor.BLUE;
            }
            case 4: {
                return ChatColor.GREEN;
            }
        }
        return null;
    }

    @Override
    public String getSelectionText(ConversationContext context, int number) {
        switch (number) {
            case 1: {
                return ChatColor.YELLOW + BukkitLang.get("conditionEditorPermissions");
            }
            case 2: {
                return ChatColor.YELLOW + BukkitLang.get("conditionEditorItemsInMainHand");
            }
            case 3: {
                return ChatColor.YELLOW + BukkitLang.get("conditionEditorItemsWear");
            }
            case 4: {
                return ChatColor.GREEN + BukkitLang.get("done");
            }
        }
        return null;
    }

    @Override
    public String getAdditionalText(ConversationContext context, int number) {
        switch (number) {
            case 1: {
                if (context.getSessionData((Object)"conPermission") == null) {
                    return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                StringBuilder text = new StringBuilder();
                List whilePermission = (List)context.getSessionData((Object)"conPermission");
                if (whilePermission != null) {
                    for (String s : whilePermission) {
                        text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.BLUE).append(s.replace(".", "\uff0e"));
                    }
                }
                return text.toString();
            }
            case 2: {
                if (context.getSessionData((Object)"conHoldingMainHand") == null) {
                    return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                StringBuilder text = new StringBuilder();
                LinkedList whileHoldingMainHand = (LinkedList)context.getSessionData((Object)"conHoldingMainHand");
                if (whileHoldingMainHand != null) {
                    for (ItemStack item : whileHoldingMainHand) {
                        text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.BLUE).append(BukkitItemUtil.getName(item)).append(ChatColor.GRAY).append(" x ").append(ChatColor.AQUA).append(item.getAmount());
                    }
                }
                return text.toString();
            }
            case 3: {
                if (context.getSessionData((Object)"conWearing") == null) {
                    return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                StringBuilder text = new StringBuilder();
                LinkedList whileWearing = (LinkedList)context.getSessionData((Object)"conWearing");
                if (whileWearing != null) {
                    for (ItemStack item : whileWearing) {
                        text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.BLUE).append(BukkitItemUtil.getName(item)).append(ChatColor.GRAY).append(" x ").append(ChatColor.AQUA).append(item.getAmount());
                    }
                }
                return text.toString();
            }
            case 4: {
                return "";
            }
        }
        return null;
    }

    @Override
    @NotNull
    public String getBasicPromptText(ConversationContext context) {
        if (context.getSessionData((Object)"tempStack") != null) {
            List items;
            if (context.getSessionData((Object)"conHoldingMainHand") != null && (items = (List)context.getSessionData((Object)"conHoldingMainHand")) != null) {
                items.add((ItemStack)context.getSessionData((Object)"tempStack"));
                context.setSessionData((Object)"conHoldingMainHand", (Object)items);
            }
            ItemStackPrompt.clearSessionData(context);
        }
        ConditionsEditorPostOpenNumericPromptEvent event = new ConditionsEditorPostOpenNumericPromptEvent(context, this);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        StringBuilder text = new StringBuilder(ChatColor.AQUA + "- " + this.getTitle(context) + " -");
        for (int i = 1; i <= 4; ++i) {
            text.append("\n").append(this.getNumberColor(context, i)).append(ChatColor.BOLD).append(i).append(ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i)).append(" ").append(this.getAdditionalText(context, i));
        }
        return text.toString();
    }

    protected Prompt acceptValidatedInput(@NotNull ConversationContext context, Number input) {
        switch (input.intValue()) {
            case 1: {
                return new ConditionPermissionsPrompt(context);
            }
            case 2: {
                return new ConditionItemsInMainHandListPrompt(context);
            }
            case 3: {
                return new ConditionItemsWearListPrompt(context);
            }
            case 4: {
                try {
                    return new ConditionMainPrompt(context);
                }
                catch (Exception e) {
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("itemCreateCriticalError"));
                    return Prompt.END_OF_CONVERSATION;
                }
            }
        }
        return new ConditionPlayerPrompt(context);
    }

    public class ConditionPermissionsPrompt
    extends ConditionsEditorStringPrompt {
        public ConditionPermissionsPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("conditionEditorPermissionsPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            ConditionsEditorPostOpenStringPromptEvent event = new ConditionsEditorPostOpenStringPromptEvent(context, this);
            ConditionPlayerPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                LinkedList<String> permissions = new LinkedList<String>();
                for (String s : input.split(" ")) {
                    permissions.add(s.trim());
                }
                context.setSessionData((Object)"conPermission", permissions);
            }
            return new ConditionPlayerPrompt(context);
        }
    }

    public class ConditionItemsInMainHandListPrompt
    extends ConditionsEditorNumericPrompt {
        private final int size = 3;

        public ConditionItemsInMainHandListPrompt(ConversationContext context) {
            super(context);
            this.size = 3;
        }

        @Override
        public int getSize() {
            return 3;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("conditionEditorItemsInMainHand");
        }

        @Override
        public ChatColor getNumberColor(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.BLUE;
                }
                case 2: {
                    return ChatColor.RED;
                }
                case 3: {
                    return ChatColor.GREEN;
                }
            }
            return null;
        }

        @Override
        public String getSelectionText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.YELLOW + BukkitLang.get("stageEditorDeliveryAddItem");
                }
                case 2: {
                    return ChatColor.RED + BukkitLang.get("clear");
                }
                case 3: {
                    return ChatColor.GREEN + BukkitLang.get("done");
                }
            }
            return null;
        }

        @Override
        public String getAdditionalText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    if (context.getSessionData((Object)"conHoldingMainHand") == null) {
                        return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    StringBuilder text = new StringBuilder();
                    List whileHoldingMainHand = (List)context.getSessionData((Object)"conHoldingMainHand");
                    if (whileHoldingMainHand != null) {
                        for (ItemStack is : whileHoldingMainHand) {
                            text.append("\n").append(ChatColor.GRAY).append("     - ").append(BukkitItemUtil.getDisplayString(is));
                        }
                    }
                    return text.toString();
                }
                case 2: 
                case 3: {
                    return "";
                }
            }
            return null;
        }

        @Override
        public String getBasicPromptText(ConversationContext context) {
            if (context.getSessionData((Object)"tempStack") != null) {
                List<ItemStack> items;
                if (context.getSessionData((Object)"conHoldingMainHand") != null) {
                    items = (List)context.getSessionData((Object)"conHoldingMainHand");
                    if (items != null) {
                        items.add((ItemStack)context.getSessionData((Object)"tempStack"));
                        context.setSessionData((Object)"conHoldingMainHand", items);
                    }
                } else {
                    items = new LinkedList();
                    ((LinkedList)items).add((ItemStack)context.getSessionData((Object)"tempStack"));
                    context.setSessionData((Object)"conHoldingMainHand", items);
                }
                ItemStackPrompt.clearSessionData(context);
            }
            ConditionsEditorPostOpenNumericPromptEvent event = new ConditionsEditorPostOpenNumericPromptEvent(context, this);
            ConditionPlayerPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(ChatColor.GOLD + "- " + this.getTitle(context) + " -");
            for (int i = 1; i <= 3; ++i) {
                text.append("\n").append(this.getNumberColor(context, i)).append(ChatColor.BOLD).append(i).append(ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i)).append(" ").append(this.getAdditionalText(context, i));
            }
            return text.toString();
        }

        protected Prompt acceptValidatedInput(@NotNull ConversationContext context, Number input) {
            switch (input.intValue()) {
                case 1: {
                    return new ItemStackPrompt(context, (Prompt)this);
                }
                case 2: {
                    context.getForWhom().sendRawMessage(ChatColor.YELLOW + BukkitLang.get("conditionEditorConditionCleared"));
                    context.setSessionData((Object)"conHoldingMainHand", null);
                    return new ConditionItemsInMainHandListPrompt(context);
                }
                case 3: {
                    return new ConditionPlayerPrompt(context);
                }
            }
            return new ConditionItemsInMainHandListPrompt(context);
        }
    }

    public class ConditionItemsWearListPrompt
    extends ConditionsEditorNumericPrompt {
        private final int size = 3;

        public ConditionItemsWearListPrompt(ConversationContext context) {
            super(context);
            this.size = 3;
        }

        @Override
        public int getSize() {
            return 3;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("conditionEditorItemsWear");
        }

        @Override
        public ChatColor getNumberColor(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.BLUE;
                }
                case 2: {
                    return ChatColor.RED;
                }
                case 3: {
                    return ChatColor.GREEN;
                }
            }
            return null;
        }

        @Override
        public String getSelectionText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.YELLOW + BukkitLang.get("stageEditorDeliveryAddItem");
                }
                case 2: {
                    return ChatColor.RED + BukkitLang.get("clear");
                }
                case 3: {
                    return ChatColor.GREEN + BukkitLang.get("done");
                }
            }
            return null;
        }

        @Override
        public String getAdditionalText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    if (context.getSessionData((Object)"conWearing") == null) {
                        return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    StringBuilder text = new StringBuilder();
                    List whileWearing = (List)context.getSessionData((Object)"conWearing");
                    if (whileWearing != null) {
                        for (ItemStack is : whileWearing) {
                            text.append("\n").append(ChatColor.GRAY).append("     - ").append(BukkitItemUtil.getDisplayString(is));
                        }
                    }
                    return text.toString();
                }
                case 2: 
                case 3: {
                    return "";
                }
            }
            return null;
        }

        @Override
        public String getBasicPromptText(ConversationContext context) {
            if (context.getSessionData((Object)"tempStack") != null) {
                List<ItemStack> items;
                if (context.getSessionData((Object)"conWearing") != null) {
                    items = (List)context.getSessionData((Object)"conWearing");
                    if (items != null) {
                        items.add((ItemStack)context.getSessionData((Object)"tempStack"));
                        context.setSessionData((Object)"conWearing", items);
                    }
                } else {
                    items = new LinkedList();
                    ((LinkedList)items).add((ItemStack)context.getSessionData((Object)"tempStack"));
                    context.setSessionData((Object)"conWearing", items);
                }
                ItemStackPrompt.clearSessionData(context);
            }
            ConditionsEditorPostOpenNumericPromptEvent event = new ConditionsEditorPostOpenNumericPromptEvent(context, this);
            ConditionPlayerPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(ChatColor.GOLD + "- " + this.getTitle(context) + " -");
            for (int i = 1; i <= 3; ++i) {
                text.append("\n").append(this.getNumberColor(context, i)).append(ChatColor.BOLD).append(i).append(ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i)).append(" ").append(this.getAdditionalText(context, i));
            }
            return text.toString();
        }

        protected Prompt acceptValidatedInput(@NotNull ConversationContext context, Number input) {
            switch (input.intValue()) {
                case 1: {
                    return new ItemStackPrompt(context, (Prompt)this);
                }
                case 2: {
                    context.getForWhom().sendRawMessage(ChatColor.YELLOW + BukkitLang.get("conditionEditorConditionCleared"));
                    context.setSessionData((Object)"conWearing", null);
                    return new ConditionItemsWearListPrompt(context);
                }
                case 3: {
                    return new ConditionPlayerPrompt(context);
                }
            }
            return new ConditionItemsWearListPrompt(context);
        }
    }
}

