/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.convo.conditions.tasks;

import com.sk89q.worldguard.protection.managers.RegionManager;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.convo.conditions.ConditionsEditorNumericPrompt;
import me.pikamug.quests.convo.conditions.ConditionsEditorStringPrompt;
import me.pikamug.quests.convo.conditions.main.ConditionMainPrompt;
import me.pikamug.quests.dependencies.reflect.worldguard.WorldGuardAPI;
import me.pikamug.quests.events.editor.conditions.ConditionsEditorPostOpenNumericPromptEvent;
import me.pikamug.quests.events.editor.conditions.ConditionsEditorPostOpenStringPromptEvent;
import me.pikamug.quests.util.BukkitLang;
import me.pikamug.quests.util.BukkitMiscUtil;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.Prompt;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

public class ConditionWorldPrompt
extends ConditionsEditorNumericPrompt {
    private final BukkitQuestsPlugin plugin;
    private final int size = 5;

    public ConditionWorldPrompt(ConversationContext context) {
        super(context);
        this.plugin = (BukkitQuestsPlugin)context.getPlugin();
    }

    @Override
    public int getSize() {
        return 5;
    }

    @Override
    public String getTitle(ConversationContext context) {
        return BukkitLang.get("conditionEditorWorld");
    }

    @Override
    public ChatColor getNumberColor(ConversationContext context, int number) {
        switch (number) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return ChatColor.BLUE;
            }
            case 5: {
                return ChatColor.GREEN;
            }
        }
        return null;
    }

    @Override
    public String getSelectionText(ConversationContext context, int number) {
        switch (number) {
            case 1: {
                return ChatColor.YELLOW + BukkitLang.get("conditionEditorStayWithinWorld");
            }
            case 2: {
                return ChatColor.YELLOW + BukkitLang.get("conditionEditorStayWithinTicks");
            }
            case 3: {
                return ChatColor.YELLOW + BukkitLang.get("conditionEditorStayWithinBiome");
            }
            case 4: {
                if (this.plugin.getDependencies().getWorldGuardApi() != null) {
                    return ChatColor.YELLOW + BukkitLang.get("conditionEditorStayWithinRegion");
                }
                return ChatColor.GRAY + BukkitLang.get("conditionEditorStayWithinRegion");
            }
            case 5: {
                return ChatColor.GREEN + BukkitLang.get("done");
            }
        }
        return null;
    }

    @Override
    public String getAdditionalText(ConversationContext context, int number) {
        switch (number) {
            case 1: {
                if (context.getSessionData((Object)"conWithinWorld") == null) {
                    return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                StringBuilder text = new StringBuilder();
                List whileWithinWorld = (List)context.getSessionData((Object)"conWithinWorld");
                if (whileWithinWorld != null) {
                    for (String s : whileWithinWorld) {
                        text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.BLUE).append(s);
                    }
                }
                return text.toString();
            }
            case 2: {
                if (context.getSessionData((Object)"conWithinTicksStart") == null || context.getSessionData((Object)"conWithinTicksEnd") == null) {
                    return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                return ChatColor.GRAY + "(" + ChatColor.AQUA + context.getSessionData((Object)"conWithinTicksStart") + " - " + context.getSessionData((Object)"conWithinTicksEnd") + ChatColor.GRAY + ")";
            }
            case 3: {
                if (context.getSessionData((Object)"conWithinBiome") == null) {
                    return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                StringBuilder text = new StringBuilder();
                List whileWithinBiome = (List)context.getSessionData((Object)"conWithinBiome");
                if (whileWithinBiome != null) {
                    for (String s : whileWithinBiome) {
                        text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.BLUE).append(s);
                    }
                }
                return text.toString();
            }
            case 4: {
                if (this.plugin.getDependencies().getWorldGuardApi() != null) {
                    if (context.getSessionData((Object)"conWithinRegion") == null) {
                        return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    StringBuilder text = new StringBuilder();
                    List whileWithinRegion = (List)context.getSessionData((Object)"conWithinRegion");
                    if (whileWithinRegion != null) {
                        for (String s : whileWithinRegion) {
                            text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.BLUE).append(s);
                        }
                    }
                    return text.toString();
                }
                return ChatColor.GRAY + "(" + BukkitLang.get("notInstalled") + ")";
            }
            case 5: {
                return "";
            }
        }
        return null;
    }

    @Override
    @NotNull
    public String getBasicPromptText(@NotNull ConversationContext context) {
        ConditionsEditorPostOpenNumericPromptEvent event = new ConditionsEditorPostOpenNumericPromptEvent(context, this);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        StringBuilder text = new StringBuilder(ChatColor.AQUA + "- " + this.getTitle(context) + " -");
        for (int i = 1; i <= 5; ++i) {
            text.append("\n").append(this.getNumberColor(context, i)).append(ChatColor.BOLD).append(i).append(ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i)).append(" ").append(this.getAdditionalText(context, i));
        }
        return text.toString();
    }

    protected Prompt acceptValidatedInput(@NotNull ConversationContext context, Number input) {
        switch (input.intValue()) {
            case 1: {
                return new ConditionWorldsPrompt(context);
            }
            case 2: {
                return new ConditionTicksListPrompt(context);
            }
            case 3: {
                return new ConditionBiomesPrompt(context);
            }
            case 4: {
                if (this.plugin.getDependencies().getWorldGuardApi() != null) {
                    return new ConditionRegionsPrompt(context);
                }
                return new ConditionWorldPrompt(context);
            }
            case 5: {
                try {
                    return new ConditionMainPrompt(context);
                }
                catch (Exception e) {
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("itemCreateCriticalError"));
                    return Prompt.END_OF_CONVERSATION;
                }
            }
        }
        return new ConditionWorldPrompt(context);
    }

    public class ConditionWorldsPrompt
    extends ConditionsEditorStringPrompt {
        public ConditionWorldsPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("conditionEditorWorldsTitle");
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("conditionEditorWorldsPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            ConditionsEditorPostOpenStringPromptEvent event = new ConditionsEditorPostOpenStringPromptEvent(context, this);
            ConditionWorldPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder worlds = new StringBuilder(ChatColor.LIGHT_PURPLE + this.getTitle(context) + "\n");
            List worldArr = Bukkit.getWorlds();
            for (int i = 0; i < worldArr.size(); ++i) {
                worlds.append(ChatColor.AQUA).append(((World)worldArr.get(i)).getName());
                if (i >= worldArr.size() - 1) continue;
                worlds.append(ChatColor.GRAY).append(", ");
            }
            worlds.append("\n").append(ChatColor.YELLOW).append(this.getQueryText(context));
            return worlds.toString();
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                LinkedList<String> worlds = new LinkedList<String>();
                for (String s : input.split(" ")) {
                    if (Bukkit.getWorld((String)s) == null) {
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("conditionEditorInvalidWorld").replace("<input>", s));
                        return new ConditionWorldsPrompt(context);
                    }
                    worlds.add(s);
                }
                context.setSessionData((Object)"conWithinWorld", worlds);
            }
            return new ConditionWorldPrompt(context);
        }
    }

    public class ConditionTicksListPrompt
    extends ConditionsEditorNumericPrompt {
        private final int size = 4;

        public ConditionTicksListPrompt(ConversationContext context) {
            super(context);
            this.size = 4;
        }

        @Override
        public int getSize() {
            return 4;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("conditionEditorTicksTitle");
        }

        @Override
        public ChatColor getNumberColor(ConversationContext context, int number) {
            switch (number) {
                case 1: 
                case 2: {
                    return ChatColor.BLUE;
                }
                case 3: {
                    return ChatColor.RED;
                }
                case 4: {
                    return ChatColor.GREEN;
                }
            }
            return null;
        }

        @Override
        public String getSelectionText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.YELLOW + BukkitLang.get("conditionEditorSetStartTick");
                }
                case 2: {
                    return ChatColor.YELLOW + BukkitLang.get("conditionEditorSetEndTick");
                }
                case 3: {
                    return ChatColor.RED + BukkitLang.get("clear");
                }
                case 4: {
                    return ChatColor.GREEN + BukkitLang.get("done");
                }
            }
            return null;
        }

        @Override
        public String getAdditionalText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    if (context.getSessionData((Object)"conWithinTicksStart") == null) {
                        return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    int i = (Integer)Objects.requireNonNull(context.getSessionData((Object)"conWithinTicksStart"));
                    return ChatColor.GRAY + "(" + ChatColor.AQUA + i + ChatColor.GRAY + ")";
                }
                case 2: {
                    if (context.getSessionData((Object)"conWithinTicksEnd") == null) {
                        return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    int i = (Integer)Objects.requireNonNull(context.getSessionData((Object)"conWithinTicksEnd"));
                    return ChatColor.GRAY + "(" + ChatColor.AQUA + i + ChatColor.GRAY + ")";
                }
                case 3: 
                case 4: {
                    return "";
                }
            }
            return null;
        }

        @Override
        @NotNull
        public String getBasicPromptText(@NotNull ConversationContext context) {
            ConditionsEditorPostOpenNumericPromptEvent event = new ConditionsEditorPostOpenNumericPromptEvent(context, this);
            ConditionWorldPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(ChatColor.GOLD + this.getTitle(context));
            for (int i = 1; i <= 4; ++i) {
                text.append("\n").append(this.getNumberColor(context, i)).append(ChatColor.BOLD).append(i).append(ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i)).append(" ").append(this.getAdditionalText(context, i));
            }
            return text.toString();
        }

        protected Prompt acceptValidatedInput(@NotNull ConversationContext context, Number input) {
            switch (input.intValue()) {
                case 1: {
                    return new ConditionTickStartPrompt(context);
                }
                case 2: {
                    return new ConditionTickEndPrompt(context);
                }
                case 3: {
                    context.getForWhom().sendRawMessage(ChatColor.YELLOW + BukkitLang.get("conditionEditorConditionCleared"));
                    context.setSessionData((Object)"conWithinTicksStart", null);
                    context.setSessionData((Object)"conWithinTicksEnd", null);
                    return new ConditionWorldPrompt(context);
                }
                case 4: {
                    if (context.getSessionData((Object)"conWithinTicksStart") != null && context.getSessionData((Object)"conWithinTicksEnd") != null || context.getSessionData((Object)"conWithinTicksStart") == null && context.getSessionData((Object)"conWithinTicksEnd") == null) {
                        return new ConditionMainPrompt(context);
                    }
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("listsNotSameSize"));
                    return new ConditionTicksListPrompt(context);
                }
            }
            return new ConditionTicksListPrompt(context);
        }
    }

    public class ConditionBiomesPrompt
    extends ConditionsEditorStringPrompt {
        public ConditionBiomesPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("conditionEditorBiomesTitle");
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("conditionEditorBiomesPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            ConditionsEditorPostOpenStringPromptEvent event = new ConditionsEditorPostOpenStringPromptEvent(context, this);
            ConditionWorldPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder biomes = new StringBuilder(ChatColor.LIGHT_PURPLE + this.getTitle(context) + "\n");
            LinkedList<Biome> biomeArr = new LinkedList<Biome>(Arrays.asList(Biome.values()));
            for (int i = 0; i < biomeArr.size(); ++i) {
                biomes.append(ChatColor.AQUA).append(BukkitMiscUtil.snakeCaseToUpperCamelCase(biomeArr.get(i).name()));
                if (i >= biomeArr.size() - 1) continue;
                biomes.append(ChatColor.GRAY).append(", ");
            }
            biomes.append("\n").append(ChatColor.YELLOW).append(this.getQueryText(context));
            return biomes.toString();
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                LinkedList<String> biomes = new LinkedList<String>();
                for (String s : input.split(" ")) {
                    if (BukkitMiscUtil.getProperBiome(s) == null) {
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("conditionEditorInvalidBiome").replace("<input>", s));
                        return new ConditionBiomesPrompt(context);
                    }
                    biomes.add(s);
                }
                context.setSessionData((Object)"conWithinBiome", biomes);
            }
            return new ConditionWorldPrompt(context);
        }
    }

    public class ConditionRegionsPrompt
    extends ConditionsEditorStringPrompt {
        public ConditionRegionsPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("conditionEditorRegionsTitle");
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("conditionEditorRegionsPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            ConditionsEditorPostOpenStringPromptEvent event = new ConditionsEditorPostOpenStringPromptEvent(context, this);
            ConditionWorldPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder regions = new StringBuilder(ChatColor.LIGHT_PURPLE + this.getTitle(context) + "\n");
            boolean any = false;
            WorldGuardAPI api = ConditionWorldPrompt.this.plugin.getDependencies().getWorldGuardApi();
            if (api != null) {
                for (World world : ConditionWorldPrompt.this.plugin.getServer().getWorlds()) {
                    RegionManager regionManager = api.getRegionManager(world);
                    if (regionManager == null) continue;
                    for (String region : regionManager.getRegions().keySet()) {
                        any = true;
                        regions.append(ChatColor.GREEN).append(region).append(", ");
                    }
                }
            }
            if (any) {
                regions = new StringBuilder(regions.substring(0, regions.length() - 2) + "\n");
            } else {
                regions.append(ChatColor.GRAY).append("(").append(BukkitLang.get("none")).append(")\n");
            }
            return regions.toString() + ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                LinkedList<String> regions = new LinkedList<String>();
                for (String r : input.split(" ")) {
                    boolean found = false;
                    for (World world : ConditionWorldPrompt.this.plugin.getServer().getWorlds()) {
                        WorldGuardAPI api = ConditionWorldPrompt.this.plugin.getDependencies().getWorldGuardApi();
                        RegionManager regionManager = api.getRegionManager(world);
                        if (regionManager != null) {
                            for (String region : regionManager.getRegions().keySet()) {
                                if (!region.equalsIgnoreCase(r)) continue;
                                regions.add(region);
                                found = true;
                                break;
                            }
                        }
                        if (!found) continue;
                        break;
                    }
                    if (found) continue;
                    String error = BukkitLang.get("questWGInvalidRegion");
                    error = error.replace("<region>", ChatColor.RED + r + ChatColor.YELLOW);
                    context.getForWhom().sendRawMessage(ChatColor.YELLOW + error);
                    return new ConditionRegionsPrompt(context);
                }
                context.setSessionData((Object)"conWithinRegion", regions);
            }
            return new ConditionWorldPrompt(context);
        }
    }

    public class ConditionTickEndPrompt
    extends ConditionsEditorStringPrompt {
        public ConditionTickEndPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("conditionEditorTicksPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            ConditionsEditorPostOpenStringPromptEvent event = new ConditionsEditorPostOpenStringPromptEvent(context, this);
            ConditionWorldPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                try {
                    int i = Integer.parseInt(input);
                    if (i < 0 || i > 24000) {
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("invalidRange").replace("<least>", "0").replace("<greatest>", "24000"));
                        return new ConditionTickEndPrompt(context);
                    }
                    context.setSessionData((Object)"conWithinTicksEnd", (Object)i);
                }
                catch (NumberFormatException e) {
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("reqNotANumber").replace("<input>", input));
                    return new ConditionTickEndPrompt(context);
                }
            }
            return new ConditionTicksListPrompt(context);
        }
    }

    public class ConditionTickStartPrompt
    extends ConditionsEditorStringPrompt {
        public ConditionTickStartPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("conditionEditorTicksPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            ConditionsEditorPostOpenStringPromptEvent event = new ConditionsEditorPostOpenStringPromptEvent(context, this);
            ConditionWorldPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                try {
                    int i = Integer.parseInt(input);
                    if (i < 0 || i > 24000) {
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("invalidRange").replace("<least>", "0").replace("<greatest>", "24000"));
                        return new ConditionTickStartPrompt(context);
                    }
                    context.setSessionData((Object)"conWithinTicksStart", (Object)i);
                }
                catch (NumberFormatException e) {
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("reqNotANumber").replace("<input>", input));
                    return new ConditionTickStartPrompt(context);
                }
            }
            return new ConditionTicksListPrompt(context);
        }
    }
}

