/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.convo.generic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.convo.quests.QuestsEditorNumericPrompt;
import me.pikamug.quests.convo.quests.QuestsEditorStringPrompt;
import me.pikamug.quests.events.editor.quests.QuestsEditorPostOpenNumericPromptEvent;
import me.pikamug.quests.util.BukkitConfigUtil;
import me.pikamug.quests.util.BukkitItemUtil;
import me.pikamug.quests.util.BukkitLang;
import me.pikamug.quests.util.BukkitMiscUtil;
import me.pikamug.quests.util.RomanNumeral;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.Prompt;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class ItemStackPrompt
extends QuestsEditorNumericPrompt {
    private final Prompt oldPrompt;
    private final int size = 10;

    public ItemStackPrompt(ConversationContext context, Prompt old) {
        super(context);
        this.oldPrompt = old;
    }

    @Override
    public int getSize() {
        return 10;
    }

    @Override
    public String getTitle(ConversationContext context) {
        return BukkitLang.get("createItemTitle");
    }

    @Override
    public ChatColor getNumberColor(ConversationContext context, int number) {
        switch (number) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return ChatColor.BLUE;
            }
            case 7: {
                if (context.getSessionData((Object)"tempMeta") != null) {
                    return ChatColor.BLUE;
                }
                return ChatColor.GRAY;
            }
            case 8: {
                return ChatColor.RED;
            }
            case 9: {
                return ChatColor.GREEN;
            }
        }
        return null;
    }

    @Override
    public String getSelectionText(ConversationContext context, int number) {
        switch (number) {
            case 0: {
                return ChatColor.YELLOW + BukkitLang.get("itemCreateLoadHand");
            }
            case 1: {
                return ChatColor.YELLOW + BukkitLang.get("itemCreateSetName");
            }
            case 2: {
                return ChatColor.YELLOW + BukkitLang.get("itemCreateSetAmount");
            }
            case 3: {
                return ChatColor.YELLOW + BukkitLang.get("itemCreateSetDurab");
            }
            case 4: {
                return ChatColor.YELLOW + BukkitLang.get("itemCreateSetEnchs");
            }
            case 5: {
                return ChatColor.YELLOW + BukkitLang.get("itemCreateSetDisplay");
            }
            case 6: {
                return ChatColor.YELLOW + BukkitLang.get("itemCreateSetLore");
            }
            case 7: {
                if (context.getSessionData((Object)"tempMeta") != null) {
                    return ChatColor.DARK_GREEN + BukkitLang.get("itemCreateSetClearMeta");
                }
                return ChatColor.GRAY + BukkitLang.get("itemCreateSetClearMeta");
            }
            case 8: {
                return ChatColor.RED + BukkitLang.get("cancel");
            }
            case 9: {
                return ChatColor.GREEN + BukkitLang.get("done");
            }
        }
        return null;
    }

    @Override
    public String getAdditionalText(ConversationContext context, int number) {
        switch (number) {
            case 0: 
            case 8: 
            case 9: {
                return "";
            }
            case 1: {
                if (context.getSessionData((Object)"tempName") == null) {
                    return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                String text = (String)context.getSessionData((Object)"tempName");
                return ChatColor.GRAY + "(" + ChatColor.AQUA + BukkitItemUtil.getPrettyItemName(text) + ChatColor.GRAY + ")";
            }
            case 2: {
                if (context.getSessionData((Object)"tempAmount") == null) {
                    return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                Integer text = (Integer)context.getSessionData((Object)"tempAmount");
                return ChatColor.GRAY + "(" + ChatColor.AQUA + text + ChatColor.GRAY + ")";
            }
            case 3: {
                if (context.getSessionData((Object)"tempData") == null) {
                    return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                Short text = (Short)context.getSessionData((Object)"tempData");
                return ChatColor.GRAY + "(" + ChatColor.AQUA + text + ChatColor.GRAY + ")";
            }
            case 4: {
                if (context.getSessionData((Object)"tempEnchantments") == null) {
                    return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                StringBuilder text = new StringBuilder();
                Map map = (Map)context.getSessionData((Object)"tempEnchantments");
                if (map != null) {
                    for (Map.Entry e : map.entrySet()) {
                        text.append("\n").append(BukkitItemUtil.getPrettyEnchantmentName((Enchantment)e.getKey())).append(" ").append(RomanNumeral.getNumeral((Integer)e.getValue()));
                    }
                }
                return ChatColor.GRAY + "(" + ChatColor.AQUA + text + ChatColor.GRAY + ")";
            }
            case 5: {
                if (context.getSessionData((Object)"tempDisplay") == null) {
                    return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                String text = (String)context.getSessionData((Object)"tempDisplay");
                return ChatColor.GRAY + "(" + ChatColor.AQUA + text + ChatColor.GRAY + ")";
            }
            case 6: {
                if (context.getSessionData((Object)"tempLore") == null) {
                    return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                StringBuilder text = new StringBuilder();
                List list = (List)context.getSessionData((Object)"tempLore");
                if (list != null) {
                    for (String s : list) {
                        text.append("\n").append(s);
                    }
                }
                return ChatColor.GRAY + "(" + ChatColor.AQUA + text + ChatColor.GRAY + ")";
            }
            case 7: {
                if (context.getSessionData((Object)"tempMeta") == null) {
                    return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                StringBuilder text = new StringBuilder();
                LinkedHashMap map = (LinkedHashMap)context.getSessionData((Object)"tempMeta");
                if (map != null && !map.isEmpty()) {
                    for (String key : map.keySet()) {
                        if (key.equals("pages")) {
                            List pages = (List)map.get(key);
                            text.append("\n").append(ChatColor.GRAY).append("  \u2515 ").append(ChatColor.DARK_GREEN).append(key).append("=").append(pages.size());
                            continue;
                        }
                        text.append("\n").append(ChatColor.GRAY).append("  \u2515 ").append(ChatColor.DARK_GREEN).append(key).append("=").append(map.get(key));
                    }
                }
                return text.toString();
            }
        }
        return null;
    }

    @Override
    @NotNull
    public String getBasicPromptText(@NotNull ConversationContext context) {
        String stackData;
        QuestsEditorPostOpenNumericPromptEvent event = new QuestsEditorPostOpenNumericPromptEvent(context, this);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        StringBuilder text = new StringBuilder(ChatColor.GOLD + this.getTitle(context));
        if (context.getSessionData((Object)"tempName") != null && (stackData = this.getItemData(context)) != null) {
            LinkedHashMap map;
            text.append("\n").append(stackData);
            if (context.getSessionData((Object)"tempMeta") != null && (map = (LinkedHashMap)context.getSessionData((Object)"tempMeta")) != null && !map.isEmpty()) {
                for (String key : map.keySet()) {
                    if (key.equals("pages")) {
                        List pages = (List)map.get(key);
                        text.append("\n").append(ChatColor.GRAY).append("  \u2515 ").append(ChatColor.DARK_GREEN).append(key).append("=").append(pages.size());
                        continue;
                    }
                    text.append("\n").append(ChatColor.GRAY).append("  \u2515 ").append(ChatColor.DARK_GREEN).append(key).append("=").append(map.get(key));
                }
            }
        }
        int start = 0;
        if (!(context.getForWhom() instanceof Player)) {
            start = 1;
        }
        for (int i = start; i <= 9; ++i) {
            text.append("\n").append(this.getNumberColor(context, i)).append(ChatColor.BOLD).append(i).append(ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i));
        }
        return text.toString();
    }

    protected Prompt acceptValidatedInput(@NotNull ConversationContext context, @NotNull Number input) {
        return this.acceptValidatedInput(context, input, null);
    }

    public Prompt acceptValidatedInput(ConversationContext context, Number input, ItemStack item) {
        switch (input.intValue()) {
            case 0: {
                if (context.getForWhom() instanceof Player) {
                    ItemStack is;
                    context.setSessionData((Object)"tempMeta", null);
                    Player player = (Player)context.getForWhom();
                    ItemStack itemStack = is = item == null ? player.getItemInHand() : item;
                    if (is.getType().equals((Object)Material.AIR)) {
                        player.sendMessage(ChatColor.RED + BukkitLang.get("itemCreateNoItem"));
                    } else {
                        ItemMeta meta;
                        context.setSessionData((Object)"tempName", (Object)is.getType().name());
                        context.setSessionData((Object)"tempAmount", (Object)is.getAmount());
                        context.setSessionData((Object)"tempData", null);
                        context.setSessionData((Object)"tempEnchantments", null);
                        context.setSessionData((Object)"tempDisplay", null);
                        context.setSessionData((Object)"tempLore", null);
                        if (is.getDurability() != 0) {
                            context.setSessionData((Object)"tempData", (Object)is.getDurability());
                        }
                        if (!is.getEnchantments().isEmpty()) {
                            context.setSessionData((Object)"tempEnchantments", new HashMap(is.getEnchantments()));
                        }
                        if (is.hasItemMeta() && (meta = is.getItemMeta()) != null) {
                            if (meta.hasDisplayName()) {
                                String display = meta.getDisplayName().replace('\u00a7', '&');
                                context.setSessionData((Object)"tempDisplay", (Object)display);
                            }
                            if (meta.getLore() != null) {
                                LinkedList lore = new LinkedList(meta.getLore());
                                context.setSessionData((Object)"tempLore", lore);
                            }
                            LinkedHashMap map = new LinkedHashMap(meta.serialize());
                            map.remove("lore");
                            map.remove("display-name");
                            if (!map.isEmpty()) {
                                context.setSessionData((Object)"tempMeta", map);
                            }
                        }
                    }
                } else {
                    context.getForWhom().sendRawMessage(ChatColor.YELLOW + BukkitLang.get("consoleError"));
                }
                return new ItemStackPrompt(context, this.oldPrompt);
            }
            case 1: {
                context.setSessionData((Object)"tempMeta", null);
                return new ItemNamePrompt(context);
            }
            case 2: {
                if (context.getSessionData((Object)"tempName") != null) {
                    return new ItemAmountPrompt(context);
                }
                context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("itemCreateNoName"));
                return new ItemStackPrompt(context, this.oldPrompt);
            }
            case 3: {
                if (context.getSessionData((Object)"tempName") != null && context.getSessionData((Object)"tempAmount") != null) {
                    return new ItemDataPrompt(context);
                }
                context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("itemCreateNoNameAmount"));
                return new ItemStackPrompt(context, this.oldPrompt);
            }
            case 4: {
                if (context.getSessionData((Object)"tempName") != null && context.getSessionData((Object)"tempAmount") != null) {
                    return new ItemEnchantmentPrompt(context);
                }
                context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("itemCreateNoNameAmount"));
                return new ItemStackPrompt(context, this.oldPrompt);
            }
            case 5: {
                if (context.getSessionData((Object)"tempName") != null && context.getSessionData((Object)"tempAmount") != null) {
                    return new ItemDisplayPrompt(context);
                }
                context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("itemCreateNoNameAmount"));
                return new ItemStackPrompt(context, this.oldPrompt);
            }
            case 6: {
                if (context.getSessionData((Object)"tempName") != null && context.getSessionData((Object)"tempAmount") != null) {
                    return new ItemLorePrompt(context);
                }
                context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("itemCreateNoNameAmount"));
                return new ItemStackPrompt(context, this.oldPrompt);
            }
            case 7: {
                if (context.getSessionData((Object)"tempName") != null && context.getSessionData((Object)"tempAmount") != null) {
                    context.setSessionData((Object)"tempMeta", null);
                } else {
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("itemCreateNoNameAmount"));
                }
                return new ItemStackPrompt(context, this.oldPrompt);
            }
            case 8: {
                ItemStackPrompt.clearSessionData(context);
                return this.oldPrompt;
            }
            case 9: {
                if (context.getSessionData((Object)"tempName") != null && context.getSessionData((Object)"tempAmount") != null) {
                    ItemMeta meta;
                    String name = (String)context.getSessionData((Object)"tempName");
                    Integer amount = (Integer)context.getSessionData((Object)"tempAmount");
                    Short data = -1;
                    Map enchs = null;
                    String display = null;
                    ArrayList<String> lore = null;
                    if (context.getSessionData((Object)"tempData") != null) {
                        data = (Short)context.getSessionData((Object)"tempData");
                    }
                    if (context.getSessionData((Object)"tempEnchantments") != null) {
                        enchs = (Map)context.getSessionData((Object)"tempEnchantments");
                    }
                    if (context.getSessionData((Object)"tempDisplay") != null) {
                        display = ChatColor.translateAlternateColorCodes((char)'&', (String)((String)Objects.requireNonNull(context.getSessionData((Object)"tempDisplay"))));
                    }
                    if (context.getSessionData((Object)"tempLore") != null) {
                        lore = new ArrayList<String>();
                        LinkedList loadedLore = (LinkedList)context.getSessionData((Object)"tempLore");
                        if (loadedLore != null) {
                            for (String line : loadedLore) {
                                lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)line));
                            }
                        }
                    }
                    if (name == null || amount == null || data == null) break;
                    ItemStack stack = new ItemStack(Objects.requireNonNull(Material.matchMaterial((String)name)), amount.intValue());
                    if (data != -1) {
                        stack.setDurability(data.shortValue());
                    }
                    if ((meta = stack.getItemMeta()) != null) {
                        if (context.getSessionData((Object)"tempMeta") != null) {
                            meta = BukkitItemUtil.deserializeItemMeta(meta.getClass(), (Map)context.getSessionData((Object)"tempMeta"));
                        }
                        if (enchs != null) {
                            for (Map.Entry e : enchs.entrySet()) {
                                meta.addEnchant((Enchantment)e.getKey(), ((Integer)e.getValue()).intValue(), true);
                            }
                        }
                        if (display != null) {
                            meta.setDisplayName(display);
                        }
                        if (lore != null) {
                            meta.setLore(lore);
                        }
                        stack.setItemMeta(meta);
                    }
                    context.setSessionData((Object)"tempStack", (Object)stack);
                    return this.oldPrompt;
                }
                context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("itemCreateNoNameAmount"));
                return new ItemStackPrompt(context, this.oldPrompt);
            }
        }
        try {
            return new ItemStackPrompt(context, this.oldPrompt);
        }
        catch (Exception e) {
            context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("itemCreateCriticalError"));
            return Prompt.END_OF_CONVERSATION;
        }
    }

    public String getItemData(ConversationContext context) {
        List lore;
        Map enchantments;
        StringBuilder item = new StringBuilder();
        if (context.getSessionData((Object)"tempDisplay") != null) {
            item.append(ChatColor.LIGHT_PURPLE).append(ChatColor.ITALIC).append(context.getSessionData((Object)"tempDisplay")).append(ChatColor.RESET).append(" ");
        }
        if (context.getSessionData((Object)"tempName") != null) {
            String name = (String)context.getSessionData((Object)"tempName");
            item.append(ChatColor.GRAY).append("(").append(ChatColor.AQUA).append(BukkitItemUtil.getPrettyItemName(name));
            if (context.getSessionData((Object)"tempData") != null) {
                item.append(":").append(ChatColor.BLUE).append(context.getSessionData((Object)"tempData"));
            }
            item.append(ChatColor.GRAY).append(")");
        }
        if (context.getSessionData((Object)"tempAmount") != null) {
            item.append(ChatColor.GRAY).append(" x ").append(ChatColor.DARK_AQUA).append(context.getSessionData((Object)"tempAmount"));
        } else {
            item.append(ChatColor.GRAY).append(" x ").append(ChatColor.DARK_AQUA).append("1");
        }
        if (context.getSessionData((Object)"tempEnchantments") != null && (enchantments = (Map)context.getSessionData((Object)"tempEnchantments")) != null) {
            for (Map.Entry e : enchantments.entrySet()) {
                item.append("\n").append(ChatColor.GRAY).append("  - ").append(ChatColor.RED).append(BukkitItemUtil.getPrettyEnchantmentName((Enchantment)e.getKey())).append(" ").append(RomanNumeral.getNumeral((Integer)e.getValue()));
            }
        }
        if (context.getSessionData((Object)"tempLore") != null && (lore = (List)context.getSessionData((Object)"tempLore")) != null) {
            for (String s : lore) {
                item.append("\n").append(ChatColor.DARK_PURPLE).append(ChatColor.ITALIC).append(s);
            }
        }
        return item.toString();
    }

    public static void clearSessionData(ConversationContext context) {
        context.setSessionData((Object)"tempStack", null);
        context.setSessionData((Object)"tempName", null);
        context.setSessionData((Object)"tempAmount", null);
        context.setSessionData((Object)"tempData", null);
        context.setSessionData((Object)"tempEnchantments", null);
        context.setSessionData((Object)"tempDisplay", null);
        context.setSessionData((Object)"tempLore", null);
        context.setSessionData((Object)"tempMeta", null);
    }

    public class ItemNamePrompt
    extends QuestsEditorStringPrompt {
        public ItemNamePrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("itemCreateEnterName");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                BukkitQuestsPlugin plugin;
                String s = input.replace(":", "");
                Material mat = Material.matchMaterial((String)s.toUpperCase().replace(" ", "_"));
                if (mat == null) {
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("itemCreateInvalidName"));
                    return new ItemNamePrompt(context);
                }
                if (context.getPlugin() instanceof BukkitQuestsPlugin && (plugin = (BukkitQuestsPlugin)context.getPlugin()).hasLimitedAccess(context.getForWhom()) && plugin.getServer().getRecipesFor(new ItemStack(mat)).isEmpty()) {
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("noPermission"));
                    return new ItemStackPrompt(context, ItemStackPrompt.this.oldPrompt);
                }
                context.setSessionData((Object)"tempName", (Object)mat.name());
                context.setSessionData((Object)"tempAmount", (Object)1);
                return new ItemStackPrompt(context, ItemStackPrompt.this.oldPrompt);
            }
            return new ItemStackPrompt(context, ItemStackPrompt.this.oldPrompt);
        }
    }

    public class ItemAmountPrompt
    extends QuestsEditorStringPrompt {
        public ItemAmountPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("itemCreateEnterAmount");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                try {
                    int amt = Integer.parseInt(input);
                    if (amt < 1 || amt > 64) {
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("invalidRange").replace("<least>", "1").replace("<greatest>", "64"));
                        return new ItemAmountPrompt(context);
                    }
                    context.setSessionData((Object)"tempAmount", (Object)Integer.parseInt(input));
                    return new ItemStackPrompt(context, ItemStackPrompt.this.oldPrompt);
                }
                catch (NumberFormatException e) {
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("itemCreateInvalidInput"));
                    return new ItemAmountPrompt(context);
                }
            }
            return new ItemStackPrompt(context, ItemStackPrompt.this.oldPrompt);
        }
    }

    public class ItemDataPrompt
    extends QuestsEditorStringPrompt {
        public ItemDataPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("itemCreateEnterDurab");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel")) && !input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                try {
                    int amt = Integer.parseInt(input);
                    if (amt < 1) {
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("itemCreateInvalidDurab"));
                        return new ItemDataPrompt(context);
                    }
                    context.setSessionData((Object)"tempData", (Object)Short.parseShort(input));
                    return new ItemStackPrompt(context, ItemStackPrompt.this.oldPrompt);
                }
                catch (NumberFormatException e) {
                    if (input.equals("*")) {
                        context.setSessionData((Object)"tempData", (Object)Short.parseShort("999"));
                        return new ItemStackPrompt(context, ItemStackPrompt.this.oldPrompt);
                    }
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("itemCreateInvalidInput"));
                    return new ItemDataPrompt(context);
                }
            }
            if (input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                context.setSessionData((Object)"tempData", null);
            }
            return new ItemStackPrompt(context, ItemStackPrompt.this.oldPrompt);
        }
    }

    public class ItemEnchantmentPrompt
    extends QuestsEditorStringPrompt {
        public ItemEnchantmentPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("enchantmentsTitle");
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("itemCreateEnterEnch");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            StringBuilder text = new StringBuilder(ChatColor.LIGHT_PURPLE + this.getTitle(context) + "\n");
            for (Enchantment e : Enchantment.values()) {
                text.append(ChatColor.GREEN).append(BukkitItemUtil.getPrettyEnchantmentName(e)).append(", ");
            }
            text = new StringBuilder(text.substring(0, text.length() - 2));
            return text + "\n" + ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            String s = input.replace(":", "");
            if (!s.equalsIgnoreCase(BukkitLang.get("cmdClear")) && !s.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                Enchantment e = BukkitItemUtil.getEnchantmentFromPrettyName(BukkitMiscUtil.getCapitalized(s));
                if (e != null) {
                    context.setSessionData((Object)"tempEnchant", (Object)e);
                    return new ItemEnchantmentLevelPrompt(context, BukkitItemUtil.getPrettyEnchantmentName(e));
                }
                context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("itemCreateInvalidEnch"));
                return new ItemEnchantmentPrompt(context);
            }
            if (s.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                context.setSessionData((Object)"tempEnchantments", null);
            }
            return new ItemStackPrompt(context, ItemStackPrompt.this.oldPrompt);
        }
    }

    public class ItemDisplayPrompt
    extends QuestsEditorStringPrompt {
        public ItemDisplayPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("itemCreateEnterDisplay");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            String s = input.replace(":", "");
            if (!s.equalsIgnoreCase(BukkitLang.get("cmdCancel")) && !s.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                s = BukkitConfigUtil.parseString(s);
                context.setSessionData((Object)"tempDisplay", (Object)s);
            } else if (s.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                context.setSessionData((Object)"tempDisplay", null);
            }
            return new ItemStackPrompt(context, ItemStackPrompt.this.oldPrompt);
        }
    }

    public class ItemLorePrompt
    extends QuestsEditorStringPrompt {
        public ItemLorePrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("itemCreateEnterLore");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            String s = input.replace(":", "");
            if (!s.equalsIgnoreCase(BukkitLang.get("cmdCancel")) && !s.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                s = BukkitConfigUtil.parseString(s);
                LinkedList<String> lore = new LinkedList<String>(Arrays.asList(s.split(BukkitLang.get("charSemi"))));
                context.setSessionData((Object)"tempLore", lore);
            } else if (s.equalsIgnoreCase("clear")) {
                context.setSessionData((Object)"tempLore", null);
            }
            return new ItemStackPrompt(context, ItemStackPrompt.this.oldPrompt);
        }
    }

    public class ItemEnchantmentLevelPrompt
    extends QuestsEditorStringPrompt {
        final String enchantment;

        protected ItemEnchantmentLevelPrompt(ConversationContext context, String ench) {
            super(context);
            this.enchantment = ench;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("itemCreateEnterLevel").replace("<enchantment>", this.enchantment);
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            return ChatColor.AQUA + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            try {
                int num = Integer.parseInt(input);
                if (num < 1) {
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("invalidMinimum").replace("<number>", "1"));
                    return new ItemEnchantmentLevelPrompt(context, this.enchantment);
                }
                if (context.getSessionData((Object)"tempEnchantments") != null) {
                    Map enchs = (Map)context.getSessionData((Object)"tempEnchantments");
                    if (enchs != null) {
                        enchs.put((Enchantment)context.getSessionData((Object)"tempEnchant"), num);
                        context.setSessionData((Object)"tempEnchantments", (Object)enchs);
                    }
                } else {
                    HashMap<Enchantment, Integer> enchs = new HashMap<Enchantment, Integer>();
                    enchs.put((Enchantment)context.getSessionData((Object)"tempEnchant"), num);
                    context.setSessionData((Object)"tempEnchantments", enchs);
                }
                return new ItemStackPrompt(context, ItemStackPrompt.this.oldPrompt);
            }
            catch (NumberFormatException e) {
                context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("reqNotANumber").replace("<input>", input));
                return new ItemEnchantmentLevelPrompt(context, this.enchantment);
            }
        }
    }
}

