/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.convo.generic;

import me.pikamug.quests.convo.quests.QuestsEditorStringPrompt;
import me.pikamug.quests.events.editor.quests.QuestsEditorPostOpenStringPromptEvent;
import me.pikamug.quests.util.BukkitLang;
import org.bukkit.ChatColor;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.Prompt;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

public class OverridePrompt
extends QuestsEditorStringPrompt {
    private final Prompt oldPrompt;
    private final String promptText;
    private final String classPrefix;
    private final int size = 1;

    public OverridePrompt(ConversationContext context, Prompt old, String promptText) {
        super(context);
        this.oldPrompt = old;
        this.classPrefix = old.getClass().getSimpleName();
        this.promptText = promptText;
    }

    public int getSize() {
        return 1;
    }

    @Override
    public String getTitle(ConversationContext context) {
        return null;
    }

    @Override
    public String getQueryText(ConversationContext context) {
        return this.promptText;
    }

    @NotNull
    public String getPromptText(@NotNull ConversationContext context) {
        if (context.getPlugin() != null) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            context.getPlugin().getServer().getPluginManager().callEvent((Event)event);
        }
        return ChatColor.YELLOW + this.getQueryText(context);
    }

    public Prompt acceptInput(@NotNull ConversationContext context, String input) {
        if (input != null) {
            if (input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                context.getForWhom().sendRawMessage(ChatColor.YELLOW + BukkitLang.get("stageEditorMessageCleared"));
                context.setSessionData((Object)(this.classPrefix + "-override"), (Object)BukkitLang.get("cmdClear"));
            } else if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                context.setSessionData((Object)(this.classPrefix + "-override"), (Object)input);
            }
        }
        return this.oldPrompt;
    }

    public static class Builder {
        private ConversationContext context;
        private Prompt oldPrompt;
        private String promptText = "Enter input";

        public Builder context(ConversationContext context) {
            this.context = context;
            return this;
        }

        public Builder source(Prompt prompt) {
            this.oldPrompt = prompt;
            return this;
        }

        public Builder promptText(String text) {
            this.promptText = text;
            return this;
        }

        public OverridePrompt build() {
            return new OverridePrompt(this.context, this.oldPrompt, this.promptText);
        }
    }
}

