/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.convo.misc;

import java.text.MessageFormat;
import java.util.Comparator;
import java.util.LinkedList;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.convo.misc.MiscStringPrompt;
import me.pikamug.quests.events.misc.MiscPostNpcOfferQuestEvent;
import me.pikamug.quests.player.BukkitQuester;
import me.pikamug.quests.player.Quester;
import me.pikamug.quests.quests.BukkitQuest;
import me.pikamug.quests.quests.Quest;
import me.pikamug.quests.util.BukkitLang;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.Prompt;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

public class NpcOfferQuestPrompt
extends MiscStringPrompt {
    private ConversationContext context;
    private final BukkitQuestsPlugin plugin;
    private int size = 3;

    public NpcOfferQuestPrompt(BukkitQuestsPlugin plugin) {
        super(null);
        this.plugin = plugin;
    }

    public NpcOfferQuestPrompt(ConversationContext context) {
        super(context);
        this.plugin = (BukkitQuestsPlugin)context.getPlugin();
    }

    @Override
    public ConversationContext getConversationContext() {
        return this.context;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public String getTitle(ConversationContext context) {
        String npc = (String)context.getSessionData((Object)"npc");
        return BukkitLang.get("questNPCListTitle").replace("<npc>", npc != null ? npc : "NPC");
    }

    public ChatColor getNumberColor(ConversationContext context, int number) {
        LinkedList quests = (LinkedList)context.getSessionData((Object)"npcQuests");
        if (this.plugin != null) {
            BukkitQuester quester = this.plugin.getQuester(((Player)context.getForWhom()).getUniqueId());
            if (quests != null && number > 0) {
                if (number < quests.size() + 1) {
                    Quest quest = (Quest)quests.get(number - 1);
                    if (quester.getCompletedQuests().contains(quest)) {
                        return ChatColor.GREEN;
                    }
                    return ChatColor.GOLD;
                }
                if (number == quests.size() + 1) {
                    return ChatColor.GOLD;
                }
            }
        }
        return null;
    }

    public String getSelectionText(ConversationContext context, int number) {
        LinkedList quests = (LinkedList)context.getSessionData((Object)"npcQuests");
        if (this.plugin != null) {
            BukkitQuester quester = this.plugin.getQuester(((Player)context.getForWhom()).getUniqueId());
            if (quests != null && number > 0) {
                if (number < quests.size() + 1) {
                    Quest quest = (Quest)quests.get(number - 1);
                    if (quester.getCompletedQuests().contains(quest)) {
                        return ChatColor.GREEN + "" + ChatColor.ITALIC + quest.getName();
                    }
                    return ChatColor.YELLOW + "" + ChatColor.ITALIC + quest.getName();
                }
                if (number == quests.size() + 1) {
                    return ChatColor.GRAY + BukkitLang.get("cancel");
                }
            }
        }
        return null;
    }

    public String getAdditionalText(ConversationContext context, int number) {
        LinkedList quests = (LinkedList)context.getSessionData((Object)"npcQuests");
        if (this.plugin != null) {
            BukkitQuester quester = this.plugin.getQuester(((Player)context.getForWhom()).getUniqueId());
            if (quests != null && number > 0 && number < quests.size() + 1) {
                Quest quest = (Quest)quests.get(number - 1);
                if (quester.getCompletedQuests().contains(quest)) {
                    return ChatColor.GREEN + "" + BukkitLang.get("redoCompleted");
                }
            }
        }
        return "";
    }

    @Override
    public String getQueryText(ConversationContext context) {
        return BukkitLang.get("enterAnOption");
    }

    @NotNull
    public String getPromptText(ConversationContext context) {
        this.context = context;
        LinkedList quests = (LinkedList)context.getSessionData((Object)"npcQuests");
        String npc = (String)context.getSessionData((Object)"npc");
        if (this.plugin == null || quests == null || npc == null) {
            return ChatColor.YELLOW + BukkitLang.get("itemCreateCriticalError");
        }
        quests.sort(Comparator.comparing(BukkitQuest::getName));
        MiscPostNpcOfferQuestEvent event = new MiscPostNpcOfferQuestEvent(context, (Prompt)this);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        if (!(context.getForWhom() instanceof Player) || !this.plugin.getConfigSettings().canClickablePrompts()) {
            StringBuilder text = new StringBuilder(ChatColor.WHITE + this.getTitle(context));
            this.size = quests.size();
            for (int i = 1; i <= this.size + 1; ++i) {
                text.append("\n").append(this.getNumberColor(context, i)).append(ChatColor.BOLD).append(i).append(". ").append(ChatColor.RESET).append(this.getSelectionText(context, i)).append(" ").append(this.getAdditionalText(context, i));
            }
            text.append("\n").append(ChatColor.WHITE).append(this.getQueryText(context));
            return text.toString();
        }
        TextComponent component = new TextComponent(this.getTitle(context));
        component.setColor(net.md_5.bungee.api.ChatColor.WHITE);
        this.size = quests.size();
        TextComponent line = new TextComponent("");
        for (int i = 1; i <= this.size + 1; ++i) {
            TextComponent choice = new TextComponent("\n" + this.getNumberColor(context, i) + ChatColor.BOLD + i + ". " + ChatColor.RESET + this.getSelectionText(context, i));
            choice.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/quests choice " + i));
            if (this.plugin.getConfigSettings().canShowQuestReqs() && i <= this.size) {
                choice.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(((BukkitQuest)quests.get(i - 1)).getDescription()).create()));
            }
            line.addExtra((BaseComponent)choice);
            line.addExtra(this.getAdditionalText(context, i));
        }
        component.addExtra((BaseComponent)line);
        component.addExtra("\n" + ChatColor.WHITE + this.getQueryText(context));
        ((Player)context.getForWhom()).spigot().sendMessage((BaseComponent)component);
        return "";
    }

    public Prompt acceptInput(ConversationContext context, String input) {
        LinkedList quests = (LinkedList)context.getSessionData((Object)"npcQuests");
        if (this.plugin == null || quests == null) {
            return Prompt.END_OF_CONVERSATION;
        }
        BukkitQuester quester = this.plugin.getQuester(((Player)context.getForWhom()).getUniqueId());
        int numInput = -1;
        try {
            numInput = Integer.parseInt(input);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (input.equalsIgnoreCase(BukkitLang.get("cancel")) || numInput == quests.size() + 1) {
            context.getForWhom().sendRawMessage(ChatColor.YELLOW + BukkitLang.get("cancelled"));
            return Prompt.END_OF_CONVERSATION;
        }
        Quest q = null;
        for (Quest quest : quests) {
            if (!quest.getName().equalsIgnoreCase(input)) continue;
            q = quest;
            break;
        }
        if (q == null) {
            for (Quest quest : quests) {
                if (numInput != quests.indexOf(quest) + 1) continue;
                q = quest;
                break;
            }
        }
        if (q == null) {
            for (Quest quest : quests) {
                if (!quest.getName().toLowerCase().contains(input.toLowerCase())) continue;
                q = quest;
                break;
            }
        }
        if (q == null) {
            context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("invalidOption"));
            return new NpcOfferQuestPrompt(context);
        }
        Player player = quester.getPlayer();
        if (quester.canAcceptOffer(q, true)) {
            quester.setQuestIdToTake(q.getId());
            for (String msg : this.extracted(this.plugin, quester).split("<br>")) {
                player.sendMessage(msg);
            }
            if (!this.plugin.getConfigSettings().canConfirmAccept()) {
                quester.takeQuest(q, false);
            } else {
                this.plugin.getConversationFactory().buildConversation((Conversable)player).begin();
            }
        }
        return Prompt.END_OF_CONVERSATION;
    }

    private String extracted(BukkitQuestsPlugin plugin, Quester quester) {
        Quest quest = plugin.getQuestById(quester.getQuestIdToTake());
        return MessageFormat.format("{0}- {1}{2}{3} -\n\n{4}{5}\n", ChatColor.GOLD, ChatColor.DARK_PURPLE, quest.getName(), ChatColor.GOLD, ChatColor.RESET, quest.getDescription());
    }
}

