/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.convo.misc;

import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.convo.misc.MiscStringPrompt;
import me.pikamug.quests.events.misc.MiscPostQuestAbandonEvent;
import me.pikamug.quests.player.BukkitQuester;
import me.pikamug.quests.quests.Quest;
import me.pikamug.quests.util.BukkitLang;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.Prompt;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

public class QuestAbandonPrompt
extends MiscStringPrompt {
    private ConversationContext context;
    private final BukkitQuestsPlugin plugin;
    private final int size = 2;

    public QuestAbandonPrompt(BukkitQuestsPlugin plugin) {
        super(null);
        this.plugin = plugin;
    }

    public QuestAbandonPrompt(ConversationContext context) {
        super(context);
        this.plugin = (BukkitQuestsPlugin)context.getPlugin();
    }

    @Override
    public ConversationContext getConversationContext() {
        return this.context;
    }

    @Override
    public int getSize() {
        return 2;
    }

    @Override
    public String getTitle(ConversationContext context) {
        return null;
    }

    public ChatColor getNumberColor(ConversationContext context, int number) {
        switch (number) {
            case 1: {
                return ChatColor.GREEN;
            }
            case 2: {
                return ChatColor.RED;
            }
        }
        return null;
    }

    public String getSelectionText(ConversationContext context, int number) {
        switch (number) {
            case 1: {
                return ChatColor.GREEN + BukkitLang.get("yesWord");
            }
            case 2: {
                return ChatColor.RED + BukkitLang.get("noWord");
            }
        }
        return null;
    }

    @Override
    public String getQueryText(ConversationContext context) {
        return BukkitLang.get("abandonQuest");
    }

    @NotNull
    public String getPromptText(@NotNull ConversationContext context) {
        this.context = context;
        if (this.plugin == null) {
            return ChatColor.YELLOW + BukkitLang.get("itemCreateCriticalError");
        }
        MiscPostQuestAbandonEvent event = new MiscPostQuestAbandonEvent(context, (Prompt)this);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        if (!this.plugin.getConfigSettings().canClickablePrompts()) {
            return ChatColor.YELLOW + this.getQueryText(context) + "  " + ChatColor.GREEN + this.getSelectionText(context, 1) + ChatColor.RESET + " / " + this.getSelectionText(context, 2);
        }
        TextComponent component = new TextComponent("");
        component.addExtra(ChatColor.YELLOW + this.getQueryText(context) + "  " + ChatColor.GREEN);
        TextComponent yes = new TextComponent(this.getSelectionText(context, 1));
        yes.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/quests choice " + BukkitLang.get("yesWord")));
        component.addExtra((BaseComponent)yes);
        component.addExtra(ChatColor.RESET + " / ");
        TextComponent no = new TextComponent(this.getSelectionText(context, 2));
        no.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/quests choice " + BukkitLang.get("noWord")));
        component.addExtra((BaseComponent)no);
        ((Player)context.getForWhom()).spigot().sendMessage((BaseComponent)component);
        return "";
    }

    public Prompt acceptInput(@NotNull ConversationContext context, String input) {
        BukkitQuestsPlugin plugin = (BukkitQuestsPlugin)context.getPlugin();
        if (plugin == null || input == null) {
            return Prompt.END_OF_CONVERSATION;
        }
        Player player = (Player)context.getForWhom();
        if (input.equalsIgnoreCase("1") || input.equalsIgnoreCase("y") || input.equalsIgnoreCase(BukkitLang.get("yesWord")) || input.equalsIgnoreCase(BukkitLang.get(player, "yesWord"))) {
            BukkitQuester quester = plugin.getQuester(player.getUniqueId());
            if (quester == null) {
                plugin.getLogger().info("Ended conversation because quester for " + this.getName() + "was null");
                return Prompt.END_OF_CONVERSATION;
            }
            String questIdToQuit = quester.getQuestIdToQuit();
            try {
                Quest quest = plugin.getQuestById(questIdToQuit);
                if (quest == null) {
                    plugin.getLogger().info(player.getName() + " attempted to quit quest ID \"" + questIdToQuit + "\" but something went wrong");
                    player.sendMessage(ChatColor.RED + "Something went wrong! Please report issue to an administrator.");
                } else {
                    String msg = ChatColor.YELLOW + BukkitLang.get("questQuit").replace("<quest>", ChatColor.DARK_PURPLE + quest.getName() + ChatColor.YELLOW);
                    quester.quitQuest(plugin.getQuestById(questIdToQuit), msg);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return Prompt.END_OF_CONVERSATION;
        }
        if (input.equalsIgnoreCase("2") || input.equalsIgnoreCase("n") || input.equalsIgnoreCase(BukkitLang.get("noWord")) || input.equalsIgnoreCase(BukkitLang.get(player, "noWord"))) {
            BukkitLang.send(player, ChatColor.YELLOW + BukkitLang.get("cancelled"));
            return Prompt.END_OF_CONVERSATION;
        }
        String msg = BukkitLang.get(player, "questInvalidChoice").replace("<yes>", BukkitLang.get(player, "yesWord")).replace("<no>", BukkitLang.get(player, "noWord"));
        BukkitLang.send(player, ChatColor.RED + msg);
        return new QuestAbandonPrompt(context);
    }
}

