/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.convo.quests.main;

import com.sk89q.worldguard.protection.managers.RegionManager;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.convo.QuestsNumericPrompt;
import me.pikamug.quests.convo.generic.ItemStackPrompt;
import me.pikamug.quests.convo.quests.QuestsEditorNumericPrompt;
import me.pikamug.quests.convo.quests.QuestsEditorStringPrompt;
import me.pikamug.quests.convo.quests.options.QuestOptionsPrompt;
import me.pikamug.quests.convo.quests.planner.QuestPlannerPrompt;
import me.pikamug.quests.convo.quests.requirements.QuestRequirementsPrompt;
import me.pikamug.quests.convo.quests.rewards.QuestRewardsPrompt;
import me.pikamug.quests.convo.quests.stages.QuestStageMenuPrompt;
import me.pikamug.quests.dependencies.reflect.worldguard.WorldGuardAPI;
import me.pikamug.quests.events.editor.quests.QuestsEditorPostOpenNumericPromptEvent;
import me.pikamug.quests.events.editor.quests.QuestsEditorPostOpenStringPromptEvent;
import me.pikamug.quests.quests.Quest;
import me.pikamug.quests.util.BukkitItemUtil;
import me.pikamug.quests.util.BukkitLang;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.Prompt;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class QuestMainPrompt
extends QuestsEditorNumericPrompt {
    private final BukkitQuestsPlugin plugin;
    private final int size = 14;

    public QuestMainPrompt(ConversationContext context) {
        super(context);
        this.plugin = (BukkitQuestsPlugin)context.getPlugin();
    }

    @Override
    public int getSize() {
        return 14;
    }

    @Override
    public String getTitle(ConversationContext context) {
        StringBuilder title = new StringBuilder(BukkitLang.get("quest") + ": " + context.getSessionData((Object)"questName"));
        if (this.plugin.hasLimitedAccess(context.getForWhom())) {
            title.append(ChatColor.RED).append(" (").append(BukkitLang.get("trialMode")).append(")");
        } else if (context.getSessionData((Object)"questId") != null) {
            title.append(ChatColor.GRAY).append(" (").append(BukkitLang.get("id")).append(":").append(context.getSessionData((Object)"questId")).append(")");
        }
        return title.toString();
    }

    @Override
    public ChatColor getNumberColor(ConversationContext context, int number) {
        switch (number) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return ChatColor.BLUE;
            }
            case 5: {
                if (context.getForWhom() instanceof Player) {
                    return ChatColor.BLUE;
                }
                return ChatColor.GRAY;
            }
            case 6: {
                if (this.plugin.getDependencies().getWorldGuardApi() != null) {
                    return ChatColor.BLUE;
                }
                return ChatColor.GRAY;
            }
            case 7: {
                if (this.plugin.getDependencies().hasAnyNpcDependencies()) {
                    return ChatColor.BLUE;
                }
                return ChatColor.GRAY;
            }
            case 13: {
                return ChatColor.GREEN;
            }
            case 14: {
                return ChatColor.RED;
            }
        }
        return null;
    }

    @Override
    public String getSelectionText(ConversationContext context, int number) {
        switch (number) {
            case 1: {
                return ChatColor.YELLOW + BukkitLang.get("questEditorName");
            }
            case 2: {
                return ChatColor.YELLOW + BukkitLang.get("questEditorAskMessage");
            }
            case 3: {
                return ChatColor.YELLOW + BukkitLang.get("questEditorFinishMessage");
            }
            case 4: {
                if (context.getSessionData((Object)"npcStart") == null || this.plugin.getDependencies().hasAnyNpcDependencies()) {
                    return ChatColor.YELLOW + BukkitLang.get("questEditorNPCStart");
                }
                return ChatColor.GRAY + BukkitLang.get("questEditorNPCStart");
            }
            case 5: {
                if (context.getForWhom() instanceof Player) {
                    return ChatColor.YELLOW + BukkitLang.get("questEditorBlockStart");
                }
                return ChatColor.GRAY + BukkitLang.get("questEditorBlockStart");
            }
            case 6: {
                if (this.plugin.getDependencies().getWorldGuardApi() != null) {
                    return ChatColor.YELLOW + BukkitLang.get("questWGSetRegion");
                }
                return ChatColor.GRAY + BukkitLang.get("questWGSetRegion");
            }
            case 7: {
                if (this.plugin.getDependencies().hasAnyNpcDependencies()) {
                    return ChatColor.YELLOW + BukkitLang.get("questEditorSetGUI");
                }
                return ChatColor.GRAY + BukkitLang.get("questEditorSetGUI");
            }
            case 8: {
                return ChatColor.DARK_AQUA + BukkitLang.get("questEditorReqs");
            }
            case 9: {
                return ChatColor.AQUA + BukkitLang.get("questEditorPln");
            }
            case 10: {
                return ChatColor.LIGHT_PURPLE + BukkitLang.get("questEditorStages");
            }
            case 11: {
                return ChatColor.DARK_PURPLE + BukkitLang.get("questEditorRews");
            }
            case 12: {
                return ChatColor.DARK_GREEN + BukkitLang.get("questEditorOpts");
            }
            case 13: {
                return ChatColor.GREEN + BukkitLang.get("save");
            }
            case 14: {
                return ChatColor.RED + BukkitLang.get("exit");
            }
        }
        return null;
    }

    @Override
    public String getAdditionalText(ConversationContext context, int number) {
        switch (number) {
            case 1: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                return "";
            }
            case 2: {
                return ChatColor.GRAY + "(" + ChatColor.AQUA + context.getSessionData((Object)"askMessage") + ChatColor.RESET + ChatColor.GRAY + ")";
            }
            case 3: {
                return ChatColor.GRAY + "(" + ChatColor.AQUA + context.getSessionData((Object)"finishMessage") + ChatColor.RESET + ChatColor.GRAY + ")";
            }
            case 4: {
                if (context.getSessionData((Object)"npcStart") == null && this.plugin.getDependencies().hasAnyNpcDependencies()) {
                    return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                if (this.plugin.getDependencies().hasAnyNpcDependencies()) {
                    UUID uuid = UUID.fromString((String)Objects.requireNonNull(context.getSessionData((Object)"npcStart")));
                    return ChatColor.GRAY + "(" + ChatColor.AQUA + this.plugin.getDependencies().getNpcName(uuid) + ChatColor.RESET + ChatColor.GRAY + ")";
                }
                return ChatColor.GRAY + "(" + BukkitLang.get("notInstalled") + ")";
            }
            case 5: {
                if (context.getSessionData((Object)"blockStart") == null) {
                    return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                Location l = (Location)context.getSessionData((Object)"blockStart");
                if (l != null && l.getWorld() != null) {
                    return ChatColor.GRAY + "(" + ChatColor.AQUA + l.getWorld().getName() + ", " + l.getBlockX() + ", " + l.getBlockY() + ", " + l.getBlockZ() + ChatColor.RESET + ChatColor.GRAY + ")";
                }
            }
            case 6: {
                if (this.plugin.getDependencies().getWorldGuardApi() != null) {
                    if (context.getSessionData((Object)"region") == null) {
                        return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    return ChatColor.GRAY + "(" + ChatColor.AQUA + context.getSessionData((Object)"region") + ChatColor.RESET + ChatColor.GRAY + ")";
                }
                return ChatColor.GRAY + "(" + BukkitLang.get("notInstalled") + ")";
            }
            case 7: {
                if (this.plugin.getDependencies().hasAnyNpcDependencies()) {
                    if (context.getSessionData((Object)"guiDisplay") == null) {
                        return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    return ChatColor.GRAY + "(" + ChatColor.AQUA + BukkitItemUtil.getDisplayString((ItemStack)context.getSessionData((Object)"guiDisplay")) + ChatColor.RESET + ChatColor.GRAY + ")";
                }
                return ChatColor.GRAY + "(" + BukkitLang.get("notInstalled") + ")";
            }
        }
        return null;
    }

    @Override
    @NotNull
    public String getBasicPromptText(@NotNull ConversationContext context) {
        QuestsEditorPostOpenNumericPromptEvent event = new QuestsEditorPostOpenNumericPromptEvent(context, this);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        StringBuilder text = new StringBuilder(ChatColor.GOLD + "- " + this.getTitle(context).replaceFirst(": ", ": " + ChatColor.AQUA) + ChatColor.GOLD + " -");
        try {
            for (int i = 1; i <= 14; ++i) {
                text.append("\n").append(this.getNumberColor(context, i)).append(ChatColor.BOLD).append(i).append(ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i)).append(" ").append(this.getAdditionalText(context, i));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return text.toString();
    }

    protected Prompt acceptValidatedInput(@NotNull ConversationContext context, Number input) {
        switch (input.intValue()) {
            case 1: {
                return new QuestNamePrompt(context);
            }
            case 2: {
                return new QuestAskMessagePrompt(context);
            }
            case 3: {
                return new QuestFinishMessagePrompt(context);
            }
            case 4: {
                if (this.plugin.getDependencies().hasAnyNpcDependencies()) {
                    return new QuestNPCStartPrompt(context);
                }
                return new QuestMainPrompt(context);
            }
            case 5: {
                if (context.getForWhom() instanceof Player) {
                    ConcurrentHashMap<UUID, Block> blockStarts = this.plugin.getQuestFactory().getSelectedBlockStarts();
                    blockStarts.put(((Player)context.getForWhom()).getUniqueId(), ((World)Bukkit.getWorlds().get(0)).getBlockAt(0, 0, 0));
                    this.plugin.getQuestFactory().setSelectedBlockStarts(blockStarts);
                    return new QuestBlockStartPrompt(context);
                }
                context.getForWhom().sendRawMessage(ChatColor.YELLOW + BukkitLang.get("consoleError"));
                return new QuestMainPrompt(context);
            }
            case 6: {
                if (this.plugin.getDependencies().getWorldGuardApi() != null) {
                    return new QuestRegionPrompt(context);
                }
                return new QuestMainPrompt(context);
            }
            case 7: {
                if (this.plugin.getDependencies().hasAnyNpcDependencies()) {
                    return new QuestGuiDisplayPrompt(context);
                }
                return new QuestMainPrompt(context);
            }
            case 8: {
                return new QuestRequirementsPrompt(context);
            }
            case 9: {
                return new QuestPlannerPrompt(context);
            }
            case 10: {
                return new QuestStageMenuPrompt(context);
            }
            case 11: {
                return new QuestRewardsPrompt(context);
            }
            case 12: {
                return new QuestOptionsPrompt(context);
            }
            case 13: {
                return new QuestSavePrompt(context);
            }
            case 14: {
                return new QuestExitPrompt(context);
            }
        }
        return new QuestMainPrompt(context);
    }

    public class QuestNamePrompt
    extends QuestsEditorStringPrompt {
        public QuestNamePrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("questEditorEnterQuestName");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestMainPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                for (Quest q : QuestMainPrompt.this.plugin.getLoadedQuests()) {
                    if (!q.getName().equalsIgnoreCase(input)) continue;
                    String s = null;
                    if (context.getSessionData((Object)"edit") != null) {
                        s = (String)context.getSessionData((Object)"edit");
                    }
                    if (s == null || s.equalsIgnoreCase(input)) continue;
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("questEditorNameExists"));
                    return new QuestNamePrompt(context);
                }
                List<String> questNames = QuestMainPrompt.this.plugin.getQuestFactory().getNamesOfQuestsBeingEdited();
                if (questNames.contains(input)) {
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("questEditorBeingEdited"));
                    return new QuestNamePrompt(context);
                }
                if (input.contains(",")) {
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("questEditorInvalidQuestName"));
                    return new QuestNamePrompt(context);
                }
                questNames.remove((String)context.getSessionData((Object)"questName"));
                context.setSessionData((Object)"questName", (Object)input);
                questNames.add(input);
                QuestMainPrompt.this.plugin.getQuestFactory().setNamesOfQuestsBeingEdited(questNames);
            }
            return new QuestMainPrompt(context);
        }
    }

    public class QuestAskMessagePrompt
    extends QuestsEditorStringPrompt {
        public QuestAskMessagePrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("questEditorEnterAskMessage");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestMainPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                if (input.startsWith("++") && context.getSessionData((Object)"askMessage") != null) {
                    context.setSessionData((Object)"askMessage", (Object)(context.getSessionData((Object)"askMessage") + " " + input.substring(2)));
                    return new QuestMainPrompt(context);
                }
                context.setSessionData((Object)"askMessage", (Object)input);
            }
            return new QuestMainPrompt(context);
        }
    }

    public class QuestFinishMessagePrompt
    extends QuestsEditorStringPrompt {
        public QuestFinishMessagePrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("questEditorEnterFinishMessage");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestMainPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                if (input.startsWith("++") && context.getSessionData((Object)"finishMessage") != null) {
                    context.setSessionData((Object)"finishMessage", (Object)(context.getSessionData((Object)"finishMessage") + " " + input.substring(2)));
                    return new QuestMainPrompt(context);
                }
                context.setSessionData((Object)"finishMessage", (Object)input);
            }
            return new QuestMainPrompt(context);
        }
    }

    public class QuestNPCStartPrompt
    extends QuestsEditorStringPrompt {
        public QuestNPCStartPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("questEditorEnterNPCStart");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestMainPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            if (context.getForWhom() instanceof Player) {
                ConcurrentSkipListSet<UUID> selectingNpcs = QuestMainPrompt.this.plugin.getQuestFactory().getSelectingNpcs();
                selectingNpcs.add(((Player)context.getForWhom()).getUniqueId());
                QuestMainPrompt.this.plugin.getQuestFactory().setSelectingNpcs(selectingNpcs);
                return ChatColor.YELLOW + BukkitLang.get("questEditorClickNPCStart");
            }
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel")) && !input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                try {
                    UUID uuid = UUID.fromString(input);
                    if (!QuestMainPrompt.this.plugin.getDependencies().isNpc(uuid)) {
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("stageEditorInvalidNPC").replace("<input>", input));
                        return new QuestNPCStartPrompt(context);
                    }
                    context.setSessionData((Object)"npcStart", (Object)uuid.toString());
                    if (context.getForWhom() instanceof Player) {
                        ConcurrentSkipListSet<UUID> selectingNpcs = QuestMainPrompt.this.plugin.getQuestFactory().getSelectingNpcs();
                        selectingNpcs.remove(((Player)context.getForWhom()).getUniqueId());
                        QuestMainPrompt.this.plugin.getQuestFactory().setSelectingNpcs(selectingNpcs);
                    }
                    return new QuestMainPrompt(context);
                }
                catch (IllegalArgumentException e) {
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("reqNotAUniqueId").replace("<input>", input));
                    return new QuestNPCStartPrompt(context);
                }
            }
            if (input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                context.setSessionData((Object)"npcStart", null);
            }
            if (context.getForWhom() instanceof Player) {
                ConcurrentSkipListSet<UUID> selectingNpcs = QuestMainPrompt.this.plugin.getQuestFactory().getSelectingNpcs();
                selectingNpcs.remove(((Player)context.getForWhom()).getUniqueId());
                QuestMainPrompt.this.plugin.getQuestFactory().setSelectingNpcs(selectingNpcs);
            }
            return new QuestMainPrompt(context);
        }
    }

    public class QuestBlockStartPrompt
    extends QuestsEditorStringPrompt {
        public QuestBlockStartPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("questEditorEnterBlockStart");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestMainPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        /*
         * Enabled aggressive block sorting
         */
        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            Player player = (Player)context.getForWhom();
            if (input.equalsIgnoreCase(BukkitLang.get("cmdDone")) || input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                if (!input.equalsIgnoreCase(BukkitLang.get("cmdDone"))) {
                    ConcurrentHashMap<UUID, Block> selectedBlockStarts = QuestMainPrompt.this.plugin.getQuestFactory().getSelectedBlockStarts();
                    selectedBlockStarts.remove(player.getUniqueId());
                    QuestMainPrompt.this.plugin.getQuestFactory().setSelectedBlockStarts(selectedBlockStarts);
                    return new QuestMainPrompt(context);
                }
                ConcurrentHashMap<UUID, Block> selectedBlockStarts = QuestMainPrompt.this.plugin.getQuestFactory().getSelectedBlockStarts();
                Block block = (Block)selectedBlockStarts.get(player.getUniqueId());
                if (block != null) {
                    Location loc = block.getLocation();
                    context.setSessionData((Object)"blockStart", (Object)loc);
                    selectedBlockStarts.remove(player.getUniqueId());
                    return new QuestMainPrompt(context);
                }
                player.sendMessage(ChatColor.RED + BukkitLang.get("questEditorNoStartBlockSelected"));
                return new QuestBlockStartPrompt(context);
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) return new QuestBlockStartPrompt(context);
            if (context.getForWhom() instanceof Player) {
                ConcurrentHashMap<UUID, Block> selectedBlockStarts = QuestMainPrompt.this.plugin.getQuestFactory().getSelectedBlockStarts();
                selectedBlockStarts.remove(player.getUniqueId());
                QuestMainPrompt.this.plugin.getQuestFactory().setSelectedBlockStarts(selectedBlockStarts);
            }
            context.setSessionData((Object)"blockStart", null);
            return new QuestMainPrompt(context);
        }
    }

    public class QuestRegionPrompt
    extends QuestsEditorStringPrompt {
        public QuestRegionPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("questRegionTitle");
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("questWGPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestMainPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(ChatColor.AQUA + this.getTitle(context) + "\n");
            boolean any = false;
            for (World world : QuestMainPrompt.this.plugin.getServer().getWorlds()) {
                WorldGuardAPI api = QuestMainPrompt.this.plugin.getDependencies().getWorldGuardApi();
                RegionManager regionManager = api.getRegionManager(world);
                if (regionManager == null) continue;
                for (String region : regionManager.getRegions().keySet()) {
                    any = true;
                    text.append(ChatColor.GREEN).append(region).append(", ");
                }
            }
            if (any) {
                text = new StringBuilder(text.substring(0, text.length() - 2) + "\n");
            } else {
                text.append(ChatColor.GRAY).append("(").append(BukkitLang.get("none")).append(")\n");
            }
            return text.toString() + ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel")) && !input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                String found = null;
                boolean done = false;
                for (World world : QuestMainPrompt.this.plugin.getServer().getWorlds()) {
                    WorldGuardAPI api = QuestMainPrompt.this.plugin.getDependencies().getWorldGuardApi();
                    RegionManager regionManager = api.getRegionManager(world);
                    if (regionManager != null) {
                        for (String region : regionManager.getRegions().keySet()) {
                            if (!region.equalsIgnoreCase(input)) continue;
                            found = region;
                            done = true;
                            break;
                        }
                    }
                    if (!done) continue;
                    break;
                }
                if (found == null) {
                    String error = BukkitLang.get("questWGInvalidRegion");
                    error = error.replace("<region>", ChatColor.RED + input + ChatColor.YELLOW);
                    context.getForWhom().sendRawMessage(ChatColor.YELLOW + error);
                    return new QuestRegionPrompt(context);
                }
                context.setSessionData((Object)"region", found);
                return new QuestMainPrompt(context);
            }
            if (input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                context.setSessionData((Object)"region", null);
                context.getForWhom().sendRawMessage(ChatColor.YELLOW + BukkitLang.get("questWGRegionCleared"));
                return new QuestMainPrompt(context);
            }
            return new QuestMainPrompt(context);
        }
    }

    public class QuestGuiDisplayPrompt
    extends QuestsEditorNumericPrompt {
        private final int size = 3;

        public QuestGuiDisplayPrompt(ConversationContext context) {
            super(context);
            this.size = 3;
        }

        @Override
        public int getSize() {
            return 3;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("questGUITitle");
        }

        @Override
        public ChatColor getNumberColor(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.BLUE;
                }
                case 2: {
                    return ChatColor.RED;
                }
                case 3: {
                    return ChatColor.GREEN;
                }
            }
            return null;
        }

        @Override
        public String getSelectionText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.YELLOW + BukkitLang.get("stageEditorDeliveryAddItem");
                }
                case 2: {
                    return ChatColor.YELLOW + BukkitLang.get("clear");
                }
                case 3: {
                    return ChatColor.YELLOW + BukkitLang.get("done");
                }
            }
            return null;
        }

        @Override
        public String getAdditionalText(ConversationContext context, int number) {
            return null;
        }

        @Override
        @NotNull
        public String getBasicPromptText(ConversationContext context) {
            if (context.getSessionData((Object)"tempStack") != null) {
                ItemStack stack = (ItemStack)context.getSessionData((Object)"tempStack");
                if (stack != null) {
                    context.setSessionData((Object)"guiDisplay", (Object)stack.clone());
                }
                ItemStackPrompt.clearSessionData(context);
            }
            QuestsEditorPostOpenNumericPromptEvent event = new QuestsEditorPostOpenNumericPromptEvent(context, this);
            QuestMainPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(ChatColor.GOLD + this.getTitle(context) + "\n");
            if (context.getSessionData((Object)"guiDisplay") != null) {
                ItemStack stack = (ItemStack)context.getSessionData((Object)"guiDisplay");
                text.append(" ").append(ChatColor.RESET).append(BukkitItemUtil.getDisplayString(stack)).append("\n");
            } else {
                text.append(" ").append(ChatColor.GRAY).append("(").append(BukkitLang.get("noneSet")).append(")\n");
            }
            for (int i = 1; i <= 3; ++i) {
                text.append("\n").append(this.getNumberColor(context, i)).append(ChatColor.BOLD).append(i).append(ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i));
            }
            return text.toString();
        }

        protected Prompt acceptValidatedInput(@NotNull ConversationContext context, Number input) {
            switch (input.intValue()) {
                case 1: {
                    return new ItemStackPrompt(context, (Prompt)this);
                }
                case 2: {
                    context.setSessionData((Object)"guiDisplay", null);
                    context.getForWhom().sendRawMessage(ChatColor.YELLOW + BukkitLang.get("questGUICleared"));
                    return new QuestGuiDisplayPrompt(context);
                }
                case 3: {
                    return QuestMainPrompt.this.plugin.getQuestFactory().returnToMenu(context);
                }
            }
            return new QuestGuiDisplayPrompt(context);
        }
    }

    public class QuestSavePrompt
    extends QuestsEditorStringPrompt {
        private final int size = 2;

        public QuestSavePrompt(ConversationContext context) {
            super(context);
            this.size = 2;
        }

        public int getSize() {
            return 2;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        public ChatColor getNumberColor(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.GREEN;
                }
                case 2: {
                    return ChatColor.RED;
                }
            }
            return null;
        }

        public String getSelectionText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.GREEN + BukkitLang.get("yesWord");
                }
                case 2: {
                    return ChatColor.RED + BukkitLang.get("noWord");
                }
            }
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("questEditorSave");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestMainPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(ChatColor.YELLOW + this.getQueryText(context));
            for (int i = 1; i <= 2; ++i) {
                text.append("\n").append(this.getNumberColor(context, i)).append(ChatColor.BOLD).append(i).append(ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i));
            }
            return QuestsNumericPrompt.sendClickableSelection(text.toString(), context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (input.equalsIgnoreCase("1") || input.equalsIgnoreCase(BukkitLang.get("yesWord"))) {
                if (QuestMainPrompt.this.plugin.hasLimitedAccess(context.getForWhom()) && !QuestMainPrompt.this.plugin.getConfigSettings().canTrialSave()) {
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("modeDeny").replace("<mode>", BukkitLang.get("trialMode")));
                    return new QuestMainPrompt(context);
                }
                if (context.getSessionData((Object)"askMessage") == null) {
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("questEditorNeedAskMessage"));
                    return new QuestMainPrompt(context);
                }
                if (context.getSessionData((Object)"finishMessage") == null) {
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("questEditorNeedFinishMessage"));
                    return new QuestMainPrompt(context);
                }
                if (new QuestStageMenuPrompt(context).getStages(context) == 0) {
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("questEditorNeedStages"));
                    return new QuestMainPrompt(context);
                }
                YamlConfiguration data = new YamlConfiguration();
                try {
                    data.load(new File(QuestMainPrompt.this.plugin.getDataFolder(), "storage" + File.separatorChar + "quests.yml"));
                    ConfigurationSection questSection = data.getConfigurationSection("quests");
                    if (questSection == null) {
                        questSection = data.createSection("quests");
                    }
                    ConfigurationSection newSection = null;
                    if (context.getSessionData((Object)"questId") == null) {
                        Locale locale = Locale.US;
                        int padding = 6;
                        String format = "%06d";
                        int num = 1;
                        String customNum = String.format(locale, format, num);
                        while (questSection.contains(customNum)) {
                            customNum = String.format(locale, format, ++num);
                        }
                        newSection = questSection.createSection(customNum);
                    } else {
                        String qid = (String)context.getSessionData((Object)"questId");
                        if (qid != null) {
                            newSection = questSection.createSection(qid);
                        }
                    }
                    if (newSection != null) {
                        QuestMainPrompt.this.plugin.getQuestFactory().saveQuest(context, newSection);
                        data.save(new File(QuestMainPrompt.this.plugin.getDataFolder(), "storage" + File.separatorChar + "quests.yml"));
                        context.getForWhom().sendRawMessage(ChatColor.GREEN + BukkitLang.get("questEditorSaved").replace("<command>", "/questadmin " + BukkitLang.get("COMMAND_QUESTADMIN_RELOAD")));
                    }
                }
                catch (IOException | InvalidConfigurationException e) {
                    e.printStackTrace();
                }
                return Prompt.END_OF_CONVERSATION;
            }
            if (input.equalsIgnoreCase("2") || input.equalsIgnoreCase(BukkitLang.get("noWord"))) {
                return new QuestMainPrompt(context);
            }
            return new QuestSavePrompt(context);
        }
    }

    public class QuestExitPrompt
    extends QuestsEditorStringPrompt {
        private final int size = 2;

        public QuestExitPrompt(ConversationContext context) {
            super(context);
            this.size = 2;
        }

        public int getSize() {
            return 2;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        public ChatColor getNumberColor(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.GREEN;
                }
                case 2: {
                    return ChatColor.RED;
                }
            }
            return null;
        }

        public String getSelectionText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.GREEN + BukkitLang.get("yesWord");
                }
                case 2: {
                    return ChatColor.RED + BukkitLang.get("noWord");
                }
            }
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("confirmDelete");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestMainPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(ChatColor.YELLOW + this.getQueryText(context));
            for (int i = 1; i <= 2; ++i) {
                text.append("\n").append(this.getNumberColor(context, i)).append(ChatColor.BOLD).append(i).append(ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i));
            }
            return QuestsNumericPrompt.sendClickableSelection(text.toString(), context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (input.equalsIgnoreCase("1") || input.equalsIgnoreCase(BukkitLang.get("yesWord"))) {
                context.getForWhom().sendRawMessage(ChatColor.BOLD + "" + ChatColor.YELLOW + BukkitLang.get("exited"));
                return Prompt.END_OF_CONVERSATION;
            }
            if (input.equalsIgnoreCase("2") || input.equalsIgnoreCase(BukkitLang.get("noWord"))) {
                return new QuestMainPrompt(context);
            }
            return new QuestExitPrompt(context);
        }
    }
}

