/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.convo.quests.menu;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.convo.QuestsNumericPrompt;
import me.pikamug.quests.convo.quests.QuestsEditorNumericPrompt;
import me.pikamug.quests.convo.quests.QuestsEditorStringPrompt;
import me.pikamug.quests.convo.quests.main.QuestMainPrompt;
import me.pikamug.quests.events.editor.quests.QuestsEditorPostOpenNumericPromptEvent;
import me.pikamug.quests.events.editor.quests.QuestsEditorPostOpenStringPromptEvent;
import me.pikamug.quests.quests.Quest;
import me.pikamug.quests.util.BukkitLang;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.Prompt;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

public class QuestMenuPrompt
extends QuestsEditorNumericPrompt {
    private final BukkitQuestsPlugin plugin;
    private final int size = 4;

    public QuestMenuPrompt(ConversationContext context) {
        super(context);
        this.plugin = (BukkitQuestsPlugin)context.getPlugin();
    }

    @Override
    public int getSize() {
        return 4;
    }

    @Override
    public String getTitle(ConversationContext context) {
        String title = BukkitLang.get("questEditorTitle");
        return title + (this.plugin.hasLimitedAccess(context.getForWhom()) ? ChatColor.RED + " (" + BukkitLang.get("trialMode") + ")" : "");
    }

    @Override
    public ChatColor getNumberColor(ConversationContext context, int number) {
        switch (number) {
            case 1: 
            case 2: 
            case 3: {
                return ChatColor.BLUE;
            }
            case 4: {
                return ChatColor.RED;
            }
        }
        return null;
    }

    @Override
    public String getSelectionText(ConversationContext context, int number) {
        switch (number) {
            case 1: {
                return ChatColor.YELLOW + BukkitLang.get("questEditorCreate");
            }
            case 2: {
                return ChatColor.YELLOW + BukkitLang.get("questEditorEdit");
            }
            case 3: {
                return ChatColor.YELLOW + BukkitLang.get("questEditorDelete");
            }
            case 4: {
                return ChatColor.RED + BukkitLang.get("exit");
            }
        }
        return null;
    }

    @Override
    public String getAdditionalText(ConversationContext context, int number) {
        return null;
    }

    @Override
    @NotNull
    public String getBasicPromptText(@NotNull ConversationContext context) {
        QuestsEditorPostOpenNumericPromptEvent event = new QuestsEditorPostOpenNumericPromptEvent(context, this);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        StringBuilder text = new StringBuilder(ChatColor.GOLD + this.getTitle(context));
        for (int i = 1; i <= 4; ++i) {
            text.append("\n").append(this.getNumberColor(context, i)).append(ChatColor.BOLD).append(i).append(ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i));
        }
        return text.toString();
    }

    protected Prompt acceptValidatedInput(ConversationContext context, Number input) {
        CommandSender cs = (CommandSender)context.getForWhom();
        switch (input.intValue()) {
            case 1: {
                if (cs.hasPermission("quests.editor.*") || cs.hasPermission("quests.editor.create")) {
                    return new QuestSelectCreatePrompt(context);
                }
                cs.sendMessage(ChatColor.RED + BukkitLang.get("noPermission"));
                return new QuestMenuPrompt(context);
            }
            case 2: {
                if (cs.hasPermission("quests.editor.*") || cs.hasPermission("quests.editor.edit")) {
                    return new QuestSelectEditPrompt(context);
                }
                cs.sendMessage(ChatColor.RED + BukkitLang.get("noPermission"));
                return new QuestMenuPrompt(context);
            }
            case 3: {
                if (cs.hasPermission("quests.editor.*") || cs.hasPermission("quests.editor.delete")) {
                    return new QuestSelectDeletePrompt(context);
                }
                cs.sendMessage(ChatColor.RED + BukkitLang.get("noPermission"));
                return new QuestMenuPrompt(context);
            }
            case 4: {
                context.getForWhom().sendRawMessage(ChatColor.YELLOW + BukkitLang.get("exited"));
                return Prompt.END_OF_CONVERSATION;
            }
        }
        return new QuestMenuPrompt(context);
    }

    public class QuestSelectCreatePrompt
    extends QuestsEditorStringPrompt {
        public QuestSelectCreatePrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("questCreateTitle");
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("questEditorEnterQuestName");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestMenuPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.GOLD + this.getTitle(context) + "\n" + ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("itemCreateInvalidInput"));
                return new QuestSelectCreatePrompt(context);
            }
            if (!(input = input.trim()).equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                for (Quest q : QuestMenuPrompt.this.plugin.getLoadedQuests()) {
                    if (!q.getName().equalsIgnoreCase(input)) continue;
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("questEditorNameExists"));
                    return new QuestSelectCreatePrompt(context);
                }
                List<String> questNames = QuestMenuPrompt.this.plugin.getQuestFactory().getNamesOfQuestsBeingEdited();
                if (questNames.contains(input)) {
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("questEditorBeingEdited"));
                    return new QuestSelectCreatePrompt(context);
                }
                if (input.contains(".") || input.contains(",")) {
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("questEditorInvalidQuestName"));
                    return new QuestSelectCreatePrompt(context);
                }
                if (input.isEmpty()) {
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("itemCreateInvalidInput"));
                    return new QuestSelectCreatePrompt(context);
                }
                context.setSessionData((Object)"questName", (Object)input);
                context.setSessionData((Object)"askMessage", (Object)BukkitLang.get("questEditorDefaultAskMessage"));
                context.setSessionData((Object)"finishMessage", (Object)BukkitLang.get("questEditorDefaultFinishMessage"));
                questNames.add(input);
                QuestMenuPrompt.this.plugin.getQuestFactory().setNamesOfQuestsBeingEdited(questNames);
                return new QuestMainPrompt(context);
            }
            return new QuestMenuPrompt(context);
        }
    }

    public class QuestSelectEditPrompt
    extends QuestsEditorStringPrompt {
        public QuestSelectEditPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("questEditTitle");
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("questEditorEnterQuestName");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestMenuPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            List<String> names = QuestMenuPrompt.this.plugin.getLoadedQuests().stream().map(Quest::getName).collect(Collectors.toList());
            return this.sendClickableMenu(this.getTitle(context), names, this.getQueryText(context), context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                Quest q = QuestMenuPrompt.this.plugin.getQuest(input);
                if (q != null) {
                    QuestMenuPrompt.this.plugin.getQuestFactory().loadQuest(context, q);
                    return new QuestMainPrompt(context);
                }
                context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("questNotFound").replace("<input>", input));
                return new QuestSelectEditPrompt(context);
            }
            return new QuestMenuPrompt(context);
        }
    }

    public class QuestSelectDeletePrompt
    extends QuestsEditorStringPrompt {
        public QuestSelectDeletePrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("questDeleteTitle");
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("questEditorEnterQuestName");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestMenuPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            List<String> names = QuestMenuPrompt.this.plugin.getLoadedQuests().stream().map(Quest::getName).collect(Collectors.toList());
            return this.sendClickableMenu(this.getTitle(context), names, this.getQueryText(context), context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                LinkedList<String> used = new LinkedList<String>();
                Quest found = QuestMenuPrompt.this.plugin.getQuest(input);
                if (found != null) {
                    for (Quest q : QuestMenuPrompt.this.plugin.getLoadedQuests()) {
                        if (!q.getRequirements().getNeededQuestIds().contains(q.getId()) && !q.getRequirements().getBlockQuestIds().contains(q.getId())) continue;
                        used.add(q.getName());
                    }
                    if (used.isEmpty()) {
                        context.setSessionData((Object)"delQuest", (Object)found.getName());
                        return new QuestConfirmDeletePrompt(context);
                    }
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("questEditorQuestAsRequirement1") + " \"" + ChatColor.DARK_PURPLE + context.getSessionData((Object)"delQuest") + ChatColor.RED + "\" " + BukkitLang.get("questEditorQuestAsRequirement2"));
                    for (String s : used) {
                        context.getForWhom().sendRawMessage(ChatColor.RED + "- " + ChatColor.DARK_RED + s);
                    }
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("questEditorQuestAsRequirement3"));
                    return new QuestSelectDeletePrompt(context);
                }
                context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("questNotFound").replace("<input>", input));
                return new QuestSelectDeletePrompt(context);
            }
            return new QuestMenuPrompt(context);
        }
    }

    public class QuestConfirmDeletePrompt
    extends QuestsEditorStringPrompt {
        private final int size = 2;

        public QuestConfirmDeletePrompt(ConversationContext context) {
            super(context);
            this.size = 2;
        }

        public int getSize() {
            return 2;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        public ChatColor getNumberColor(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.GREEN;
                }
                case 2: {
                    return ChatColor.RED;
                }
            }
            return null;
        }

        public String getSelectionText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.GREEN + BukkitLang.get("yesWord");
                }
                case 2: {
                    return ChatColor.RED + BukkitLang.get("noWord");
                }
            }
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("confirmDelete");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestMenuPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(ChatColor.RED + this.getQueryText(context) + " (" + ChatColor.YELLOW + context.getSessionData((Object)"delQuest") + ChatColor.RED + ")\n");
            for (int i = 1; i <= 2; ++i) {
                text.append("\n").append(this.getNumberColor(context, i)).append(ChatColor.BOLD).append(i).append(ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i));
            }
            return QuestsNumericPrompt.sendClickableSelection(text.toString(), context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (input.equalsIgnoreCase("1") || input.equalsIgnoreCase(BukkitLang.get("yesWord"))) {
                QuestMenuPrompt.this.plugin.getQuestFactory().deleteQuest(context);
                return Prompt.END_OF_CONVERSATION;
            }
            if (input.equalsIgnoreCase("2") || input.equalsIgnoreCase(BukkitLang.get("noWord"))) {
                return new QuestMenuPrompt(context);
            }
            return new QuestConfirmDeletePrompt(context);
        }
    }
}

