/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.convo.quests.objectives;

import java.util.LinkedList;
import java.util.List;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.convo.quests.QuestsEditorNumericPrompt;
import me.pikamug.quests.convo.quests.QuestsEditorStringPrompt;
import me.pikamug.quests.convo.quests.stages.QuestStageMainPrompt;
import me.pikamug.quests.events.editor.quests.QuestsEditorPostOpenNumericPromptEvent;
import me.pikamug.quests.events.editor.quests.QuestsEditorPostOpenStringPromptEvent;
import me.pikamug.quests.util.BukkitItemUtil;
import me.pikamug.quests.util.BukkitLang;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.Prompt;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

public class QuestBlocksPrompt
extends QuestsEditorNumericPrompt {
    private final BukkitQuestsPlugin plugin;
    private final int stageNum;
    private final String pref;
    private final int size = 5;

    public QuestBlocksPrompt(int stageNum, ConversationContext context) {
        super(context);
        this.plugin = (BukkitQuestsPlugin)context.getPlugin();
        this.stageNum = stageNum;
        this.pref = "stage" + stageNum;
    }

    @Override
    public int getSize() {
        return 5;
    }

    @Override
    public String getTitle(ConversationContext context) {
        return BukkitLang.get("stageEditorBlocks");
    }

    @Override
    public ChatColor getNumberColor(ConversationContext context, int number) {
        switch (number) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return ChatColor.BLUE;
            }
            case 5: {
                return ChatColor.GREEN;
            }
        }
        return null;
    }

    @Override
    public String getSelectionText(ConversationContext context, int number) {
        switch (number) {
            case 1: {
                return ChatColor.YELLOW + BukkitLang.get("stageEditorBreakBlocks");
            }
            case 2: {
                return ChatColor.YELLOW + BukkitLang.get("stageEditorDamageBlocks");
            }
            case 3: {
                return ChatColor.YELLOW + BukkitLang.get("stageEditorPlaceBlocks");
            }
            case 4: {
                return ChatColor.YELLOW + BukkitLang.get("stageEditorUseBlocks");
            }
            case 5: {
                return ChatColor.GREEN + BukkitLang.get("done");
            }
        }
        return null;
    }

    @Override
    public String getAdditionalText(ConversationContext context, int number) {
        switch (number) {
            case 1: {
                if (context.getSessionData((Object)(this.pref + "breakNames")) == null) {
                    return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                StringBuilder text = new StringBuilder();
                LinkedList names = (LinkedList)context.getSessionData((Object)(this.pref + "breakNames"));
                LinkedList amounts = (LinkedList)context.getSessionData((Object)(this.pref + "breakAmounts"));
                if (names != null && amounts != null) {
                    for (int i = 0; i < names.size(); ++i) {
                        text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.BLUE).append(BukkitItemUtil.getPrettyItemName((String)names.get(i))).append(ChatColor.GRAY).append(" x ").append(ChatColor.DARK_AQUA).append(amounts.get(i));
                    }
                }
                return text.toString();
            }
            case 2: {
                if (context.getSessionData((Object)(this.pref + "damageNames")) == null) {
                    return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                StringBuilder text = new StringBuilder();
                LinkedList names = (LinkedList)context.getSessionData((Object)(this.pref + "damageNames"));
                LinkedList amounts = (LinkedList)context.getSessionData((Object)(this.pref + "damageAmounts"));
                if (names != null && amounts != null) {
                    for (int i = 0; i < names.size(); ++i) {
                        text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.BLUE).append(BukkitItemUtil.getPrettyItemName((String)names.get(i))).append(ChatColor.GRAY).append(" x ").append(ChatColor.DARK_AQUA).append(amounts.get(i));
                    }
                }
                return text.toString();
            }
            case 3: {
                if (context.getSessionData((Object)(this.pref + "placeNames")) == null) {
                    return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                StringBuilder text = new StringBuilder();
                LinkedList names = (LinkedList)context.getSessionData((Object)(this.pref + "placeNames"));
                LinkedList amounts = (LinkedList)context.getSessionData((Object)(this.pref + "placeAmounts"));
                if (names != null && amounts != null) {
                    for (int i = 0; i < names.size(); ++i) {
                        text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.BLUE).append(BukkitItemUtil.getPrettyItemName((String)names.get(i))).append(ChatColor.GRAY).append(" x ").append(ChatColor.DARK_AQUA).append(amounts.get(i));
                    }
                }
                return text.toString();
            }
            case 4: {
                if (context.getSessionData((Object)(this.pref + "useNames")) == null) {
                    return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                StringBuilder text = new StringBuilder();
                LinkedList names = (LinkedList)context.getSessionData((Object)(this.pref + "useNames"));
                LinkedList amounts = (LinkedList)context.getSessionData((Object)(this.pref + "useAmounts"));
                if (names != null && amounts != null) {
                    for (int i = 0; i < names.size(); ++i) {
                        text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.BLUE).append(BukkitItemUtil.getPrettyItemName((String)names.get(i))).append(ChatColor.GRAY).append(" x ").append(ChatColor.DARK_AQUA).append(amounts.get(i));
                    }
                }
                return text.toString();
            }
            case 5: {
                return "";
            }
        }
        return null;
    }

    @Override
    @NotNull
    public String getBasicPromptText(ConversationContext context) {
        context.setSessionData((Object)this.pref, (Object)Boolean.TRUE);
        QuestsEditorPostOpenNumericPromptEvent event = new QuestsEditorPostOpenNumericPromptEvent(context, this);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        StringBuilder text = new StringBuilder(ChatColor.AQUA + "- " + this.getTitle(context) + " -");
        for (int i = 1; i <= 5; ++i) {
            text.append("\n").append(this.getNumberColor(context, i)).append(ChatColor.BOLD).append(i).append(ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i)).append(" ").append(this.getAdditionalText(context, i));
        }
        return text.toString();
    }

    protected Prompt acceptValidatedInput(@NotNull ConversationContext context, Number input) {
        switch (input.intValue()) {
            case 1: {
                return new QuestBlocksBreakListPrompt(context);
            }
            case 2: {
                return new QuestBlocksDamageListPrompt(context);
            }
            case 3: {
                return new QuestBlocksPlaceListPrompt(context);
            }
            case 4: {
                return new QuestBlocksUseListPrompt(context);
            }
            case 5: {
                try {
                    return new QuestStageMainPrompt(this.stageNum, context);
                }
                catch (Exception e) {
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("itemCreateCriticalError"));
                    return Prompt.END_OF_CONVERSATION;
                }
            }
        }
        return new QuestBlocksPrompt(this.stageNum, context);
    }

    public class QuestBlocksBreakListPrompt
    extends QuestsEditorNumericPrompt {
        private final int size = 5;

        public QuestBlocksBreakListPrompt(ConversationContext context) {
            super(context);
            this.size = 5;
        }

        @Override
        public int getSize() {
            return 5;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("stageEditorBreakBlocks");
        }

        @Override
        public ChatColor getNumberColor(ConversationContext context, int number) {
            switch (number) {
                case 1: 
                case 2: 
                case 3: {
                    return ChatColor.BLUE;
                }
                case 4: {
                    return ChatColor.RED;
                }
                case 5: {
                    return ChatColor.GREEN;
                }
            }
            return null;
        }

        @Override
        public String getSelectionText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.YELLOW + BukkitLang.get("stageEditorSetBlockNames");
                }
                case 2: {
                    return ChatColor.YELLOW + BukkitLang.get("stageEditorSetBlockAmounts");
                }
                case 3: {
                    return ChatColor.YELLOW + BukkitLang.get("stageEditorSetBlockDurability");
                }
                case 4: {
                    return ChatColor.RED + BukkitLang.get("clear");
                }
                case 5: {
                    return ChatColor.GREEN + BukkitLang.get("done");
                }
            }
            return null;
        }

        @Override
        public String getAdditionalText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    if (context.getSessionData((Object)(QuestBlocksPrompt.this.pref + "breakNames")) != null) {
                        StringBuilder text = new StringBuilder();
                        List breakNames = (List)context.getSessionData((Object)(QuestBlocksPrompt.this.pref + "breakNames"));
                        if (breakNames != null) {
                            for (String s : breakNames) {
                                text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.AQUA).append(BukkitItemUtil.getPrettyItemName(s));
                            }
                        }
                        return text.toString();
                    }
                    return "";
                }
                case 2: {
                    if (context.getSessionData((Object)(QuestBlocksPrompt.this.pref + "breakAmounts")) != null) {
                        StringBuilder text = new StringBuilder();
                        List breakAmounts = (List)context.getSessionData((Object)(QuestBlocksPrompt.this.pref + "breakAmounts"));
                        if (breakAmounts != null) {
                            for (Integer i : breakAmounts) {
                                text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.AQUA).append(i);
                            }
                        }
                        return text.toString();
                    }
                    return "";
                }
                case 3: {
                    if (context.getSessionData((Object)(QuestBlocksPrompt.this.pref + "breakDurability")) != null) {
                        StringBuilder text = new StringBuilder();
                        List breakDurability = (List)context.getSessionData((Object)(QuestBlocksPrompt.this.pref + "breakDurability"));
                        if (breakDurability != null) {
                            for (Short s : breakDurability) {
                                text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.AQUA).append(s);
                            }
                        }
                        return text.toString();
                    }
                    return "";
                }
                case 4: 
                case 5: {
                    return "";
                }
            }
            return null;
        }

        @Override
        @NotNull
        public String getBasicPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenNumericPromptEvent event = new QuestsEditorPostOpenNumericPromptEvent(context, this);
            QuestBlocksPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(ChatColor.GOLD + "- " + this.getTitle(context) + " -");
            for (int i = 1; i <= 5; ++i) {
                text.append("\n").append(this.getNumberColor(context, i)).append(ChatColor.BOLD).append(i).append(ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i)).append(" ").append(this.getAdditionalText(context, i));
            }
            return text.toString();
        }

        protected Prompt acceptValidatedInput(@NotNull ConversationContext context, Number input) {
            switch (input.intValue()) {
                case 1: {
                    return new QuestBlockBreakNamesPrompt(context);
                }
                case 2: {
                    return new QuestBlockBreakAmountsPrompt(context);
                }
                case 3: {
                    return new QuestBlockBreakDurabilityPrompt(context);
                }
                case 4: {
                    context.getForWhom().sendRawMessage(ChatColor.YELLOW + BukkitLang.get("stageEditorObjectiveCleared"));
                    context.setSessionData((Object)(QuestBlocksPrompt.this.pref + "breakNames"), null);
                    context.setSessionData((Object)(QuestBlocksPrompt.this.pref + "breakAmounts"), null);
                    context.setSessionData((Object)(QuestBlocksPrompt.this.pref + "breakDurability"), null);
                    return new QuestBlocksBreakListPrompt(context);
                }
                case 5: {
                    List names = (List)context.getSessionData((Object)(QuestBlocksPrompt.this.pref + "breakNames"));
                    List amounts = (List)context.getSessionData((Object)(QuestBlocksPrompt.this.pref + "breakAmounts"));
                    int one = names != null ? names.size() : 0;
                    int two = amounts != null ? amounts.size() : 0;
                    if (one == two) {
                        int missing;
                        LinkedList<Short> durability = (LinkedList<Short>)context.getSessionData((Object)(QuestBlocksPrompt.this.pref + "breakDurability"));
                        if (durability != null) {
                            missing = one - durability.size();
                        } else {
                            missing = one;
                            durability = new LinkedList<Short>();
                        }
                        for (int i = 0; i < missing; ++i) {
                            durability.add((short)0);
                        }
                        context.setSessionData((Object)(QuestBlocksPrompt.this.pref + "breakDurability"), durability);
                        return new QuestBlocksPrompt(QuestBlocksPrompt.this.stageNum, context);
                    }
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("listsNotSameSize"));
                    return new QuestBlocksBreakListPrompt(context);
                }
            }
            return new QuestBlocksPrompt(QuestBlocksPrompt.this.stageNum, context);
        }
    }

    public class QuestBlocksDamageListPrompt
    extends QuestsEditorNumericPrompt {
        private final int size = 5;

        public QuestBlocksDamageListPrompt(ConversationContext context) {
            super(context);
            this.size = 5;
        }

        @Override
        public int getSize() {
            return 5;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("stageEditorDamageBlocks");
        }

        @Override
        public ChatColor getNumberColor(ConversationContext context, int number) {
            switch (number) {
                case 1: 
                case 2: 
                case 3: {
                    return ChatColor.BLUE;
                }
                case 4: {
                    return ChatColor.RED;
                }
                case 5: {
                    return ChatColor.GREEN;
                }
            }
            return null;
        }

        @Override
        public String getSelectionText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.YELLOW + BukkitLang.get("stageEditorSetBlockNames");
                }
                case 2: {
                    return ChatColor.YELLOW + BukkitLang.get("stageEditorSetBlockAmounts");
                }
                case 3: {
                    return ChatColor.YELLOW + BukkitLang.get("stageEditorSetBlockDurability");
                }
                case 4: {
                    return ChatColor.RED + BukkitLang.get("clear");
                }
                case 5: {
                    return ChatColor.GREEN + BukkitLang.get("done");
                }
            }
            return null;
        }

        @Override
        public String getAdditionalText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    if (context.getSessionData((Object)(QuestBlocksPrompt.this.pref + "damageNames")) != null) {
                        StringBuilder text = new StringBuilder();
                        List damageNames = (List)context.getSessionData((Object)(QuestBlocksPrompt.this.pref + "damageNames"));
                        if (damageNames != null) {
                            for (String s : damageNames) {
                                text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.AQUA).append(BukkitItemUtil.getPrettyItemName(s));
                            }
                        }
                        return text.toString();
                    }
                    return "";
                }
                case 2: {
                    if (context.getSessionData((Object)(QuestBlocksPrompt.this.pref + "damageAmounts")) != null) {
                        StringBuilder text = new StringBuilder();
                        List damageAmounts = (List)context.getSessionData((Object)(QuestBlocksPrompt.this.pref + "damageAmounts"));
                        if (damageAmounts != null) {
                            for (Integer i : damageAmounts) {
                                text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.AQUA).append(i);
                            }
                        }
                        return text.toString();
                    }
                    return "";
                }
                case 3: {
                    if (context.getSessionData((Object)(QuestBlocksPrompt.this.pref + "damageDurability")) != null) {
                        StringBuilder text = new StringBuilder();
                        List damageDurability = (List)context.getSessionData((Object)(QuestBlocksPrompt.this.pref + "damageDurability"));
                        if (damageDurability != null) {
                            for (Short s : damageDurability) {
                                text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.AQUA).append(s);
                            }
                        }
                        return text.toString();
                    }
                    return "";
                }
                case 4: 
                case 5: {
                    return "";
                }
            }
            return null;
        }

        @Override
        @NotNull
        public String getBasicPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenNumericPromptEvent event = new QuestsEditorPostOpenNumericPromptEvent(context, this);
            QuestBlocksPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(ChatColor.GOLD + "- " + this.getTitle(context) + " -");
            for (int i = 1; i <= 5; ++i) {
                text.append("\n").append(this.getNumberColor(context, i)).append(ChatColor.BOLD).append(i).append(ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i)).append(" ").append(this.getAdditionalText(context, i));
            }
            return text.toString();
        }

        protected Prompt acceptValidatedInput(@NotNull ConversationContext context, Number input) {
            switch (input.intValue()) {
                case 1: {
                    return new QuestBlockDamageNamesPrompt(context);
                }
                case 2: {
                    return new QuestBlockDamageAmountsPrompt(context);
                }
                case 3: {
                    return new QuestBlockDamageDurabilityPrompt(context);
                }
                case 4: {
                    context.getForWhom().sendRawMessage(ChatColor.YELLOW + BukkitLang.get("stageEditorObjectiveCleared"));
                    context.setSessionData((Object)(QuestBlocksPrompt.this.pref + "damageNames"), null);
                    context.setSessionData((Object)(QuestBlocksPrompt.this.pref + "damageAmounts"), null);
                    context.setSessionData((Object)(QuestBlocksPrompt.this.pref + "damageDurability"), null);
                    return new QuestBlocksDamageListPrompt(context);
                }
                case 5: {
                    List names = (List)context.getSessionData((Object)(QuestBlocksPrompt.this.pref + "damageNames"));
                    List amounts = (List)context.getSessionData((Object)(QuestBlocksPrompt.this.pref + "damageAmounts"));
                    int one = names != null ? names.size() : 0;
                    int two = amounts != null ? amounts.size() : 0;
                    if (one == two) {
                        int missing;
                        LinkedList<Short> durability = (LinkedList<Short>)context.getSessionData((Object)(QuestBlocksPrompt.this.pref + "damageDurability"));
                        if (durability != null) {
                            missing = one - durability.size();
                        } else {
                            missing = one;
                            durability = new LinkedList<Short>();
                        }
                        for (int i = 0; i < missing; ++i) {
                            durability.add((short)0);
                        }
                        context.setSessionData((Object)(QuestBlocksPrompt.this.pref + "damageDurability"), durability);
                        return new QuestBlocksPrompt(QuestBlocksPrompt.this.stageNum, context);
                    }
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("listsNotSameSize"));
                    return new QuestBlocksDamageListPrompt(context);
                }
            }
            return new QuestBlocksPrompt(QuestBlocksPrompt.this.stageNum, context);
        }
    }

    public class QuestBlocksPlaceListPrompt
    extends QuestsEditorNumericPrompt {
        private final int size = 5;

        public QuestBlocksPlaceListPrompt(ConversationContext context) {
            super(context);
            this.size = 5;
        }

        @Override
        public int getSize() {
            return 5;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("stageEditorPlaceBlocks");
        }

        @Override
        public ChatColor getNumberColor(ConversationContext context, int number) {
            switch (number) {
                case 1: 
                case 2: 
                case 3: {
                    return ChatColor.BLUE;
                }
                case 4: {
                    return ChatColor.RED;
                }
                case 5: {
                    return ChatColor.GREEN;
                }
            }
            return null;
        }

        @Override
        public String getSelectionText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.YELLOW + BukkitLang.get("stageEditorSetBlockNames");
                }
                case 2: {
                    return ChatColor.YELLOW + BukkitLang.get("stageEditorSetBlockAmounts");
                }
                case 3: {
                    return ChatColor.YELLOW + BukkitLang.get("stageEditorSetBlockDurability");
                }
                case 4: {
                    return ChatColor.RED + BukkitLang.get("clear");
                }
                case 5: {
                    return ChatColor.GREEN + BukkitLang.get("done");
                }
            }
            return null;
        }

        @Override
        public String getAdditionalText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    if (context.getSessionData((Object)(QuestBlocksPrompt.this.pref + "placeNames")) != null) {
                        StringBuilder text = new StringBuilder();
                        List placeNames = (List)context.getSessionData((Object)(QuestBlocksPrompt.this.pref + "placeNames"));
                        if (placeNames != null) {
                            for (String s : placeNames) {
                                text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.AQUA).append(BukkitItemUtil.getPrettyItemName(s));
                            }
                        }
                        return text.toString();
                    }
                    return "";
                }
                case 2: {
                    if (context.getSessionData((Object)(QuestBlocksPrompt.this.pref + "placeAmounts")) != null) {
                        StringBuilder text = new StringBuilder();
                        List placeAmounts = (List)context.getSessionData((Object)(QuestBlocksPrompt.this.pref + "placeAmounts"));
                        if (placeAmounts != null) {
                            for (Integer i : placeAmounts) {
                                text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.AQUA).append(i);
                            }
                        }
                        return text.toString();
                    }
                    return "";
                }
                case 3: {
                    if (context.getSessionData((Object)(QuestBlocksPrompt.this.pref + "placeDurability")) != null) {
                        StringBuilder text = new StringBuilder();
                        List placeDurability = (List)context.getSessionData((Object)(QuestBlocksPrompt.this.pref + "placeDurability"));
                        if (placeDurability != null) {
                            for (Short s : placeDurability) {
                                text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.AQUA).append(s);
                            }
                        }
                        return text.toString();
                    }
                    return "";
                }
                case 4: 
                case 5: {
                    return "";
                }
            }
            return null;
        }

        @Override
        @NotNull
        public String getBasicPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenNumericPromptEvent event = new QuestsEditorPostOpenNumericPromptEvent(context, this);
            QuestBlocksPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(ChatColor.GOLD + "- " + this.getTitle(context) + " -");
            for (int i = 1; i <= 5; ++i) {
                text.append("\n").append(this.getNumberColor(context, i)).append(ChatColor.BOLD).append(i).append(ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i)).append(" ").append(this.getAdditionalText(context, i));
            }
            return text.toString();
        }

        protected Prompt acceptValidatedInput(@NotNull ConversationContext context, Number input) {
            switch (input.intValue()) {
                case 1: {
                    return new QuestBlockPlaceNamesPrompt(context);
                }
                case 2: {
                    return new QuestBlockPlaceAmountsPrompt(context);
                }
                case 3: {
                    return new QuestBlockPlaceDurabilityPrompt(context);
                }
                case 4: {
                    context.getForWhom().sendRawMessage(ChatColor.YELLOW + BukkitLang.get("stageEditorObjectiveCleared"));
                    context.setSessionData((Object)(QuestBlocksPrompt.this.pref + "placeNames"), null);
                    context.setSessionData((Object)(QuestBlocksPrompt.this.pref + "placeAmounts"), null);
                    context.setSessionData((Object)(QuestBlocksPrompt.this.pref + "placeDurability"), null);
                    return new QuestBlocksPlaceListPrompt(context);
                }
                case 5: {
                    List names = (List)context.getSessionData((Object)(QuestBlocksPrompt.this.pref + "placeNames"));
                    List amounts = (List)context.getSessionData((Object)(QuestBlocksPrompt.this.pref + "placeAmounts"));
                    int one = names != null ? names.size() : 0;
                    int two = amounts != null ? amounts.size() : 0;
                    if (one == two) {
                        int missing;
                        LinkedList<Short> durability = (LinkedList<Short>)context.getSessionData((Object)(QuestBlocksPrompt.this.pref + "placeDurability"));
                        if (durability != null) {
                            missing = one - durability.size();
                        } else {
                            missing = one;
                            durability = new LinkedList<Short>();
                        }
                        for (int i = 0; i < missing; ++i) {
                            durability.add((short)0);
                        }
                        context.setSessionData((Object)(QuestBlocksPrompt.this.pref + "placeDurability"), durability);
                        return new QuestBlocksPrompt(QuestBlocksPrompt.this.stageNum, context);
                    }
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("listsNotSameSize"));
                    return new QuestBlocksPlaceListPrompt(context);
                }
            }
            return new QuestBlocksPrompt(QuestBlocksPrompt.this.stageNum, context);
        }
    }

    public class QuestBlocksUseListPrompt
    extends QuestsEditorNumericPrompt {
        private final int size = 5;

        public QuestBlocksUseListPrompt(ConversationContext context) {
            super(context);
            this.size = 5;
        }

        @Override
        public int getSize() {
            return 5;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("stageEditorUseBlocks");
        }

        @Override
        public ChatColor getNumberColor(ConversationContext context, int number) {
            switch (number) {
                case 1: 
                case 2: 
                case 3: {
                    return ChatColor.BLUE;
                }
                case 4: {
                    return ChatColor.RED;
                }
                case 5: {
                    return ChatColor.GREEN;
                }
            }
            return null;
        }

        @Override
        public String getSelectionText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.YELLOW + BukkitLang.get("stageEditorSetBlockNames");
                }
                case 2: {
                    return ChatColor.YELLOW + BukkitLang.get("stageEditorSetBlockAmounts");
                }
                case 3: {
                    return ChatColor.YELLOW + BukkitLang.get("stageEditorSetBlockDurability");
                }
                case 4: {
                    return ChatColor.RED + BukkitLang.get("clear");
                }
                case 5: {
                    return ChatColor.GREEN + BukkitLang.get("done");
                }
            }
            return null;
        }

        @Override
        public String getAdditionalText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    if (context.getSessionData((Object)(QuestBlocksPrompt.this.pref + "useNames")) != null) {
                        StringBuilder text = new StringBuilder();
                        List useNames = (List)context.getSessionData((Object)(QuestBlocksPrompt.this.pref + "useNames"));
                        if (useNames != null) {
                            for (String s : useNames) {
                                text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.AQUA).append(BukkitItemUtil.getPrettyItemName(s));
                            }
                        }
                        return text.toString();
                    }
                    return "";
                }
                case 2: {
                    if (context.getSessionData((Object)(QuestBlocksPrompt.this.pref + "useAmounts")) != null) {
                        StringBuilder text = new StringBuilder();
                        List useAmounts = (List)context.getSessionData((Object)(QuestBlocksPrompt.this.pref + "useAmounts"));
                        if (useAmounts != null) {
                            for (Integer i : useAmounts) {
                                text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.AQUA).append(i);
                            }
                        }
                        return text.toString();
                    }
                    return "";
                }
                case 3: {
                    if (context.getSessionData((Object)(QuestBlocksPrompt.this.pref + "useDurability")) != null) {
                        StringBuilder text = new StringBuilder();
                        List useDurability = (List)context.getSessionData((Object)(QuestBlocksPrompt.this.pref + "useDurability"));
                        if (useDurability != null) {
                            for (Short s : useDurability) {
                                text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.AQUA).append(s);
                            }
                        }
                        return text.toString();
                    }
                    return "";
                }
                case 4: 
                case 5: {
                    return "";
                }
            }
            return null;
        }

        @Override
        @NotNull
        public String getBasicPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenNumericPromptEvent event = new QuestsEditorPostOpenNumericPromptEvent(context, this);
            QuestBlocksPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(ChatColor.GOLD + "- " + this.getTitle(context) + " -");
            for (int i = 1; i <= 5; ++i) {
                text.append("\n").append(this.getNumberColor(context, i)).append(ChatColor.BOLD).append(i).append(ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i)).append(" ").append(this.getAdditionalText(context, i));
            }
            return text.toString();
        }

        protected Prompt acceptValidatedInput(@NotNull ConversationContext context, Number input) {
            switch (input.intValue()) {
                case 1: {
                    return new QuestBlockUseNamesPrompt(context);
                }
                case 2: {
                    return new QuestBlockUseAmountsPrompt(context);
                }
                case 3: {
                    return new QuestBlockUseDurabilityPrompt(context);
                }
                case 4: {
                    context.getForWhom().sendRawMessage(ChatColor.YELLOW + BukkitLang.get("stageEditorObjectiveCleared"));
                    context.setSessionData((Object)(QuestBlocksPrompt.this.pref + "useNames"), null);
                    context.setSessionData((Object)(QuestBlocksPrompt.this.pref + "useAmounts"), null);
                    context.setSessionData((Object)(QuestBlocksPrompt.this.pref + "useDurability"), null);
                    return new QuestBlocksUseListPrompt(context);
                }
                case 5: {
                    List names = (List)context.getSessionData((Object)(QuestBlocksPrompt.this.pref + "useNames"));
                    List amounts = (List)context.getSessionData((Object)(QuestBlocksPrompt.this.pref + "useAmounts"));
                    int one = names != null ? names.size() : 0;
                    int two = amounts != null ? amounts.size() : 0;
                    if (one == two) {
                        int missing;
                        LinkedList<Short> durability = (LinkedList<Short>)context.getSessionData((Object)(QuestBlocksPrompt.this.pref + "useDurability"));
                        if (durability != null) {
                            missing = one - durability.size();
                        } else {
                            missing = one;
                            durability = new LinkedList<Short>();
                        }
                        for (int i = 0; i < missing; ++i) {
                            durability.add((short)0);
                        }
                        context.setSessionData((Object)(QuestBlocksPrompt.this.pref + "useDurability"), durability);
                        return new QuestBlocksPrompt(QuestBlocksPrompt.this.stageNum, context);
                    }
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("listsNotSameSize"));
                    return new QuestBlocksUseListPrompt(context);
                }
            }
            return new QuestBlocksPrompt(QuestBlocksPrompt.this.stageNum, context);
        }
    }

    public class QuestBlockUseDurabilityPrompt
    extends QuestsEditorStringPrompt {
        public QuestBlockUseDurabilityPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("stageEditorEnterBlockDurability");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestBlocksPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                String[] args = input.split(" ");
                LinkedList<Short> durability = new LinkedList<Short>();
                for (String s : args) {
                    try {
                        if (Short.parseShort(s) < 0) {
                            context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("invalidMinimum").replace("<number>", "0"));
                            return new QuestBlockUseDurabilityPrompt(context);
                        }
                        durability.add(Short.parseShort(s));
                    }
                    catch (NumberFormatException e) {
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("stageEditorNotListOfNumbers").replace("<data>", s));
                        return new QuestBlockUseDurabilityPrompt(context);
                    }
                }
                context.setSessionData((Object)(QuestBlocksPrompt.this.pref + "useDurability"), durability);
            }
            return new QuestBlocksUseListPrompt(context);
        }
    }

    public class QuestBlockUseAmountsPrompt
    extends QuestsEditorStringPrompt {
        public QuestBlockUseAmountsPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("stageEditorEnterBlockAmounts");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestBlocksPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                String[] args = input.split(" ");
                LinkedList<Integer> amounts = new LinkedList<Integer>();
                for (String s : args) {
                    try {
                        if (Integer.parseInt(s) <= 0) {
                            context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("invalidMinimum").replace("<number>", "1"));
                            return new QuestBlockUseAmountsPrompt(context);
                        }
                        amounts.add(Integer.parseInt(s));
                    }
                    catch (NumberFormatException e) {
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("stageEditorNotListOfNumbers").replace("<data>", s));
                        return new QuestBlockUseAmountsPrompt(context);
                    }
                }
                context.setSessionData((Object)(QuestBlocksPrompt.this.pref + "useAmounts"), amounts);
            }
            return new QuestBlocksUseListPrompt(context);
        }
    }

    public class QuestBlockUseNamesPrompt
    extends QuestsEditorStringPrompt {
        public QuestBlockUseNamesPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("stageEditorEnterBlockNames");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestBlocksPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                String[] args = input.split(" ");
                LinkedList<String> names = new LinkedList<String>();
                for (String s : args) {
                    try {
                        Material m = Material.matchMaterial((String)s);
                        if (m != null) {
                            if (!m.isBlock()) {
                                context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("stageEditorNotSolid").replace("<input>", s));
                                return new QuestBlockUseNamesPrompt(context);
                            }
                        } else {
                            context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("stageEditorInvalidBlockName").replace("<input>", s));
                            return new QuestBlockUseNamesPrompt(context);
                        }
                        names.add(m.name());
                    }
                    catch (NumberFormatException e) {
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("stageEditorNotListOfNumbers").replace("<data>", s));
                        return new QuestBlockUseNamesPrompt(context);
                    }
                }
                context.setSessionData((Object)(QuestBlocksPrompt.this.pref + "useNames"), names);
                LinkedList amounts = new LinkedList();
                if (context.getSessionData((Object)(QuestBlocksPrompt.this.pref + "useAmounts")) != null) {
                    amounts = (LinkedList)context.getSessionData((Object)(QuestBlocksPrompt.this.pref + "useAmounts"));
                }
                for (int i = 0; i < names.size(); ++i) {
                    if (amounts == null || i < amounts.size()) continue;
                    amounts.add(1);
                }
                context.setSessionData((Object)(QuestBlocksPrompt.this.pref + "useAmounts"), (Object)amounts);
            }
            return new QuestBlocksUseListPrompt(context);
        }
    }

    public class QuestBlockPlaceDurabilityPrompt
    extends QuestsEditorStringPrompt {
        public QuestBlockPlaceDurabilityPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("stageEditorEnterBlockDurability");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestBlocksPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                String[] args = input.split(" ");
                LinkedList<Short> durability = new LinkedList<Short>();
                for (String s : args) {
                    try {
                        if (Short.parseShort(s) < 0) {
                            context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("invalidMinimum").replace("<number>", "0"));
                            return new QuestBlockPlaceDurabilityPrompt(context);
                        }
                        durability.add(Short.parseShort(s));
                    }
                    catch (NumberFormatException e) {
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("stageEditorNotListOfNumbers").replace("<data>", s));
                        return new QuestBlockPlaceDurabilityPrompt(context);
                    }
                }
                context.setSessionData((Object)(QuestBlocksPrompt.this.pref + "placeDurability"), durability);
            }
            return new QuestBlocksPlaceListPrompt(context);
        }
    }

    public class QuestBlockPlaceAmountsPrompt
    extends QuestsEditorStringPrompt {
        public QuestBlockPlaceAmountsPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("stageEditorEnterBlockAmounts");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestBlocksPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                String[] args = input.split(" ");
                LinkedList<Integer> amounts = new LinkedList<Integer>();
                for (String s : args) {
                    try {
                        if (Integer.parseInt(s) <= 0) {
                            context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("invalidMinimum").replace("<number>", "1"));
                            return new QuestBlockPlaceAmountsPrompt(context);
                        }
                        amounts.add(Integer.parseInt(s));
                    }
                    catch (NumberFormatException e) {
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("stageEditorNotListOfNumbers").replace("<data>", s));
                        return new QuestBlockPlaceAmountsPrompt(context);
                    }
                }
                context.setSessionData((Object)(QuestBlocksPrompt.this.pref + "placeAmounts"), amounts);
            }
            return new QuestBlocksPlaceListPrompt(context);
        }
    }

    public class QuestBlockPlaceNamesPrompt
    extends QuestsEditorStringPrompt {
        public QuestBlockPlaceNamesPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("stageEditorEnterBlockNames");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestBlocksPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                String[] args = input.split(" ");
                LinkedList<String> names = new LinkedList<String>();
                for (String s : args) {
                    try {
                        Material m = Material.matchMaterial((String)s);
                        if (m != null) {
                            if (!m.isBlock()) {
                                context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("stageEditorNotSolid").replace("<input>", s));
                                return new QuestBlockPlaceNamesPrompt(context);
                            }
                        } else {
                            context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("stageEditorInvalidBlockName").replace("<input>", s));
                            return new QuestBlockPlaceNamesPrompt(context);
                        }
                        names.add(m.name());
                    }
                    catch (NumberFormatException e) {
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("stageEditorNotListOfNumbers").replace("<data>", s));
                        return new QuestBlockPlaceNamesPrompt(context);
                    }
                }
                context.setSessionData((Object)(QuestBlocksPrompt.this.pref + "placeNames"), names);
                LinkedList amounts = new LinkedList();
                if (context.getSessionData((Object)(QuestBlocksPrompt.this.pref + "placeAmounts")) != null) {
                    amounts = (LinkedList)context.getSessionData((Object)(QuestBlocksPrompt.this.pref + "placeAmounts"));
                }
                for (int i = 0; i < names.size(); ++i) {
                    if (amounts == null || i < amounts.size()) continue;
                    amounts.add(1);
                }
                context.setSessionData((Object)(QuestBlocksPrompt.this.pref + "placeAmounts"), (Object)amounts);
            }
            return new QuestBlocksPlaceListPrompt(context);
        }
    }

    public class QuestBlockDamageDurabilityPrompt
    extends QuestsEditorStringPrompt {
        public QuestBlockDamageDurabilityPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("stageEditorEnterBlockDurability");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestBlocksPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                String[] args = input.split(" ");
                LinkedList<Short> durability = new LinkedList<Short>();
                for (String s : args) {
                    try {
                        if (Short.parseShort(s) < 0) {
                            context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("invalidMinimum").replace("<number>", "0"));
                            return new QuestBlockDamageDurabilityPrompt(context);
                        }
                        durability.add(Short.parseShort(s));
                    }
                    catch (NumberFormatException e) {
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("stageEditorNotListOfNumbers").replace("<data>", s));
                        return new QuestBlockDamageDurabilityPrompt(context);
                    }
                }
                context.setSessionData((Object)(QuestBlocksPrompt.this.pref + "damageDurability"), durability);
            }
            return new QuestBlocksDamageListPrompt(context);
        }
    }

    public class QuestBlockDamageAmountsPrompt
    extends QuestsEditorStringPrompt {
        public QuestBlockDamageAmountsPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("stageEditorEnterBlockAmounts");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestBlocksPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                String[] args = input.split(" ");
                LinkedList<Integer> amounts = new LinkedList<Integer>();
                for (String s : args) {
                    try {
                        if (Integer.parseInt(s) <= 0) {
                            context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("invalidMinimum").replace("<number>", "1"));
                            return new QuestBlockDamageAmountsPrompt(context);
                        }
                        amounts.add(Integer.parseInt(s));
                    }
                    catch (NumberFormatException e) {
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("stageEditorNotListOfNumbers").replace("<data>", s));
                        return new QuestBlockDamageAmountsPrompt(context);
                    }
                }
                context.setSessionData((Object)(QuestBlocksPrompt.this.pref + "damageAmounts"), amounts);
            }
            return new QuestBlocksDamageListPrompt(context);
        }
    }

    public class QuestBlockDamageNamesPrompt
    extends QuestsEditorStringPrompt {
        public QuestBlockDamageNamesPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("stageEditorEnterBlockNames");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestBlocksPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                String[] args = input.split(" ");
                LinkedList<String> names = new LinkedList<String>();
                for (String s : args) {
                    try {
                        Material m = Material.matchMaterial((String)s);
                        if (m != null) {
                            if (!m.isBlock()) {
                                context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("stageEditorNotSolid").replace("<input>", s));
                                return new QuestBlockDamageNamesPrompt(context);
                            }
                        } else {
                            context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("stageEditorInvalidBlockName").replace("<input>", s));
                            return new QuestBlockDamageNamesPrompt(context);
                        }
                        names.add(m.name());
                    }
                    catch (NumberFormatException e) {
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("stageEditorNotListOfNumbers").replace("<data>", s));
                        return new QuestBlockDamageNamesPrompt(context);
                    }
                }
                context.setSessionData((Object)(QuestBlocksPrompt.this.pref + "damageNames"), names);
                LinkedList amounts = new LinkedList();
                if (context.getSessionData((Object)(QuestBlocksPrompt.this.pref + "damageAmounts")) != null) {
                    amounts = (LinkedList)context.getSessionData((Object)(QuestBlocksPrompt.this.pref + "damageAmounts"));
                }
                for (int i = 0; i < names.size(); ++i) {
                    if (amounts == null || i < amounts.size()) continue;
                    amounts.add(1);
                }
                context.setSessionData((Object)(QuestBlocksPrompt.this.pref + "damageAmounts"), (Object)amounts);
            }
            return new QuestBlocksDamageListPrompt(context);
        }
    }

    public class QuestBlockBreakDurabilityPrompt
    extends QuestsEditorStringPrompt {
        public QuestBlockBreakDurabilityPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("stageEditorEnterBlockDurability");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestBlocksPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                String[] args = input.split(" ");
                LinkedList<Short> durability = new LinkedList<Short>();
                for (String s : args) {
                    try {
                        if (Short.parseShort(s) < 0) {
                            context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("invalidMinimum").replace("<number>", "0"));
                            return new QuestBlockBreakDurabilityPrompt(context);
                        }
                        durability.add(Short.parseShort(s));
                    }
                    catch (NumberFormatException e) {
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("stageEditorNotListOfNumbers").replace("<data>", s));
                        return new QuestBlockBreakDurabilityPrompt(context);
                    }
                }
                context.setSessionData((Object)(QuestBlocksPrompt.this.pref + "breakDurability"), durability);
            }
            return new QuestBlocksBreakListPrompt(context);
        }
    }

    public class QuestBlockBreakAmountsPrompt
    extends QuestsEditorStringPrompt {
        public QuestBlockBreakAmountsPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("stageEditorEnterBlockAmounts");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestBlocksPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                String[] args = input.split(" ");
                LinkedList<Integer> amounts = new LinkedList<Integer>();
                for (String s : args) {
                    try {
                        if (Integer.parseInt(s) <= 0) {
                            context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("invalidMinimum").replace("<number>", "1"));
                            return new QuestBlockBreakAmountsPrompt(context);
                        }
                        amounts.add(Integer.parseInt(s));
                    }
                    catch (NumberFormatException e) {
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("stageEditorNotListOfNumbers").replace("<data>", s));
                        return new QuestBlockBreakAmountsPrompt(context);
                    }
                }
                context.setSessionData((Object)(QuestBlocksPrompt.this.pref + "breakAmounts"), amounts);
            }
            return new QuestBlocksBreakListPrompt(context);
        }
    }

    public class QuestBlockBreakNamesPrompt
    extends QuestsEditorStringPrompt {
        public QuestBlockBreakNamesPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("stageEditorEnterBlockNames");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestBlocksPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                String[] args = input.split(" ");
                LinkedList<String> names = new LinkedList<String>();
                for (String s : args) {
                    try {
                        Material m = Material.matchMaterial((String)s);
                        if (m != null) {
                            if (!m.isBlock()) {
                                context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("stageEditorNotSolid").replace("<input>", s));
                                return new QuestBlockBreakNamesPrompt(context);
                            }
                        } else {
                            context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("stageEditorInvalidBlockName").replace("<input>", s));
                            return new QuestBlockBreakNamesPrompt(context);
                        }
                        names.add(m.name());
                    }
                    catch (NumberFormatException e) {
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("stageEditorNotListOfNumbers").replace("<data>", s));
                        return new QuestBlockBreakNamesPrompt(context);
                    }
                }
                context.setSessionData((Object)(QuestBlocksPrompt.this.pref + "breakNames"), names);
                LinkedList amounts = new LinkedList();
                if (context.getSessionData((Object)(QuestBlocksPrompt.this.pref + "breakAmounts")) != null) {
                    amounts = (LinkedList)context.getSessionData((Object)(QuestBlocksPrompt.this.pref + "breakAmounts"));
                }
                for (int i = 0; i < names.size(); ++i) {
                    if (amounts == null || i < amounts.size()) continue;
                    amounts.add(1);
                }
                context.setSessionData((Object)(QuestBlocksPrompt.this.pref + "breakAmounts"), (Object)amounts);
            }
            return new QuestBlocksBreakListPrompt(context);
        }
    }
}

