/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.convo.quests.objectives;

import java.util.LinkedList;
import java.util.List;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.convo.generic.ItemStackPrompt;
import me.pikamug.quests.convo.quests.QuestsEditorNumericPrompt;
import me.pikamug.quests.convo.quests.stages.QuestStageMainPrompt;
import me.pikamug.quests.events.editor.quests.QuestsEditorPostOpenNumericPromptEvent;
import me.pikamug.quests.util.BukkitItemUtil;
import me.pikamug.quests.util.BukkitLang;
import org.bukkit.ChatColor;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.Prompt;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class QuestItemsPrompt
extends QuestsEditorNumericPrompt {
    private final BukkitQuestsPlugin plugin;
    private final int stageNum;
    private final String pref;
    private final int size = 6;

    public QuestItemsPrompt(int stageNum, ConversationContext context) {
        super(context);
        this.plugin = (BukkitQuestsPlugin)context.getPlugin();
        this.stageNum = stageNum;
        this.pref = "stage" + stageNum;
    }

    @Override
    public int getSize() {
        return 6;
    }

    @Override
    public String getTitle(ConversationContext context) {
        return BukkitLang.get("stageEditorItems");
    }

    @Override
    public ChatColor getNumberColor(ConversationContext context, int number) {
        switch (number) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return ChatColor.BLUE;
            }
            case 6: {
                return ChatColor.GREEN;
            }
        }
        return null;
    }

    @Override
    public String getSelectionText(ConversationContext context, int number) {
        switch (number) {
            case 1: {
                return ChatColor.YELLOW + BukkitLang.get("stageEditorCraftItems");
            }
            case 2: {
                return ChatColor.YELLOW + BukkitLang.get("stageEditorSmeltItems");
            }
            case 3: {
                return ChatColor.YELLOW + BukkitLang.get("stageEditorEnchantItems");
            }
            case 4: {
                return ChatColor.YELLOW + BukkitLang.get("stageEditorBrewPotions");
            }
            case 5: {
                return ChatColor.YELLOW + BukkitLang.get("stageEditorConsumeItems");
            }
            case 6: {
                return ChatColor.GREEN + BukkitLang.get("done");
            }
        }
        return null;
    }

    @Override
    public String getAdditionalText(ConversationContext context, int number) {
        switch (number) {
            case 1: {
                if (context.getSessionData((Object)(this.pref + "craftItems")) == null) {
                    return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                StringBuilder text = new StringBuilder();
                LinkedList items = (LinkedList)context.getSessionData((Object)(this.pref + "craftItems"));
                if (items != null) {
                    for (ItemStack item : items) {
                        text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.BLUE).append(BukkitItemUtil.getName(item)).append(ChatColor.GRAY).append(" x ").append(ChatColor.AQUA).append(item.getAmount());
                    }
                }
                return text.toString();
            }
            case 2: {
                if (context.getSessionData((Object)(this.pref + "smeltItems")) == null) {
                    return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                StringBuilder text = new StringBuilder();
                LinkedList items = (LinkedList)context.getSessionData((Object)(this.pref + "smeltItems"));
                if (items != null) {
                    for (ItemStack item : items) {
                        text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.BLUE).append(BukkitItemUtil.getName(item)).append(ChatColor.GRAY).append(" x ").append(ChatColor.AQUA).append(item.getAmount());
                    }
                }
                return text.toString();
            }
            case 3: {
                if (context.getSessionData((Object)(this.pref + "enchantItems")) == null) {
                    return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                StringBuilder text = new StringBuilder();
                LinkedList items = (LinkedList)context.getSessionData((Object)(this.pref + "enchantItems"));
                if (items != null) {
                    for (ItemStack item : items) {
                        text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.BLUE).append(BukkitItemUtil.getName(item)).append(ChatColor.GRAY).append(" x ").append(ChatColor.AQUA).append(item.getAmount());
                    }
                }
                return text.toString();
            }
            case 4: {
                if (context.getSessionData((Object)(this.pref + "brewItems")) == null) {
                    return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                StringBuilder text = new StringBuilder();
                LinkedList items = (LinkedList)context.getSessionData((Object)(this.pref + "brewItems"));
                if (items != null) {
                    for (ItemStack item : items) {
                        text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.BLUE).append(BukkitItemUtil.getName(item)).append(ChatColor.GRAY).append(" x ").append(ChatColor.AQUA).append(item.getAmount());
                    }
                }
                return text.toString();
            }
            case 5: {
                if (context.getSessionData((Object)(this.pref + "consumeItems")) == null) {
                    return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                StringBuilder text = new StringBuilder();
                LinkedList items = (LinkedList)context.getSessionData((Object)(this.pref + "consumeItems"));
                if (items != null) {
                    for (ItemStack item : items) {
                        text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.BLUE).append(BukkitItemUtil.getName(item)).append(ChatColor.GRAY).append(" x ").append(ChatColor.AQUA).append(item.getAmount());
                    }
                }
                return text.toString();
            }
            case 6: {
                return "";
            }
        }
        return null;
    }

    @Override
    @NotNull
    public String getBasicPromptText(ConversationContext context) {
        if (context.getSessionData((Object)"tempStack") != null) {
            List items;
            if (context.getSessionData((Object)(this.pref + "craftItems")) != null) {
                items = (List)context.getSessionData((Object)(this.pref + "craftItems"));
                if (items != null) {
                    items.add((ItemStack)context.getSessionData((Object)"tempStack"));
                    context.setSessionData((Object)(this.pref + "craftItems"), (Object)items);
                }
            } else if (context.getSessionData((Object)(this.pref + "smeltItems")) != null && (items = (List)context.getSessionData((Object)(this.pref + "smeltItems"))) != null) {
                items.add((ItemStack)context.getSessionData((Object)"tempStack"));
                context.setSessionData((Object)(this.pref + "smeltItems"), (Object)items);
            }
            ItemStackPrompt.clearSessionData(context);
        }
        QuestsEditorPostOpenNumericPromptEvent event = new QuestsEditorPostOpenNumericPromptEvent(context, this);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        StringBuilder text = new StringBuilder(ChatColor.AQUA + "- " + this.getTitle(context) + " -");
        for (int i = 1; i <= 6; ++i) {
            text.append("\n").append(this.getNumberColor(context, i)).append(ChatColor.BOLD).append(i).append(ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i)).append(" ").append(this.getAdditionalText(context, i));
        }
        return text.toString();
    }

    protected Prompt acceptValidatedInput(@NotNull ConversationContext context, Number input) {
        switch (input.intValue()) {
            case 1: {
                return new QuestItemsCraftListPrompt(context);
            }
            case 2: {
                return new QuestItemsSmeltListPrompt(context);
            }
            case 3: {
                return new QuestItemsEnchantListPrompt(context);
            }
            case 4: {
                return new QuestItemsBrewListPrompt(context);
            }
            case 5: {
                return new QuestItemsConsumeListPrompt(context);
            }
            case 6: {
                try {
                    return new QuestStageMainPrompt(this.stageNum, context);
                }
                catch (Exception e) {
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("itemCreateCriticalError"));
                    return Prompt.END_OF_CONVERSATION;
                }
            }
        }
        return new QuestItemsPrompt(this.stageNum, context);
    }

    public class QuestItemsCraftListPrompt
    extends QuestsEditorNumericPrompt {
        private final int size = 3;

        public QuestItemsCraftListPrompt(ConversationContext context) {
            super(context);
            this.size = 3;
        }

        @Override
        public int getSize() {
            return 3;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("stageEditorCraftItems");
        }

        @Override
        public ChatColor getNumberColor(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.BLUE;
                }
                case 2: {
                    return ChatColor.RED;
                }
                case 3: {
                    return ChatColor.GREEN;
                }
            }
            return null;
        }

        @Override
        public String getSelectionText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.YELLOW + BukkitLang.get("stageEditorDeliveryAddItem");
                }
                case 2: {
                    return ChatColor.RED + BukkitLang.get("clear");
                }
                case 3: {
                    return ChatColor.GREEN + BukkitLang.get("done");
                }
            }
            return null;
        }

        @Override
        public String getAdditionalText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    if (context.getSessionData((Object)(QuestItemsPrompt.this.pref + "craftItems")) == null) {
                        return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    StringBuilder text = new StringBuilder();
                    List craftItems = (List)context.getSessionData((Object)(QuestItemsPrompt.this.pref + "craftItems"));
                    if (craftItems != null) {
                        for (ItemStack is : craftItems) {
                            text.append("\n").append(ChatColor.GRAY).append("     - ").append(BukkitItemUtil.getDisplayString(is));
                        }
                    }
                    return text.toString();
                }
                case 2: 
                case 3: {
                    return "";
                }
            }
            return null;
        }

        @Override
        @NotNull
        public String getBasicPromptText(ConversationContext context) {
            if (context.getSessionData((Object)"tempStack") != null) {
                List<ItemStack> items;
                if (context.getSessionData((Object)(QuestItemsPrompt.this.pref + "craftItems")) != null) {
                    items = (List)context.getSessionData((Object)(QuestItemsPrompt.this.pref + "craftItems"));
                    if (items != null) {
                        items.add((ItemStack)context.getSessionData((Object)"tempStack"));
                        context.setSessionData((Object)(QuestItemsPrompt.this.pref + "craftItems"), items);
                    }
                } else {
                    items = new LinkedList<ItemStack>();
                    ((LinkedList)items).add((ItemStack)context.getSessionData((Object)"tempStack"));
                    context.setSessionData((Object)(QuestItemsPrompt.this.pref + "craftItems"), items);
                }
                ItemStackPrompt.clearSessionData(context);
            }
            QuestsEditorPostOpenNumericPromptEvent event = new QuestsEditorPostOpenNumericPromptEvent(context, this);
            QuestItemsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(ChatColor.GOLD + "- " + this.getTitle(context) + " -");
            for (int i = 1; i <= 3; ++i) {
                text.append("\n").append(this.getNumberColor(context, i)).append(ChatColor.BOLD).append(i).append(ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i)).append(" ").append(this.getAdditionalText(context, i));
            }
            return text.toString();
        }

        protected Prompt acceptValidatedInput(@NotNull ConversationContext context, Number input) {
            switch (input.intValue()) {
                case 1: {
                    return new ItemStackPrompt(context, (Prompt)this);
                }
                case 2: {
                    context.getForWhom().sendRawMessage(ChatColor.YELLOW + BukkitLang.get("stageEditorObjectiveCleared"));
                    context.setSessionData((Object)(QuestItemsPrompt.this.pref + "craftItems"), null);
                    return new QuestItemsCraftListPrompt(context);
                }
            }
            return new QuestItemsPrompt(QuestItemsPrompt.this.stageNum, context);
        }
    }

    public class QuestItemsSmeltListPrompt
    extends QuestsEditorNumericPrompt {
        private final int size = 3;

        public QuestItemsSmeltListPrompt(ConversationContext context) {
            super(context);
            this.size = 3;
        }

        @Override
        public int getSize() {
            return 3;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("stageEditorSmeltItems");
        }

        @Override
        public ChatColor getNumberColor(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.BLUE;
                }
                case 2: {
                    return ChatColor.RED;
                }
                case 3: {
                    return ChatColor.GREEN;
                }
            }
            return null;
        }

        @Override
        public String getSelectionText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.YELLOW + BukkitLang.get("stageEditorDeliveryAddItem");
                }
                case 2: {
                    return ChatColor.RED + BukkitLang.get("clear");
                }
                case 3: {
                    return ChatColor.GREEN + BukkitLang.get("done");
                }
            }
            return null;
        }

        @Override
        public String getAdditionalText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    if (context.getSessionData((Object)(QuestItemsPrompt.this.pref + "smeltItems")) == null) {
                        return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    StringBuilder text = new StringBuilder();
                    List smeltItems = (List)context.getSessionData((Object)(QuestItemsPrompt.this.pref + "smeltItems"));
                    if (smeltItems != null) {
                        for (ItemStack is : smeltItems) {
                            text.append("\n").append(ChatColor.GRAY).append("     - ").append(BukkitItemUtil.getDisplayString(is));
                        }
                    }
                    return text.toString();
                }
                case 2: 
                case 3: {
                    return "";
                }
            }
            return null;
        }

        @Override
        @NotNull
        public String getBasicPromptText(ConversationContext context) {
            if (context.getSessionData((Object)"tempStack") != null) {
                List<ItemStack> items;
                if (context.getSessionData((Object)(QuestItemsPrompt.this.pref + "smeltItems")) != null) {
                    items = (List)context.getSessionData((Object)(QuestItemsPrompt.this.pref + "smeltItems"));
                    if (items != null) {
                        items.add((ItemStack)context.getSessionData((Object)"tempStack"));
                        context.setSessionData((Object)(QuestItemsPrompt.this.pref + "smeltItems"), items);
                    }
                } else {
                    items = new LinkedList<ItemStack>();
                    ((LinkedList)items).add((ItemStack)context.getSessionData((Object)"tempStack"));
                    context.setSessionData((Object)(QuestItemsPrompt.this.pref + "smeltItems"), items);
                }
                ItemStackPrompt.clearSessionData(context);
            }
            QuestsEditorPostOpenNumericPromptEvent event = new QuestsEditorPostOpenNumericPromptEvent(context, this);
            QuestItemsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(ChatColor.GOLD + "- " + this.getTitle(context) + " -");
            for (int i = 1; i <= 3; ++i) {
                text.append("\n").append(this.getNumberColor(context, i)).append(ChatColor.BOLD).append(i).append(ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i)).append(" ").append(this.getAdditionalText(context, i));
            }
            return text.toString();
        }

        protected Prompt acceptValidatedInput(@NotNull ConversationContext context, Number input) {
            switch (input.intValue()) {
                case 1: {
                    return new ItemStackPrompt(context, (Prompt)this);
                }
                case 2: {
                    context.getForWhom().sendRawMessage(ChatColor.YELLOW + BukkitLang.get("stageEditorObjectiveCleared"));
                    context.setSessionData((Object)(QuestItemsPrompt.this.pref + "smeltItems"), null);
                    return new QuestItemsSmeltListPrompt(context);
                }
            }
            return new QuestItemsPrompt(QuestItemsPrompt.this.stageNum, context);
        }
    }

    public class QuestItemsEnchantListPrompt
    extends QuestsEditorNumericPrompt {
        private final int size = 3;

        public QuestItemsEnchantListPrompt(ConversationContext context) {
            super(context);
            this.size = 3;
        }

        @Override
        public int getSize() {
            return 3;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("stageEditorEnchantItems");
        }

        @Override
        public ChatColor getNumberColor(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.BLUE;
                }
                case 2: {
                    return ChatColor.RED;
                }
                case 3: {
                    return ChatColor.GREEN;
                }
            }
            return null;
        }

        @Override
        public String getSelectionText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.YELLOW + BukkitLang.get("stageEditorDeliveryAddItem");
                }
                case 2: {
                    return ChatColor.RED + BukkitLang.get("clear");
                }
                case 3: {
                    return ChatColor.GREEN + BukkitLang.get("done");
                }
            }
            return null;
        }

        @Override
        public String getAdditionalText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    if (context.getSessionData((Object)(QuestItemsPrompt.this.pref + "enchantItems")) == null) {
                        return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    StringBuilder text = new StringBuilder();
                    List enchantItems = (List)context.getSessionData((Object)(QuestItemsPrompt.this.pref + "enchantItems"));
                    if (enchantItems != null) {
                        for (ItemStack is : enchantItems) {
                            text.append("\n").append(ChatColor.GRAY).append("     - ").append(BukkitItemUtil.getDisplayString(is));
                        }
                    }
                    return text.toString();
                }
                case 2: 
                case 3: {
                    return "";
                }
            }
            return null;
        }

        @Override
        @NotNull
        public String getBasicPromptText(ConversationContext context) {
            if (context.getSessionData((Object)"tempStack") != null) {
                List<ItemStack> items;
                if (context.getSessionData((Object)(QuestItemsPrompt.this.pref + "enchantItems")) != null) {
                    items = (List)context.getSessionData((Object)(QuestItemsPrompt.this.pref + "enchantItems"));
                    if (items != null) {
                        items.add((ItemStack)context.getSessionData((Object)"tempStack"));
                        context.setSessionData((Object)(QuestItemsPrompt.this.pref + "enchantItems"), items);
                    }
                } else {
                    items = new LinkedList<ItemStack>();
                    ((LinkedList)items).add((ItemStack)context.getSessionData((Object)"tempStack"));
                    context.setSessionData((Object)(QuestItemsPrompt.this.pref + "enchantItems"), items);
                }
                ItemStackPrompt.clearSessionData(context);
            }
            QuestsEditorPostOpenNumericPromptEvent event = new QuestsEditorPostOpenNumericPromptEvent(context, this);
            QuestItemsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(ChatColor.GOLD + "- " + this.getTitle(context) + " -");
            for (int i = 1; i <= 3; ++i) {
                text.append("\n").append(this.getNumberColor(context, i)).append(ChatColor.BOLD).append(i).append(ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i)).append(" ").append(this.getAdditionalText(context, i));
            }
            return text.toString();
        }

        protected Prompt acceptValidatedInput(@NotNull ConversationContext context, Number input) {
            switch (input.intValue()) {
                case 1: {
                    return new ItemStackPrompt(context, (Prompt)this);
                }
                case 2: {
                    context.getForWhom().sendRawMessage(ChatColor.YELLOW + BukkitLang.get("stageEditorObjectiveCleared"));
                    context.setSessionData((Object)(QuestItemsPrompt.this.pref + "enchantItems"), null);
                    return new QuestItemsEnchantListPrompt(context);
                }
            }
            return new QuestItemsPrompt(QuestItemsPrompt.this.stageNum, context);
        }
    }

    public class QuestItemsBrewListPrompt
    extends QuestsEditorNumericPrompt {
        private final int size = 3;

        public QuestItemsBrewListPrompt(ConversationContext context) {
            super(context);
            this.size = 3;
        }

        @Override
        public int getSize() {
            return 3;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("stageEditorBrewPotions");
        }

        @Override
        public ChatColor getNumberColor(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.BLUE;
                }
                case 2: {
                    return ChatColor.RED;
                }
                case 3: {
                    return ChatColor.GREEN;
                }
            }
            return null;
        }

        @Override
        public String getSelectionText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.YELLOW + BukkitLang.get("stageEditorDeliveryAddItem");
                }
                case 2: {
                    return ChatColor.RED + BukkitLang.get("clear");
                }
                case 3: {
                    return ChatColor.GREEN + BukkitLang.get("done");
                }
            }
            return null;
        }

        @Override
        public String getAdditionalText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    if (context.getSessionData((Object)(QuestItemsPrompt.this.pref + "brewItems")) == null) {
                        return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    StringBuilder text = new StringBuilder();
                    List brewItems = (List)context.getSessionData((Object)(QuestItemsPrompt.this.pref + "brewItems"));
                    if (brewItems != null) {
                        for (ItemStack is : brewItems) {
                            text.append("\n").append(ChatColor.GRAY).append("     - ").append(BukkitItemUtil.getDisplayString(is));
                        }
                    }
                    return text.toString();
                }
                case 2: 
                case 3: {
                    return "";
                }
            }
            return null;
        }

        @Override
        @NotNull
        public String getBasicPromptText(ConversationContext context) {
            if (context.getSessionData((Object)"tempStack") != null) {
                List<ItemStack> items;
                if (context.getSessionData((Object)(QuestItemsPrompt.this.pref + "brewItems")) != null) {
                    items = (List)context.getSessionData((Object)(QuestItemsPrompt.this.pref + "brewItems"));
                    if (items != null) {
                        items.add((ItemStack)context.getSessionData((Object)"tempStack"));
                        context.setSessionData((Object)(QuestItemsPrompt.this.pref + "brewItems"), items);
                    }
                } else {
                    items = new LinkedList<ItemStack>();
                    ((LinkedList)items).add((ItemStack)context.getSessionData((Object)"tempStack"));
                    context.setSessionData((Object)(QuestItemsPrompt.this.pref + "brewItems"), items);
                }
                ItemStackPrompt.clearSessionData(context);
            }
            QuestsEditorPostOpenNumericPromptEvent event = new QuestsEditorPostOpenNumericPromptEvent(context, this);
            QuestItemsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(ChatColor.GOLD + "- " + this.getTitle(context) + " -");
            for (int i = 1; i <= 3; ++i) {
                text.append("\n").append(this.getNumberColor(context, i)).append(ChatColor.BOLD).append(i).append(ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i)).append(" ").append(this.getAdditionalText(context, i));
            }
            return text.toString();
        }

        protected Prompt acceptValidatedInput(@NotNull ConversationContext context, Number input) {
            switch (input.intValue()) {
                case 1: {
                    return new ItemStackPrompt(context, (Prompt)this);
                }
                case 2: {
                    context.getForWhom().sendRawMessage(ChatColor.YELLOW + BukkitLang.get("stageEditorObjectiveCleared"));
                    context.setSessionData((Object)(QuestItemsPrompt.this.pref + "brewItems"), null);
                    return new QuestItemsBrewListPrompt(context);
                }
            }
            return new QuestItemsPrompt(QuestItemsPrompt.this.stageNum, context);
        }
    }

    public class QuestItemsConsumeListPrompt
    extends QuestsEditorNumericPrompt {
        private final int size = 3;

        public QuestItemsConsumeListPrompt(ConversationContext context) {
            super(context);
            this.size = 3;
        }

        @Override
        public int getSize() {
            return 3;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("stageEditorConsumeItems");
        }

        @Override
        public ChatColor getNumberColor(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.BLUE;
                }
                case 2: {
                    return ChatColor.RED;
                }
                case 3: {
                    return ChatColor.GREEN;
                }
            }
            return null;
        }

        @Override
        public String getSelectionText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.YELLOW + BukkitLang.get("stageEditorDeliveryAddItem");
                }
                case 2: {
                    return ChatColor.RED + BukkitLang.get("clear");
                }
                case 3: {
                    return ChatColor.GREEN + BukkitLang.get("done");
                }
            }
            return null;
        }

        @Override
        public String getAdditionalText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    if (context.getSessionData((Object)(QuestItemsPrompt.this.pref + "consumeItems")) == null) {
                        return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    StringBuilder text = new StringBuilder();
                    List consumeItems = (List)context.getSessionData((Object)(QuestItemsPrompt.this.pref + "consumeItems"));
                    if (consumeItems != null) {
                        for (ItemStack is : consumeItems) {
                            text.append("\n").append(ChatColor.GRAY).append("     - ").append(BukkitItemUtil.getDisplayString(is));
                        }
                    }
                    return text.toString();
                }
                case 2: 
                case 3: {
                    return "";
                }
            }
            return null;
        }

        @Override
        @NotNull
        public String getBasicPromptText(ConversationContext context) {
            if (context.getSessionData((Object)"tempStack") != null) {
                List<ItemStack> items;
                if (context.getSessionData((Object)(QuestItemsPrompt.this.pref + "consumeItems")) != null) {
                    items = (List)context.getSessionData((Object)(QuestItemsPrompt.this.pref + "consumeItems"));
                    if (items != null) {
                        items.add((ItemStack)context.getSessionData((Object)"tempStack"));
                        context.setSessionData((Object)(QuestItemsPrompt.this.pref + "consumeItems"), items);
                    }
                } else {
                    items = new LinkedList<ItemStack>();
                    ((LinkedList)items).add((ItemStack)context.getSessionData((Object)"tempStack"));
                    context.setSessionData((Object)(QuestItemsPrompt.this.pref + "consumeItems"), items);
                }
                ItemStackPrompt.clearSessionData(context);
            }
            QuestsEditorPostOpenNumericPromptEvent event = new QuestsEditorPostOpenNumericPromptEvent(context, this);
            QuestItemsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(ChatColor.GOLD + "- " + this.getTitle(context) + " -");
            for (int i = 1; i <= 3; ++i) {
                text.append("\n").append(this.getNumberColor(context, i)).append(ChatColor.BOLD).append(i).append(ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i)).append(" ").append(this.getAdditionalText(context, i));
            }
            return text.toString();
        }

        protected Prompt acceptValidatedInput(@NotNull ConversationContext context, Number input) {
            switch (input.intValue()) {
                case 1: {
                    return new ItemStackPrompt(context, (Prompt)this);
                }
                case 2: {
                    context.getForWhom().sendRawMessage(ChatColor.YELLOW + BukkitLang.get("stageEditorObjectiveCleared"));
                    context.setSessionData((Object)(QuestItemsPrompt.this.pref + "consumeItems"), null);
                    return new QuestItemsConsumeListPrompt(context);
                }
            }
            return new QuestItemsPrompt(QuestItemsPrompt.this.stageNum, context);
        }
    }
}

