/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.convo.quests.objectives;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.convo.quests.QuestsEditorNumericPrompt;
import me.pikamug.quests.convo.quests.QuestsEditorStringPrompt;
import me.pikamug.quests.convo.quests.stages.QuestStageMainPrompt;
import me.pikamug.quests.events.editor.quests.QuestsEditorPostOpenNumericPromptEvent;
import me.pikamug.quests.events.editor.quests.QuestsEditorPostOpenStringPromptEvent;
import me.pikamug.quests.util.BukkitConfigUtil;
import me.pikamug.quests.util.BukkitLang;
import me.pikamug.quests.util.BukkitMiscUtil;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.Prompt;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

public class QuestMobsPrompt
extends QuestsEditorNumericPrompt {
    private final BukkitQuestsPlugin plugin;
    private final int stageNum;
    private final String pref;
    private final int size = 6;

    public QuestMobsPrompt(int stageNum, ConversationContext context) {
        super(context);
        this.plugin = (BukkitQuestsPlugin)context.getPlugin();
        this.stageNum = stageNum;
        this.pref = "stage" + stageNum;
    }

    @Override
    public int getSize() {
        return 6;
    }

    @Override
    public String getTitle(ConversationContext context) {
        return BukkitLang.get("stageEditorMobs");
    }

    @Override
    public ChatColor getNumberColor(ConversationContext context, int number) {
        switch (number) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return ChatColor.BLUE;
            }
            case 6: {
                return ChatColor.GREEN;
            }
        }
        return null;
    }

    @Override
    public String getSelectionText(ConversationContext context, int number) {
        switch (number) {
            case 1: {
                return ChatColor.YELLOW + BukkitLang.get("stageEditorKillMobs");
            }
            case 2: {
                return ChatColor.YELLOW + BukkitLang.get("stageEditorTameMobs");
            }
            case 3: {
                return ChatColor.YELLOW + BukkitLang.get("stageEditorCatchFish");
            }
            case 4: {
                return ChatColor.YELLOW + BukkitLang.get("stageEditorMilkCows");
            }
            case 5: {
                return ChatColor.YELLOW + BukkitLang.get("stageEditorShearSheep");
            }
            case 6: {
                return ChatColor.GREEN + BukkitLang.get("done");
            }
        }
        return null;
    }

    @Override
    public String getAdditionalText(ConversationContext context, int number) {
        switch (number) {
            case 1: {
                if (context.getSessionData((Object)(this.pref + "mobTypes")) == null) {
                    return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                StringBuilder text = new StringBuilder();
                LinkedList mobs = (LinkedList)context.getSessionData((Object)(this.pref + "mobTypes"));
                LinkedList amounts = (LinkedList)context.getSessionData((Object)(this.pref + "mobAmounts"));
                if (mobs != null && amounts != null) {
                    if (context.getSessionData((Object)(this.pref + "killLocations")) == null) {
                        for (int i = 0; i < mobs.size(); ++i) {
                            if (BukkitMiscUtil.getProperMobType((String)mobs.get(i)) == null) continue;
                            text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.AQUA).append(BukkitMiscUtil.getPrettyMobName(Objects.requireNonNull(BukkitMiscUtil.getProperMobType((String)mobs.get(i))))).append(ChatColor.GRAY).append(" x ").append(ChatColor.DARK_AQUA).append(amounts.get(i));
                        }
                    } else {
                        LinkedList locations = (LinkedList)context.getSessionData((Object)(this.pref + "killLocations"));
                        LinkedList radii = (LinkedList)context.getSessionData((Object)(this.pref + "killLocationRadii"));
                        LinkedList names = (LinkedList)context.getSessionData((Object)(this.pref + "killLocationNames"));
                        if (locations != null && radii != null && names != null) {
                            for (int i = 0; i < mobs.size(); ++i) {
                                String msg = BukkitLang.get("blocksWithin");
                                msg = msg.replace("<amount>", String.valueOf(radii.get(i)));
                                text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.BLUE).append(BukkitMiscUtil.getPrettyMobName(Objects.requireNonNull(BukkitMiscUtil.getProperMobType((String)mobs.get(i))))).append(ChatColor.GRAY).append(" x ").append(ChatColor.DARK_AQUA).append(amounts.get(i)).append(ChatColor.GRAY).append(msg).append(ChatColor.YELLOW).append((String)names.get(i)).append(" (").append((String)locations.get(i)).append(")");
                            }
                        }
                    }
                }
                return text.toString();
            }
            case 2: {
                if (context.getSessionData((Object)(this.pref + "tameTypes")) == null) {
                    return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                StringBuilder text = new StringBuilder();
                LinkedList mobs = (LinkedList)context.getSessionData((Object)(this.pref + "tameTypes"));
                LinkedList amounts = (LinkedList)context.getSessionData((Object)(this.pref + "tameAmounts"));
                if (mobs != null && amounts != null) {
                    for (int i = 0; i < mobs.size(); ++i) {
                        text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.BLUE).append((String)mobs.get(i)).append(ChatColor.GRAY).append(" x ").append(ChatColor.AQUA).append(amounts.get(i));
                    }
                }
                return text.toString();
            }
            case 3: {
                if (context.getSessionData((Object)(this.pref + "fish")) == null) {
                    return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                Integer fish = (Integer)context.getSessionData((Object)(this.pref + "fish"));
                return ChatColor.GRAY + "(" + ChatColor.AQUA + fish + " " + BukkitLang.get("stageEditorFish") + ChatColor.GRAY + ")";
            }
            case 4: {
                if (context.getSessionData((Object)(this.pref + "cowMilk")) == null) {
                    return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                Integer cows = (Integer)context.getSessionData((Object)(this.pref + "cowMilk"));
                return ChatColor.GRAY + "(" + ChatColor.AQUA + cows + " " + BukkitLang.get("stageEditorCows") + ChatColor.GRAY + ")";
            }
            case 5: {
                if (context.getSessionData((Object)(this.pref + "shearColors")) == null) {
                    return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                StringBuilder text = new StringBuilder();
                LinkedList colors = (LinkedList)context.getSessionData((Object)(this.pref + "shearColors"));
                LinkedList amounts = (LinkedList)context.getSessionData((Object)(this.pref + "shearAmounts"));
                if (colors != null && amounts != null) {
                    for (int i = 0; i < colors.size(); ++i) {
                        text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.BLUE).append((String)colors.get(i)).append(ChatColor.GRAY).append(" x ").append(ChatColor.AQUA).append(amounts.get(i));
                    }
                }
                return text.toString();
            }
            case 6: {
                return "";
            }
        }
        return null;
    }

    @Override
    @NotNull
    public String getBasicPromptText(ConversationContext context) {
        context.setSessionData((Object)this.pref, (Object)Boolean.TRUE);
        QuestsEditorPostOpenNumericPromptEvent event = new QuestsEditorPostOpenNumericPromptEvent(context, this);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        StringBuilder text = new StringBuilder(ChatColor.AQUA + "- " + this.getTitle(context) + " -");
        for (int i = 1; i <= 6; ++i) {
            text.append("\n").append(this.getNumberColor(context, i)).append(ChatColor.BOLD).append(i).append(ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i)).append(" ").append(this.getAdditionalText(context, i));
        }
        return text.toString();
    }

    protected Prompt acceptValidatedInput(@NotNull ConversationContext context, Number input) {
        switch (input.intValue()) {
            case 1: {
                return new QuestMobsKillListPrompt(context);
            }
            case 2: {
                return new QuestMobsTameListPrompt(context);
            }
            case 3: {
                return new QuestMobsFishPrompt(context);
            }
            case 4: {
                return new QuestMobsCowsPrompt(context);
            }
            case 5: {
                return new QuestMobsShearListPrompt(context);
            }
            case 6: {
                try {
                    return new QuestStageMainPrompt(this.stageNum, context);
                }
                catch (Exception e) {
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("itemCreateCriticalError"));
                    return Prompt.END_OF_CONVERSATION;
                }
            }
        }
        return new QuestMobsPrompt(this.stageNum, context);
    }

    public class QuestMobsKillListPrompt
    extends QuestsEditorNumericPrompt {
        private final int size = 7;

        public QuestMobsKillListPrompt(ConversationContext context) {
            super(context);
            this.size = 7;
        }

        @Override
        public int getSize() {
            return 7;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("stageEditorKillMobs");
        }

        @Override
        public ChatColor getNumberColor(ConversationContext context, int number) {
            switch (number) {
                case 1: 
                case 2: 
                case 4: 
                case 5: {
                    return ChatColor.BLUE;
                }
                case 3: {
                    if (context.getForWhom() instanceof Player) {
                        return ChatColor.BLUE;
                    }
                    return ChatColor.GRAY;
                }
                case 6: {
                    return ChatColor.RED;
                }
                case 7: {
                    return ChatColor.GREEN;
                }
            }
            return null;
        }

        @Override
        public String getSelectionText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.YELLOW + BukkitLang.get("stageEditorSetMobTypes");
                }
                case 2: {
                    return ChatColor.YELLOW + BukkitLang.get("stageEditorSetMobAmounts");
                }
                case 3: {
                    if (context.getForWhom() instanceof Player) {
                        return ChatColor.YELLOW + BukkitLang.get("stageEditorSetKillLocations");
                    }
                    return ChatColor.GRAY + BukkitLang.get("stageEditorSetKillLocations");
                }
                case 4: {
                    return ChatColor.YELLOW + BukkitLang.get("stageEditorSetKillLocationRadii");
                }
                case 5: {
                    return ChatColor.YELLOW + BukkitLang.get("stageEditorSetKillLocationNames");
                }
                case 6: {
                    return ChatColor.RED + BukkitLang.get("clear");
                }
                case 7: {
                    return ChatColor.GREEN + BukkitLang.get("done");
                }
            }
            return null;
        }

        @Override
        public String getAdditionalText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    if (context.getSessionData((Object)(QuestMobsPrompt.this.pref + "mobTypes")) == null) {
                        return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    StringBuilder text = new StringBuilder();
                    List mobTypes = (List)context.getSessionData((Object)(QuestMobsPrompt.this.pref + "mobTypes"));
                    if (mobTypes != null) {
                        for (String s : mobTypes) {
                            text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.AQUA).append(s);
                        }
                    }
                    return text.toString();
                }
                case 2: {
                    if (context.getSessionData((Object)(QuestMobsPrompt.this.pref + "mobAmounts")) == null) {
                        return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    StringBuilder text = new StringBuilder();
                    List mobAmounts = (List)context.getSessionData((Object)(QuestMobsPrompt.this.pref + "mobAmounts"));
                    if (mobAmounts != null) {
                        for (Integer i : mobAmounts) {
                            text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.AQUA).append(i);
                        }
                    }
                    return text.toString();
                }
                case 3: {
                    if (context.getSessionData((Object)(QuestMobsPrompt.this.pref + "killLocations")) == null) {
                        return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    StringBuilder text = new StringBuilder();
                    List mobsKillLocations = (List)context.getSessionData((Object)(QuestMobsPrompt.this.pref + "killLocations"));
                    if (mobsKillLocations != null) {
                        for (String s : mobsKillLocations) {
                            text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.AQUA).append(s);
                        }
                    }
                    return text.toString();
                }
                case 4: {
                    if (context.getSessionData((Object)(QuestMobsPrompt.this.pref + "killLocationRadii")) == null) {
                        return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    StringBuilder text = new StringBuilder();
                    List mobKillLocationsRadius = (List)context.getSessionData((Object)(QuestMobsPrompt.this.pref + "killLocationRadii"));
                    if (mobKillLocationsRadius != null) {
                        Iterator iterator = mobKillLocationsRadius.iterator();
                        while (iterator.hasNext()) {
                            int i = (Integer)iterator.next();
                            text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.AQUA).append(i);
                        }
                    }
                    return text.toString();
                }
                case 5: {
                    if (context.getSessionData((Object)(QuestMobsPrompt.this.pref + "killLocationNames")) == null) {
                        return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    StringBuilder text = new StringBuilder();
                    List mobKillLocationsNames = (List)context.getSessionData((Object)(QuestMobsPrompt.this.pref + "killLocationNames"));
                    if (mobKillLocationsNames != null) {
                        for (String s : mobKillLocationsNames) {
                            text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.AQUA).append(s);
                        }
                    }
                    return text.toString();
                }
                case 6: 
                case 7: {
                    return "";
                }
            }
            return null;
        }

        @Override
        @NotNull
        public String getBasicPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenNumericPromptEvent event = new QuestsEditorPostOpenNumericPromptEvent(context, this);
            QuestMobsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(ChatColor.AQUA + "- " + this.getTitle(context) + " -");
            for (int i = 1; i <= 7; ++i) {
                text.append("\n").append(this.getNumberColor(context, i)).append(ChatColor.BOLD).append(i).append(ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i)).append(" ").append(this.getAdditionalText(context, i));
            }
            return text.toString();
        }

        protected Prompt acceptValidatedInput(@NotNull ConversationContext context, Number input) {
            switch (input.intValue()) {
                case 1: {
                    return new QuestMobsTypesPrompt(context);
                }
                case 2: {
                    return new QuestMobsAmountsPrompt(context);
                }
                case 3: {
                    if (context.getForWhom() instanceof Player) {
                        ConcurrentHashMap<UUID, Block> temp = QuestMobsPrompt.this.plugin.getQuestFactory().getSelectedKillLocations();
                        temp.put(((Player)context.getForWhom()).getUniqueId(), ((World)Bukkit.getWorlds().get(0)).getBlockAt(0, 0, 0));
                        QuestMobsPrompt.this.plugin.getQuestFactory().setSelectedKillLocations(temp);
                        return new QuestMobsLocationPrompt(context);
                    }
                    context.getForWhom().sendRawMessage(ChatColor.YELLOW + BukkitLang.get("consoleError"));
                    return new QuestMobsKillListPrompt(context);
                }
                case 4: {
                    return new QuestMobsRadiiPrompt(context);
                }
                case 5: {
                    return new QuestMobsLocationNamesPrompt(context);
                }
                case 6: {
                    context.getForWhom().sendRawMessage(ChatColor.YELLOW + BukkitLang.get("stageEditorObjectiveCleared"));
                    context.setSessionData((Object)(QuestMobsPrompt.this.pref + "mobTypes"), null);
                    context.setSessionData((Object)(QuestMobsPrompt.this.pref + "mobAmounts"), null);
                    context.setSessionData((Object)(QuestMobsPrompt.this.pref + "killLocations"), null);
                    context.setSessionData((Object)(QuestMobsPrompt.this.pref + "killLocationRadii"), null);
                    context.setSessionData((Object)(QuestMobsPrompt.this.pref + "killLocationNames"), null);
                    return new QuestMobsKillListPrompt(context);
                }
                case 7: {
                    List types = (List)context.getSessionData((Object)(QuestMobsPrompt.this.pref + "mobTypes"));
                    List amounts = (List)context.getSessionData((Object)(QuestMobsPrompt.this.pref + "mobAmounts"));
                    List locations = (List)context.getSessionData((Object)(QuestMobsPrompt.this.pref + "killLocations"));
                    List radii = (List)context.getSessionData((Object)(QuestMobsPrompt.this.pref + "killLocationRadii"));
                    List names = (List)context.getSessionData((Object)(QuestMobsPrompt.this.pref + "killLocationNames"));
                    int one = types != null ? types.size() : 0;
                    int two = amounts != null ? amounts.size() : 0;
                    int three = locations != null ? locations.size() : 0;
                    int four = radii != null ? radii.size() : 0;
                    int five = names != null ? names.size() : 0;
                    if (one == two) {
                        if (three != 0 || four != 0 || five != 0) {
                            if (two == three && three == four && four == five) {
                                return new QuestMobsPrompt(QuestMobsPrompt.this.stageNum, context);
                            }
                            context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("listsNotSameSize"));
                            return new QuestMobsKillListPrompt(context);
                        }
                        return new QuestMobsPrompt(QuestMobsPrompt.this.stageNum, context);
                    }
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("listsNotSameSize"));
                    return new QuestMobsKillListPrompt(context);
                }
            }
            return new QuestMobsPrompt(QuestMobsPrompt.this.stageNum, context);
        }
    }

    public class QuestMobsTameListPrompt
    extends QuestsEditorNumericPrompt {
        private final int size = 4;

        public QuestMobsTameListPrompt(ConversationContext context) {
            super(context);
            this.size = 4;
        }

        @Override
        public int getSize() {
            return 4;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("stageEditorTameMobs");
        }

        @Override
        public ChatColor getNumberColor(ConversationContext context, int number) {
            switch (number) {
                case 1: 
                case 2: {
                    return ChatColor.BLUE;
                }
                case 3: {
                    return ChatColor.RED;
                }
                case 4: {
                    return ChatColor.GREEN;
                }
            }
            return null;
        }

        @Override
        public String getSelectionText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.YELLOW + BukkitLang.get("stageEditorSetMobTypes");
                }
                case 2: {
                    return ChatColor.YELLOW + BukkitLang.get("stageEditorSetTameAmounts");
                }
                case 3: {
                    return ChatColor.RED + BukkitLang.get("clear");
                }
                case 4: {
                    return ChatColor.GREEN + BukkitLang.get("done");
                }
            }
            return null;
        }

        @Override
        public String getAdditionalText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    if (context.getSessionData((Object)(QuestMobsPrompt.this.pref + "tameTypes")) == null) {
                        return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    StringBuilder text = new StringBuilder();
                    List tameTypes = (List)context.getSessionData((Object)(QuestMobsPrompt.this.pref + "tameTypes"));
                    if (tameTypes != null) {
                        for (String s : tameTypes) {
                            text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.AQUA).append(s);
                        }
                    }
                    return text.toString();
                }
                case 2: {
                    if (context.getSessionData((Object)(QuestMobsPrompt.this.pref + "tameAmounts")) == null) {
                        return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    StringBuilder text = new StringBuilder();
                    List tameAmounts = (List)context.getSessionData((Object)(QuestMobsPrompt.this.pref + "tameAmounts"));
                    if (tameAmounts != null) {
                        for (Integer i : tameAmounts) {
                            text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.AQUA).append(i);
                        }
                    }
                    return text.toString();
                }
                case 3: 
                case 4: {
                    return "";
                }
            }
            return null;
        }

        @Override
        @NotNull
        public String getBasicPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenNumericPromptEvent event = new QuestsEditorPostOpenNumericPromptEvent(context, this);
            QuestMobsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(ChatColor.AQUA + "- " + this.getTitle(context) + " -\n");
            for (int i = 1; i <= 4; ++i) {
                text.append(this.getNumberColor(context, i)).append(ChatColor.BOLD).append(i).append(ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i)).append(" ").append(this.getAdditionalText(context, i)).append("\n");
            }
            return text.toString();
        }

        protected Prompt acceptValidatedInput(@NotNull ConversationContext context, Number input) {
            switch (input.intValue()) {
                case 1: {
                    return new QuestMobsTameTypesPrompt(context);
                }
                case 2: {
                    return new QuestMobsTameAmountsPrompt(context);
                }
                case 3: {
                    context.getForWhom().sendRawMessage(ChatColor.YELLOW + BukkitLang.get("stageEditorObjectiveCleared"));
                    context.setSessionData((Object)(QuestMobsPrompt.this.pref + "tameTypes"), null);
                    context.setSessionData((Object)(QuestMobsPrompt.this.pref + "tameAmounts"), null);
                    return new QuestMobsTameListPrompt(context);
                }
                case 4: {
                    List types = (List)context.getSessionData((Object)(QuestMobsPrompt.this.pref + "tameTypes"));
                    List amounts = (List)context.getSessionData((Object)(QuestMobsPrompt.this.pref + "tameAmounts"));
                    int one = types != null ? types.size() : 0;
                    int two = amounts != null ? amounts.size() : 0;
                    if (one == two) {
                        return new QuestMobsPrompt(QuestMobsPrompt.this.stageNum, context);
                    }
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("listsNotSameSize"));
                    return new QuestMobsTameListPrompt(context);
                }
            }
            return new QuestMobsPrompt(QuestMobsPrompt.this.stageNum, context);
        }
    }

    public class QuestMobsFishPrompt
    extends QuestsEditorStringPrompt {
        public QuestMobsFishPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("stageEditorCatchFishPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestMobsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel")) && !input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                try {
                    int i = Integer.parseInt(input);
                    if (i < 0) {
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("stageEditorPositiveAmount"));
                        return new QuestMobsFishPrompt(context);
                    }
                    if (i <= 0) return new QuestMobsPrompt(QuestMobsPrompt.this.stageNum, context);
                    context.setSessionData((Object)(QuestMobsPrompt.this.pref + "fish"), (Object)i);
                    return new QuestMobsPrompt(QuestMobsPrompt.this.stageNum, context);
                }
                catch (NumberFormatException e) {
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("reqNotANumber").replace("<input>", input));
                    return new QuestMobsFishPrompt(context);
                }
            } else {
                if (!input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) return new QuestMobsPrompt(QuestMobsPrompt.this.stageNum, context);
                context.setSessionData((Object)(QuestMobsPrompt.this.pref + "fish"), null);
            }
            return new QuestMobsPrompt(QuestMobsPrompt.this.stageNum, context);
        }
    }

    public class QuestMobsCowsPrompt
    extends QuestsEditorStringPrompt {
        public QuestMobsCowsPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("stageEditorMilkCowsPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestMobsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel")) && !input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                try {
                    int i = Integer.parseInt(input);
                    if (i < 0) {
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("stageEditorPositiveAmount"));
                        return new QuestMobsCowsPrompt(context);
                    }
                    if (i <= 0) return new QuestMobsPrompt(QuestMobsPrompt.this.stageNum, context);
                    context.setSessionData((Object)(QuestMobsPrompt.this.pref + "cowMilk"), (Object)i);
                    return new QuestMobsPrompt(QuestMobsPrompt.this.stageNum, context);
                }
                catch (NumberFormatException e) {
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("reqNotANumber").replace("<input>", input));
                    return new QuestMobsCowsPrompt(context);
                }
            } else {
                if (!input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) return new QuestMobsPrompt(QuestMobsPrompt.this.stageNum, context);
                context.setSessionData((Object)(QuestMobsPrompt.this.pref + "cowMilk"), null);
            }
            return new QuestMobsPrompt(QuestMobsPrompt.this.stageNum, context);
        }
    }

    public class QuestMobsShearListPrompt
    extends QuestsEditorNumericPrompt {
        private final int size = 4;

        public QuestMobsShearListPrompt(ConversationContext context) {
            super(context);
            this.size = 4;
        }

        @Override
        public int getSize() {
            return 4;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("stageEditorShearSheep");
        }

        @Override
        public ChatColor getNumberColor(ConversationContext context, int number) {
            switch (number) {
                case 1: 
                case 2: {
                    return ChatColor.BLUE;
                }
                case 3: {
                    return ChatColor.RED;
                }
                case 4: {
                    return ChatColor.GREEN;
                }
            }
            return null;
        }

        @Override
        public String getSelectionText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.YELLOW + BukkitLang.get("stageEditorSetShearColors");
                }
                case 2: {
                    return ChatColor.YELLOW + BukkitLang.get("stageEditorSetShearAmounts");
                }
                case 3: {
                    return ChatColor.RED + BukkitLang.get("clear");
                }
                case 4: {
                    return ChatColor.GREEN + BukkitLang.get("done");
                }
            }
            return null;
        }

        @Override
        public String getAdditionalText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    if (context.getSessionData((Object)(QuestMobsPrompt.this.pref + "shearColors")) == null) {
                        return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    StringBuilder text = new StringBuilder();
                    List shearColors = (List)context.getSessionData((Object)(QuestMobsPrompt.this.pref + "shearColors"));
                    if (shearColors != null) {
                        for (String s : shearColors) {
                            text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.AQUA).append(s);
                        }
                    }
                    return text.toString();
                }
                case 2: {
                    if (context.getSessionData((Object)(QuestMobsPrompt.this.pref + "shearAmounts")) == null) {
                        return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    StringBuilder text = new StringBuilder();
                    List shearAmounts = (List)context.getSessionData((Object)(QuestMobsPrompt.this.pref + "shearAmounts"));
                    if (shearAmounts != null) {
                        for (Integer i : shearAmounts) {
                            text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.AQUA).append(i);
                        }
                    }
                    return text.toString();
                }
                case 3: 
                case 4: {
                    return "";
                }
            }
            return null;
        }

        @Override
        @NotNull
        public String getBasicPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenNumericPromptEvent event = new QuestsEditorPostOpenNumericPromptEvent(context, this);
            QuestMobsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(ChatColor.AQUA + "- " + this.getTitle(context) + " -");
            for (int i = 1; i <= 4; ++i) {
                text.append("\n").append(this.getNumberColor(context, i)).append(ChatColor.BOLD).append(i).append(ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i)).append(" ").append(this.getAdditionalText(context, i));
            }
            return text.toString();
        }

        protected Prompt acceptValidatedInput(@NotNull ConversationContext context, Number input) {
            switch (input.intValue()) {
                case 1: {
                    return new QuestMobsShearColorsPrompt(context);
                }
                case 2: {
                    return new QuestMobsShearAmountsPrompt(context);
                }
                case 3: {
                    context.getForWhom().sendRawMessage(ChatColor.YELLOW + BukkitLang.get("stageEditorObjectiveCleared"));
                    context.setSessionData((Object)(QuestMobsPrompt.this.pref + "shearColors"), null);
                    context.setSessionData((Object)(QuestMobsPrompt.this.pref + "shearAmounts"), null);
                    return new QuestMobsShearListPrompt(context);
                }
                case 4: {
                    List colors = (List)context.getSessionData((Object)(QuestMobsPrompt.this.pref + "shearColors"));
                    List amounts = (List)context.getSessionData((Object)(QuestMobsPrompt.this.pref + "shearAmounts"));
                    int one = colors != null ? colors.size() : 0;
                    int two = amounts != null ? amounts.size() : 0;
                    if (one == two) {
                        return new QuestMobsPrompt(QuestMobsPrompt.this.stageNum, context);
                    }
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("listsNotSameSize"));
                    return new QuestMobsShearListPrompt(context);
                }
            }
            return new QuestMobsPrompt(QuestMobsPrompt.this.stageNum, context);
        }
    }

    public class QuestMobsShearAmountsPrompt
    extends QuestsEditorStringPrompt {
        public QuestMobsShearAmountsPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("stageEditorShearAmountsPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestMobsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                LinkedList<Integer> shearAmounts = new LinkedList<Integer>();
                for (String s : input.split(" ")) {
                    try {
                        int i = Integer.parseInt(s);
                        if (i < 1) {
                            context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("invalidMinimum").replace("<number>", "1"));
                            return new QuestMobsShearAmountsPrompt(context);
                        }
                        shearAmounts.add(i);
                    }
                    catch (NumberFormatException e) {
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("reqNotANumber").replace("<input>", input));
                        return new QuestMobsShearAmountsPrompt(context);
                    }
                }
                context.setSessionData((Object)(QuestMobsPrompt.this.pref + "shearAmounts"), shearAmounts);
            }
            return new QuestMobsShearListPrompt(context);
        }
    }

    public class QuestMobsShearColorsPrompt
    extends QuestsEditorStringPrompt {
        public QuestMobsShearColorsPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("stageEditorColors");
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("stageEditorShearColorsPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestMobsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder cols = new StringBuilder(ChatColor.LIGHT_PURPLE + "- " + this.getTitle(context) + " - \n");
            DyeColor[] colArr = DyeColor.values();
            for (int i = 0; i < colArr.length; ++i) {
                if (i < colArr.length - 1) {
                    cols.append(BukkitMiscUtil.snakeCaseToUpperCamelCase(colArr[i].name())).append(", ");
                    continue;
                }
                cols.append(BukkitMiscUtil.snakeCaseToUpperCamelCase(colArr[i].name())).append("\n");
            }
            return cols.toString() + ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                LinkedList<String> colors = new LinkedList<String>();
                for (String s : input.split(" ")) {
                    LinkedList amounts;
                    if (BukkitMiscUtil.getProperDyeColor(s) != null) {
                        colors.add(s);
                        context.setSessionData((Object)(QuestMobsPrompt.this.pref + "shearColors"), colors);
                        amounts = new LinkedList();
                        if (context.getSessionData((Object)(QuestMobsPrompt.this.pref + "shearAmounts")) != null) {
                            amounts = (LinkedList)context.getSessionData((Object)(QuestMobsPrompt.this.pref + "shearAmounts"));
                        }
                        if (amounts != null) {
                            for (int i = 0; i < colors.size(); ++i) {
                                if (i < amounts.size()) continue;
                                amounts.add(1);
                            }
                        }
                    } else {
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("stageEditorInvalidDye").replace("<input>", s));
                        return new QuestMobsShearColorsPrompt(context);
                    }
                    context.setSessionData((Object)(QuestMobsPrompt.this.pref + "shearAmounts"), (Object)amounts);
                }
            }
            return new QuestMobsShearListPrompt(context);
        }
    }

    public class QuestMobsTameAmountsPrompt
    extends QuestsEditorStringPrompt {
        public QuestMobsTameAmountsPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("stageEditorTameAmountsPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestMobsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                LinkedList<Integer> mobAmounts = new LinkedList<Integer>();
                for (String s : input.split(" ")) {
                    try {
                        int i = Integer.parseInt(s);
                        if (i < 1) {
                            context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("invalidMinimum").replace("<number>", "1"));
                            return new QuestMobsTameAmountsPrompt(context);
                        }
                        mobAmounts.add(i);
                    }
                    catch (NumberFormatException e) {
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("reqNotANumber").replace("<input>", input));
                        return new QuestMobsTameAmountsPrompt(context);
                    }
                }
                context.setSessionData((Object)(QuestMobsPrompt.this.pref + "tameAmounts"), mobAmounts);
            }
            return new QuestMobsTameListPrompt(context);
        }
    }

    public class QuestMobsTameTypesPrompt
    extends QuestsEditorStringPrompt {
        public QuestMobsTameTypesPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("eventEditorMobsTitle");
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("stageEditorMobsPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestMobsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder mobs = new StringBuilder(ChatColor.LIGHT_PURPLE + this.getTitle(context) + "\n");
            LinkedList<EntityType> mobArr = new LinkedList<EntityType>(Arrays.asList(EntityType.values()));
            LinkedList<EntityType> toRemove = new LinkedList<EntityType>();
            for (EntityType type : mobArr) {
                Class ec = type.getEntityClass();
                if (type.isAlive() && (ec == null || Tameable.class.isAssignableFrom(ec))) continue;
                toRemove.add(type);
            }
            mobArr.removeAll(toRemove);
            mobArr.sort(Comparator.comparing(Enum::name));
            for (int i = 0; i < mobArr.size(); ++i) {
                mobs.append(ChatColor.AQUA).append(BukkitMiscUtil.snakeCaseToUpperCamelCase(((EntityType)mobArr.get(i)).name()));
                if (i >= mobArr.size() - 1) continue;
                mobs.append(ChatColor.GRAY).append(", ");
            }
            mobs.append("\n").append(ChatColor.YELLOW).append(this.getQueryText(context));
            return mobs.toString();
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                LinkedList<String> mobTypes = new LinkedList<String>();
                for (String s : input.split(" ")) {
                    if (BukkitMiscUtil.getProperMobType(s) != null) {
                        EntityType type = BukkitMiscUtil.getProperMobType(s);
                        if (type == null) continue;
                        Class ec = type.getEntityClass();
                        if (type.isAlive() && ec != null && Tameable.class.isAssignableFrom(ec)) {
                            mobTypes.add(s);
                            context.setSessionData((Object)(QuestMobsPrompt.this.pref + "tameTypes"), mobTypes);
                            LinkedList amounts = new LinkedList();
                            if (context.getSessionData((Object)(QuestMobsPrompt.this.pref + "tameAmounts")) != null) {
                                amounts = (LinkedList)context.getSessionData((Object)(QuestMobsPrompt.this.pref + "tameAmounts"));
                            }
                            if (amounts != null) {
                                for (int i = 0; i < mobTypes.size(); ++i) {
                                    if (i < amounts.size()) continue;
                                    amounts.add(1);
                                }
                            }
                            context.setSessionData((Object)(QuestMobsPrompt.this.pref + "tameAmounts"), (Object)amounts);
                            continue;
                        }
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("stageEditorInvalidMob").replace("<input>", s));
                        return new QuestMobsTameTypesPrompt(context);
                    }
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("stageEditorInvalidMob").replace("<input>", s));
                    return new QuestMobsTameTypesPrompt(context);
                }
            }
            return new QuestMobsTameListPrompt(context);
        }
    }

    public class QuestMobsLocationNamesPrompt
    extends QuestsEditorStringPrompt {
        public QuestMobsLocationNamesPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("stageEditorMobLocationNamesPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestMobsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                LinkedList<String> locNames = new LinkedList<String>(Arrays.asList(input.split(BukkitLang.get("charSemi"))));
                context.setSessionData((Object)(QuestMobsPrompt.this.pref + "killLocationNames"), locNames);
            }
            return new QuestMobsKillListPrompt(context);
        }
    }

    public class QuestMobsRadiiPrompt
    extends QuestsEditorStringPrompt {
        public QuestMobsRadiiPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("stageEditorMobLocationRadiiPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestMobsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                LinkedList<Integer> radii = new LinkedList<Integer>();
                for (String s : input.split(" ")) {
                    try {
                        int i = Integer.parseInt(s);
                        if (i < 1) {
                            context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("invalidMinimum").replace("<number>", "1"));
                            return new QuestMobsRadiiPrompt(context);
                        }
                        radii.add(i);
                    }
                    catch (NumberFormatException e) {
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("stageEditorInvalidItemName").replace("<input>", s));
                        return new QuestMobsRadiiPrompt(context);
                    }
                }
                context.setSessionData((Object)(QuestMobsPrompt.this.pref + "killLocationRadii"), radii);
            }
            return new QuestMobsKillListPrompt(context);
        }
    }

    public class QuestMobsLocationPrompt
    extends QuestsEditorStringPrompt {
        public QuestMobsLocationPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("stageEditorMobLocationPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestMobsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            Player player = (Player)context.getForWhom();
            if (input.equalsIgnoreCase(BukkitLang.get("cmdAdd"))) {
                LinkedList locations;
                Block block = QuestMobsPrompt.this.plugin.getQuestFactory().getSelectedKillLocations().get(player.getUniqueId());
                if (block != null) {
                    Location loc = block.getLocation();
                    locations = context.getSessionData((Object)(QuestMobsPrompt.this.pref + "killLocations")) != null ? (LinkedList)context.getSessionData((Object)(QuestMobsPrompt.this.pref + "killLocations")) : new LinkedList();
                    if (locations != null) {
                        locations.add(BukkitConfigUtil.getLocationInfo(loc));
                    }
                } else {
                    player.sendMessage(ChatColor.RED + BukkitLang.get("stageEditorNoBlock"));
                    return new QuestMobsLocationPrompt(context);
                }
                context.setSessionData((Object)(QuestMobsPrompt.this.pref + "killLocations"), (Object)locations);
                ConcurrentHashMap<UUID, Block> temp = QuestMobsPrompt.this.plugin.getQuestFactory().getSelectedKillLocations();
                temp.remove(player.getUniqueId());
                QuestMobsPrompt.this.plugin.getQuestFactory().setSelectedKillLocations(temp);
                return new QuestMobsKillListPrompt(context);
            }
            if (input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                ConcurrentHashMap<UUID, Block> temp = QuestMobsPrompt.this.plugin.getQuestFactory().getSelectedKillLocations();
                temp.remove(player.getUniqueId());
                QuestMobsPrompt.this.plugin.getQuestFactory().setSelectedKillLocations(temp);
                return new QuestMobsKillListPrompt(context);
            }
            return new QuestMobsLocationPrompt(context);
        }
    }

    public class QuestMobsAmountsPrompt
    extends QuestsEditorStringPrompt {
        public QuestMobsAmountsPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("stageEditorMobAmountsPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestMobsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                LinkedList<Integer> mobAmounts = new LinkedList<Integer>();
                for (String s : input.split(" ")) {
                    try {
                        int i = Integer.parseInt(s);
                        if (i < 1) {
                            context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("invalidMinimum").replace("<number>", "1"));
                            return new QuestMobsAmountsPrompt(context);
                        }
                        mobAmounts.add(i);
                    }
                    catch (NumberFormatException e) {
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("reqNotANumber").replace("<input>", input));
                        return new QuestMobsAmountsPrompt(context);
                    }
                }
                context.setSessionData((Object)(QuestMobsPrompt.this.pref + "mobAmounts"), mobAmounts);
            }
            return new QuestMobsKillListPrompt(context);
        }
    }

    public class QuestMobsTypesPrompt
    extends QuestsEditorStringPrompt {
        public QuestMobsTypesPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("eventEditorMobsTitle");
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("stageEditorMobsPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestMobsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder mobs = new StringBuilder(ChatColor.LIGHT_PURPLE + this.getTitle(context) + "\n");
            LinkedList<EntityType> mobArr = new LinkedList<EntityType>(Arrays.asList(EntityType.values()));
            LinkedList<EntityType> toRemove = new LinkedList<EntityType>();
            for (EntityType type : mobArr) {
                if (type.isAlive() && !type.name().equals("PLAYER")) continue;
                toRemove.add(type);
            }
            mobArr.removeAll(toRemove);
            mobArr.sort(Comparator.comparing(Enum::name));
            for (int i = 0; i < mobArr.size(); ++i) {
                mobs.append(ChatColor.AQUA).append(BukkitMiscUtil.snakeCaseToUpperCamelCase(((EntityType)mobArr.get(i)).name()));
                if (i >= mobArr.size() - 1) continue;
                mobs.append(ChatColor.GRAY).append(", ");
            }
            mobs.append("\n").append(ChatColor.YELLOW).append(this.getQueryText(context));
            return mobs.toString();
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                LinkedList<String> mobTypes = new LinkedList<String>();
                for (String s : input.split(" ")) {
                    if (BukkitMiscUtil.getProperMobType(s) == null) {
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("stageEditorInvalidMob").replace("<input>", s));
                        return new QuestMobsTypesPrompt(context);
                    }
                    mobTypes.add(s);
                }
                context.setSessionData((Object)(QuestMobsPrompt.this.pref + "mobTypes"), mobTypes);
                LinkedList amounts = new LinkedList();
                if (context.getSessionData((Object)(QuestMobsPrompt.this.pref + "mobAmounts")) != null) {
                    amounts = (LinkedList)context.getSessionData((Object)(QuestMobsPrompt.this.pref + "mobAmounts"));
                }
                if (amounts != null) {
                    for (int i = 0; i < mobTypes.size(); ++i) {
                        if (i < amounts.size()) continue;
                        amounts.add(1);
                    }
                }
                context.setSessionData((Object)(QuestMobsPrompt.this.pref + "mobAmounts"), (Object)amounts);
            }
            return new QuestMobsKillListPrompt(context);
        }
    }
}

