/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.convo.quests.objectives;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListSet;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.convo.generic.ItemStackPrompt;
import me.pikamug.quests.convo.quests.QuestsEditorNumericPrompt;
import me.pikamug.quests.convo.quests.QuestsEditorStringPrompt;
import me.pikamug.quests.convo.quests.stages.QuestStageMainPrompt;
import me.pikamug.quests.events.editor.quests.QuestsEditorPostOpenNumericPromptEvent;
import me.pikamug.quests.events.editor.quests.QuestsEditorPostOpenStringPromptEvent;
import me.pikamug.quests.util.BukkitItemUtil;
import me.pikamug.quests.util.BukkitLang;
import org.bukkit.ChatColor;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.Prompt;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class QuestNpcsPrompt
extends QuestsEditorNumericPrompt {
    private final BukkitQuestsPlugin plugin;
    private final int stageNum;
    private final String pref;
    private final int size = 4;

    public QuestNpcsPrompt(int stageNum, ConversationContext context) {
        super(context);
        this.plugin = (BukkitQuestsPlugin)context.getPlugin();
        this.stageNum = stageNum;
        this.pref = "stage" + stageNum;
    }

    @Override
    public int getSize() {
        return 4;
    }

    @Override
    public String getTitle(ConversationContext context) {
        return BukkitLang.get("stageEditorNPCs");
    }

    @Override
    public ChatColor getNumberColor(ConversationContext context, int number) {
        switch (number) {
            case 1: 
            case 2: 
            case 3: {
                return ChatColor.BLUE;
            }
            case 4: {
                return ChatColor.GREEN;
            }
        }
        return null;
    }

    @Override
    public String getSelectionText(ConversationContext context, int number) {
        switch (number) {
            case 1: {
                return ChatColor.YELLOW + BukkitLang.get("stageEditorDeliverItems");
            }
            case 2: {
                return ChatColor.YELLOW + BukkitLang.get("stageEditorTalkToNPCs");
            }
            case 3: {
                return ChatColor.YELLOW + BukkitLang.get("stageEditorKillNPCs");
            }
            case 4: {
                return ChatColor.GREEN + BukkitLang.get("done");
            }
        }
        return null;
    }

    @Override
    public String getAdditionalText(ConversationContext context, int number) {
        switch (number) {
            case 1: {
                if (this.plugin.getDependencies().hasAnyNpcDependencies()) {
                    if (context.getSessionData((Object)(this.pref + "deliveryItems")) == null) {
                        return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    StringBuilder text = new StringBuilder();
                    LinkedList npcs = (LinkedList)context.getSessionData((Object)(this.pref + "deliveryNPCs"));
                    LinkedList items = (LinkedList)context.getSessionData((Object)(this.pref + "deliveryItems"));
                    if (npcs != null && items != null) {
                        for (int i = 0; i < npcs.size(); ++i) {
                            text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.BLUE).append(BukkitItemUtil.getName((ItemStack)items.get(i))).append(ChatColor.GRAY).append(" x ").append(ChatColor.AQUA).append(((ItemStack)items.get(i)).getAmount()).append(ChatColor.GRAY).append(" ").append(BukkitLang.get("to")).append(" ").append(ChatColor.BLUE).append(this.plugin.getDependencies().getNpcName(UUID.fromString((String)npcs.get(i))));
                        }
                    }
                    return text.toString();
                }
                return ChatColor.GRAY + " (" + BukkitLang.get("notInstalled") + ")";
            }
            case 2: {
                if (this.plugin.getDependencies().hasAnyNpcDependencies()) {
                    if (context.getSessionData((Object)(this.pref + "npcIdsToTalkTo")) == null) {
                        return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    StringBuilder text = new StringBuilder();
                    LinkedList npcs = (LinkedList)context.getSessionData((Object)(this.pref + "npcIdsToTalkTo"));
                    if (npcs != null) {
                        for (String npc : npcs) {
                            text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.BLUE).append(this.plugin.getDependencies().getNpcName(UUID.fromString(npc)));
                        }
                    }
                    return text.toString();
                }
                return ChatColor.GRAY + "(" + BukkitLang.get("notInstalled") + ")";
            }
            case 3: {
                if (this.plugin.getDependencies().hasAnyNpcDependencies()) {
                    if (context.getSessionData((Object)(this.pref + "npcIdsToKill")) == null) {
                        return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    StringBuilder text = new StringBuilder();
                    LinkedList npcs = (LinkedList)context.getSessionData((Object)(this.pref + "npcIdsToKill"));
                    LinkedList amounts = (LinkedList)context.getSessionData((Object)(this.pref + "npcAmountsToKill"));
                    if (npcs != null && amounts != null) {
                        for (int i = 0; i < npcs.size(); ++i) {
                            text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.BLUE).append(this.plugin.getDependencies().getNpcName(UUID.fromString((String)npcs.get(i)))).append(ChatColor.GRAY).append(" x ").append(ChatColor.AQUA).append(amounts.get(i));
                        }
                    }
                    return text.toString();
                }
                return ChatColor.GRAY + "(" + BukkitLang.get("notInstalled") + ")";
            }
            case 4: {
                return "";
            }
        }
        return null;
    }

    @Override
    @NotNull
    public String getBasicPromptText(ConversationContext context) {
        context.setSessionData((Object)this.pref, (Object)Boolean.TRUE);
        QuestsEditorPostOpenNumericPromptEvent event = new QuestsEditorPostOpenNumericPromptEvent(context, this);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        StringBuilder text = new StringBuilder(ChatColor.AQUA + "- " + this.getTitle(context) + " -");
        for (int i = 1; i <= 4; ++i) {
            text.append("\n").append(this.getNumberColor(context, i)).append(ChatColor.BOLD).append(i).append(ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i)).append(" ").append(this.getAdditionalText(context, i));
        }
        return text.toString();
    }

    protected Prompt acceptValidatedInput(@NotNull ConversationContext context, Number input) {
        switch (input.intValue()) {
            case 1: {
                if (this.plugin.getDependencies().hasAnyNpcDependencies()) {
                    return new QuestNpcsDeliveryListPrompt(context);
                }
                context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("stageEditorNoCitizens"));
                return new QuestStageMainPrompt(this.stageNum, context);
            }
            case 2: {
                if (this.plugin.getDependencies().hasAnyNpcDependencies()) {
                    return new QuestNpcsIdsToTalkToPrompt(context);
                }
                context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("stageEditorNoCitizens"));
                return new QuestStageMainPrompt(this.stageNum, context);
            }
            case 3: {
                if (this.plugin.getDependencies().hasAnyNpcDependencies()) {
                    return new QuestNpcsKillListPrompt(context);
                }
                context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("stageEditorNoCitizens"));
                return new QuestStageMainPrompt(this.stageNum, context);
            }
            case 4: {
                try {
                    return new QuestStageMainPrompt(this.stageNum, context);
                }
                catch (Exception e) {
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("itemCreateCriticalError"));
                    return Prompt.END_OF_CONVERSATION;
                }
            }
        }
        return new QuestNpcsPrompt(this.stageNum, context);
    }

    public class QuestNpcsDeliveryListPrompt
    extends QuestsEditorNumericPrompt {
        private final int size = 5;

        public QuestNpcsDeliveryListPrompt(ConversationContext context) {
            super(context);
            this.size = 5;
        }

        @Override
        public int getSize() {
            return 5;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("stageEditorDeliverItems");
        }

        @Override
        public ChatColor getNumberColor(ConversationContext context, int number) {
            switch (number) {
                case 1: 
                case 2: 
                case 3: {
                    return ChatColor.BLUE;
                }
                case 4: {
                    return ChatColor.RED;
                }
                case 5: {
                    return ChatColor.GREEN;
                }
            }
            return null;
        }

        @Override
        public String getSelectionText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.YELLOW + BukkitLang.get("stageEditorDeliveryAddItem");
                }
                case 2: {
                    return ChatColor.YELLOW + BukkitLang.get("stageEditorNPCUniqueIds");
                }
                case 3: {
                    return ChatColor.YELLOW + BukkitLang.get("stageEditorDeliveryMessages");
                }
                case 4: {
                    return ChatColor.RED + BukkitLang.get("clear");
                }
                case 5: {
                    return ChatColor.GREEN + BukkitLang.get("done");
                }
            }
            return null;
        }

        @Override
        public String getAdditionalText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    if (context.getSessionData((Object)(QuestNpcsPrompt.this.pref + "deliveryItems")) == null) {
                        return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    StringBuilder text = new StringBuilder();
                    List deliveryItems = (List)context.getSessionData((Object)(QuestNpcsPrompt.this.pref + "deliveryItems"));
                    if (deliveryItems != null) {
                        for (ItemStack is : deliveryItems) {
                            text.append("\n").append(ChatColor.GRAY).append("     - ").append(BukkitItemUtil.getDisplayString(is));
                        }
                    }
                    return text.toString();
                }
                case 2: {
                    if (context.getSessionData((Object)(QuestNpcsPrompt.this.pref + "deliveryNPCs")) == null) {
                        return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    StringBuilder text = new StringBuilder();
                    List deliveryNpcs = (List)context.getSessionData((Object)(QuestNpcsPrompt.this.pref + "deliveryNPCs"));
                    if (deliveryNpcs != null) {
                        for (String s : deliveryNpcs) {
                            UUID uuid = UUID.fromString(s);
                            text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.AQUA).append(QuestNpcsPrompt.this.plugin.getDependencies().getNpcName(uuid)).append(ChatColor.GRAY).append(" (").append(ChatColor.BLUE).append(s).append(ChatColor.GRAY).append(")");
                        }
                    }
                    return text.toString();
                }
                case 3: {
                    if (context.getSessionData((Object)(QuestNpcsPrompt.this.pref + "deliveryMessages")) == null) {
                        return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    StringBuilder text = new StringBuilder();
                    List deliveryMessages = (List)context.getSessionData((Object)(QuestNpcsPrompt.this.pref + "deliveryMessages"));
                    if (deliveryMessages != null) {
                        for (String s : deliveryMessages) {
                            text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.AQUA).append("\"").append(s).append("\"");
                        }
                    }
                    return text.toString();
                }
                case 4: 
                case 5: {
                    return "";
                }
            }
            return null;
        }

        @Override
        @NotNull
        public String getBasicPromptText(ConversationContext context) {
            if (context.getSessionData((Object)"tempStack") != null) {
                if (context.getSessionData((Object)(QuestNpcsPrompt.this.pref + "deliveryItems")) != null) {
                    List itemRew = (List)context.getSessionData((Object)(QuestNpcsPrompt.this.pref + "deliveryItems"));
                    if (itemRew != null) {
                        itemRew.add((ItemStack)context.getSessionData((Object)"tempStack"));
                    }
                    context.setSessionData((Object)(QuestNpcsPrompt.this.pref + "deliveryItems"), (Object)itemRew);
                } else {
                    LinkedList<ItemStack> itemRews = new LinkedList<ItemStack>();
                    itemRews.add((ItemStack)context.getSessionData((Object)"tempStack"));
                    context.setSessionData((Object)(QuestNpcsPrompt.this.pref + "deliveryItems"), itemRews);
                }
                ItemStackPrompt.clearSessionData(context);
            }
            QuestsEditorPostOpenNumericPromptEvent event = new QuestsEditorPostOpenNumericPromptEvent(context, this);
            QuestNpcsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(ChatColor.AQUA + "- " + this.getTitle(context) + " -");
            for (int i = 1; i <= 5; ++i) {
                text.append("\n").append(this.getNumberColor(context, i)).append(ChatColor.BOLD).append(i).append(ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i)).append(" ").append(this.getAdditionalText(context, i));
            }
            return text.toString();
        }

        protected Prompt acceptValidatedInput(@NotNull ConversationContext context, Number input) {
            switch (input.intValue()) {
                case 1: {
                    return new ItemStackPrompt(context, (Prompt)this);
                }
                case 2: {
                    return new QuestNpcDeliveryNpcsPrompt(context);
                }
                case 3: {
                    return new QuestNpcDeliveryMessagesPrompt(context);
                }
                case 4: {
                    context.getForWhom().sendRawMessage(ChatColor.YELLOW + BukkitLang.get("cleared"));
                    context.setSessionData((Object)(QuestNpcsPrompt.this.pref + "deliveryItems"), null);
                    context.setSessionData((Object)(QuestNpcsPrompt.this.pref + "deliveryNPCs"), null);
                    context.setSessionData((Object)(QuestNpcsPrompt.this.pref + "deliveryMessages"), null);
                    return new QuestNpcsDeliveryListPrompt(context);
                }
                case 5: {
                    List items = (List)context.getSessionData((Object)(QuestNpcsPrompt.this.pref + "deliveryItems"));
                    List npcs = (List)context.getSessionData((Object)(QuestNpcsPrompt.this.pref + "deliveryNPCs"));
                    int one = items != null ? items.size() : 0;
                    int two = npcs != null ? npcs.size() : 0;
                    if (one == two) {
                        if (context.getSessionData((Object)(QuestNpcsPrompt.this.pref + "deliveryMessages")) == null && one != 0) {
                            context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("stageEditorNoDeliveryMessage"));
                            return new QuestNpcsDeliveryListPrompt(context);
                        }
                        return new QuestNpcsPrompt(QuestNpcsPrompt.this.stageNum, context);
                    }
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("listsNotSameSize"));
                    return new QuestNpcsDeliveryListPrompt(context);
                }
            }
            return new QuestNpcsPrompt(QuestNpcsPrompt.this.stageNum, context);
        }
    }

    public class QuestNpcsIdsToTalkToPrompt
    extends QuestsEditorStringPrompt {
        public QuestNpcsIdsToTalkToPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("enterOrClearNpcUniqueIds");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestNpcsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            if (context.getForWhom() instanceof Player) {
                ConcurrentSkipListSet<UUID> selectingNpcs = QuestNpcsPrompt.this.plugin.getQuestFactory().getSelectingNpcs();
                selectingNpcs.add(((Player)context.getForWhom()).getUniqueId());
                QuestNpcsPrompt.this.plugin.getQuestFactory().setSelectingNpcs(selectingNpcs);
                return ChatColor.YELLOW + BukkitLang.get("questEditorClickNPCStart");
            }
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel")) && !input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                String[] args = input.split(" ");
                LinkedList npcs = context.getSessionData((Object)(QuestNpcsPrompt.this.pref + "npcIdsToTalkTo")) != null ? (LinkedList)context.getSessionData((Object)(QuestNpcsPrompt.this.pref + "npcIdsToTalkTo")) : new LinkedList();
                for (String s : args) {
                    try {
                        UUID uuid = UUID.fromString(s);
                        if (npcs == null || !QuestNpcsPrompt.this.plugin.getDependencies().isNpc(uuid)) {
                            context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("stageEditorInvalidNPC").replace("<input>", s));
                            return new QuestNpcsIdsToTalkToPrompt(context);
                        }
                        npcs.add(uuid.toString());
                    }
                    catch (NumberFormatException e) {
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("stageEditorNotListOfUniqueIds").replace("<data>", s));
                        return new QuestNpcsIdsToTalkToPrompt(context);
                    }
                }
                context.setSessionData((Object)(QuestNpcsPrompt.this.pref + "npcIdsToTalkTo"), (Object)npcs);
            } else if (input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                context.setSessionData((Object)(QuestNpcsPrompt.this.pref + "npcIdsToTalkTo"), null);
            }
            if (context.getForWhom() instanceof Player) {
                ConcurrentSkipListSet<UUID> selectingNpcs = QuestNpcsPrompt.this.plugin.getQuestFactory().getSelectingNpcs();
                selectingNpcs.remove(((Player)context.getForWhom()).getUniqueId());
                QuestNpcsPrompt.this.plugin.getQuestFactory().setSelectingNpcs(selectingNpcs);
            }
            return new QuestStageMainPrompt(QuestNpcsPrompt.this.stageNum, context);
        }
    }

    public class QuestNpcsKillListPrompt
    extends QuestsEditorNumericPrompt {
        private final int size = 4;

        public QuestNpcsKillListPrompt(ConversationContext context) {
            super(context);
            this.size = 4;
        }

        @Override
        public int getSize() {
            return 4;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("stageEditorNPCs");
        }

        @Override
        public ChatColor getNumberColor(ConversationContext context, int number) {
            switch (number) {
                case 1: 
                case 2: {
                    return ChatColor.BLUE;
                }
                case 3: {
                    return ChatColor.RED;
                }
                case 4: {
                    return ChatColor.GREEN;
                }
            }
            return null;
        }

        @Override
        public String getSelectionText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.YELLOW + BukkitLang.get("stageEditorNPCUniqueIds");
                }
                case 2: {
                    return ChatColor.YELLOW + BukkitLang.get("stageEditorSetKillAmounts");
                }
                case 3: {
                    return ChatColor.RED + BukkitLang.get("clear");
                }
                case 4: {
                    return ChatColor.GREEN + BukkitLang.get("done");
                }
            }
            return null;
        }

        @Override
        public String getAdditionalText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    if (QuestNpcsPrompt.this.plugin.getDependencies().hasAnyNpcDependencies()) {
                        if (context.getSessionData((Object)(QuestNpcsPrompt.this.pref + "npcIdsToKill")) == null) {
                            return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                        }
                        StringBuilder text = new StringBuilder();
                        List npcsToKill = (List)context.getSessionData((Object)(QuestNpcsPrompt.this.pref + "npcIdsToKill"));
                        if (npcsToKill != null) {
                            for (String s : npcsToKill) {
                                text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.BLUE).append(QuestNpcsPrompt.this.plugin.getDependencies().getNpcName(UUID.fromString(s))).append(ChatColor.GRAY).append(" (").append(ChatColor.AQUA).append(s).append(ChatColor.GRAY).append(")");
                            }
                        }
                        return text.toString();
                    }
                    return ChatColor.GRAY + " (" + BukkitLang.get("notInstalled") + ")";
                }
                case 2: {
                    if (context.getSessionData((Object)(QuestNpcsPrompt.this.pref + "npcAmountsToKill")) == null) {
                        return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    StringBuilder text = new StringBuilder();
                    List npcsToKillAmounts = (List)context.getSessionData((Object)(QuestNpcsPrompt.this.pref + "npcAmountsToKill"));
                    if (npcsToKillAmounts != null) {
                        for (Integer i : npcsToKillAmounts) {
                            text.append("\n").append(ChatColor.GRAY).append("     - ").append(ChatColor.BLUE).append(i);
                        }
                    }
                    return text.toString();
                }
                case 3: 
                case 4: {
                    return "";
                }
            }
            return null;
        }

        @Override
        @NotNull
        public String getBasicPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenNumericPromptEvent event = new QuestsEditorPostOpenNumericPromptEvent(context, this);
            QuestNpcsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(ChatColor.AQUA + "- " + this.getTitle(context) + " -");
            for (int i = 1; i <= 4; ++i) {
                text.append("\n").append(this.getNumberColor(context, i)).append(ChatColor.BOLD).append(i).append(ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i)).append(" ").append(this.getAdditionalText(context, i));
            }
            return text.toString();
        }

        protected Prompt acceptValidatedInput(@NotNull ConversationContext context, Number input) {
            switch (input.intValue()) {
                case 1: {
                    return new QuestNpcIdsToKillPrompt(context);
                }
                case 2: {
                    return new QuestNpcAmountsToKillPrompt(context);
                }
                case 3: {
                    context.getForWhom().sendRawMessage(ChatColor.YELLOW + BukkitLang.get("stageEditorObjectiveCleared"));
                    context.setSessionData((Object)(QuestNpcsPrompt.this.pref + "npcIdsToKill"), null);
                    context.setSessionData((Object)(QuestNpcsPrompt.this.pref + "npcAmountsToKill"), null);
                    return new QuestNpcsKillListPrompt(context);
                }
                case 4: {
                    List kill = (List)context.getSessionData((Object)(QuestNpcsPrompt.this.pref + "npcIdsToKill"));
                    List killAmounts = (List)context.getSessionData((Object)(QuestNpcsPrompt.this.pref + "npcAmountsToKill"));
                    int one = kill != null ? kill.size() : 0;
                    int two = killAmounts != null ? killAmounts.size() : 0;
                    if (one == two) {
                        return new QuestStageMainPrompt(QuestNpcsPrompt.this.stageNum, context);
                    }
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("listsNotSameSize"));
                    return new QuestNpcsKillListPrompt(context);
                }
            }
            return new QuestNpcsPrompt(QuestNpcsPrompt.this.stageNum, context);
        }
    }

    public class QuestNpcAmountsToKillPrompt
    extends QuestsEditorStringPrompt {
        public QuestNpcAmountsToKillPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("stageEditorKillNPCsPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestNpcsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                String[] args = input.split(" ");
                LinkedList<Integer> amounts = new LinkedList<Integer>();
                for (String s : args) {
                    try {
                        if (Integer.parseInt(s) <= 0) {
                            context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("invalidMinimum").replace("<number>", "1"));
                            return new QuestNpcAmountsToKillPrompt(context);
                        }
                        amounts.add(Integer.parseInt(s));
                    }
                    catch (NumberFormatException e) {
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("stageEditorNotListOfUniqueIds").replace("<data>", s));
                        return new QuestNpcAmountsToKillPrompt(context);
                    }
                }
                context.setSessionData((Object)(QuestNpcsPrompt.this.pref + "npcAmountsToKill"), amounts);
            }
            return new QuestNpcsKillListPrompt(context);
        }
    }

    public class QuestNpcIdsToKillPrompt
    extends QuestsEditorStringPrompt {
        public QuestNpcIdsToKillPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("enterNpcUniqueIds");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestNpcsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            if (context.getForWhom() instanceof Player) {
                ConcurrentSkipListSet<UUID> selectingNpcs = QuestNpcsPrompt.this.plugin.getQuestFactory().getSelectingNpcs();
                selectingNpcs.add(((Player)context.getForWhom()).getUniqueId());
                QuestNpcsPrompt.this.plugin.getQuestFactory().setSelectingNpcs(selectingNpcs);
                return ChatColor.YELLOW + BukkitLang.get("questEditorClickNPCStart");
            }
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                String[] args = input.split(" ");
                LinkedList npcs = context.getSessionData((Object)(QuestNpcsPrompt.this.pref + "npcIdsToKill")) != null ? (LinkedList)context.getSessionData((Object)(QuestNpcsPrompt.this.pref + "npcIdsToKill")) : new LinkedList();
                for (String s : args) {
                    try {
                        UUID uuid = UUID.fromString(s);
                        if (npcs == null || !QuestNpcsPrompt.this.plugin.getDependencies().isNpc(uuid)) {
                            context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("stageEditorInvalidNPC").replace("<input>", s));
                            return new QuestNpcIdsToKillPrompt(context);
                        }
                        npcs.add(uuid.toString());
                    }
                    catch (IllegalArgumentException e) {
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("stageEditorNotListOfUniqueIds").replace("<data>", s));
                        return new QuestNpcIdsToKillPrompt(context);
                    }
                }
                context.setSessionData((Object)(QuestNpcsPrompt.this.pref + "npcIdsToKill"), (Object)npcs);
                LinkedList amounts = new LinkedList();
                if (context.getSessionData((Object)(QuestNpcsPrompt.this.pref + "npcAmountsToKill")) != null) {
                    amounts = (LinkedList)context.getSessionData((Object)(QuestNpcsPrompt.this.pref + "npcAmountsToKill"));
                }
                if (npcs != null && amounts != null) {
                    for (int i = 0; i < npcs.size(); ++i) {
                        if (i < amounts.size()) continue;
                        amounts.add(1);
                    }
                }
                context.setSessionData((Object)(QuestNpcsPrompt.this.pref + "npcAmountsToKill"), (Object)amounts);
            }
            ConcurrentSkipListSet<UUID> selectingNpcs = QuestNpcsPrompt.this.plugin.getQuestFactory().getSelectingNpcs();
            selectingNpcs.remove(((Player)context.getForWhom()).getUniqueId());
            QuestNpcsPrompt.this.plugin.getQuestFactory().setSelectingNpcs(selectingNpcs);
            return new QuestNpcsKillListPrompt(context);
        }
    }

    public class QuestNpcDeliveryMessagesPrompt
    extends QuestsEditorStringPrompt {
        public QuestNpcDeliveryMessagesPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("stageEditorDeliveryMessagesPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestNpcsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.YELLOW + this.getQueryText(context) + "\n" + ChatColor.GOLD + BukkitLang.get("stageEditorNPCNote");
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                String[] args = input.split(BukkitLang.get("charSemi"));
                LinkedList<String> messages = new LinkedList<String>(Arrays.asList(args));
                context.setSessionData((Object)(QuestNpcsPrompt.this.pref + "deliveryMessages"), messages);
            }
            return new QuestNpcsDeliveryListPrompt(context);
        }
    }

    public class QuestNpcDeliveryNpcsPrompt
    extends QuestsEditorStringPrompt {
        public QuestNpcDeliveryNpcsPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("enterNpcUniqueIds");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestNpcsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            if (context.getForWhom() instanceof Player) {
                ConcurrentSkipListSet<UUID> selectingNpcs = QuestNpcsPrompt.this.plugin.getQuestFactory().getSelectingNpcs();
                selectingNpcs.add(((Player)context.getForWhom()).getUniqueId());
                QuestNpcsPrompt.this.plugin.getQuestFactory().setSelectingNpcs(selectingNpcs);
                return ChatColor.YELLOW + BukkitLang.get("questEditorClickNPCStart");
            }
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                LinkedList npcs = context.getSessionData((Object)(QuestNpcsPrompt.this.pref + "deliveryNPCs")) != null ? (LinkedList)context.getSessionData((Object)(QuestNpcsPrompt.this.pref + "deliveryNPCs")) : new LinkedList();
                for (String s : input.split(" ")) {
                    try {
                        UUID uuid = UUID.fromString(s);
                        if (npcs == null || !QuestNpcsPrompt.this.plugin.getDependencies().isNpc(uuid)) {
                            context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("stageEditorInvalidNPC").replace("<input>", s));
                            return new QuestNpcDeliveryNpcsPrompt(context);
                        }
                        npcs.add(uuid.toString());
                    }
                    catch (IllegalArgumentException e) {
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("stageEditorNotListOfUniqueIds").replace("<data>", input));
                        return new QuestNpcDeliveryNpcsPrompt(context);
                    }
                }
                context.setSessionData((Object)(QuestNpcsPrompt.this.pref + "deliveryNPCs"), (Object)npcs);
                LinkedList messages = new LinkedList();
                if (context.getSessionData((Object)(QuestNpcsPrompt.this.pref + "deliveryMessages")) != null) {
                    messages = (LinkedList)context.getSessionData((Object)(QuestNpcsPrompt.this.pref + "deliveryMessages"));
                }
                if (messages != null && npcs != null) {
                    for (int i = 0; i < npcs.size(); ++i) {
                        if (i < messages.size()) continue;
                        messages.add(ChatColor.RESET + BukkitLang.get("thankYouMore"));
                    }
                }
                context.setSessionData((Object)(QuestNpcsPrompt.this.pref + "deliveryMessages"), (Object)messages);
            }
            if (context.getForWhom() instanceof Player) {
                ConcurrentSkipListSet<UUID> selectingNpcs = QuestNpcsPrompt.this.plugin.getQuestFactory().getSelectingNpcs();
                selectingNpcs.remove(((Player)context.getForWhom()).getUniqueId());
                QuestNpcsPrompt.this.plugin.getQuestFactory().setSelectingNpcs(selectingNpcs);
            }
            return new QuestNpcsDeliveryListPrompt(context);
        }
    }
}

