/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.convo.quests.options;

import java.util.Objects;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.convo.quests.QuestsEditorNumericPrompt;
import me.pikamug.quests.convo.quests.QuestsEditorStringPrompt;
import me.pikamug.quests.events.editor.quests.QuestsEditorPostOpenNumericPromptEvent;
import me.pikamug.quests.events.editor.quests.QuestsEditorPostOpenStringPromptEvent;
import me.pikamug.quests.quests.components.BukkitOptions;
import me.pikamug.quests.util.BukkitLang;
import me.pikamug.unite.api.objects.PartyProvider;
import org.bukkit.ChatColor;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.Prompt;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

public class QuestOptionsPrompt
extends QuestsEditorNumericPrompt {
    private final BukkitQuestsPlugin plugin;
    private String tempKey;
    private Prompt tempPrompt;
    private final int size = 4;

    public QuestOptionsPrompt(ConversationContext context) {
        super(context);
        this.plugin = (BukkitQuestsPlugin)context.getPlugin();
    }

    @Override
    public int getSize() {
        return 4;
    }

    @Override
    public String getTitle(ConversationContext context) {
        return BukkitLang.get("optionsTitle").replace("<quest>", (String)Objects.requireNonNull(context.getSessionData((Object)"questName")));
    }

    @Override
    public ChatColor getNumberColor(ConversationContext context, int number) {
        switch (number) {
            case 1: 
            case 2: 
            case 3: {
                return ChatColor.BLUE;
            }
            case 4: {
                return ChatColor.GREEN;
            }
        }
        return null;
    }

    @Override
    public String getSelectionText(ConversationContext context, int number) {
        switch (number) {
            case 1: {
                return ChatColor.GOLD + BukkitLang.get("optGeneral");
            }
            case 2: {
                return ChatColor.GOLD + BukkitLang.get("optMultiplayer");
            }
            case 3: {
                return ChatColor.GOLD + "Server (Global)";
            }
            case 4: {
                return ChatColor.YELLOW + BukkitLang.get("done");
            }
        }
        return null;
    }

    @Override
    public String getAdditionalText(ConversationContext context, int number) {
        return null;
    }

    @Override
    @NotNull
    public String getBasicPromptText(@NotNull ConversationContext context) {
        QuestsEditorPostOpenNumericPromptEvent event = new QuestsEditorPostOpenNumericPromptEvent(context, this);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        StringBuilder text = new StringBuilder(ChatColor.DARK_GREEN + "- " + this.getTitle(context).replace((String)Objects.requireNonNull(context.getSessionData((Object)"questName")), ChatColor.AQUA + (String)context.getSessionData((Object)"questName") + ChatColor.DARK_GREEN) + " -");
        for (int i = 1; i <= 4; ++i) {
            text.append("\n").append(this.getNumberColor(context, i)).append(ChatColor.BOLD).append(i).append(ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i));
        }
        return text.toString();
    }

    protected Prompt acceptValidatedInput(@NotNull ConversationContext context, Number input) {
        switch (input.intValue()) {
            case 1: {
                return new QuestOptionsGeneralPrompt(context);
            }
            case 2: {
                return new QuestOptionsMultiplayerPrompt(context);
            }
            case 3: {
                return new QuestOptionsGlobalPrompt(context);
            }
            case 4: {
                return this.plugin.getQuestFactory().returnToMenu(context);
            }
        }
        return new QuestOptionsPrompt(context);
    }

    public class QuestOptionsGeneralPrompt
    extends QuestsEditorNumericPrompt {
        private final int size = 5;

        public QuestOptionsGeneralPrompt(ConversationContext context) {
            super(context);
            this.size = 5;
        }

        @Override
        public int getSize() {
            return 5;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return ChatColor.DARK_GREEN + BukkitLang.get("optGeneral");
        }

        @Override
        public ChatColor getNumberColor(ConversationContext context, int number) {
            switch (number) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    return ChatColor.BLUE;
                }
                case 5: {
                    return ChatColor.GREEN;
                }
            }
            return null;
        }

        @Override
        public String getSelectionText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.YELLOW + BukkitLang.get("optAllowCommands");
                }
                case 2: {
                    return ChatColor.YELLOW + BukkitLang.get("optAllowQuitting");
                }
                case 3: {
                    return ChatColor.YELLOW + BukkitLang.get("optIgnoreSilkTouch");
                }
                case 4: {
                    return ChatColor.YELLOW + BukkitLang.get("optIgnoreBlockReplace");
                }
                case 5: {
                    return ChatColor.YELLOW + BukkitLang.get("done");
                }
            }
            return null;
        }

        @Override
        public String getAdditionalText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    Boolean commandsOpt = (Boolean)context.getSessionData((Object)"allowCommandsOpt");
                    if (commandsOpt == null) {
                        boolean defaultOpt = new BukkitOptions().canAllowCommands();
                        return ChatColor.GRAY + "(" + (defaultOpt ? ChatColor.GREEN + BukkitLang.get("true") : ChatColor.RED + BukkitLang.get("false")) + ChatColor.GRAY + ")";
                    }
                    return ChatColor.GRAY + "(" + (commandsOpt != false ? ChatColor.GREEN + BukkitLang.get("true") : ChatColor.RED + BukkitLang.get("false")) + ChatColor.GRAY + ")";
                }
                case 2: {
                    Boolean quittingOpt = (Boolean)context.getSessionData((Object)"allowQuittingOpt");
                    if (quittingOpt == null) {
                        boolean defaultOpt = new BukkitOptions().canAllowQuitting();
                        return ChatColor.GRAY + "(" + (defaultOpt ? ChatColor.GREEN + BukkitLang.get("true") : ChatColor.RED + BukkitLang.get("false")) + ChatColor.GRAY + ")";
                    }
                    return ChatColor.GRAY + "(" + (quittingOpt != false ? ChatColor.GREEN + BukkitLang.get("true") : ChatColor.RED + BukkitLang.get("false")) + ChatColor.GRAY + ")";
                }
                case 3: {
                    Boolean ignoreOpt = (Boolean)context.getSessionData((Object)"ignoreSilkTouchOpt");
                    if (ignoreOpt == null) {
                        boolean defaultOpt = new BukkitOptions().canIgnoreSilkTouch();
                        return ChatColor.GRAY + "(" + (defaultOpt ? ChatColor.GREEN + BukkitLang.get("true") : ChatColor.RED + BukkitLang.get("false")) + ChatColor.GRAY + ")";
                    }
                    return ChatColor.GRAY + "(" + (ignoreOpt != false ? ChatColor.GREEN + BukkitLang.get("true") : ChatColor.RED + BukkitLang.get("false")) + ChatColor.GRAY + ")";
                }
                case 4: {
                    Boolean ignoreBlockReplaceOpt = (Boolean)context.getSessionData((Object)"ignoreBlockReplaceOpt");
                    if (ignoreBlockReplaceOpt == null) {
                        boolean defaultOpt = new BukkitOptions().canIgnoreBlockReplace();
                        return ChatColor.GRAY + "(" + (defaultOpt ? ChatColor.GREEN + BukkitLang.get("true") : ChatColor.RED + BukkitLang.get("false")) + ChatColor.GRAY + ")";
                    }
                    return ChatColor.GRAY + "(" + (ignoreBlockReplaceOpt != false ? ChatColor.GREEN + BukkitLang.get("true") : ChatColor.RED + BukkitLang.get("false")) + ChatColor.GRAY + ")";
                }
                case 5: {
                    return "";
                }
            }
            return null;
        }

        @Override
        @NotNull
        public String getBasicPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenNumericPromptEvent event = new QuestsEditorPostOpenNumericPromptEvent(context, this);
            QuestOptionsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(ChatColor.DARK_GREEN + "- " + this.getTitle(context) + " -");
            for (int i = 1; i <= 5; ++i) {
                text.append("\n").append(this.getNumberColor(context, i)).append(ChatColor.BOLD).append(i).append(ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i)).append(" ").append(this.getAdditionalText(context, i));
            }
            return text.toString();
        }

        public Prompt acceptValidatedInput(@NotNull ConversationContext context, Number input) {
            switch (input.intValue()) {
                case 1: {
                    QuestOptionsPrompt.this.tempKey = "allowCommandsOpt";
                    QuestOptionsPrompt.this.tempPrompt = (Prompt)new QuestOptionsGeneralPrompt(context);
                    return new QuestOptionsTrueFalsePrompt(context);
                }
                case 2: {
                    QuestOptionsPrompt.this.tempKey = "allowQuittingOpt";
                    QuestOptionsPrompt.this.tempPrompt = (Prompt)new QuestOptionsGeneralPrompt(context);
                    return new QuestOptionsTrueFalsePrompt(context);
                }
                case 3: {
                    QuestOptionsPrompt.this.tempKey = "ignoreSilkTouchOpt";
                    QuestOptionsPrompt.this.tempPrompt = (Prompt)new QuestOptionsGeneralPrompt(context);
                    return new QuestOptionsTrueFalsePrompt(context);
                }
                case 4: {
                    QuestOptionsPrompt.this.tempKey = "ignoreBlockReplaceOpt";
                    QuestOptionsPrompt.this.tempPrompt = (Prompt)new QuestOptionsGeneralPrompt(context);
                    return new QuestOptionsTrueFalsePrompt(context);
                }
                case 5: {
                    QuestOptionsPrompt.this.tempKey = null;
                    QuestOptionsPrompt.this.tempPrompt = null;
                    try {
                        return new QuestOptionsPrompt(context);
                    }
                    catch (Exception e) {
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("itemCreateCriticalError"));
                        return Prompt.END_OF_CONVERSATION;
                    }
                }
            }
            return null;
        }
    }

    public class QuestOptionsMultiplayerPrompt
    extends QuestsEditorNumericPrompt {
        private final int size = 7;

        public QuestOptionsMultiplayerPrompt(ConversationContext context) {
            super(context);
            this.size = 7;
        }

        @Override
        public int getSize() {
            return 7;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return ChatColor.DARK_GREEN + BukkitLang.get("optMultiplayer");
        }

        @Override
        public ChatColor getNumberColor(ConversationContext context, int number) {
            switch (number) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    return ChatColor.BLUE;
                }
                case 7: {
                    return ChatColor.GREEN;
                }
            }
            return null;
        }

        @Override
        public String getSelectionText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.YELLOW + BukkitLang.get("optExternalPartyPlugin");
                }
                case 2: {
                    return ChatColor.YELLOW + BukkitLang.get("optUsePartiesPlugin");
                }
                case 3: {
                    return ChatColor.YELLOW + BukkitLang.get("optShareProgressLevel");
                }
                case 4: {
                    return ChatColor.YELLOW + BukkitLang.get("optShareOnlySameQuest");
                }
                case 5: {
                    return ChatColor.YELLOW + BukkitLang.get("optShareDistance");
                }
                case 6: {
                    return ChatColor.YELLOW + BukkitLang.get("optHandleOfflinePlayer");
                }
                case 7: {
                    return ChatColor.YELLOW + BukkitLang.get("done");
                }
            }
            return null;
        }

        @Override
        public String getAdditionalText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    String externalOpt = (String)context.getSessionData((Object)"externalPartyPluginOpt");
                    if (QuestOptionsPrompt.this.plugin.getDependencies().getPartyProvider() == null) {
                        return ChatColor.GRAY + "(" + BukkitLang.get("notInstalled") + ")";
                    }
                    if (externalOpt != null) {
                        return ChatColor.GRAY + "(" + ChatColor.AQUA + externalOpt + ChatColor.GRAY + ")";
                    }
                    return "";
                }
                case 2: {
                    Boolean partiesOpt = (Boolean)context.getSessionData((Object)"usePartiesPluginOpt");
                    if (partiesOpt == null) {
                        boolean defaultOpt = new BukkitOptions().canUsePartiesPlugin();
                        return ChatColor.GRAY + "(" + (defaultOpt ? ChatColor.GREEN + BukkitLang.get(String.valueOf(defaultOpt)) : ChatColor.RED + BukkitLang.get(String.valueOf(defaultOpt))) + ChatColor.GRAY + ")";
                    }
                    return ChatColor.GRAY + "(" + (partiesOpt != false ? ChatColor.GREEN + BukkitLang.get(String.valueOf(partiesOpt)) : ChatColor.RED + BukkitLang.get(String.valueOf(partiesOpt))) + ChatColor.GRAY + ")";
                }
                case 3: {
                    Integer shareOpt = (Integer)context.getSessionData((Object)"shareProgressLevelOpt");
                    if (shareOpt == null) {
                        int defaultOpt = new BukkitOptions().getShareProgressLevel();
                        return ChatColor.GRAY + "(" + ChatColor.AQUA + defaultOpt + ChatColor.GRAY + ")";
                    }
                    return ChatColor.GRAY + "(" + ChatColor.AQUA + shareOpt + ChatColor.GRAY + ")";
                }
                case 4: {
                    Boolean requireOpt = (Boolean)context.getSessionData((Object)"shareSameQuestOnlyOpt");
                    if (requireOpt == null) {
                        boolean defaultOpt = new BukkitOptions().canShareSameQuestOnly();
                        return ChatColor.GRAY + "(" + (defaultOpt ? ChatColor.GREEN + BukkitLang.get(String.valueOf(defaultOpt)) : ChatColor.RED + BukkitLang.get(String.valueOf(defaultOpt))) + ChatColor.GRAY + ")";
                    }
                    return ChatColor.GRAY + "(" + (requireOpt != false ? ChatColor.GREEN + BukkitLang.get(String.valueOf(requireOpt)) : ChatColor.RED + BukkitLang.get(String.valueOf(requireOpt))) + ChatColor.GRAY + ")";
                }
                case 5: {
                    Double distanceOpt = (Double)context.getSessionData((Object)"shareDistanceOpt");
                    if (distanceOpt == null) {
                        double defaultOpt = new BukkitOptions().getShareDistance();
                        return ChatColor.GRAY + "(" + ChatColor.AQUA + defaultOpt + ChatColor.GRAY + ")";
                    }
                    return ChatColor.GRAY + "(" + ChatColor.AQUA + distanceOpt + ChatColor.GRAY + ")";
                }
                case 6: {
                    Boolean handleOpt = (Boolean)context.getSessionData((Object)"handleOfflinePlayersOpt");
                    if (handleOpt == null) {
                        boolean defaultOpt = new BukkitOptions().canHandleOfflinePlayers();
                        return ChatColor.GRAY + "(" + (defaultOpt ? ChatColor.GREEN + BukkitLang.get(String.valueOf(defaultOpt)) : ChatColor.RED + BukkitLang.get(String.valueOf(defaultOpt))) + ChatColor.GRAY + ")";
                    }
                    return ChatColor.GRAY + "(" + (handleOpt != false ? ChatColor.GREEN + BukkitLang.get(String.valueOf(handleOpt)) : ChatColor.RED + BukkitLang.get(String.valueOf(handleOpt))) + ChatColor.GRAY + ")";
                }
                case 7: {
                    return "";
                }
            }
            return null;
        }

        @Override
        @NotNull
        public String getBasicPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenNumericPromptEvent event = new QuestsEditorPostOpenNumericPromptEvent(context, this);
            QuestOptionsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(ChatColor.DARK_GREEN + "- " + this.getTitle(context) + " -");
            for (int i = 1; i <= 7; ++i) {
                text.append("\n").append(this.getNumberColor(context, i)).append(ChatColor.BOLD).append(i).append(ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i)).append(" ").append(this.getAdditionalText(context, i));
            }
            return text.toString();
        }

        public Prompt acceptValidatedInput(@NotNull ConversationContext context, Number input) {
            switch (input.intValue()) {
                case 1: {
                    QuestOptionsPrompt.this.tempKey = "externalPartyPluginOpt";
                    QuestOptionsPrompt.this.tempPrompt = (Prompt)new QuestOptionsMultiplayerPrompt(context);
                    return new QuestOptionsPluginPrompt(context);
                }
                case 2: {
                    QuestOptionsPrompt.this.tempKey = "usePartiesPluginOpt";
                    QuestOptionsPrompt.this.tempPrompt = (Prompt)new QuestOptionsMultiplayerPrompt(context);
                    return new QuestOptionsTrueFalsePrompt(context);
                }
                case 3: {
                    QuestOptionsPrompt.this.tempKey = "shareProgressLevelOpt";
                    QuestOptionsPrompt.this.tempPrompt = (Prompt)new QuestOptionsMultiplayerPrompt(context);
                    return new QuestOptionsLevelPrompt(context);
                }
                case 4: {
                    QuestOptionsPrompt.this.tempKey = "shareSameQuestOnlyOpt";
                    QuestOptionsPrompt.this.tempPrompt = (Prompt)new QuestOptionsMultiplayerPrompt(context);
                    return new QuestOptionsTrueFalsePrompt(context);
                }
                case 5: {
                    QuestOptionsPrompt.this.tempKey = "shareDistanceOpt";
                    QuestOptionsPrompt.this.tempPrompt = (Prompt)new QuestOptionsMultiplayerPrompt(context);
                    return new QuestOptionsDistancePrompt(context);
                }
                case 6: {
                    QuestOptionsPrompt.this.tempKey = "handleOfflinePlayersOpt";
                    QuestOptionsPrompt.this.tempPrompt = (Prompt)new QuestOptionsMultiplayerPrompt(context);
                    return new QuestOptionsTrueFalsePrompt(context);
                }
                case 7: {
                    QuestOptionsPrompt.this.tempKey = null;
                    QuestOptionsPrompt.this.tempPrompt = null;
                    try {
                        return new QuestOptionsPrompt(context);
                    }
                    catch (Exception e) {
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("itemCreateCriticalError"));
                        return Prompt.END_OF_CONVERSATION;
                    }
                }
            }
            return null;
        }
    }

    public class QuestOptionsGlobalPrompt
    extends QuestsEditorNumericPrompt {
        private final int size = 5;

        public QuestOptionsGlobalPrompt(ConversationContext context) {
            super(context);
            this.size = 5;
        }

        @Override
        public int getSize() {
            return 5;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return ChatColor.DARK_GREEN + BukkitLang.get("optServer");
        }

        @Override
        public ChatColor getNumberColor(ConversationContext context, int number) {
            switch (number) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    return ChatColor.BLUE;
                }
                case 5: {
                    return ChatColor.GREEN;
                }
            }
            return null;
        }

        @Override
        public String getSelectionText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.YELLOW + BukkitLang.get("optGiveLoginGlobal");
                }
                case 2: {
                    return ChatColor.YELLOW + BukkitLang.get("optAllowStackingGlobal");
                }
                case 3: {
                    return ChatColor.YELLOW + BukkitLang.get("optInformStartGlobal");
                }
                case 4: {
                    return ChatColor.YELLOW + BukkitLang.get("optOverrideSettingGlobal");
                }
                case 5: {
                    return ChatColor.YELLOW + BukkitLang.get("done");
                }
            }
            return null;
        }

        @Override
        public String getAdditionalText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    Boolean globalOpt = (Boolean)context.getSessionData((Object)"giveGloballyAtLoginOpt");
                    if (globalOpt == null) {
                        boolean defaultOpt = new BukkitOptions().canGiveGloballyAtLogin();
                        return ChatColor.GRAY + "(" + (defaultOpt ? ChatColor.GREEN + BukkitLang.get(String.valueOf(defaultOpt)) : ChatColor.RED + BukkitLang.get(String.valueOf(defaultOpt))) + ChatColor.GRAY + ")";
                    }
                    return ChatColor.GRAY + "(" + (globalOpt != false ? ChatColor.GREEN + BukkitLang.get(String.valueOf(globalOpt)) : ChatColor.RED + BukkitLang.get(String.valueOf(globalOpt))) + ChatColor.GRAY + ")";
                }
                case 2: {
                    Boolean stackOpt = (Boolean)context.getSessionData((Object)"allowStackingGlobalOpt");
                    if (stackOpt == null) {
                        boolean defaultOpt = new BukkitOptions().canAllowStackingGlobal();
                        return ChatColor.GRAY + "(" + (defaultOpt ? ChatColor.GREEN + BukkitLang.get(String.valueOf(defaultOpt)) : ChatColor.RED + BukkitLang.get(String.valueOf(defaultOpt))) + ChatColor.GRAY + ")";
                    }
                    return ChatColor.GRAY + "(" + (stackOpt != false ? ChatColor.GREEN + BukkitLang.get(String.valueOf(stackOpt)) : ChatColor.RED + BukkitLang.get(String.valueOf(stackOpt))) + ChatColor.GRAY + ")";
                }
                case 3: {
                    Boolean informOpt = (Boolean)context.getSessionData((Object)"informQuestStartOpt");
                    if (informOpt == null) {
                        boolean defaultOpt = new BukkitOptions().canInformOnStart();
                        return ChatColor.GRAY + "(" + (defaultOpt ? ChatColor.GREEN + BukkitLang.get(String.valueOf(defaultOpt)) : ChatColor.RED + BukkitLang.get(String.valueOf(defaultOpt))) + ChatColor.GRAY + ")";
                    }
                    return ChatColor.GRAY + "(" + (informOpt != false ? ChatColor.GREEN + BukkitLang.get(String.valueOf(informOpt)) : ChatColor.RED + BukkitLang.get(String.valueOf(informOpt))) + ChatColor.GRAY + ")";
                }
                case 4: {
                    Boolean overrideOpt = (Boolean)context.getSessionData((Object)"overrideMaxQuestsOpt");
                    if (overrideOpt == null) {
                        boolean defaultOpt = new BukkitOptions().canInformOnStart();
                        return ChatColor.GRAY + "(" + (defaultOpt ? ChatColor.GREEN + BukkitLang.get(String.valueOf(defaultOpt)) : ChatColor.RED + BukkitLang.get(String.valueOf(defaultOpt))) + ChatColor.GRAY + ")";
                    }
                    return ChatColor.GRAY + "(" + (overrideOpt != false ? ChatColor.GREEN + BukkitLang.get(String.valueOf(overrideOpt)) : ChatColor.RED + BukkitLang.get(String.valueOf(overrideOpt))) + ChatColor.GRAY + ")";
                }
                case 5: {
                    return "";
                }
            }
            return null;
        }

        @Override
        @NotNull
        public String getBasicPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenNumericPromptEvent event = new QuestsEditorPostOpenNumericPromptEvent(context, this);
            QuestOptionsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(ChatColor.DARK_GREEN + "- " + this.getTitle(context) + " -");
            for (int i = 1; i <= 5; ++i) {
                text.append("\n").append(this.getNumberColor(context, i)).append(ChatColor.BOLD).append(i).append(ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i)).append(" ").append(this.getAdditionalText(context, i));
            }
            return text.toString();
        }

        public Prompt acceptValidatedInput(@NotNull ConversationContext context, Number input) {
            switch (input.intValue()) {
                case 1: {
                    QuestOptionsPrompt.this.tempKey = "giveGloballyAtLoginOpt";
                    QuestOptionsPrompt.this.tempPrompt = (Prompt)new QuestOptionsGlobalPrompt(context);
                    return new QuestOptionsTrueFalsePrompt(context);
                }
                case 2: {
                    QuestOptionsPrompt.this.tempKey = "allowStackingGlobalOpt";
                    QuestOptionsPrompt.this.tempPrompt = (Prompt)new QuestOptionsGlobalPrompt(context);
                    return new QuestOptionsTrueFalsePrompt(context);
                }
                case 3: {
                    QuestOptionsPrompt.this.tempKey = "informQuestStartOpt";
                    QuestOptionsPrompt.this.tempPrompt = (Prompt)new QuestOptionsGlobalPrompt(context);
                    return new QuestOptionsTrueFalsePrompt(context);
                }
                case 4: {
                    QuestOptionsPrompt.this.tempKey = "overrideMaxQuestsOpt";
                    QuestOptionsPrompt.this.tempPrompt = (Prompt)new QuestOptionsGlobalPrompt(context);
                    return new QuestOptionsTrueFalsePrompt(context);
                }
                case 5: {
                    QuestOptionsPrompt.this.tempKey = null;
                    QuestOptionsPrompt.this.tempPrompt = null;
                    try {
                        return new QuestOptionsPrompt(context);
                    }
                    catch (Exception e) {
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("itemCreateCriticalError"));
                        return Prompt.END_OF_CONVERSATION;
                    }
                }
            }
            return null;
        }
    }

    public class QuestOptionsDistancePrompt
    extends QuestsEditorStringPrompt {
        public QuestOptionsDistancePrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("optDistancePrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestOptionsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel")) && !input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                try {
                    double d = Double.parseDouble(input);
                    context.setSessionData((Object)QuestOptionsPrompt.this.tempKey, (Object)d);
                }
                catch (Exception e) {
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("reqNotANumber").replace("<input>", input));
                }
            } else if (input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                context.setSessionData((Object)QuestOptionsPrompt.this.tempKey, null);
                return QuestOptionsPrompt.this.tempPrompt;
            }
            return QuestOptionsPrompt.this.tempPrompt;
        }
    }

    public class QuestOptionsLevelPrompt
    extends QuestsEditorStringPrompt {
        private final int size = 6;

        public QuestOptionsLevelPrompt(ConversationContext context) {
            super(context);
            this.size = 6;
        }

        public int getSize() {
            return 6;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("optNumberQuery");
        }

        public String getSelectionText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.GOLD + "1";
                }
                case 2: {
                    return ChatColor.GOLD + "2";
                }
                case 3: {
                    return ChatColor.GOLD + "3";
                }
                case 4: {
                    return ChatColor.GOLD + "4";
                }
                case 5: {
                    return ChatColor.RED + BukkitLang.get("cmdClear");
                }
                case 6: {
                    return ChatColor.RED + BukkitLang.get("cmdCancel");
                }
            }
            return null;
        }

        public String getAdditionalText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.GRAY + BukkitLang.get("everything");
                }
                case 2: {
                    return ChatColor.GRAY + BukkitLang.get("objectives");
                }
                case 3: {
                    return ChatColor.GRAY + BukkitLang.get("stageEditorStages");
                }
                case 4: {
                    return ChatColor.GRAY + BukkitLang.get("quests");
                }
                case 5: 
                case 6: {
                    return "";
                }
            }
            return null;
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestOptionsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            String text = BukkitLang.get("optNumberPrompt");
            text = text + "\n" + ChatColor.GRAY + "\u2515 " + ChatColor.GOLD + "1" + ChatColor.RESET + " = " + ChatColor.GRAY + BukkitLang.get("everything");
            text = text + "\n" + ChatColor.GRAY + "\u2515 " + ChatColor.GOLD + "2" + ChatColor.RESET + " = " + ChatColor.GRAY + BukkitLang.get("objectives");
            text = text + "\n" + ChatColor.GRAY + "\u2515 " + ChatColor.GOLD + "3" + ChatColor.RESET + " = " + ChatColor.GRAY + BukkitLang.get("stageEditorStages");
            text = text + "\n" + ChatColor.GRAY + "\u2515 " + ChatColor.GOLD + "4" + ChatColor.RESET + " = " + ChatColor.GRAY + BukkitLang.get("quests");
            return ChatColor.YELLOW + text;
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel")) && !input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                try {
                    int i = Integer.parseInt(input);
                    context.setSessionData((Object)QuestOptionsPrompt.this.tempKey, (Object)i);
                }
                catch (Exception e) {
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("reqNotANumber").replace("<input>", input));
                }
            } else if (input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                context.setSessionData((Object)QuestOptionsPrompt.this.tempKey, null);
                return QuestOptionsPrompt.this.tempPrompt;
            }
            return QuestOptionsPrompt.this.tempPrompt;
        }
    }

    public class QuestOptionsTrueFalsePrompt
    extends QuestsEditorStringPrompt {
        private final int size = 4;

        public QuestOptionsTrueFalsePrompt(ConversationContext context) {
            super(context);
            this.size = 4;
        }

        public int getSize() {
            return 4;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("optBooleanQuery").replace("<true>", BukkitLang.get("true")).replace("<false>", BukkitLang.get("false"));
        }

        public String getSelectionText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.YELLOW + BukkitLang.get("true");
                }
                case 2: {
                    return ChatColor.YELLOW + BukkitLang.get("false");
                }
                case 3: {
                    return ChatColor.RED + BukkitLang.get("cmdClear");
                }
                case 4: {
                    return ChatColor.RED + BukkitLang.get("cmdCancel");
                }
            }
            return null;
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestOptionsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.YELLOW + BukkitLang.get("optBooleanPrompt").replace("<true>", BukkitLang.get("true")).replace("<false>", BukkitLang.get("false"));
        }

        /*
         * Enabled aggressive block sorting
         */
        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel")) && !input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                if (input.startsWith("t") || input.equalsIgnoreCase(BukkitLang.get("true")) || input.equalsIgnoreCase(BukkitLang.get("yesWord"))) {
                    context.setSessionData((Object)QuestOptionsPrompt.this.tempKey, (Object)true);
                    return QuestOptionsPrompt.this.tempPrompt;
                }
                if (!(input.startsWith("f") || input.equalsIgnoreCase(BukkitLang.get("false")) || input.equalsIgnoreCase(BukkitLang.get("noWord")))) {
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("itemCreateInvalidInput"));
                    return new QuestOptionsTrueFalsePrompt(context);
                }
                context.setSessionData((Object)QuestOptionsPrompt.this.tempKey, (Object)false);
                return QuestOptionsPrompt.this.tempPrompt;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) return QuestOptionsPrompt.this.tempPrompt;
            context.setSessionData((Object)QuestOptionsPrompt.this.tempKey, null);
            return QuestOptionsPrompt.this.tempPrompt;
        }
    }

    public class QuestOptionsPluginPrompt
    extends QuestsEditorStringPrompt {
        public QuestOptionsPluginPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("optPluginListTitle");
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("optExternalPartyPluginPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestOptionsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(ChatColor.LIGHT_PURPLE + this.getTitle(context) + "\n" + ChatColor.DARK_PURPLE);
            boolean none = true;
            for (PartyProvider q : QuestOptionsPrompt.this.plugin.getDependencies().getPartyProviders()) {
                text.append(q.getPluginName()).append(", ");
                none = false;
            }
            if (none) {
                text.append("(").append(BukkitLang.get("none")).append(")\n");
            } else {
                text = new StringBuilder(text.substring(0, text.length() - 2));
                text.append("\n");
            }
            text.append(ChatColor.YELLOW).append(this.getQueryText(context));
            return text.toString();
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel")) && !input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                if (input.equalsIgnoreCase("Quests")) {
                    context.getForWhom().sendRawMessage(" " + ChatColor.AQUA + ChatColor.UNDERLINE + "https://www.youtube.com/watch?v=gvdf5n-zI14");
                    return new QuestOptionsPluginPrompt(context);
                }
                String properCase = null;
                for (PartyProvider partyProvider : QuestOptionsPrompt.this.plugin.getDependencies().getPartyProviders()) {
                    if (!input.equalsIgnoreCase(partyProvider.getPluginName())) continue;
                    properCase = partyProvider.getPluginName();
                }
                if (properCase == null) {
                    String text = BukkitLang.get("optNotAPluginName");
                    text = text.replace("<plugin>", ChatColor.LIGHT_PURPLE + input + ChatColor.RED);
                    context.getForWhom().sendRawMessage(text);
                    return new QuestOptionsPluginPrompt(context);
                }
                context.setSessionData((Object)"externalPartyPluginOpt", properCase);
            } else if (input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                context.setSessionData((Object)QuestOptionsPrompt.this.tempKey, null);
                return QuestOptionsPrompt.this.tempPrompt;
            }
            return QuestOptionsPrompt.this.tempPrompt;
        }
    }
}

