/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.convo.quests.planner;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.convo.quests.QuestsEditorNumericPrompt;
import me.pikamug.quests.convo.quests.QuestsEditorStringPrompt;
import me.pikamug.quests.events.editor.quests.QuestsEditorPostOpenNumericPromptEvent;
import me.pikamug.quests.events.editor.quests.QuestsEditorPostOpenStringPromptEvent;
import me.pikamug.quests.util.BukkitLang;
import org.bukkit.ChatColor;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.Prompt;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

public class QuestDateTimePrompt
extends QuestsEditorNumericPrompt {
    private final BukkitQuestsPlugin plugin;
    private final Prompt oldPrompt;
    private final String source;
    private final int size = 10;

    public QuestDateTimePrompt(ConversationContext context, Prompt old, String origin) {
        super(context);
        this.plugin = (BukkitQuestsPlugin)context.getPlugin();
        this.oldPrompt = old;
        this.source = origin;
    }

    @Override
    public int getSize() {
        return 10;
    }

    @Override
    public String getTitle(ConversationContext context) {
        return BukkitLang.get("dateTimeTitle");
    }

    public String getDataText(ConversationContext context) {
        String dateData = "";
        Integer year = (Integer)context.getSessionData((Object)"tempYear");
        Integer month = (Integer)context.getSessionData((Object)"tempMonth");
        Integer day = (Integer)context.getSessionData((Object)"tempDay");
        Integer hour = (Integer)context.getSessionData((Object)"tempHour");
        Integer minute = (Integer)context.getSessionData((Object)"tempMinute");
        Integer second = (Integer)context.getSessionData((Object)"tempSecond");
        if (year == null || month == null || day == null || hour == null || minute == null || second == null) {
            return dateData;
        }
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd");
        SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
        cal.set(year, month, day, hour, minute, second);
        dateData = dateData + ChatColor.DARK_AQUA + dateFormat.format(cal.getTime()) + " ";
        dateData = dateData + ChatColor.AQUA + timeFormat.format(cal.getTime()) + " ";
        cal.setTimeZone(TimeZone.getTimeZone((String)context.getSessionData((Object)"tempZone")));
        String[] iso = this.plugin.getConfigSettings().getLanguage().split("-");
        Locale loc = new Locale(iso[0], iso[1]);
        Double zonedHour = cal.getTimeZone().getRawOffset() / 60 / 60 / 1000;
        String[] sep = String.valueOf(zonedHour).replace("-", "").split("\\.");
        DecimalFormat zoneFormat = new DecimalFormat("00");
        dateData = dateData + ChatColor.LIGHT_PURPLE + "UTC" + (zonedHour < 0.0 ? "-" : "+") + zoneFormat.format(Integer.valueOf(sep[0])) + ":" + zoneFormat.format(Integer.valueOf(sep[1])) + ChatColor.GREEN + " (" + cal.getTimeZone().getDisplayName(loc) + ")";
        return dateData;
    }

    @Override
    public ChatColor getNumberColor(ConversationContext context, int number) {
        switch (number) {
            case 0: {
                return ChatColor.YELLOW;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return ChatColor.BLUE;
            }
            case 8: {
                return ChatColor.RED;
            }
            case 9: {
                return ChatColor.GREEN;
            }
        }
        return null;
    }

    @Override
    public String getSelectionText(ConversationContext context, int number) {
        switch (number) {
            case 0: {
                return ChatColor.GOLD + BukkitLang.get("dateCreateLoadTime");
            }
            case 1: {
                return ChatColor.YELLOW + BukkitLang.get("timeYear");
            }
            case 2: {
                return ChatColor.YELLOW + BukkitLang.get("timeMonth");
            }
            case 3: {
                return ChatColor.YELLOW + BukkitLang.get("timeDay");
            }
            case 4: {
                return ChatColor.YELLOW + BukkitLang.get("timeHour");
            }
            case 5: {
                return ChatColor.YELLOW + BukkitLang.get("timeMinute");
            }
            case 6: {
                return ChatColor.YELLOW + BukkitLang.get("timeSecond");
            }
            case 7: {
                return ChatColor.YELLOW + BukkitLang.get("timeZone");
            }
            case 8: {
                return ChatColor.RED + BukkitLang.get("cancel");
            }
            case 9: {
                return ChatColor.GREEN + BukkitLang.get("done");
            }
        }
        return null;
    }

    @Override
    public String getAdditionalText(ConversationContext context, int number) {
        switch (number) {
            case 0: {
                return "";
            }
            case 1: {
                if (context.getSessionData((Object)"tempYear") != null) {
                    return ChatColor.GRAY + "(" + ChatColor.AQUA + context.getSessionData((Object)"tempYear") + ChatColor.GRAY + ")";
                }
            }
            case 2: {
                Integer month = (Integer)context.getSessionData((Object)"tempMonth");
                if (month != null) {
                    return ChatColor.GRAY + "(" + ChatColor.AQUA + (month + 1) + ChatColor.GRAY + ")";
                }
            }
            case 3: {
                if (context.getSessionData((Object)"tempDay") != null) {
                    return ChatColor.GRAY + "(" + ChatColor.AQUA + context.getSessionData((Object)"tempDay") + ChatColor.GRAY + ")";
                }
            }
            case 4: {
                if (context.getSessionData((Object)"tempHour") != null) {
                    return ChatColor.GRAY + "(" + ChatColor.AQUA + context.getSessionData((Object)"tempHour") + ChatColor.GRAY + ")";
                }
            }
            case 5: {
                if (context.getSessionData((Object)"tempMinute") != null) {
                    return ChatColor.GRAY + "(" + ChatColor.AQUA + context.getSessionData((Object)"tempMinute") + ChatColor.GRAY + ")";
                }
            }
            case 6: {
                if (context.getSessionData((Object)"tempSecond") != null) {
                    return ChatColor.GRAY + "(" + ChatColor.AQUA + context.getSessionData((Object)"tempSecond") + ChatColor.GRAY + ")";
                }
            }
            case 7: {
                if (context.getSessionData((Object)"tempZone") != null) {
                    TimeZone tz = TimeZone.getTimeZone((String)context.getSessionData((Object)"tempZone"));
                    return ChatColor.GRAY + "(" + ChatColor.AQUA + tz.getDisplayName(false, 0) + ChatColor.GRAY + ")";
                }
            }
            case 8: 
            case 9: {
                return "";
            }
        }
        return null;
    }

    @Override
    @NotNull
    public String getBasicPromptText(@NotNull ConversationContext context) {
        QuestsEditorPostOpenNumericPromptEvent event = new QuestsEditorPostOpenNumericPromptEvent(context, this);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        StringBuilder text = new StringBuilder(ChatColor.AQUA + this.getTitle(context) + "\n");
        if (context.getSessionData((Object)"tempYear") != null && context.getSessionData((Object)"tempMonth") != null && context.getSessionData((Object)"tempDay") != null && context.getSessionData((Object)"tempHour") != null && context.getSessionData((Object)"tempMinute") != null && context.getSessionData((Object)"tempSecond") != null && context.getSessionData((Object)"tempZone") != null) {
            text.append(this.getDataText(context));
        }
        for (int i = 0; i <= 9; ++i) {
            text.append("\n").append(this.getNumberColor(context, i)).append(ChatColor.BOLD).append(i).append(ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i)).append(" ").append(this.getAdditionalText(context, i));
        }
        return text.toString();
    }

    protected Prompt acceptValidatedInput(@NotNull ConversationContext context, Number input) {
        switch (input.intValue()) {
            case 0: {
                Calendar cal = Calendar.getInstance();
                context.setSessionData((Object)"tempYear", (Object)cal.get(1));
                context.setSessionData((Object)"tempMonth", (Object)cal.get(2));
                context.setSessionData((Object)"tempDay", (Object)cal.get(5));
                context.setSessionData((Object)"tempHour", (Object)cal.get(11));
                context.setSessionData((Object)"tempMinute", (Object)cal.get(12));
                context.setSessionData((Object)"tempSecond", (Object)cal.get(13));
                context.setSessionData((Object)"tempZone", (Object)cal.getTimeZone().getID());
                return new QuestDateTimePrompt(context, this.oldPrompt, this.source);
            }
            case 1: {
                return new QuestYearPrompt(context);
            }
            case 2: {
                return new QuestMonthPrompt(context);
            }
            case 3: {
                return new QuestDayPrompt(context);
            }
            case 4: {
                return new QuestHourPrompt(context);
            }
            case 5: {
                return new QuestMinutePrompt(context);
            }
            case 6: {
                return new QuestSecondPrompt(context);
            }
            case 7: {
                return new QuestOffsetPrompt(context);
            }
            case 8: {
                context.setSessionData((Object)"tempYear", null);
                context.setSessionData((Object)"tempMonth", null);
                context.setSessionData((Object)"tempDay", null);
                context.setSessionData((Object)"tempHour", null);
                context.setSessionData((Object)"tempMinute", null);
                context.setSessionData((Object)"tempSecond", null);
                context.setSessionData((Object)"tempZone", null);
                return this.oldPrompt;
            }
            case 9: {
                if (context.getSessionData((Object)"tempYear") != null && context.getSessionData((Object)"tempMonth") != null && context.getSessionData((Object)"tempDay") != null && context.getSessionData((Object)"tempHour") != null && context.getSessionData((Object)"tempMinute") != null && context.getSessionData((Object)"tempSecond") != null && context.getSessionData((Object)"tempZone") != null) {
                    Integer year = (Integer)context.getSessionData((Object)"tempYear");
                    Integer month = (Integer)context.getSessionData((Object)"tempMonth");
                    Integer day = (Integer)context.getSessionData((Object)"tempDay");
                    Integer hour = (Integer)context.getSessionData((Object)"tempHour");
                    Integer minute = (Integer)context.getSessionData((Object)"tempMinute");
                    Integer second = (Integer)context.getSessionData((Object)"tempSecond");
                    String zone = (String)context.getSessionData((Object)"tempZone");
                    String date = day + ":" + month + ":" + year + ":" + hour + ":" + minute + ":" + second + ":" + zone;
                    if (this.source != null) {
                        if (this.source.equals("start")) {
                            context.setSessionData((Object)"startDatePln", (Object)date);
                            if (context.getSessionData((Object)"endDatePln") == null) {
                                String endDate = "31:11:2999:23:59:59:" + zone;
                                context.setSessionData((Object)"endDatePln", (Object)endDate);
                            }
                        } else if (this.source.equals("end")) {
                            context.setSessionData((Object)"endDatePln", (Object)date);
                        }
                    }
                    context.setSessionData((Object)"tempYear", null);
                    context.setSessionData((Object)"tempMonth", null);
                    context.setSessionData((Object)"tempDay", null);
                    context.setSessionData((Object)"tempHour", null);
                    context.setSessionData((Object)"tempMinute", null);
                    context.setSessionData((Object)"tempSecond", null);
                    context.setSessionData((Object)"tempZone", null);
                    return this.oldPrompt;
                }
                if (context.getSessionData((Object)"tempYear") != null || context.getSessionData((Object)"tempMonth") != null || context.getSessionData((Object)"tempDay") != null || context.getSessionData((Object)"tempHour") != null || context.getSessionData((Object)"tempMinute") != null || context.getSessionData((Object)"tempSecond") != null || context.getSessionData((Object)"tempZone") != null) {
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("listsNotSameSize"));
                    return new QuestDateTimePrompt(context, this.oldPrompt, this.source);
                }
                return this.oldPrompt;
            }
        }
        return new QuestDateTimePrompt(context, this.oldPrompt, this.source);
    }

    public class QuestYearPrompt
    extends QuestsEditorStringPrompt {
        public QuestYearPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("dateCreateEnterYear");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestDateTimePrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                try {
                    int amt = Integer.parseInt(input);
                    if (amt < 1000 || amt > 9999) {
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("invalidRange").replace("<least>", "1000").replace("<greatest>", "9999"));
                        return new QuestYearPrompt(context);
                    }
                    context.setSessionData((Object)"tempYear", (Object)Integer.parseInt(input));
                    return new QuestDateTimePrompt(context, QuestDateTimePrompt.this.oldPrompt, QuestDateTimePrompt.this.source);
                }
                catch (NumberFormatException e) {
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("itemCreateInvalidInput"));
                    return new QuestYearPrompt(context);
                }
            }
            return new QuestDateTimePrompt(context, QuestDateTimePrompt.this.oldPrompt, QuestDateTimePrompt.this.source);
        }
    }

    public class QuestMonthPrompt
    extends QuestsEditorStringPrompt {
        public QuestMonthPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("dateCreateEnterMonth");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestDateTimePrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                try {
                    int amt = Integer.parseInt(input);
                    if (amt < 1 || amt > 12) {
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("invalidRange").replace("<least>", "1").replace("<greatest>", "12"));
                        return new QuestMonthPrompt(context);
                    }
                    context.setSessionData((Object)"tempMonth", (Object)(Integer.parseInt(input) - 1));
                    return new QuestDateTimePrompt(context, QuestDateTimePrompt.this.oldPrompt, QuestDateTimePrompt.this.source);
                }
                catch (NumberFormatException e) {
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("itemCreateInvalidInput"));
                    return new QuestMonthPrompt(context);
                }
            }
            return new QuestDateTimePrompt(context, QuestDateTimePrompt.this.oldPrompt, QuestDateTimePrompt.this.source);
        }
    }

    public class QuestDayPrompt
    extends QuestsEditorStringPrompt {
        public QuestDayPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("dateCreateEnterDay");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestDateTimePrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                try {
                    int amt = Integer.parseInt(input);
                    if (amt < 1 || amt > 31) {
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("invalidRange").replace("<least>", "1").replace("<greatest>", "31"));
                        return new QuestDayPrompt(context);
                    }
                    context.setSessionData((Object)"tempDay", (Object)Integer.parseInt(input));
                    return new QuestDateTimePrompt(context, QuestDateTimePrompt.this.oldPrompt, QuestDateTimePrompt.this.source);
                }
                catch (NumberFormatException e) {
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("itemCreateInvalidInput"));
                    return new QuestDayPrompt(context);
                }
            }
            return new QuestDateTimePrompt(context, QuestDateTimePrompt.this.oldPrompt, QuestDateTimePrompt.this.source);
        }
    }

    public class QuestHourPrompt
    extends QuestsEditorStringPrompt {
        public QuestHourPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("dateCreateEnterHour");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestDateTimePrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                try {
                    int amt = Integer.parseInt(input);
                    if (amt < 0 || amt > 23) {
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("invalidRange").replace("<least>", "0").replace("<greatest>", "23"));
                        return new QuestHourPrompt(context);
                    }
                    context.setSessionData((Object)"tempHour", (Object)Integer.parseInt(input));
                    return new QuestDateTimePrompt(context, QuestDateTimePrompt.this.oldPrompt, QuestDateTimePrompt.this.source);
                }
                catch (NumberFormatException e) {
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("itemCreateInvalidInput"));
                    return new QuestHourPrompt(context);
                }
            }
            return new QuestDateTimePrompt(context, QuestDateTimePrompt.this.oldPrompt, QuestDateTimePrompt.this.source);
        }
    }

    public class QuestMinutePrompt
    extends QuestsEditorStringPrompt {
        public QuestMinutePrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("dateCreateEnterMinute");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestDateTimePrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                try {
                    int amt = Integer.parseInt(input);
                    if (amt < 0 || amt > 59) {
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("invalidRange").replace("<least>", "0").replace("<greatest>", "59"));
                        return new QuestMinutePrompt(context);
                    }
                    context.setSessionData((Object)"tempMinute", (Object)Integer.parseInt(input));
                    return new QuestDateTimePrompt(context, QuestDateTimePrompt.this.oldPrompt, QuestDateTimePrompt.this.source);
                }
                catch (NumberFormatException e) {
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("itemCreateInvalidInput"));
                    return new QuestMinutePrompt(context);
                }
            }
            return new QuestDateTimePrompt(context, QuestDateTimePrompt.this.oldPrompt, QuestDateTimePrompt.this.source);
        }
    }

    public class QuestSecondPrompt
    extends QuestsEditorStringPrompt {
        public QuestSecondPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("dateCreateEnterSecond");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestDateTimePrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                try {
                    int amt = Integer.parseInt(input);
                    if (amt < 0 || amt > 59) {
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("invalidRange").replace("<least>", "0").replace("<greatest>", "59"));
                        return new QuestSecondPrompt(context);
                    }
                    context.setSessionData((Object)"tempSecond", (Object)Integer.parseInt(input));
                    return new QuestDateTimePrompt(context, QuestDateTimePrompt.this.oldPrompt, QuestDateTimePrompt.this.source);
                }
                catch (NumberFormatException e) {
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("itemCreateInvalidInput"));
                    return new QuestSecondPrompt(context);
                }
            }
            return new QuestDateTimePrompt(context, QuestDateTimePrompt.this.oldPrompt, QuestDateTimePrompt.this.source);
        }
    }

    public class QuestOffsetPrompt
    extends QuestsEditorStringPrompt {
        public QuestOffsetPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("dateCreateEnterOffset");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestDateTimePrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                try {
                    double amt = Double.parseDouble(input.replace("UTC", "").replace(":", "."));
                    if (amt < -12.0 || amt > 14.0) {
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("invalidRange").replace("<least>", "-12:00").replace("<greatest>", "14:00"));
                        return new QuestOffsetPrompt(context);
                    }
                    String[] t = TimeZone.getAvailableIDs((int)Math.round(amt * 60.0 * 60.0 * 1000.0));
                    if (t.length > 1) {
                        return new QuestZonePrompt(context, t);
                    }
                    if (t.length > 0) {
                        context.setSessionData((Object)"tempZone", (Object)t[0]);
                    } else {
                        context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("itemCreateInvalidInput"));
                    }
                    return new QuestDateTimePrompt(context, QuestDateTimePrompt.this.oldPrompt, QuestDateTimePrompt.this.source);
                }
                catch (NumberFormatException e) {
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("itemCreateInvalidInput"));
                    return new QuestOffsetPrompt(context);
                }
            }
            return new QuestDateTimePrompt(context, QuestDateTimePrompt.this.oldPrompt, QuestDateTimePrompt.this.source);
        }
    }

    public class QuestZonePrompt
    extends QuestsEditorStringPrompt {
        String[] zones;

        public QuestZonePrompt(ConversationContext context, String[] timezones) {
            super(context);
            this.zones = timezones;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("timeZoneTitle");
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("dateCreateEnterZone");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestDateTimePrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(ChatColor.LIGHT_PURPLE + this.getTitle(context) + "\n");
            for (String z : this.zones) {
                text.append(ChatColor.GREEN).append(z).append(", ");
            }
            text = new StringBuilder(text.substring(0, text.length() - 2));
            return text + "\n" + ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                for (String z : this.zones) {
                    if (!z.toLowerCase().startsWith(input.toLowerCase())) continue;
                    context.setSessionData((Object)"tempZone", (Object)z);
                    return new QuestDateTimePrompt(context, QuestDateTimePrompt.this.oldPrompt, QuestDateTimePrompt.this.source);
                }
                context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("itemCreateInvalidInput"));
                return new QuestZonePrompt(context, this.zones);
            }
            return new QuestDateTimePrompt(context, QuestDateTimePrompt.this.oldPrompt, QuestDateTimePrompt.this.source);
        }
    }
}

