/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.convo.quests.planner;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.Objects;
import java.util.TimeZone;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.convo.quests.QuestsEditorNumericPrompt;
import me.pikamug.quests.convo.quests.QuestsEditorStringPrompt;
import me.pikamug.quests.convo.quests.planner.QuestDateTimePrompt;
import me.pikamug.quests.events.editor.quests.QuestsEditorPostOpenNumericPromptEvent;
import me.pikamug.quests.events.editor.quests.QuestsEditorPostOpenStringPromptEvent;
import me.pikamug.quests.quests.components.BukkitPlanner;
import me.pikamug.quests.util.BukkitLang;
import me.pikamug.quests.util.BukkitMiscUtil;
import org.bukkit.ChatColor;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.Prompt;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

public class QuestPlannerPrompt
extends QuestsEditorNumericPrompt {
    private final BukkitQuestsPlugin plugin;
    private final int size = 6;

    public QuestPlannerPrompt(ConversationContext context) {
        super(context);
        this.plugin = (BukkitQuestsPlugin)context.getPlugin();
    }

    @Override
    public int getSize() {
        return 6;
    }

    @Override
    public String getTitle(ConversationContext context) {
        return BukkitLang.get("plannerTitle").replace("<quest>", (String)Objects.requireNonNull(context.getSessionData((Object)"questName")));
    }

    @Override
    public ChatColor getNumberColor(ConversationContext context, int number) {
        switch (number) {
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                return ChatColor.BLUE;
            }
            case 3: {
                if (context.getSessionData((Object)"startDatePln") == null || context.getSessionData((Object)"endDatePln") == null) {
                    return ChatColor.GRAY;
                }
                return ChatColor.BLUE;
            }
            case 6: {
                return ChatColor.GREEN;
            }
        }
        return null;
    }

    @Override
    public String getSelectionText(ConversationContext context, int number) {
        switch (number) {
            case 1: {
                return ChatColor.YELLOW + BukkitLang.get("plnStart");
            }
            case 2: {
                return ChatColor.YELLOW + BukkitLang.get("plnEnd");
            }
            case 3: {
                if (context.getSessionData((Object)"startDatePln") == null || context.getSessionData((Object)"endDatePln") == null) {
                    return ChatColor.GRAY + BukkitLang.get("plnRepeat");
                }
                return ChatColor.YELLOW + BukkitLang.get("plnRepeat");
            }
            case 4: {
                return ChatColor.YELLOW + BukkitLang.get("plnCooldown");
            }
            case 5: {
                return ChatColor.YELLOW + BukkitLang.get("plnOverride");
            }
            case 6: {
                return ChatColor.YELLOW + BukkitLang.get("done");
            }
        }
        return null;
    }

    @Override
    public String getAdditionalText(ConversationContext context, int number) {
        switch (number) {
            case 1: {
                String start = (String)context.getSessionData((Object)"startDatePln");
                if (start == null) {
                    return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                return "\n" + ChatColor.YELLOW + "     - " + this.getPrettyDate(start);
            }
            case 2: {
                String end = (String)context.getSessionData((Object)"endDatePln");
                if (end == null) {
                    return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                return "\n" + ChatColor.YELLOW + "     - " + this.getPrettyDate(end);
            }
            case 3: {
                Long repeat = (Long)context.getSessionData((Object)"repeatCyclePln");
                if (context.getSessionData((Object)"startDatePln") == null || context.getSessionData((Object)"endDatePln") == null) {
                    return ChatColor.GRAY + "(" + BukkitLang.get("stageEditorOptional") + ")";
                }
                if (repeat == null) {
                    return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                return ChatColor.YELLOW + "(" + BukkitMiscUtil.getTime(repeat) + ChatColor.RESET + ChatColor.YELLOW + ")";
            }
            case 4: {
                Long cooldown = (Long)context.getSessionData((Object)"cooldownPln");
                if (cooldown == null) {
                    return ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                return ChatColor.YELLOW + "(" + BukkitMiscUtil.getTime(cooldown) + ChatColor.RESET + ChatColor.YELLOW + ")";
            }
            case 5: {
                Boolean override = (Boolean)context.getSessionData((Object)"overridePln");
                if (override == null) {
                    boolean defaultOpt = new BukkitPlanner().getOverride();
                    return ChatColor.GRAY + "(" + (defaultOpt ? ChatColor.GREEN + BukkitLang.get(String.valueOf(defaultOpt)) : ChatColor.RED + BukkitLang.get(String.valueOf(defaultOpt))) + ChatColor.GRAY + ")";
                }
                return ChatColor.GRAY + "(" + (override != false ? ChatColor.GREEN + BukkitLang.get(String.valueOf(override)) : ChatColor.RED + BukkitLang.get(String.valueOf(override))) + ChatColor.GRAY + ")";
            }
            case 6: {
                return "";
            }
        }
        return null;
    }

    @Override
    @NotNull
    public String getBasicPromptText(@NotNull ConversationContext context) {
        QuestsEditorPostOpenNumericPromptEvent event = new QuestsEditorPostOpenNumericPromptEvent(context, this);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        String name = Objects.requireNonNull((String)context.getSessionData((Object)"questName"));
        StringBuilder text = new StringBuilder(ChatColor.DARK_AQUA + "- " + this.getTitle(context).replace(name, ChatColor.AQUA + (String)context.getSessionData((Object)"questName") + ChatColor.DARK_AQUA) + " -");
        for (int i = 1; i <= 6; ++i) {
            text.append("\n").append(this.getNumberColor(context, i)).append(ChatColor.BOLD).append(i).append(ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i)).append(" ").append(this.getAdditionalText(context, i));
        }
        return text.toString();
    }

    protected Prompt acceptValidatedInput(@NotNull ConversationContext context, Number input) {
        switch (input.intValue()) {
            case 1: {
                return new QuestDateTimePrompt(context, (Prompt)this, "start");
            }
            case 2: {
                return new QuestDateTimePrompt(context, (Prompt)this, "end");
            }
            case 3: {
                if (context.getSessionData((Object)"startDatePln") != null && context.getSessionData((Object)"endDatePln") != null) {
                    return new QuestPlannerRepeatPrompt(context);
                }
                context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("invalidOption"));
                return new QuestPlannerPrompt(context);
            }
            case 4: {
                return new QuestPlannerCooldownPrompt(context);
            }
            case 5: {
                return new QuestPlannerOverridePrompt(context);
            }
            case 6: {
                return this.plugin.getQuestFactory().returnToMenu(context);
            }
        }
        return new QuestPlannerPrompt(context);
    }

    private String getPrettyDate(String formattedDate) {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd");
        SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
        String[] date = formattedDate.split(":");
        int day = Integer.parseInt(date[0]);
        int month = Integer.parseInt(date[1]);
        int year = Integer.parseInt(date[2]);
        int hour = Integer.parseInt(date[3]);
        int minute = Integer.parseInt(date[4]);
        int second = Integer.parseInt(date[5]);
        cal.set(year, month, day, hour, minute, second);
        String output = ChatColor.DARK_AQUA + dateFormat.format(cal.getTime());
        output = output + ChatColor.AQUA + " " + timeFormat.format(cal.getTime());
        TimeZone tz = TimeZone.getTimeZone(date[6]);
        cal.setTimeZone(tz);
        String[] iso = this.plugin.getConfigSettings().getLanguage().split("-");
        Locale loc = iso.length > 1 ? new Locale(iso[0], iso[1]) : new Locale(iso[0]);
        Double zonehour = cal.getTimeZone().getRawOffset() / 60 / 60 / 1000;
        String[] sep = String.valueOf(zonehour).replace("-", "").split("\\.");
        DecimalFormat zoneFormat = new DecimalFormat("00");
        output = output + ChatColor.LIGHT_PURPLE + " UTC" + (zonehour < 0.0 ? "-" : "+") + zoneFormat.format(Integer.valueOf(sep[0])) + ":" + zoneFormat.format(Integer.valueOf(sep[1])) + ChatColor.GREEN + " (" + cal.getTimeZone().getDisplayName(loc) + ")";
        return output;
    }

    public class QuestPlannerRepeatPrompt
    extends QuestsEditorStringPrompt {
        public QuestPlannerRepeatPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("timePrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestPlannerPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                return new QuestPlannerPrompt(context);
            }
            if (input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                context.setSessionData((Object)"repeatCyclePln", null);
                return new QuestPlannerPrompt(context);
            }
            try {
                long l = Long.parseLong(input);
                long delay = l * 1000L;
                if (delay < 1L) {
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("questEditorPositiveAmount"));
                } else {
                    context.setSessionData((Object)"repeatCyclePln", (Object)delay);
                }
            }
            catch (NumberFormatException e) {
                context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("reqNotANumber").replace("<input>", input));
                return new QuestPlannerRepeatPrompt(context);
            }
            return new QuestPlannerPrompt(context);
        }
    }

    public class QuestPlannerCooldownPrompt
    extends QuestsEditorStringPrompt {
        public QuestPlannerCooldownPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("timePrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestPlannerPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                return new QuestPlannerPrompt(context);
            }
            if (input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                context.setSessionData((Object)"cooldownPln", null);
                return new QuestPlannerPrompt(context);
            }
            try {
                long l = Long.parseLong(input);
                long delay = l * 1000L;
                if (delay < 1L) {
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("questEditorPositiveAmount"));
                } else {
                    context.setSessionData((Object)"cooldownPln", (Object)delay);
                }
            }
            catch (NumberFormatException e) {
                context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("reqNotANumber").replace("<input>", input));
                return new QuestPlannerCooldownPrompt(context);
            }
            return new QuestPlannerPrompt(context);
        }
    }

    public class QuestPlannerOverridePrompt
    extends QuestsEditorStringPrompt {
        private final int size = 4;

        public QuestPlannerOverridePrompt(ConversationContext context) {
            super(context);
            this.size = 4;
        }

        public int getSize() {
            return 4;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            String text = "Select '<true>' or '<false>'";
            text = text.replace("<true>", BukkitLang.get("true"));
            text = text.replace("<false>", BukkitLang.get("false"));
            return text;
        }

        public String getSelectionText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return ChatColor.YELLOW + BukkitLang.get("true");
                }
                case 2: {
                    return ChatColor.YELLOW + BukkitLang.get("false");
                }
                case 3: {
                    return ChatColor.RED + BukkitLang.get("cmdClear");
                }
                case 4: {
                    return ChatColor.RED + BukkitLang.get("cmdCancel");
                }
            }
            return null;
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestPlannerPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            String text = BukkitLang.get("optBooleanPrompt");
            text = text.replace("<true>", BukkitLang.get("true"));
            text = text.replace("<false>", BukkitLang.get("false"));
            return ChatColor.YELLOW + text;
        }

        /*
         * Enabled aggressive block sorting
         */
        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel")) && !input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                if (input.startsWith("t") || input.equalsIgnoreCase(BukkitLang.get("true")) || input.equalsIgnoreCase(BukkitLang.get("yesWord"))) {
                    context.setSessionData((Object)"overridePln", (Object)true);
                    return new QuestPlannerPrompt(context);
                }
                if (!(input.startsWith("f") || input.equalsIgnoreCase(BukkitLang.get("false")) || input.equalsIgnoreCase(BukkitLang.get("noWord")))) {
                    context.getForWhom().sendRawMessage(ChatColor.RED + BukkitLang.get("itemCreateInvalidInput"));
                    return new QuestPlannerOverridePrompt(context);
                }
                context.setSessionData((Object)"overridePln", (Object)false);
                return new QuestPlannerPrompt(context);
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) return new QuestPlannerPrompt(context);
            context.setSessionData((Object)"overridePln", null);
            return new QuestPlannerPrompt(context);
        }
    }
}

