/*
 * Decompiled with CFR 0.152.
 */
package me.pikamug.quests.convo.quests.requirements;

import com.gmail.nossr50.datatypes.skills.SkillType;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import me.pikamug.quests.BukkitQuestsPlugin;
import me.pikamug.quests.convo.generic.ItemStackPrompt;
import me.pikamug.quests.convo.generic.OverridePrompt;
import me.pikamug.quests.convo.quests.QuestsEditorNumericPrompt;
import me.pikamug.quests.convo.quests.QuestsEditorStringPrompt;
import me.pikamug.quests.events.editor.quests.QuestsEditorPostOpenNumericPromptEvent;
import me.pikamug.quests.events.editor.quests.QuestsEditorPostOpenStringPromptEvent;
import me.pikamug.quests.module.CustomRequirement;
import me.pikamug.quests.quests.Quest;
import me.pikamug.quests.util.BukkitItemUtil;
import me.pikamug.quests.util.BukkitLang;
import me.pikamug.quests.util.BukkitMiscUtil;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.Prompt;
import org.bukkit.conversations.StringPrompt;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuestRequirementsPrompt
extends QuestsEditorNumericPrompt {
    private final BukkitQuestsPlugin plugin;
    private final String classPrefix;
    private boolean hasRequirement = false;
    private final int size = 12;

    public QuestRequirementsPrompt(ConversationContext context) {
        super(context);
        this.plugin = (BukkitQuestsPlugin)context.getPlugin();
        this.classPrefix = ((Object)((Object)this)).getClass().getSimpleName();
    }

    @Override
    public int getSize() {
        return 12;
    }

    @Override
    public String getTitle(ConversationContext context) {
        return BukkitLang.get("requirementsTitle").replace("<quest>", (String)Objects.requireNonNull(context.getSessionData((Object)"questName")));
    }

    @Override
    public org.bukkit.ChatColor getNumberColor(ConversationContext context, int number) {
        switch (number) {
            case 1: {
                if (this.plugin.getDependencies().getVaultEconomy() != null) {
                    return org.bukkit.ChatColor.BLUE;
                }
                return org.bukkit.ChatColor.GRAY;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                return org.bukkit.ChatColor.BLUE;
            }
            case 8: {
                if (this.plugin.getDependencies().getMcmmoClassic() != null) {
                    return org.bukkit.ChatColor.BLUE;
                }
                return org.bukkit.ChatColor.GRAY;
            }
            case 9: {
                if (this.plugin.getDependencies().getHeroes() != null) {
                    return org.bukkit.ChatColor.BLUE;
                }
                return org.bukkit.ChatColor.GRAY;
            }
            case 11: {
                if (context.getSessionData((Object)"failMessage") == null) {
                    if (!this.hasRequirement) {
                        return org.bukkit.ChatColor.GRAY;
                    }
                    return org.bukkit.ChatColor.BLUE;
                }
                return org.bukkit.ChatColor.BLUE;
            }
            case 12: {
                return org.bukkit.ChatColor.GREEN;
            }
        }
        return null;
    }

    @Override
    public String getSelectionText(ConversationContext context, int number) {
        switch (number) {
            case 1: {
                if (this.plugin.getDependencies().getVaultEconomy() != null) {
                    return org.bukkit.ChatColor.YELLOW + BukkitLang.get("reqSetMoney");
                }
                return org.bukkit.ChatColor.GRAY + BukkitLang.get("reqSetMoney");
            }
            case 2: {
                return org.bukkit.ChatColor.YELLOW + BukkitLang.get("reqSetQuestPoints").replace("<points>", BukkitLang.get("questPoints"));
            }
            case 3: {
                return org.bukkit.ChatColor.YELLOW + BukkitLang.get("reqSetItem");
            }
            case 4: {
                return org.bukkit.ChatColor.YELLOW + BukkitLang.get("reqSetExperience");
            }
            case 5: {
                return org.bukkit.ChatColor.YELLOW + BukkitLang.get("reqSetPerms");
            }
            case 6: {
                return org.bukkit.ChatColor.YELLOW + BukkitLang.get("reqSetQuest");
            }
            case 7: {
                return org.bukkit.ChatColor.YELLOW + BukkitLang.get("reqSetQuestBlocks");
            }
            case 8: {
                if (this.plugin.getDependencies().getMcmmoClassic() != null) {
                    return org.bukkit.ChatColor.YELLOW + BukkitLang.get("reqSetMcMMO");
                }
                return org.bukkit.ChatColor.GRAY + BukkitLang.get("reqSetMcMMO");
            }
            case 9: {
                if (this.plugin.getDependencies().getHeroes() != null) {
                    return org.bukkit.ChatColor.YELLOW + BukkitLang.get("reqSetHeroes");
                }
                return org.bukkit.ChatColor.GRAY + BukkitLang.get("reqSetHeroes");
            }
            case 10: {
                return org.bukkit.ChatColor.DARK_PURPLE + BukkitLang.get("reqSetCustom");
            }
            case 11: {
                if (!this.hasRequirement) {
                    return org.bukkit.ChatColor.GRAY + BukkitLang.get("overrideCreateSet");
                }
                return org.bukkit.ChatColor.YELLOW + BukkitLang.get("overrideCreateSet");
            }
            case 12: {
                return org.bukkit.ChatColor.YELLOW + BukkitLang.get("done");
            }
        }
        return null;
    }

    @Override
    public String getAdditionalText(ConversationContext context, int number) {
        switch (number) {
            case 1: {
                if (this.plugin.getDependencies().getVaultEconomy() != null) {
                    Integer moneyReq = (Integer)context.getSessionData((Object)"moneyReq");
                    if (moneyReq == null) {
                        return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    return org.bukkit.ChatColor.GRAY + "(" + org.bukkit.ChatColor.AQUA + moneyReq + " " + this.plugin.getDependencies().getVaultEconomy().format((double)moneyReq.intValue()) + org.bukkit.ChatColor.GRAY + ")";
                }
                return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("notInstalled") + ")";
            }
            case 2: {
                if (context.getSessionData((Object)"questPointsReq") == null) {
                    return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                return org.bukkit.ChatColor.GRAY + "(" + org.bukkit.ChatColor.AQUA + context.getSessionData((Object)"questPointsReq") + " " + BukkitLang.get("questPoints") + org.bukkit.ChatColor.GRAY + ")";
            }
            case 3: {
                if (context.getSessionData((Object)"itemReqs") == null) {
                    return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                StringBuilder text = new StringBuilder();
                LinkedList items = (LinkedList)context.getSessionData((Object)"itemReqs");
                if (items != null) {
                    for (ItemStack item : items) {
                        text.append("\n").append(org.bukkit.ChatColor.GRAY).append("     - ").append(org.bukkit.ChatColor.BLUE).append(BukkitItemUtil.getName(item)).append(org.bukkit.ChatColor.GRAY).append(" x ").append(org.bukkit.ChatColor.AQUA).append(item.getAmount());
                    }
                }
                return text.toString();
            }
            case 4: {
                if (context.getSessionData((Object)"expReq") == null) {
                    return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                return org.bukkit.ChatColor.GRAY + "(" + org.bukkit.ChatColor.AQUA + context.getSessionData((Object)"expReq") + " " + BukkitLang.get("points") + org.bukkit.ChatColor.GRAY + ")";
            }
            case 5: {
                if (context.getSessionData((Object)"permissionReqs") == null) {
                    return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                StringBuilder text = new StringBuilder();
                List perms = (List)context.getSessionData((Object)"permissionReqs");
                if (perms != null) {
                    for (String s : perms) {
                        text.append("\n").append(org.bukkit.ChatColor.GRAY).append("     - ").append(org.bukkit.ChatColor.AQUA).append(s);
                    }
                }
                return text.toString();
            }
            case 6: {
                if (context.getSessionData((Object)"questReqs") == null) {
                    return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                StringBuilder text = new StringBuilder();
                List questReq = (List)context.getSessionData((Object)"questReqs");
                if (questReq != null) {
                    for (String s : questReq) {
                        if (this.plugin.getQuestById(s) != null) {
                            s = this.plugin.getQuestById(s).getName();
                        }
                        text.append("\n").append(org.bukkit.ChatColor.GRAY).append("     - ").append(org.bukkit.ChatColor.AQUA).append(s);
                    }
                }
                return text.toString();
            }
            case 7: {
                if (context.getSessionData((Object)"questBlocks") == null) {
                    return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                StringBuilder text = new StringBuilder();
                List questBlockReq = (List)context.getSessionData((Object)"questBlocks");
                if (questBlockReq != null) {
                    for (String s : questBlockReq) {
                        if (this.plugin.getQuestById(s) != null) {
                            s = this.plugin.getQuestById(s).getName();
                        }
                        text.append("\n").append(org.bukkit.ChatColor.GRAY).append("     - ").append(org.bukkit.ChatColor.AQUA).append(s);
                    }
                }
                return text.toString();
            }
            case 8: {
                if (this.plugin.getDependencies().getMcmmoClassic() != null) {
                    if (context.getSessionData((Object)"mcMMOSkillReqs") == null) {
                        return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    StringBuilder text = new StringBuilder();
                    List skills = (List)context.getSessionData((Object)"mcMMOSkillReqs");
                    List amounts = (List)context.getSessionData((Object)"mcMMOSkillAmountReqs");
                    if (skills != null && amounts != null) {
                        for (String s : skills) {
                            text.append("\n").append(org.bukkit.ChatColor.GRAY).append("     - ").append(org.bukkit.ChatColor.DARK_GREEN).append(s).append(org.bukkit.ChatColor.RESET).append(org.bukkit.ChatColor.YELLOW).append(" ").append(BukkitLang.get("mcMMOLevel")).append(" ").append(org.bukkit.ChatColor.GREEN).append(amounts.get(skills.indexOf(s)));
                        }
                    }
                    return text.toString();
                }
                return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("notInstalled") + ")";
            }
            case 9: {
                if (this.plugin.getDependencies().getHeroes() != null) {
                    if (context.getSessionData((Object)"heroesPrimaryClassReq") == null && context.getSessionData((Object)"heroesSecondaryClassReq") == null) {
                        return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")\n";
                    }
                    String text = "\n";
                    if (context.getSessionData((Object)"heroesPrimaryClassReq") != null) {
                        text = text + org.bukkit.ChatColor.AQUA + "    " + BukkitLang.get("reqHeroesPrimaryDisplay") + " " + org.bukkit.ChatColor.BLUE + context.getSessionData((Object)"heroesPrimaryClassReq");
                    }
                    if (context.getSessionData((Object)"heroesSecondaryClassReq") != null) {
                        text = text + org.bukkit.ChatColor.AQUA + "    " + BukkitLang.get("reqHeroesSecondaryDisplay") + " " + org.bukkit.ChatColor.BLUE + context.getSessionData((Object)"heroesSecondaryClassReq");
                    }
                    return text;
                }
                return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("notInstalled") + ")";
            }
            case 10: {
                if (context.getSessionData((Object)"customReqs") == null) {
                    return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                StringBuilder text = new StringBuilder();
                LinkedList customReq = (LinkedList)context.getSessionData((Object)"customReqs");
                if (customReq != null) {
                    for (String s : customReq) {
                        text.append("\n").append(org.bukkit.ChatColor.LIGHT_PURPLE).append("     - ").append(s);
                    }
                }
                return text.toString();
            }
            case 11: {
                if (context.getSessionData((Object)"failMessage") == null) {
                    if (!this.hasRequirement) {
                        return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("stageEditorOptional") + ")";
                    }
                    return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                }
                StringBuilder text = new StringBuilder();
                List overrides = (List)context.getSessionData((Object)"failMessage");
                if (overrides != null) {
                    for (String override : overrides) {
                        text.append("\n").append(org.bukkit.ChatColor.GRAY).append("     - ").append(org.bukkit.ChatColor.AQUA).append(override);
                    }
                }
                return text.toString();
            }
            case 12: {
                return "";
            }
        }
        return null;
    }

    @Override
    @NotNull
    public String getBasicPromptText(ConversationContext context) {
        String input = (String)context.getSessionData((Object)(this.classPrefix + "-override"));
        if (input != null && !input.equalsIgnoreCase(BukkitLang.get("cancel"))) {
            if (input.equalsIgnoreCase(BukkitLang.get("clear"))) {
                context.setSessionData((Object)"failMessage", null);
            } else {
                LinkedList<String> overrides = new LinkedList<String>();
                if (context.getSessionData((Object)"failMessage") != null) {
                    overrides.addAll((List)context.getSessionData((Object)"failMessage"));
                }
                overrides.add(input);
                context.setSessionData((Object)"failMessage", overrides);
                context.setSessionData((Object)(this.classPrefix + "-override"), null);
            }
        }
        this.checkRequirement(context);
        QuestsEditorPostOpenNumericPromptEvent event = new QuestsEditorPostOpenNumericPromptEvent(context, this);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        StringBuilder text = new StringBuilder(org.bukkit.ChatColor.DARK_AQUA + "- " + this.getTitle(context).replace((String)Objects.requireNonNull(context.getSessionData((Object)"questName")), org.bukkit.ChatColor.AQUA + (String)context.getSessionData((Object)"questName") + org.bukkit.ChatColor.DARK_AQUA) + " -");
        for (int i = 1; i <= 12; ++i) {
            text.append("\n").append(this.getNumberColor(context, i)).append(org.bukkit.ChatColor.BOLD).append(i).append(org.bukkit.ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i)).append(" ").append(this.getAdditionalText(context, i));
        }
        return text.toString();
    }

    protected Prompt acceptValidatedInput(@NotNull ConversationContext context, Number input) {
        switch (input.intValue()) {
            case 1: {
                if (this.plugin.getDependencies().getVaultEconomy() != null) {
                    return new QuestRequirementsMoneyPrompt(context);
                }
                return new QuestRequirementsPrompt(context);
            }
            case 2: {
                return new QuestRequirementsQuestPointsPrompt(context);
            }
            case 3: {
                return new QuestRequirementsItemListPrompt(context);
            }
            case 4: {
                return new QuestRequirementsExperiencePrompt(context);
            }
            case 5: {
                return new QuestRequirementsPermissionsPrompt(context);
            }
            case 6: {
                return new QuestRequirementsQuestListPrompt(context, true);
            }
            case 7: {
                return new QuestRequirementsQuestListPrompt(context, false);
            }
            case 8: {
                if (this.plugin.getDependencies().getMcmmoClassic() != null) {
                    return new QuestRequirementsMcMMOListPrompt(context);
                }
                return new QuestRequirementsPrompt(context);
            }
            case 9: {
                if (this.plugin.getDependencies().getHeroes() != null) {
                    return new QuestRequirementsHeroesListPrompt(context);
                }
                return new QuestRequirementsPrompt(context);
            }
            case 10: {
                return new QuestCustomRequirementModulePrompt(context);
            }
            case 11: {
                if (this.hasRequirement) {
                    return new OverridePrompt.Builder().context(context).source((Prompt)this).promptText(BukkitLang.get("overrideCreateEnter")).build();
                }
                context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("invalidOption"));
                return new QuestRequirementsPrompt(context);
            }
            case 12: {
                return this.plugin.getQuestFactory().returnToMenu(context);
            }
        }
        return new QuestRequirementsPrompt(context);
    }

    public boolean checkRequirement(ConversationContext context) {
        if (context.getSessionData((Object)"moneyReq") != null || context.getSessionData((Object)"questPointsReq") != null || context.getSessionData((Object)"itemReqs") != null || context.getSessionData((Object)"expReq") != null || context.getSessionData((Object)"permissionReqs") != null || context.getSessionData((Object)"questReqs") != null || context.getSessionData((Object)"questBlocks") != null || context.getSessionData((Object)"mcMMOSkillReqs") != null || context.getSessionData((Object)"heroesPrimaryClassReq") != null || context.getSessionData((Object)"heroesSecondaryClassReq") != null || context.getSessionData((Object)"customReqs") != null) {
            this.hasRequirement = true;
            return true;
        }
        return false;
    }

    public class QuestRequirementsMoneyPrompt
    extends QuestsEditorStringPrompt {
        public QuestRequirementsMoneyPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("rewMoneyPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestRequirementsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            String text = this.getQueryText(context);
            if (QuestRequirementsPrompt.this.plugin.getDependencies().getVaultEconomy() != null) {
                text = text.replace("<money>", QuestRequirementsPrompt.this.plugin.getDependencies().getVaultEconomy().currencyNamePlural());
            }
            return org.bukkit.ChatColor.YELLOW + text;
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel")) && !input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                try {
                    int i = Integer.parseInt(input);
                    if (i <= 0) {
                        context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("inputPosNum"));
                        return new QuestRequirementsMoneyPrompt(context);
                    }
                    context.setSessionData((Object)"moneyReq", (Object)i);
                }
                catch (NumberFormatException e) {
                    context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("reqNotANumber").replace("<input>", input));
                    return new QuestRequirementsMoneyPrompt(context);
                }
            } else if (input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                context.setSessionData((Object)"moneyReq", null);
                return new QuestRequirementsPrompt(context);
            }
            return new QuestRequirementsPrompt(context);
        }
    }

    public class QuestRequirementsQuestPointsPrompt
    extends QuestsEditorStringPrompt {
        public QuestRequirementsQuestPointsPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("rewQuestPointsPrompt").replace("<points>", BukkitLang.get("questPoints"));
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestRequirementsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return org.bukkit.ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel")) && !input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                try {
                    int i = Integer.parseInt(input);
                    if (i <= 0) {
                        context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("inputPosNum"));
                        return new QuestRequirementsQuestPointsPrompt(context);
                    }
                    context.setSessionData((Object)"questPointsReq", (Object)i);
                }
                catch (NumberFormatException e) {
                    context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("reqNotANumber").replace("<input>", input));
                    return new QuestRequirementsQuestPointsPrompt(context);
                }
            } else if (input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                context.setSessionData((Object)"questPointsReq", null);
                return new QuestRequirementsPrompt(context);
            }
            return new QuestRequirementsPrompt(context);
        }
    }

    public class QuestRequirementsItemListPrompt
    extends QuestsEditorNumericPrompt {
        private final int size = 4;

        public QuestRequirementsItemListPrompt(ConversationContext context) {
            super(context);
            this.size = 4;
        }

        @Override
        public int getSize() {
            return 4;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("itemRequirementsTitle");
        }

        @Override
        public org.bukkit.ChatColor getNumberColor(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return org.bukkit.ChatColor.BLUE;
                }
                case 2: {
                    if (context.getSessionData((Object)"itemReqs") == null) {
                        return org.bukkit.ChatColor.GRAY;
                    }
                    return org.bukkit.ChatColor.BLUE;
                }
                case 3: {
                    return org.bukkit.ChatColor.RED;
                }
                case 4: {
                    return org.bukkit.ChatColor.GREEN;
                }
            }
            return null;
        }

        @Override
        public String getSelectionText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return org.bukkit.ChatColor.YELLOW + BukkitLang.get("stageEditorDeliveryAddItem");
                }
                case 2: {
                    if (context.getSessionData((Object)"itemReqs") == null) {
                        return org.bukkit.ChatColor.GRAY + BukkitLang.get("reqSetRemoveItems");
                    }
                    return org.bukkit.ChatColor.YELLOW + BukkitLang.get("reqSetRemoveItems");
                }
                case 3: {
                    return org.bukkit.ChatColor.RED + BukkitLang.get("clear");
                }
                case 4: {
                    return org.bukkit.ChatColor.GREEN + BukkitLang.get("done");
                }
            }
            return null;
        }

        @Override
        public String getAdditionalText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    if (context.getSessionData((Object)"itemReqs") == null) {
                        return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    StringBuilder text = new StringBuilder();
                    List reqItems = (List)context.getSessionData((Object)"itemReqs");
                    if (reqItems != null) {
                        for (ItemStack is : reqItems) {
                            text.append("\n").append(org.bukkit.ChatColor.GRAY).append("     - ").append(BukkitItemUtil.getDisplayString(is));
                        }
                    }
                    return text.toString();
                }
                case 2: {
                    if (context.getSessionData((Object)"itemReqs") == null) {
                        return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    if (context.getSessionData((Object)"removeItemReqs") == null) {
                        return org.bukkit.ChatColor.GRAY + "(" + BukkitLang.get("noneSet") + ")";
                    }
                    StringBuilder text = new StringBuilder();
                    List reqItemsRemove = (List)context.getSessionData((Object)"removeItemReqs");
                    if (reqItemsRemove != null) {
                        for (Boolean b : reqItemsRemove) {
                            text.append("\n").append(org.bukkit.ChatColor.GRAY).append("     - ").append(org.bukkit.ChatColor.AQUA).append(b.equals(Boolean.TRUE) ? BukkitLang.get("yesWord") : BukkitLang.get("noWord"));
                        }
                    }
                    return text.toString();
                }
                case 3: 
                case 4: {
                    return "";
                }
            }
            return null;
        }

        @Override
        @NotNull
        public String getBasicPromptText(ConversationContext context) {
            if (context.getSessionData((Object)"tempStack") != null) {
                ItemStack i;
                List<ItemStack> itemReq;
                if (context.getSessionData((Object)"itemReqs") != null) {
                    itemReq = (List)context.getSessionData((Object)"itemReqs");
                    i = (ItemStack)context.getSessionData((Object)"tempStack");
                    if (itemReq != null && i != null) {
                        itemReq.add(i);
                    }
                    context.setSessionData((Object)"itemReqs", itemReq);
                } else {
                    itemReq = new LinkedList();
                    i = (ItemStack)context.getSessionData((Object)"tempStack");
                    if (i != null) {
                        ((LinkedList)itemReq).add(i);
                    }
                    context.setSessionData((Object)"itemReqs", itemReq);
                }
                ItemStackPrompt.clearSessionData(context);
            }
            QuestsEditorPostOpenNumericPromptEvent event = new QuestsEditorPostOpenNumericPromptEvent(context, this);
            QuestRequirementsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(org.bukkit.ChatColor.AQUA + this.getTitle(context) + "\n");
            for (int i = 1; i <= 4; ++i) {
                text.append(this.getNumberColor(context, i)).append(org.bukkit.ChatColor.BOLD).append(i).append(org.bukkit.ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i)).append(" ").append(this.getAdditionalText(context, i)).append("\n");
            }
            return text.toString();
        }

        protected Prompt acceptValidatedInput(@NotNull ConversationContext context, Number input) {
            switch (input.intValue()) {
                case 1: {
                    return new ItemStackPrompt(context, (Prompt)this);
                }
                case 2: {
                    if (context.getSessionData((Object)"itemReqs") == null) {
                        context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("reqMustAddItem"));
                        return new QuestRequirementsItemListPrompt(context);
                    }
                    return new QuestRemoveItemsPrompt(context);
                }
                case 3: {
                    context.getForWhom().sendRawMessage(org.bukkit.ChatColor.YELLOW + BukkitLang.get("reqItemCleared"));
                    context.setSessionData((Object)"itemReqs", null);
                    context.setSessionData((Object)"removeItemReqs", null);
                    return new QuestRequirementsItemListPrompt(context);
                }
                case 4: {
                    List items = (List)context.getSessionData((Object)"itemReqs");
                    LinkedList<Boolean> remove = (LinkedList<Boolean>)context.getSessionData((Object)"removeItemReqs");
                    if (items != null) {
                        int missing;
                        if (remove != null) {
                            missing = items.size() - remove.size();
                        } else {
                            missing = items.size();
                            remove = new LinkedList<Boolean>();
                        }
                        for (int i = 0; i < missing; ++i) {
                            remove.add(false);
                        }
                    }
                    context.setSessionData((Object)"removeItemReqs", (Object)remove);
                    return new QuestRequirementsPrompt(context);
                }
            }
            return new QuestRequirementsPrompt(context);
        }
    }

    public class QuestRequirementsExperiencePrompt
    extends QuestsEditorStringPrompt {
        public QuestRequirementsExperiencePrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("reqExperiencePrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestRequirementsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return org.bukkit.ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel")) && !input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                try {
                    int i = Integer.parseInt(input);
                    if (i <= 0) {
                        context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("inputPosNum"));
                        return new QuestRequirementsExperiencePrompt(context);
                    }
                    context.setSessionData((Object)"expReq", (Object)i);
                }
                catch (NumberFormatException e) {
                    context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("reqNotANumber").replace("<input>", input));
                    return new QuestRequirementsExperiencePrompt(context);
                }
            } else if (input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                context.setSessionData((Object)"expReq", null);
                return new QuestRequirementsPrompt(context);
            }
            return new QuestRequirementsPrompt(context);
        }
    }

    public class QuestRequirementsPermissionsPrompt
    extends QuestsEditorStringPrompt {
        public QuestRequirementsPermissionsPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("reqPermissionsPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestRequirementsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return org.bukkit.ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel")) && !input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                String[] args = input.split(" ");
                LinkedList<String> permissions = new LinkedList<String>(Arrays.asList(args));
                context.setSessionData((Object)"permissionReqs", permissions);
            } else if (input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                context.setSessionData((Object)"permissionReqs", null);
            }
            return new QuestRequirementsPrompt(context);
        }
    }

    public class QuestRequirementsQuestListPrompt
    extends QuestsEditorStringPrompt {
        private final boolean isRequiredQuest;

        public QuestRequirementsQuestListPrompt(ConversationContext context, boolean isRequired) {
            super(context);
            this.isRequiredQuest = isRequired;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("reqQuestListTitle");
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("reqQuestPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestRequirementsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            List<String> names = QuestRequirementsPrompt.this.plugin.getLoadedQuests().stream().map(Quest::getName).collect(Collectors.toList());
            return this.sendClickableMenu(this.getTitle(context), names, this.getQueryText(context), context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel")) && !input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                String[] args = input.split(BukkitLang.get("charSemi"));
                LinkedList<String> questIds = new LinkedList<String>();
                for (String s : args) {
                    s = s.trim();
                    if (QuestRequirementsPrompt.this.plugin.getQuest(s) == null) {
                        String text = BukkitLang.get("reqNotAQuestName");
                        text = text.replace("<quest>", s);
                        context.getForWhom().sendRawMessage(text);
                        return new QuestRequirementsQuestListPrompt(context, this.isRequiredQuest);
                    }
                    if (questIds.contains(QuestRequirementsPrompt.this.plugin.getQuest(s).getId())) {
                        context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("listDuplicate"));
                        return new QuestRequirementsQuestListPrompt(context, this.isRequiredQuest);
                    }
                    questIds.add(QuestRequirementsPrompt.this.plugin.getQuest(s).getId());
                }
                if (this.isRequiredQuest) {
                    context.setSessionData((Object)"questReqs", questIds);
                } else {
                    context.setSessionData((Object)"questBlocks", questIds);
                }
            } else if (input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                if (this.isRequiredQuest) {
                    context.setSessionData((Object)"questReqs", null);
                } else {
                    context.setSessionData((Object)"questBlocks", null);
                }
            }
            return new QuestRequirementsPrompt(context);
        }
    }

    public class QuestRequirementsMcMMOListPrompt
    extends QuestsEditorNumericPrompt {
        private final int size = 3;

        public QuestRequirementsMcMMOListPrompt(ConversationContext context) {
            super(context);
            this.size = 3;
        }

        @Override
        public int getSize() {
            return 3;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("mcMMORequirementsTitle");
        }

        @Override
        public org.bukkit.ChatColor getNumberColor(ConversationContext context, int number) {
            switch (number) {
                case 1: 
                case 2: {
                    return org.bukkit.ChatColor.BLUE;
                }
                case 3: {
                    return org.bukkit.ChatColor.GREEN;
                }
            }
            return null;
        }

        @Override
        public String getSelectionText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return org.bukkit.ChatColor.YELLOW + BukkitLang.get("reqSetSkills");
                }
                case 2: {
                    return org.bukkit.ChatColor.YELLOW + BukkitLang.get("reqSetSkillAmounts");
                }
                case 3: {
                    return org.bukkit.ChatColor.GREEN + BukkitLang.get("done");
                }
            }
            return null;
        }

        @Override
        public String getAdditionalText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    if (context.getSessionData((Object)"mcMMOSkillReqs") == null) {
                        return org.bukkit.ChatColor.GRAY + " (" + BukkitLang.get("noneSet") + ")";
                    }
                    StringBuilder text = new StringBuilder();
                    LinkedList skills = (LinkedList)context.getSessionData((Object)"mcMMOSkillReqs");
                    if (skills != null) {
                        for (String skill : skills) {
                            text.append("\n").append(org.bukkit.ChatColor.GRAY).append("     - ").append(org.bukkit.ChatColor.AQUA).append(skill);
                        }
                    }
                    return text.toString();
                }
                case 2: {
                    if (context.getSessionData((Object)"mcMMOSkillAmountReqs") == null) {
                        return org.bukkit.ChatColor.GRAY + " (" + BukkitLang.get("noneSet") + ")";
                    }
                    StringBuilder text = new StringBuilder();
                    LinkedList skillAmounts = (LinkedList)context.getSessionData((Object)"mcMMOSkillAmountReqs");
                    if (skillAmounts != null) {
                        Iterator iterator = skillAmounts.iterator();
                        while (iterator.hasNext()) {
                            int i = (Integer)iterator.next();
                            text.append("\n").append(org.bukkit.ChatColor.GRAY).append("     - ").append(org.bukkit.ChatColor.AQUA).append(i);
                        }
                    }
                    return text.toString();
                }
                case 3: {
                    return "";
                }
            }
            return null;
        }

        @Override
        @NotNull
        public String getBasicPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenNumericPromptEvent event = new QuestsEditorPostOpenNumericPromptEvent(context, this);
            QuestRequirementsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(org.bukkit.ChatColor.AQUA + this.getTitle(context) + "\n");
            for (int i = 1; i <= 3; ++i) {
                text.append(this.getNumberColor(context, i)).append(org.bukkit.ChatColor.BOLD).append(i).append(org.bukkit.ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i)).append(" ").append(this.getAdditionalText(context, i)).append("\n");
            }
            return text.toString();
        }

        protected Prompt acceptValidatedInput(@NotNull ConversationContext context, Number input) {
            switch (input.intValue()) {
                case 1: {
                    return new QuestMcMMOSkillsPrompt(context);
                }
                case 2: {
                    return new QuestMcMMOAmountsPrompt(context);
                }
                case 3: {
                    return new QuestRequirementsPrompt(context);
                }
            }
            return new QuestRequirementsMcMMOListPrompt(context);
        }
    }

    public class QuestRequirementsHeroesListPrompt
    extends QuestsEditorNumericPrompt {
        private final int size = 3;

        public QuestRequirementsHeroesListPrompt(ConversationContext context) {
            super(context);
            this.size = 3;
        }

        @Override
        public int getSize() {
            return 3;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("heroesRequirementsTitle");
        }

        @Override
        public org.bukkit.ChatColor getNumberColor(ConversationContext context, int number) {
            switch (number) {
                case 1: 
                case 2: {
                    return org.bukkit.ChatColor.BLUE;
                }
                case 3: {
                    return org.bukkit.ChatColor.GREEN;
                }
            }
            return null;
        }

        @Override
        public String getSelectionText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    return org.bukkit.ChatColor.YELLOW + BukkitLang.get("reqHeroesSetPrimary");
                }
                case 2: {
                    return org.bukkit.ChatColor.YELLOW + BukkitLang.get("reqHeroesSetSecondary");
                }
                case 3: {
                    return org.bukkit.ChatColor.GREEN + BukkitLang.get("done");
                }
            }
            return null;
        }

        @Override
        public String getAdditionalText(ConversationContext context, int number) {
            switch (number) {
                case 1: {
                    if (context.getSessionData((Object)"heroesPrimaryClassReq") == null) {
                        return org.bukkit.ChatColor.GRAY + " (" + BukkitLang.get("noneSet") + ")";
                    }
                    return "(" + org.bukkit.ChatColor.AQUA + context.getSessionData((Object)"heroesPrimaryClassReq") + org.bukkit.ChatColor.GREEN + ")\n";
                }
                case 2: {
                    if (context.getSessionData((Object)"heroesSecondaryClassReq") == null) {
                        return org.bukkit.ChatColor.GRAY + " (" + BukkitLang.get("noneSet") + ")";
                    }
                    return "(" + org.bukkit.ChatColor.AQUA + context.getSessionData((Object)"heroesSecondaryClassReq") + org.bukkit.ChatColor.GREEN + ")\n";
                }
                case 3: {
                    return "";
                }
            }
            return null;
        }

        @Override
        @NotNull
        public String getBasicPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenNumericPromptEvent event = new QuestsEditorPostOpenNumericPromptEvent(context, this);
            QuestRequirementsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(org.bukkit.ChatColor.AQUA + this.getTitle(context) + "\n");
            for (int i = 1; i <= 3; ++i) {
                text.append(this.getNumberColor(context, i)).append(org.bukkit.ChatColor.BOLD).append(i).append(org.bukkit.ChatColor.RESET).append(" - ").append(this.getSelectionText(context, i)).append(" ").append(this.getAdditionalText(context, i)).append("\n");
            }
            return text.toString();
        }

        protected Prompt acceptValidatedInput(@NotNull ConversationContext context, Number input) {
            switch (input.intValue()) {
                case 1: {
                    return new QuestHeroesPrimaryPrompt(context);
                }
                case 2: {
                    return new QuestHeroesSecondaryPrompt(context);
                }
                case 3: {
                    return new QuestRequirementsPrompt(context);
                }
            }
            return new QuestRequirementsHeroesListPrompt(context);
        }
    }

    public class QuestCustomRequirementModulePrompt
    extends QuestsEditorStringPrompt {
        public QuestCustomRequirementModulePrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("stageEditorModules");
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("stageEditorModulePrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestRequirementsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            if (!(context.getForWhom() instanceof Player) || !QuestRequirementsPrompt.this.plugin.getConfigSettings().canClickablePrompts()) {
                StringBuilder text = new StringBuilder(org.bukkit.ChatColor.LIGHT_PURPLE + this.getTitle(context) + "\n");
                if (QuestRequirementsPrompt.this.plugin.getCustomRequirements().isEmpty()) {
                    text.append(org.bukkit.ChatColor.DARK_AQUA).append(org.bukkit.ChatColor.UNDERLINE).append("https://pikamug.gitbook.io/quests/casual/modules").append(org.bukkit.ChatColor.RESET).append("\n");
                    text.append(org.bukkit.ChatColor.RED).append("(").append(BukkitLang.get("stageEditorNoModules")).append(")").append("\n");
                } else {
                    for (String name : QuestRequirementsPrompt.this.plugin.getCustomRequirements().stream().map(CustomRequirement::getModuleName).collect(Collectors.toCollection(TreeSet::new))) {
                        text.append(org.bukkit.ChatColor.DARK_PURPLE).append("  - ").append(name).append("\n");
                    }
                }
                return text.toString() + org.bukkit.ChatColor.YELLOW + this.getQueryText(context);
            }
            TextComponent component = new TextComponent(this.getTitle(context) + "\n");
            component.setColor(ChatColor.LIGHT_PURPLE);
            TextComponent line = new TextComponent("");
            if (QuestRequirementsPrompt.this.plugin.getCustomRequirements().isEmpty()) {
                TextComponent link = new TextComponent("https://pikamug.gitbook.io/quests/casual/modules\n");
                link.setColor(ChatColor.DARK_AQUA);
                link.setUnderlined(Boolean.valueOf(true));
                line.addExtra((BaseComponent)link);
                line.addExtra(org.bukkit.ChatColor.RED + "(" + BukkitLang.get("stageEditorNoModules") + ")\n");
            } else {
                for (String name : QuestRequirementsPrompt.this.plugin.getCustomRequirements().stream().map(CustomRequirement::getModuleName).collect(Collectors.toCollection(TreeSet::new))) {
                    TextComponent click = new TextComponent(org.bukkit.ChatColor.DARK_PURPLE + "  - " + name + "\n");
                    click.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/quests choice " + name));
                    line.addExtra((BaseComponent)click);
                }
            }
            component.addExtra((BaseComponent)line);
            component.addExtra(org.bukkit.ChatColor.YELLOW + this.getQueryText(context));
            ((Player)context.getForWhom()).spigot().sendMessage((BaseComponent)component);
            return "";
        }

        public Prompt acceptInput(@NotNull ConversationContext context, @Nullable String input) {
            if (input != null && !input.equalsIgnoreCase(BukkitLang.get("cmdCancel")) && !input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                String found = null;
                for (CustomRequirement cr : QuestRequirementsPrompt.this.plugin.getCustomRequirements()) {
                    if (!cr.getModuleName().equalsIgnoreCase(input)) continue;
                    found = cr.getModuleName();
                    break;
                }
                if (found == null) {
                    for (CustomRequirement cr : QuestRequirementsPrompt.this.plugin.getCustomRequirements()) {
                        if (!cr.getModuleName().toLowerCase().contains(input.toLowerCase())) continue;
                        found = cr.getModuleName();
                        break;
                    }
                }
                if (found != null) {
                    return new QuestCustomRequirementsPrompt(found, context);
                }
            } else {
                if (input != null && input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                    return new QuestRequirementsPrompt(context);
                }
                if (input != null && input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                    context.setSessionData((Object)"customReqs", null);
                    context.setSessionData((Object)"customReqData", null);
                    context.setSessionData((Object)"customReqDataTemp", null);
                    context.getForWhom().sendRawMessage(org.bukkit.ChatColor.YELLOW + BukkitLang.get("reqCustomCleared"));
                    return new QuestRequirementsPrompt(context);
                }
            }
            context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("reqCustomNotFound"));
            return new QuestCustomRequirementModulePrompt(context);
        }
    }

    private class QuestRequirementCustomDataPrompt
    extends StringPrompt {
        private QuestRequirementCustomDataPrompt() {
        }

        @NotNull
        public String getPromptText(ConversationContext context) {
            String text = "";
            String temp = (String)context.getSessionData((Object)"customReqDataTemp");
            Map descriptions = (Map)context.getSessionData((Object)"customReqDataDesc");
            if (temp != null && descriptions != null) {
                if (descriptions.get(temp) != null) {
                    text = text + org.bukkit.ChatColor.GOLD + (String)descriptions.get(temp) + "\n";
                }
                String lang = BukkitLang.get("stageEditorCustomDataPrompt");
                lang = lang.replace("<data>", temp);
                text = text + org.bukkit.ChatColor.YELLOW + lang;
            }
            return text;
        }

        public Prompt acceptInput(ConversationContext context, String input) {
            LinkedList dataMapList = (LinkedList)context.getSessionData((Object)"customReqData");
            if (dataMapList != null) {
                Map dataMap = (Map)dataMapList.getLast();
                dataMap.put((String)context.getSessionData((Object)"customReqDataTemp"), input);
                context.setSessionData((Object)"customReqDataTemp", null);
            }
            return new QuestRequirementCustomDataListPrompt();
        }
    }

    private class QuestRequirementCustomDataListPrompt
    extends StringPrompt {
        private QuestRequirementCustomDataListPrompt() {
        }

        @NotNull
        public String getPromptText(ConversationContext context) {
            StringBuilder text = new StringBuilder(org.bukkit.ChatColor.GOLD + "- ");
            LinkedList list = (LinkedList)context.getSessionData((Object)"customReqs");
            LinkedList dataMapList = (LinkedList)context.getSessionData((Object)"customReqData");
            if (dataMapList != null && list != null) {
                String reqName = (String)list.getLast();
                Map dataMap = (Map)dataMapList.getLast();
                text.append(reqName).append(" -\n");
                int index = 1;
                LinkedList dataMapKeys = new LinkedList(dataMap.keySet());
                Collections.sort(dataMapKeys);
                for (String dataKey : dataMapKeys) {
                    text.append(org.bukkit.ChatColor.BLUE).append(org.bukkit.ChatColor.BOLD).append(index).append(org.bukkit.ChatColor.RESET).append(org.bukkit.ChatColor.YELLOW).append(" - ").append(dataKey);
                    if (dataMap.get(dataKey) != null) {
                        text.append(org.bukkit.ChatColor.GRAY).append(" (").append(org.bukkit.ChatColor.AQUA).append(org.bukkit.ChatColor.translateAlternateColorCodes((char)'&', (String)dataMap.get(dataKey).toString())).append(org.bukkit.ChatColor.GRAY).append(")\n");
                    } else {
                        text.append(org.bukkit.ChatColor.GRAY).append(" (").append(BukkitLang.get("noneSet")).append(org.bukkit.ChatColor.GRAY).append(")\n");
                    }
                    ++index;
                }
                text.append(org.bukkit.ChatColor.GREEN).append(org.bukkit.ChatColor.BOLD).append(index).append(org.bukkit.ChatColor.YELLOW).append(" - ").append(BukkitLang.get("done"));
            }
            return text.toString();
        }

        public Prompt acceptInput(ConversationContext context, String input) {
            LinkedList dataMapList = (LinkedList)context.getSessionData((Object)"customReqData");
            if (dataMapList != null) {
                int numInput;
                Map dataMap = (Map)dataMapList.getLast();
                try {
                    numInput = Integer.parseInt(input);
                }
                catch (NumberFormatException nfe) {
                    return new QuestRequirementCustomDataListPrompt();
                }
                if (numInput < 1 || numInput > dataMap.size() + 1) {
                    return new QuestRequirementCustomDataListPrompt();
                }
                if (numInput < dataMap.size() + 1) {
                    LinkedList dataMapKeys = new LinkedList(dataMap.keySet());
                    Collections.sort(dataMapKeys);
                    String selectedKey = (String)dataMapKeys.get(numInput - 1);
                    context.setSessionData((Object)"customReqDataTemp", (Object)selectedKey);
                    return new QuestRequirementCustomDataPrompt();
                }
                if (dataMap.containsValue(null)) {
                    return new QuestRequirementCustomDataListPrompt();
                }
                context.setSessionData((Object)"customReqDataDesc", null);
            }
            return new QuestRequirementsPrompt(context);
        }
    }

    public class QuestCustomRequirementsPrompt
    extends QuestsEditorStringPrompt {
        private final String moduleName;

        public QuestCustomRequirementsPrompt(String moduleName, ConversationContext context) {
            super(context);
            this.moduleName = moduleName;
        }

        public String getModuleName() {
            return this.moduleName;
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("customRequirementsTitle");
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("reqCustomPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestRequirementsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            if (!(context.getForWhom() instanceof Player) || !QuestRequirementsPrompt.this.plugin.getConfigSettings().canClickablePrompts()) {
                StringBuilder text = new StringBuilder(org.bukkit.ChatColor.LIGHT_PURPLE + this.getTitle(context) + "\n");
                if (QuestRequirementsPrompt.this.plugin.getCustomRequirements().isEmpty()) {
                    text.append(org.bukkit.ChatColor.DARK_AQUA).append(org.bukkit.ChatColor.UNDERLINE).append("https://pikamug.gitbook.io/quests/casual/modules\n");
                    text.append(org.bukkit.ChatColor.RED).append("(").append(BukkitLang.get("stageEditorNoModules")).append(")\n");
                } else {
                    for (CustomRequirement cr : QuestRequirementsPrompt.this.plugin.getCustomRequirements()) {
                        if (!cr.getModuleName().equals(this.moduleName)) continue;
                        text.append(org.bukkit.ChatColor.DARK_PURPLE).append("  - ").append(cr.getName()).append("\n");
                    }
                }
                return text.toString() + org.bukkit.ChatColor.YELLOW + this.getQueryText(context);
            }
            TextComponent component = new TextComponent(this.getTitle(context) + "\n");
            component.setColor(ChatColor.LIGHT_PURPLE);
            TextComponent line = new TextComponent("");
            if (QuestRequirementsPrompt.this.plugin.getCustomRequirements().isEmpty()) {
                TextComponent link = new TextComponent("https://pikamug.gitbook.io/quests/casual/modules\n");
                link.setColor(ChatColor.DARK_AQUA);
                link.setUnderlined(Boolean.valueOf(true));
                line.addExtra((BaseComponent)link);
                line.addExtra(org.bukkit.ChatColor.RED + "(" + BukkitLang.get("stageEditorNoModules") + ")\n");
            } else {
                for (CustomRequirement co : QuestRequirementsPrompt.this.plugin.getCustomRequirements()) {
                    if (!co.getModuleName().equals(this.moduleName)) continue;
                    TextComponent click = new TextComponent(org.bukkit.ChatColor.DARK_PURPLE + "  - " + co.getName() + "\n");
                    click.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/quests choice " + co.getName()));
                    line.addExtra((BaseComponent)click);
                }
            }
            component.addExtra((BaseComponent)line);
            component.addExtra(org.bukkit.ChatColor.YELLOW + this.getQueryText(context));
            ((Player)context.getForWhom()).spigot().sendMessage((BaseComponent)component);
            return "";
        }

        /*
         * Enabled aggressive block sorting
         */
        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel")) && !input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                CustomRequirement found;
                block9: {
                    found = null;
                    for (CustomRequirement cr : QuestRequirementsPrompt.this.plugin.getCustomRequirements()) {
                        if (!cr.getModuleName().equals(this.moduleName) || !cr.getName().toLowerCase().contains(input.toLowerCase())) continue;
                        found = cr;
                        break;
                    }
                    if (found == null) {
                        context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("reqCustomNotFound"));
                        return new QuestCustomRequirementsPrompt(this.moduleName, context);
                    }
                    if (context.getSessionData((Object)"customReqs") != null) {
                        LinkedList list = (LinkedList)context.getSessionData((Object)"customReqs");
                        LinkedList dataMapList = (LinkedList)context.getSessionData((Object)"customReqData");
                        if (dataMapList != null && list != null && !list.contains(found.getName())) {
                            list.add(found.getName());
                            dataMapList.add(found.getData());
                            context.setSessionData((Object)"customReqs", (Object)list);
                            context.setSessionData((Object)"customReqData", (Object)dataMapList);
                            break block9;
                        } else {
                            context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("reqCustomAlreadyAdded"));
                            return new QuestCustomRequirementsPrompt(this.moduleName, context);
                        }
                    }
                    LinkedList<Map<String, Object>> dataMapList = new LinkedList<Map<String, Object>>();
                    dataMapList.add(found.getData());
                    LinkedList<String> list = new LinkedList<String>();
                    list.add(found.getName());
                    context.setSessionData((Object)"customReqs", list);
                    context.setSessionData((Object)"customReqData", dataMapList);
                }
                if (found.getData().isEmpty()) return new QuestRequirementsPrompt(context);
                context.setSessionData((Object)"customReqDataDesc", found.getDescriptions());
                return new QuestRequirementCustomDataListPrompt();
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) return new QuestRequirementsPrompt(context);
            context.setSessionData((Object)"customReqs", null);
            context.setSessionData((Object)"customReqData", null);
            context.setSessionData((Object)"customReqDataTemp", null);
            context.getForWhom().sendRawMessage(org.bukkit.ChatColor.YELLOW + BukkitLang.get("reqCustomCleared"));
            return new QuestRequirementsPrompt(context);
        }
    }

    public class QuestHeroesSecondaryPrompt
    extends QuestsEditorStringPrompt {
        public QuestHeroesSecondaryPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("heroesSecondaryTitle");
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("reqHeroesSecondaryPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestRequirementsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(org.bukkit.ChatColor.LIGHT_PURPLE + this.getTitle(context) + "\n");
            LinkedList<String> list = new LinkedList<String>();
            for (HeroClass hc : QuestRequirementsPrompt.this.plugin.getDependencies().getHeroes().getClassManager().getClasses()) {
                if (!hc.isSecondary()) continue;
                list.add(hc.getName());
            }
            if (list.isEmpty()) {
                text.append(org.bukkit.ChatColor.GRAY).append("(").append(BukkitLang.get("none")).append(")\n");
            } else {
                Collections.sort(list);
                for (int i = 0; i < list.size(); ++i) {
                    text.append(org.bukkit.ChatColor.AQUA).append(BukkitMiscUtil.snakeCaseToUpperCamelCase((String)list.get(i)));
                    if (i >= list.size() - 1) continue;
                    text.append(org.bukkit.ChatColor.GRAY).append(", ");
                }
            }
            text.append("\n").append(org.bukkit.ChatColor.YELLOW).append(this.getQueryText(context));
            return text.toString();
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdClear")) && !input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                HeroClass hc = QuestRequirementsPrompt.this.plugin.getDependencies().getHeroes().getClassManager().getClass(input);
                if (hc != null) {
                    if (hc.isSecondary()) {
                        context.setSessionData((Object)"heroesSecondaryClassReq", (Object)hc.getName());
                        return new QuestRequirementsHeroesListPrompt(context);
                    }
                    String text = BukkitLang.get("reqHeroesNotSecondary");
                    text = text.replace("<class>", org.bukkit.ChatColor.LIGHT_PURPLE + hc.getName() + org.bukkit.ChatColor.RED);
                    context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + text);
                    return new QuestHeroesSecondaryPrompt(context);
                }
                context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("reqHeroesClassNotFound"));
                return new QuestHeroesSecondaryPrompt(context);
            }
            if (input.equalsIgnoreCase(BukkitLang.get("clear"))) {
                context.setSessionData((Object)"heroesSecondaryClassReq", null);
                context.getForWhom().sendRawMessage(org.bukkit.ChatColor.YELLOW + BukkitLang.get("reqHeroesSecondaryCleared"));
                return new QuestRequirementsHeroesListPrompt(context);
            }
            return new QuestRequirementsHeroesListPrompt(context);
        }
    }

    public class QuestHeroesPrimaryPrompt
    extends QuestsEditorStringPrompt {
        public QuestHeroesPrimaryPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("heroesPrimaryTitle");
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("reqHeroesPrimaryPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestRequirementsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder text = new StringBuilder(org.bukkit.ChatColor.LIGHT_PURPLE + this.getTitle(context) + "\n");
            LinkedList<String> list = new LinkedList<String>();
            for (HeroClass hc : QuestRequirementsPrompt.this.plugin.getDependencies().getHeroes().getClassManager().getClasses()) {
                if (!hc.isPrimary()) continue;
                list.add(hc.getName());
            }
            if (list.isEmpty()) {
                text.append(org.bukkit.ChatColor.GRAY).append("(").append(BukkitLang.get("none")).append(")\n");
            } else {
                Collections.sort(list);
                for (int i = 0; i < list.size(); ++i) {
                    text.append(org.bukkit.ChatColor.AQUA).append(BukkitMiscUtil.snakeCaseToUpperCamelCase((String)list.get(i)));
                    if (i >= list.size() - 1) continue;
                    text.append(org.bukkit.ChatColor.GRAY).append(", ");
                }
            }
            text.append("\n").append(org.bukkit.ChatColor.YELLOW).append(this.getQueryText(context));
            return text.toString();
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdClear")) && !input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                HeroClass hc = QuestRequirementsPrompt.this.plugin.getDependencies().getHeroes().getClassManager().getClass(input);
                if (hc != null) {
                    if (hc.isPrimary()) {
                        context.setSessionData((Object)"heroesPrimaryClassReq", (Object)hc.getName());
                        return new QuestRequirementsHeroesListPrompt(context);
                    }
                    String text = BukkitLang.get("reqHeroesNotPrimary");
                    text = text.replace("<class>", org.bukkit.ChatColor.LIGHT_PURPLE + hc.getName() + org.bukkit.ChatColor.RED);
                    context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + text);
                    return new QuestHeroesPrimaryPrompt(context);
                }
                context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("reqHeroesClassNotFound"));
                return new QuestHeroesPrimaryPrompt(context);
            }
            if (input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                context.setSessionData((Object)"heroesPrimaryClassReq", null);
                context.getForWhom().sendRawMessage(org.bukkit.ChatColor.YELLOW + BukkitLang.get("reqHeroesPrimaryCleared"));
                return new QuestRequirementsHeroesListPrompt(context);
            }
            return new QuestRequirementsHeroesListPrompt(context);
        }
    }

    public class QuestMcMMOAmountsPrompt
    extends QuestsEditorStringPrompt {
        public QuestMcMMOAmountsPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("reqMcMMOAmountsPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestRequirementsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return org.bukkit.ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel")) && !input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                LinkedList<Integer> amounts = new LinkedList<Integer>();
                for (String s : input.split(" ")) {
                    try {
                        int i = Integer.parseInt(s);
                        amounts.add(i);
                    }
                    catch (NumberFormatException nfe) {
                        String text = BukkitLang.get("reqNotANumber");
                        text = text.replace("<input>", s);
                        context.getForWhom().sendRawMessage(org.bukkit.ChatColor.YELLOW + text);
                        return new QuestMcMMOAmountsPrompt(context);
                    }
                }
                context.setSessionData((Object)"mcMMOSkillAmountReqs", amounts);
                return new QuestRequirementsMcMMOListPrompt(context);
            }
            if (input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                context.getForWhom().sendRawMessage(org.bukkit.ChatColor.YELLOW + BukkitLang.get("reqMcMMOAmountsCleared"));
                context.setSessionData((Object)"mcMMOSkillAmountReqs", null);
                return new QuestRequirementsMcMMOListPrompt(context);
            }
            if (input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                return new QuestRequirementsMcMMOListPrompt(context);
            }
            return new QuestMcMMOAmountsPrompt(context);
        }
    }

    public class QuestMcMMOSkillsPrompt
    extends QuestsEditorStringPrompt {
        public QuestMcMMOSkillsPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return BukkitLang.get("skillListTitle");
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("rewMcMMOPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestRequirementsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            StringBuilder skillList = new StringBuilder(org.bukkit.ChatColor.LIGHT_PURPLE + this.getTitle(context) + "\n");
            SkillType[] skills = SkillType.values();
            for (int i = 0; i < skills.length; ++i) {
                skillList.append(org.bukkit.ChatColor.AQUA).append(BukkitMiscUtil.snakeCaseToUpperCamelCase(skills[i].getName()));
                if (i >= skills.length - 1) continue;
                skillList.append(org.bukkit.ChatColor.GRAY).append(", ");
            }
            skillList.append("\n").append(org.bukkit.ChatColor.YELLOW).append(this.getQueryText(context));
            return skillList.toString();
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel")) && !input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                LinkedList<String> skills = new LinkedList<String>();
                for (String s : input.split(" ")) {
                    String formatted = BukkitMiscUtil.getCapitalized(s);
                    if (QuestRequirementsPrompt.this.plugin.getDependencies().getMcMMOSkill(formatted) == null) {
                        if (skills.contains(formatted)) {
                            context.getForWhom().sendRawMessage(org.bukkit.ChatColor.YELLOW + BukkitLang.get("listDuplicate"));
                            return new QuestMcMMOSkillsPrompt(context);
                        }
                        String text = BukkitLang.get("reqMcMMOError");
                        text = text.replace("<input>", s);
                        context.getForWhom().sendRawMessage(org.bukkit.ChatColor.YELLOW + text);
                        return new QuestMcMMOSkillsPrompt(context);
                    }
                    skills.add(formatted);
                }
                context.setSessionData((Object)"mcMMOSkillReqs", skills);
                return new QuestRequirementsMcMMOListPrompt(context);
            }
            if (input.equalsIgnoreCase(BukkitLang.get("cmdClear"))) {
                context.getForWhom().sendRawMessage(org.bukkit.ChatColor.YELLOW + BukkitLang.get("reqMcMMOCleared"));
                context.setSessionData((Object)"mcMMOSkillReqs", null);
                return new QuestRequirementsMcMMOListPrompt(context);
            }
            if (input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                return new QuestRequirementsMcMMOListPrompt(context);
            }
            return new QuestMcMMOSkillsPrompt(context);
        }
    }

    public class QuestRemoveItemsPrompt
    extends QuestsEditorStringPrompt {
        public QuestRemoveItemsPrompt(ConversationContext context) {
            super(context);
        }

        @Override
        public String getTitle(ConversationContext context) {
            return null;
        }

        @Override
        public String getQueryText(ConversationContext context) {
            return BukkitLang.get("reqRemoveItemsPrompt");
        }

        @NotNull
        public String getPromptText(@NotNull ConversationContext context) {
            QuestsEditorPostOpenStringPromptEvent event = new QuestsEditorPostOpenStringPromptEvent(context, this);
            QuestRequirementsPrompt.this.plugin.getServer().getPluginManager().callEvent((Event)event);
            return org.bukkit.ChatColor.YELLOW + this.getQueryText(context);
        }

        public Prompt acceptInput(@NotNull ConversationContext context, String input) {
            if (input == null) {
                return null;
            }
            if (!input.equalsIgnoreCase(BukkitLang.get("cmdCancel"))) {
                String[] args = input.split(" ");
                LinkedList<Boolean> booleans = new LinkedList<Boolean>();
                for (String s : args) {
                    if (input.startsWith("t") || s.equalsIgnoreCase(BukkitLang.get("true")) || s.equalsIgnoreCase(BukkitLang.get("yesWord"))) {
                        booleans.add(true);
                        continue;
                    }
                    if (input.startsWith("f") || s.equalsIgnoreCase(BukkitLang.get("false")) || s.equalsIgnoreCase(BukkitLang.get("noWord"))) {
                        booleans.add(false);
                        continue;
                    }
                    context.getForWhom().sendRawMessage(org.bukkit.ChatColor.RED + BukkitLang.get("itemCreateInvalidInput"));
                    return new QuestRemoveItemsPrompt(context);
                }
                context.setSessionData((Object)"removeItemReqs", booleans);
            }
            return new QuestRequirementsItemListPrompt(context);
        }
    }
}

